/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.util.http.server;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import hr.iii.fiskal.AppContext;
import hr.iii.util.http.server.forms.HttpFormParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractHttpHandler
implements HttpHandler {
    private static String errorHtml = "<html><body><h1>Gre\u0139\u02c7ka 404</h1></body</html>";
    protected Map<String, Object> parameters = null;

    @Override
    public void handle(HttpExchange t) throws IOException {
        if (t.getRequestMethod().compareToIgnoreCase("GET") == 0) {
            this.handleGet(t);
        } else if (t.getRequestMethod().compareToIgnoreCase("POST") == 0) {
            this.handlePost(t);
        } else {
            this.sendResponse(t, errorHtml.getBytes(), 404);
        }
    }

    private void handleGet(HttpExchange t) {
        try {
            this.parameters = new HashMap<String, Object>();
            URI requestedUri = t.getRequestURI();
            String query = requestedUri.getRawQuery();
            this.parseQuery(query, this.parameters);
            t.setAttribute("parameters", this.parameters);
            byte[] response = this.getResource(t);
            response = this.prepareResponse(response);
            this.sendResponse(t, response, 200);
        }
        catch (IOException e) {
            this.sendResponse(t, errorHtml.getBytes(), 404);
        }
    }

    private void handlePost(HttpExchange t) {
        byte[] response;
        block7: {
            response = null;
            String uri = t.getRequestURI().toString();
            String contentTypeExpected = "multipart/form-data; boundary=";
            Headers requestHeaders = t.getRequestHeaders();
            String contentType = requestHeaders.getFirst("Content-type");
            try {
                if (contentType == null) {
                    response = this.createPostResponse(uri, null);
                } else {
                    int boundaryOff = contentType.indexOf(contentTypeExpected);
                    if (boundaryOff < 0) {
                        response = this.createPostResponse(uri, null);
                    }
                }
                if (null != response) break block7;
                HttpFormParser parser = null;
                try {
                    parser = new HttpFormParser(t, -1, "UTF-8");
                }
                catch (IOException e) {
                    parser = null;
                }
                response = this.createPostResponse(uri, parser);
            }
            catch (IOException e) {
                this.sendResponse(t, errorHtml.getBytes(), 404);
            }
        }
        this.sendResponse(t, response, 200);
    }

    private byte[] getResource(HttpExchange t) throws IOException {
        String uri = t.getRequestURI().toString();
        return this.createResponse(uri);
    }

    protected byte[] createResponseFromFile(String uri) throws IOException {
        int len;
        if (uri.startsWith("/download/")) {
            uri = AppContext.getLogDir() + uri.substring(10);
            File file = new File(uri);
            byte[] bytearray = new byte[(int)file.length()];
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            bis.read(bytearray, 0, bytearray.length);
            bis.close();
            return bytearray;
        }
        uri = uri.charAt(0) != '/' ? "html/" + uri : "html" + uri;
        InputStream is = AppContext.getContext().getClass().getResourceAsStream(uri);
        if (null == is) {
            return new byte[0];
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        return os.toByteArray();
    }

    private void sendResponse(HttpExchange t, byte[] response, int returnCode) {
        OutputStream os = t.getResponseBody();
        try {
            Headers h = t.getResponseHeaders();
            h.add("Cache-Control", "no-cache");
            String uri = t.getRequestURI().toString();
            if (uri.startsWith("/download/")) {
                h.add("content-disposition", "attachment; filename=" + uri.substring(10));
            } else {
                h.add("Content-type", "text/html; charset=utf-8");
            }
            t.sendResponseHeaders(returnCode, response.length);
            if (response.length > 0) {
                os.write(response);
            }
        }
        catch (IOException e) {
            return;
        }
        try {
            os.close();
        }
        catch (IOException e) {
            return;
        }
    }

    private void parseQuery(String query, Map<String, Object> parameters) throws UnsupportedEncodingException {
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("[&]")) {
                String[] param = pair.split("[=]");
                String key = null;
                String value = null;
                if (param.length > 0) {
                    key = URLDecoder.decode(param[0], System.getProperty("file.encoding"));
                }
                if (param.length > 1) {
                    value = URLDecoder.decode(param[1], System.getProperty("file.encoding"));
                }
                if (parameters.containsKey(key)) {
                    ArrayList<String> values;
                    Object obj = parameters.get(key);
                    if (obj instanceof List) {
                        values = (ArrayList<String>)obj;
                        values.add(value);
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    values = new ArrayList<String>();
                    values.add((String)obj);
                    values.add(value);
                    parameters.put(key, values);
                    continue;
                }
                parameters.put(key, value);
            }
        }
    }

    protected abstract byte[] createPostResponse(String var1, HttpFormParser var2) throws IOException;

    protected abstract byte[] prepareResponse(byte[] var1);

    protected abstract byte[] createResponse(String var1) throws IOException;
}

