/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.jnl.XMLFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.zip.GZIPInputStream;

public class LaunchDescFactory {
    private static final boolean DEBUG = false;
    private static final int BUFFER_SIZE = 8192;
    private static URL derivedCodebase = null;
    private static URL docbase = null;

    public static void setDocBase(URL uRL) {
        docbase = uRL;
    }

    public static URL getDocBase() {
        return docbase;
    }

    public static URL getDerivedCodebase() {
        if (docbase != null && derivedCodebase == null) {
            try {
                derivedCodebase = new URL(docbase.toString().substring(0, docbase.toString().lastIndexOf("/") + 1));
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
        }
        return derivedCodebase;
    }

    public static LaunchDesc buildDescriptor(byte[] byArray, URL uRL, URL uRL2, URL uRL3) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return XMLFormat.parse(byArray, uRL, uRL2, uRL3, LaunchSelection.createDefaultMatchJRE());
    }

    public static LaunchDesc buildDescriptor(byte[] byArray, URL uRL, URL uRL2) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return LaunchDescFactory.buildDescriptor(byArray, uRL, uRL2, null);
    }

    public static LaunchDesc buildDescriptor(File file, URL uRL, URL uRL2, URL uRL3) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        return LaunchDescFactory.buildDescriptor(LaunchDescFactory.readBytes(new FileInputStream(file), file.length()), uRL, uRL2, uRL3);
    }

    public static LaunchDesc buildDescriptor(File file) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((String)file.getPath());
        if (localApplicationProperties != null) {
            String string = localApplicationProperties.getDocumentBase();
            String string2 = localApplicationProperties.getCodebase();
            URL uRL = null;
            URL uRL2 = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            try {
                uRL2 = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return LaunchDescFactory.buildDescriptor(file, uRL, uRL2, null);
        }
        String string = System.getProperty("jnlpx.origFilenameArg");
        if (string != null) {
            Object object;
            File file2 = new File(string);
            URL uRL = null;
            try {
                object = file2.getAbsoluteFile().getParent();
                if (((String)object).startsWith(File.separator)) {
                    object = ((String)object).substring(1, ((String)object).length());
                }
                uRL = new URL("file:/" + (String)object + File.separator);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
            if (uRL != null) {
                object = new URL(uRL.toString() + file2.getName());
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, uRL, null, (URL)object);
                derivedCodebase = uRL;
                return launchDesc;
            }
        }
        return null;
    }

    public static LaunchDesc buildDescriptor(URL uRL, URL uRL2) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        File file;
        IOException iOException = null;
        try {
            file = DownloadEngine.getCachedFile((URL)uRL, null, (boolean)true, (boolean)false, null);
        }
        catch (IOException iOException2) {
            if (iOException2 instanceof UnknownHostException || iOException2 instanceof FailedDownloadException || iOException2 instanceof ConnectException || iOException2 instanceof SocketException) {
                Trace.ignoredException((Exception)iOException2);
                iOException = iOException2;
                file = DownloadEngine.getCachedFile((URL)uRL, null, (boolean)false, (boolean)false, null);
                if (file == null && DeployOfflineManager.isForcedOffline()) {
                    throw iOException2;
                }
            }
            throw iOException2;
        }
        URL uRL3 = URLUtil.asPathURL((URL)URLUtil.getBase((URL)uRL));
        if (file != null && file.exists()) {
            URL uRL4 = DownloadEngine.getKnownRedirectFinalURL((URL)uRL);
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file, uRL3, uRL2, uRL4 != null ? uRL4 : uRL);
            if (launchDesc != null && launchDesc.getLaunchType() == 5) {
                DownloadEngine.removeCachedResource((URL)uRL, null, null);
            }
            if (iOException != null && !launchDesc.getInformation().supportsOfflineOperation()) {
                throw iOException;
            }
            derivedCodebase = uRL3;
            return launchDesc;
        }
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = httpRequest.doGetRequest(uRL);
        FilterInputStream filterInputStream = httpResponse.getInputStream();
        int n = httpResponse.getContentLength();
        String string = httpResponse.getContentEncoding();
        if (string != null && string.indexOf("gzip") >= 0) {
            filterInputStream = new GZIPInputStream((InputStream)filterInputStream, 8192);
        }
        URL uRL5 = HttpUtils.getFinalRedirectedURL((HttpResponse)httpResponse);
        LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(LaunchDescFactory.readBytes(filterInputStream, n), uRL3, uRL2, uRL5 != null ? uRL5 : uRL);
        ((InputStream)filterInputStream).close();
        return launchDesc;
    }

    public static LaunchDesc buildDescriptor(String string, String string2, URL uRL, boolean bl) throws BadFieldException, MissingFieldException, JNLParseException {
        URL uRL2 = null;
        if (bl) {
            System.out.println("JNLP Build LaunchDesc jnlp: " + string + ", codebaseStr: " + string2 + ", documentbase: " + uRL);
        }
        try {
            uRL2 = URLUtil.asPathURL((URL)new URL(string2));
            if (bl) {
                System.out.println("   JNLP Codebase (absolute): " + uRL2);
            }
        }
        catch (Exception exception) {
            uRL2 = null;
        }
        if (uRL2 == null) {
            try {
                uRL2 = URLUtil.asPathURL((URL)new URL(URLUtil.getBase((URL)uRL), string2));
                if (bl) {
                    System.out.println("   JNLP Codebase (documentbase+codebase): " + uRL2);
                }
            }
            catch (Exception exception) {
                uRL2 = null;
            }
        }
        if (bl && uRL2 == null) {
            System.out.println("   JNLP Codebase (null)");
        }
        return LaunchDescFactory.buildDescriptor(string, uRL2, uRL, bl);
    }

    private static LaunchDesc buildDescriptorFromCache(URL uRL, URL uRL2) throws BadFieldException, MissingFieldException, JNLParseException {
        try {
            File file = DownloadEngine.getCachedFile((URL)uRL, null, (boolean)false, (boolean)false, null);
            if (file != null) {
                URL uRL3 = URLUtil.asPathURL((URL)URLUtil.getBase((URL)uRL));
                return LaunchDescFactory.buildDescriptor(file, uRL3, uRL2, uRL);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static LaunchDesc buildDescriptorFromCache(String string, URL uRL, URL uRL2) throws BadFieldException, MissingFieldException, JNLParseException {
        URL uRL3 = null;
        LaunchDesc launchDesc = null;
        try {
            uRL3 = new URL(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL3 != null && (launchDesc = LaunchDescFactory.buildDescriptorFromCache(uRL3, uRL2)) != null) {
            return launchDesc;
        }
        if (uRL != null) {
            try {
                uRL3 = new URL(uRL, string);
            }
            catch (Exception exception) {
                uRL3 = null;
            }
            launchDesc = LaunchDescFactory.buildDescriptorFromCache(uRL3, uRL2);
            if (launchDesc != null) {
                return launchDesc;
            }
        }
        if (uRL == null && uRL2 != null) {
            try {
                uRL3 = new URL(URLUtil.getBase((URL)uRL2), string);
            }
            catch (Exception exception) {
                uRL3 = null;
            }
            launchDesc = LaunchDescFactory.buildDescriptorFromCache(uRL3, uRL2);
            if (launchDesc != null) {
                return launchDesc;
            }
        }
        return null;
    }

    public static LaunchDesc buildDescriptor(String string, URL uRL, URL uRL2, boolean bl) throws BadFieldException, MissingFieldException, JNLParseException {
        LaunchDesc launchDesc;
        URL uRL3 = null;
        try {
            uRL3 = new URL(string);
        }
        catch (Exception exception) {
            uRL3 = null;
        }
        if (uRL3 != null) {
            try {
                LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(uRL3, uRL2);
                if (bl) {
                    System.out.println("   JNLP Ref (absolute): " + uRL3.toString());
                }
                return launchDesc2;
            }
            catch (BadFieldException badFieldException) {
                throw badFieldException;
            }
            catch (MissingFieldException missingFieldException) {
                throw missingFieldException;
            }
            catch (JNLParseException jNLParseException) {
                throw jNLParseException;
            }
            catch (Exception exception) {
                if (bl) {
                    System.out.println(exception);
                    exception.printStackTrace();
                }
                uRL3 = null;
            }
        }
        if (uRL != null) {
            try {
                uRL3 = new URL(uRL, string);
            }
            catch (Exception exception) {
                uRL3 = null;
            }
            if (uRL3 != null) {
                try {
                    launchDesc = LaunchDescFactory.buildDescriptor(uRL3, uRL2);
                    if (bl) {
                        System.out.println("   JNLP Ref (codebase + ref): " + uRL3.toString());
                    }
                    return launchDesc;
                }
                catch (BadFieldException badFieldException) {
                    throw badFieldException;
                }
                catch (MissingFieldException missingFieldException) {
                    throw missingFieldException;
                }
                catch (JNLParseException jNLParseException) {
                    throw jNLParseException;
                }
                catch (Exception exception) {
                    if (bl) {
                        System.out.println(exception);
                        exception.printStackTrace();
                    }
                    uRL3 = null;
                }
            }
        }
        if (uRL == null && uRL2 != null) {
            try {
                uRL3 = new URL(URLUtil.getBase((URL)uRL2), string);
            }
            catch (Exception exception) {
                uRL3 = null;
            }
            if (uRL3 != null) {
                try {
                    launchDesc = LaunchDescFactory.buildDescriptor(uRL3, uRL2);
                    if (bl) {
                        System.out.println("   JNLP Ref (documentbase + ref): " + uRL3.toString());
                    }
                    return launchDesc;
                }
                catch (BadFieldException badFieldException) {
                    throw badFieldException;
                }
                catch (MissingFieldException missingFieldException) {
                    throw missingFieldException;
                }
                catch (JNLParseException jNLParseException) {
                    throw jNLParseException;
                }
                catch (Exception exception) {
                    if (bl) {
                        System.out.println(exception);
                        exception.printStackTrace();
                    }
                    uRL3 = null;
                }
            }
        }
        if (bl) {
            System.out.println("   JNLP Ref (...): NULL !");
        }
        return null;
    }

    public static LaunchDesc buildDescriptor(String string) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        FileInputStream fileInputStream = null;
        Object var2_2 = null;
        int n = -1;
        try {
            URL uRL = new URL(string);
            return LaunchDescFactory.buildDescriptor(uRL, null);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (!file.exists() && !Config.isJavaVersionAtLeast14() && malformedURLException.getMessage().indexOf("https") != -1) {
                throw new BadFieldException(ResourceManager.getString((String)"launch.error.badfield.download.https"), "<jnlp>", "https");
            }
            fileInputStream = new FileInputStream(string);
            long l = file.length();
            if (l > 0x100000L) {
                throw new IOException("File too large");
            }
            n = (int)l;
            if (Environment.isImportMode()) {
                String string2 = file.getParent();
                if (Environment.getImportModeCodebaseOverride() == null && string2 != null) {
                    try {
                        URL uRL = new URL("file", null, URLUtil.encodePath((String)string2));
                        Environment.setImportModeCodebaseOverride((String)uRL.toString());
                    }
                    catch (MalformedURLException malformedURLException2) {
                        Trace.ignoredException((Exception)malformedURLException2);
                    }
                }
            }
            return LaunchDescFactory.buildDescriptor(LaunchDescFactory.readBytes(fileInputStream, n), null, null, file.toURI().toURL());
        }
    }

    public static LaunchDesc buildInternalLaunchDesc(String string, String string2, String string3) {
        return new LaunchDesc("0.1", null, null, null, null, 1, null, null, 5, null, null, null, null, string3 == null ? string : string3, string2, null, LaunchSelection.createDefaultMatchJRE());
    }

    public static byte[] readBytes(InputStream inputStream, long l) throws IOException {
        byte[] byArray;
        if (l > 0x100000L) {
            throw new IOException("File too large");
        }
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        if (l <= 0L) {
            l = 10240L;
        }
        byte[] byArray2 = new byte[(int)l];
        int n = 0;
        int n2 = bufferedInputStream.read(byArray2, n, byArray2.length - n);
        while (n2 != -1) {
            if (byArray2.length == (n += n2)) {
                byArray = new byte[byArray2.length * 2];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byArray2 = byArray;
            }
            n2 = bufferedInputStream.read(byArray2, n, byArray2.length - n);
        }
        bufferedInputStream.close();
        inputStream.close();
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }
}

