/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PDLOverrideSupported;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PagesPerMinute;
import javax.print.attribute.standard.PagesPerMinuteColor;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterMessageFromOperator;
import javax.print.attribute.standard.PrinterMoreInfo;
import javax.print.attribute.standard.PrinterMoreInfoManufacturer;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;
import sun.print.AttributeClass;
import sun.print.CUPSPrinter;
import sun.print.CustomMediaSizeName;
import sun.print.CustomMediaTray;
import sun.print.PSPrinterJob;
import sun.print.ServiceNotifier;
import sun.print.SunPrinterJobService;
import sun.print.UnixPrintJob;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPPPrintService
implements PrintService,
SunPrinterJobService {
    public static final boolean debugPrint;
    private static final String debugPrefix = "IPPPrintService>> ";
    private static final String FORCE_PIPE_PROP = "sun.print.ippdebug";
    private String printer;
    private URI myURI;
    private URL myURL;
    private transient ServiceNotifier notifier = null;
    private static int MAXCOPIES;
    private static short MAX_ATTRIBUTE_LENGTH;
    private CUPSPrinter cps;
    private HttpURLConnection urlConnection = null;
    private DocFlavor[] supportedDocFlavors;
    private Class[] supportedCats;
    private MediaTray[] mediaTrays;
    private MediaSizeName[] mediaSizeNames;
    private CustomMediaSizeName[] customMediaSizeNames;
    private int defaultMediaIndex;
    private boolean isCupsPrinter;
    private boolean init;
    private Boolean isPS;
    private HashMap getAttMap;
    private boolean pngImagesAdded = false;
    private boolean gifImagesAdded = false;
    private boolean jpgImagesAdded = false;
    private static final byte STATUSCODE_SUCCESS = 0;
    private static final byte GRPTAG_OP_ATTRIBUTES = 1;
    private static final byte GRPTAG_JOB_ATTRIBUTES = 2;
    private static final byte GRPTAG_PRINTER_ATTRIBUTES = 4;
    private static final byte GRPTAG_END_ATTRIBUTES = 3;
    public static final String OP_GET_ATTRIBUTES = "000B";
    public static final String OP_CUPS_GET_DEFAULT = "4001";
    public static final String OP_CUPS_GET_PRINTERS = "4002";
    private static Object[] printReqAttribDefault;
    private static Object[][] serviceAttributes;
    private static DocFlavor[] appPDF;
    private static DocFlavor[] appPostScript;
    private static DocFlavor[] appOctetStream;
    private static DocFlavor[] textPlain;
    private static DocFlavor[] textPlainHost;
    private static DocFlavor[] imageJPG;
    private static DocFlavor[] imageGIF;
    private static DocFlavor[] imagePNG;
    private static DocFlavor[] textHtml;
    private static DocFlavor[] textHtmlHost;
    private static DocFlavor[] appPCL;
    private static Object[] allDocFlavors;

    protected static void debug_println(String string) {
        if (debugPrint) {
            System.out.println(string);
        }
    }

    IPPPrintService(String string, URL uRL) {
        if (string == null || uRL == null) {
            throw new IllegalArgumentException("null uri or printer name");
        }
        this.printer = string;
        this.supportedDocFlavors = null;
        this.supportedCats = null;
        this.mediaSizeNames = null;
        this.customMediaSizeNames = null;
        this.mediaTrays = null;
        this.myURL = uRL;
        this.cps = null;
        this.isCupsPrinter = false;
        this.init = false;
        this.defaultMediaIndex = -1;
        String string2 = this.myURL.getHost();
        if (string2 != null && string2.equals(CUPSPrinter.getServer())) {
            this.isCupsPrinter = true;
            try {
                this.myURI = new URI("ipp://" + string2 + "/printers/" + this.printer);
                IPPPrintService.debug_println("IPPPrintService>> IPPPrintService myURI : " + this.myURI);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("invalid url");
            }
        }
    }

    IPPPrintService(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("null uri or printer name");
        }
        this.printer = string;
        this.supportedDocFlavors = null;
        this.supportedCats = null;
        this.mediaSizeNames = null;
        this.customMediaSizeNames = null;
        this.mediaTrays = null;
        this.cps = null;
        this.isCupsPrinter = false;
        this.init = false;
        this.defaultMediaIndex = -1;
        try {
            this.myURL = new URL(string2.replaceFirst("ipp", "http"));
        }
        catch (Exception exception) {
            IPPPrintService.debug_println("IPPPrintService>>  IPPPrintService, myURL=" + this.myURL + " Exception= " + exception);
        }
        this.isCupsPrinter = bl;
        try {
            this.myURI = new URI(string2);
            IPPPrintService.debug_println("IPPPrintService>> IPPPrintService myURI : " + this.myURI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("invalid uri");
        }
    }

    private void initAttributes() {
        if (!this.init) {
            this.customMediaSizeNames = new CustomMediaSizeName[0];
            this.urlConnection = IPPPrintService.getIPPConnection(this.myURL);
            if (this.urlConnection == null) {
                this.mediaSizeNames = new MediaSizeName[0];
                this.mediaTrays = new MediaTray[0];
                IPPPrintService.debug_println("initAttributes, NULL urlConnection ");
                this.init = true;
                return;
            }
            this.opGetAttributes();
            if (this.isCupsPrinter) {
                try {
                    this.cps = new CUPSPrinter(this.printer);
                    this.mediaSizeNames = this.cps.getMediaSizeNames();
                    this.mediaTrays = this.cps.getMediaTrays();
                    this.customMediaSizeNames = this.cps.getCustomMediaSizeNames();
                    this.urlConnection.disconnect();
                    this.init = true;
                    return;
                }
                catch (Exception exception) {
                    IPPPrintService.debug_println("IPPPrintService>> initAttributes, error creating CUPSPrinter e=" + exception);
                }
            }
            Media[] mediaArray = this.getSupportedMedia();
            ArrayList<Media> arrayList = new ArrayList<Media>();
            ArrayList<Media> arrayList2 = new ArrayList<Media>();
            for (int i = 0; i < mediaArray.length; ++i) {
                if (mediaArray[i] instanceof MediaSizeName) {
                    arrayList.add(mediaArray[i]);
                    continue;
                }
                if (!(mediaArray[i] instanceof MediaTray)) continue;
                arrayList2.add(mediaArray[i]);
            }
            if (arrayList != null) {
                this.mediaSizeNames = new MediaSizeName[arrayList.size()];
                this.mediaSizeNames = arrayList.toArray(this.mediaSizeNames);
            }
            if (arrayList2 != null) {
                this.mediaTrays = new MediaTray[arrayList2.size()];
                this.mediaTrays = arrayList2.toArray(this.mediaTrays);
            }
            this.urlConnection.disconnect();
            this.init = true;
        }
    }

    @Override
    public DocPrintJob createPrintJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new UnixPrintJob(this);
    }

    @Override
    public synchronized Object getSupportedAttributeValues(Class<? extends Attribute> clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " does not implement Attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor)) {
                return null;
            }
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (!this.isDestinationSupported(docFlavor, attributeSet)) {
            return null;
        }
        this.initAttributes();
        if (clazz == Copies.class || clazz == CopiesSupported.class) {
            AttributeClass attributeClass;
            CopiesSupported copiesSupported = new CopiesSupported(1, MAXCOPIES);
            AttributeClass attributeClass2 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(copiesSupported.getName()) : null;
            if (attributeClass != null) {
                int[] nArray = attributeClass.getIntRangeValue();
                copiesSupported = new CopiesSupported(nArray[0], nArray[1]);
            }
            return copiesSupported;
        }
        if (clazz == Chromaticity.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                Chromaticity[] chromaticityArray = new Chromaticity[]{Chromaticity.COLOR};
                return chromaticityArray;
            }
            return null;
        }
        if (clazz == Destination.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                try {
                    return new Destination(new File("out.ps").toURI());
                }
                catch (SecurityException securityException) {
                    try {
                        return new Destination(new URI("file:out.ps"));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        return null;
                    }
                }
            }
            return null;
        }
        if (clazz == Fidelity.class) {
            Fidelity[] fidelityArray = new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
            return fidelityArray;
        }
        if (clazz == Finishings.class) {
            int[] nArray;
            AttributeClass attributeClass;
            AttributeClass attributeClass3 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("finishings-supported") : null;
            if (attributeClass != null && (nArray = attributeClass.getArrayOfIntValues()) != null && nArray.length > 0) {
                Finishings[] finishingsArray = new Finishings[nArray.length];
                block11: for (int i = 0; i < nArray.length; ++i) {
                    finishingsArray[i] = Finishings.NONE;
                    Finishings[] finishingsArray2 = (Finishings[])new ExtFinishing(100).getAll();
                    for (int j = 0; j < finishingsArray2.length; ++j) {
                        if (nArray[i] != finishingsArray2[j].getValue()) continue;
                        finishingsArray[i] = finishingsArray2[j];
                        continue block11;
                    }
                }
                return finishingsArray;
            }
        } else {
            if (clazz == JobName.class) {
                return new JobName("Java Printing", null);
            }
            if (clazz == JobSheets.class) {
                JobSheets[] jobSheetsArray = new JobSheets[]{JobSheets.NONE, JobSheets.STANDARD};
                return jobSheetsArray;
            }
            if (clazz == Media.class) {
                int n;
                Media[] mediaArray = new Media[this.mediaSizeNames.length + this.mediaTrays.length];
                for (n = 0; n < this.mediaSizeNames.length; ++n) {
                    mediaArray[n] = this.mediaSizeNames[n];
                }
                for (n = 0; n < this.mediaTrays.length; ++n) {
                    mediaArray[n + this.mediaSizeNames.length] = this.mediaTrays[n];
                }
                if (mediaArray.length == 0) {
                    mediaArray = new Media[]{(Media)this.getDefaultAttributeValue(Media.class)};
                }
                return mediaArray;
            }
            if (clazz == MediaPrintableArea.class) {
                MediaPrintableArea[] mediaPrintableAreaArray;
                MediaPrintableArea[] mediaPrintableAreaArray2 = null;
                if (this.cps != null) {
                    mediaPrintableAreaArray2 = this.cps.getMediaPrintableArea();
                }
                if (mediaPrintableAreaArray2 == null) {
                    mediaPrintableAreaArray2 = new MediaPrintableArea[]{(MediaPrintableArea)this.getDefaultAttributeValue(MediaPrintableArea.class)};
                }
                if (attributeSet == null || attributeSet.size() == 0) {
                    return mediaPrintableAreaArray2;
                }
                int n = -1;
                Media media = (Media)attributeSet.get(Media.class);
                if (media != null && media instanceof MediaSizeName) {
                    mediaPrintableAreaArray = (MediaPrintableArea[])media;
                    if (this.mediaSizeNames.length == 0 && mediaPrintableAreaArray.equals(this.getDefaultAttributeValue(Media.class))) {
                        return mediaPrintableAreaArray2;
                    }
                    for (int i = 0; i < this.mediaSizeNames.length; ++i) {
                        if (!mediaPrintableAreaArray.equals(this.mediaSizeNames[i])) continue;
                        n = i;
                    }
                }
                if (n == -1) {
                    return null;
                }
                mediaPrintableAreaArray = new MediaPrintableArea[]{mediaPrintableAreaArray2[n]};
                return mediaPrintableAreaArray;
            }
            if (clazz == NumberUp.class) {
                AttributeClass attributeClass;
                AttributeClass attributeClass4 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("number-up-supported") : null;
                if (attributeClass != null) {
                    int[] nArray = attributeClass.getArrayOfIntValues();
                    if (nArray != null) {
                        NumberUp[] numberUpArray = new NumberUp[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            numberUpArray[i] = new NumberUp(nArray[i]);
                        }
                        return numberUpArray;
                    }
                    return null;
                }
            } else {
                if (clazz == OrientationRequested.class) {
                    Object[] objectArray;
                    AttributeClass attributeClass;
                    boolean bl = false;
                    OrientationRequested[] orientationRequestedArray = null;
                    AttributeClass attributeClass5 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("orientation-requested-supported") : null;
                    if (attributeClass != null && (objectArray = attributeClass.getArrayOfIntValues()) != null && objectArray.length > 0) {
                        orientationRequestedArray = new OrientationRequested[objectArray.length];
                        block17: for (int i = 0; i < objectArray.length; ++i) {
                            switch (objectArray[i]) {
                                default: {
                                    orientationRequestedArray[i] = OrientationRequested.PORTRAIT;
                                    continue block17;
                                }
                                case 4: {
                                    orientationRequestedArray[i] = OrientationRequested.LANDSCAPE;
                                    continue block17;
                                }
                                case 5: {
                                    orientationRequestedArray[i] = OrientationRequested.REVERSE_LANDSCAPE;
                                    continue block17;
                                }
                                case 6: {
                                    orientationRequestedArray[i] = OrientationRequested.REVERSE_PORTRAIT;
                                    bl = true;
                                }
                            }
                        }
                    }
                    if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                        if (bl && docFlavor == null) {
                            objectArray = new OrientationRequested[4];
                            objectArray[0] = (int)OrientationRequested.PORTRAIT;
                            objectArray[1] = (int)OrientationRequested.LANDSCAPE;
                            objectArray[2] = (int)OrientationRequested.REVERSE_LANDSCAPE;
                            objectArray[3] = (int)OrientationRequested.REVERSE_PORTRAIT;
                            return objectArray;
                        }
                        objectArray = new OrientationRequested[3];
                        objectArray[0] = (int)OrientationRequested.PORTRAIT;
                        objectArray[1] = (int)OrientationRequested.LANDSCAPE;
                        objectArray[2] = (int)OrientationRequested.REVERSE_LANDSCAPE;
                        return objectArray;
                    }
                    return orientationRequestedArray;
                }
                if (clazz == PageRanges.class) {
                    if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                        PageRanges[] pageRangesArray = new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
                        return pageRangesArray;
                    }
                    return null;
                }
                if (clazz == RequestingUserName.class) {
                    String string = "";
                    try {
                        string = System.getProperty("user.name", "");
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return new RequestingUserName(string, null);
                }
                if (clazz == Sides.class) {
                    String[] stringArray;
                    AttributeClass attributeClass;
                    AttributeClass attributeClass6 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get("sides-supported") : null;
                    if (attributeClass != null && (stringArray = attributeClass.getArrayOfStringValues()) != null && stringArray.length > 0) {
                        Sides[] sidesArray = new Sides[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            sidesArray[i] = stringArray[i].endsWith("long-edge") ? Sides.TWO_SIDED_LONG_EDGE : (stringArray[i].endsWith("short-edge") ? Sides.TWO_SIDED_SHORT_EDGE : Sides.ONE_SIDED);
                        }
                        return sidesArray;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor " + docFlavor + "is not supported");
        }
        if (attributeSet == null) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            try {
                Attribute attribute = attributeArray[i];
                if (!this.isAttributeCategorySupported(attribute.getCategory())) {
                    hashAttributeSet.add(attribute);
                    continue;
                }
                if (this.isAttributeValueSupported(attribute, docFlavor, attributeSet)) continue;
                hashAttributeSet.add(attribute);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (hashAttributeSet.isEmpty()) {
            return null;
        }
        return hashAttributeSet;
    }

    @Override
    public synchronized DocFlavor[] getSupportedDocFlavors() {
        AttributeClass attributeClass;
        if (this.supportedDocFlavors != null) {
            int n = this.supportedDocFlavors.length;
            DocFlavor[] docFlavorArray = new DocFlavor[n];
            System.arraycopy(this.supportedDocFlavors, 0, docFlavorArray, 0, n);
            return docFlavorArray;
        }
        this.initAttributes();
        if (this.getAttMap != null && this.getAttMap.containsKey("document-format-supported") && (attributeClass = (AttributeClass)this.getAttMap.get("document-format-supported")) != null) {
            int n;
            boolean bl = false;
            String[] stringArray = attributeClass.getArrayOfStringValues();
            HashSet<Object> hashSet = new HashSet<Object>();
            String string = DocFlavor.hostEncoding.toLowerCase(Locale.ENGLISH);
            boolean bl2 = !string.equals("utf-8") && !string.equals("utf-16") && !string.equals("utf-16be") && !string.equals("utf-16le") && !string.equals("us-ascii");
            for (n = 0; n < stringArray.length; ++n) {
                int n2;
                for (n2 = 0; n2 < allDocFlavors.length; ++n2) {
                    DocFlavor[] docFlavorArray = (DocFlavor[])allDocFlavors[n2];
                    String string2 = docFlavorArray[0].getMimeType();
                    if (!string2.startsWith(stringArray[n])) continue;
                    hashSet.addAll(Arrays.asList(docFlavorArray));
                    if (string2.equals("text/plain") && bl2) {
                        hashSet.add(Arrays.asList(textPlainHost));
                        break;
                    }
                    if (string2.equals("text/html") && bl2) {
                        hashSet.add(Arrays.asList(textHtmlHost));
                        break;
                    }
                    if (string2.equals("image/png")) {
                        this.pngImagesAdded = true;
                        break;
                    }
                    if (string2.equals("image/gif")) {
                        this.gifImagesAdded = true;
                        break;
                    }
                    if (string2.equals("image/jpeg")) {
                        this.jpgImagesAdded = true;
                        break;
                    }
                    if (string2.indexOf("postscript") == -1) break;
                    bl = true;
                    break;
                }
                if (n2 != allDocFlavors.length) continue;
                hashSet.add(new DocFlavor.BYTE_ARRAY(stringArray[n]));
                hashSet.add(new DocFlavor.INPUT_STREAM(stringArray[n]));
                hashSet.add(new DocFlavor.URL(stringArray[n]));
            }
            if (bl || this.isCupsPrinter) {
                hashSet.add(DocFlavor.SERVICE_FORMATTED.PAGEABLE);
                hashSet.add(DocFlavor.SERVICE_FORMATTED.PRINTABLE);
                hashSet.addAll(Arrays.asList(imageJPG));
                hashSet.addAll(Arrays.asList(imagePNG));
                hashSet.addAll(Arrays.asList(imageGIF));
            }
            this.supportedDocFlavors = new DocFlavor[hashSet.size()];
            hashSet.toArray(this.supportedDocFlavors);
            n = this.supportedDocFlavors.length;
            DocFlavor[] docFlavorArray = new DocFlavor[n];
            System.arraycopy(this.supportedDocFlavors, 0, docFlavorArray, 0, n);
            return docFlavorArray;
        }
        return null;
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        if (this.supportedDocFlavors == null) {
            this.getSupportedDocFlavors();
        }
        if (this.supportedDocFlavors != null) {
            for (int i = 0; i < this.supportedDocFlavors.length; ++i) {
                if (!docFlavor.equals(this.supportedDocFlavors[i])) continue;
                return true;
            }
        }
        return false;
    }

    public CustomMediaSizeName findCustomMedia(MediaSizeName mediaSizeName) {
        if (this.customMediaSizeNames == null) {
            return null;
        }
        for (int i = 0; i < this.customMediaSizeNames.length; ++i) {
            CustomMediaSizeName customMediaSizeName = this.customMediaSizeNames[i];
            MediaSizeName mediaSizeName2 = customMediaSizeName.getStandardMedia();
            if (!mediaSizeName.equals(mediaSizeName2)) continue;
            return this.customMediaSizeNames[i];
        }
        return null;
    }

    private Media getIPPMedia(String string) {
        CustomMediaSizeName customMediaSizeName = new CustomMediaSizeName("sample", "", 0.0f, 0.0f);
        Media[] mediaArray = customMediaSizeName.getSuperEnumTable();
        for (int i = 0; i < mediaArray.length; ++i) {
            if (!string.equals("" + mediaArray[i])) continue;
            return mediaArray[i];
        }
        CustomMediaTray customMediaTray = new CustomMediaTray("sample", "");
        Media[] mediaArray2 = customMediaTray.getSuperEnumTable();
        for (int i = 0; i < mediaArray2.length; ++i) {
            if (!string.equals("" + mediaArray2[i])) continue;
            return mediaArray2[i];
        }
        return null;
    }

    private Media[] getSupportedMedia() {
        AttributeClass attributeClass;
        if (this.getAttMap != null && this.getAttMap.containsKey("media-supported") && (attributeClass = (AttributeClass)this.getAttMap.get("media-supported")) != null) {
            String[] stringArray = attributeClass.getArrayOfStringValues();
            Media[] mediaArray = new Media[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Media media;
                mediaArray[i] = media = this.getIPPMedia(stringArray[i]);
            }
            return mediaArray;
        }
        return new Media[0];
    }

    public synchronized Class[] getSupportedAttributeCategories() {
        if (this.supportedCats != null) {
            Class[] classArray = new Class[this.supportedCats.length];
            System.arraycopy(this.supportedCats, 0, classArray, 0, classArray.length);
            return classArray;
        }
        this.initAttributes();
        ArrayList<Class<Attribute>> arrayList = new ArrayList<Class<Attribute>>();
        for (int i = 0; i < printReqAttribDefault.length; ++i) {
            PrintRequestAttribute printRequestAttribute = (PrintRequestAttribute)printReqAttribDefault[i];
            if (this.getAttMap == null || !this.getAttMap.containsKey(printRequestAttribute.getName() + "-supported")) continue;
            Class<? extends Attribute> clazz = printRequestAttribute.getCategory();
            arrayList.add(clazz);
        }
        if (this.isCupsPrinter) {
            if (!arrayList.contains(Media.class)) {
                arrayList.add(Media.class);
            }
            arrayList.add(MediaPrintableArea.class);
            arrayList.add(Destination.class);
        }
        if (this.getAttMap != null && this.getAttMap.containsKey("color-supported")) {
            arrayList.add(Chromaticity.class);
        }
        this.supportedCats = new Class[arrayList.size()];
        arrayList.toArray(this.supportedCats);
        Class[] classArray = new Class[this.supportedCats.length];
        System.arraycopy(this.supportedCats, 0, classArray, 0, classArray.length);
        return classArray;
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (this.supportedCats == null) {
            this.getSupportedAttributeCategories();
        }
        if (clazz == OrientationRequested.class) {
            return true;
        }
        for (int i = 0; i < this.supportedCats.length; ++i) {
            if (clazz != this.supportedCats[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized <T extends PrintServiceAttribute> T getAttribute(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("category");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not a PrintServiceAttribute");
        }
        this.initAttributes();
        if (clazz == PrinterName.class) {
            return (T)new PrinterName(this.printer, null);
        }
        if (clazz == QueuedJobCount.class) {
            AttributeClass attributeClass;
            QueuedJobCount queuedJobCount = new QueuedJobCount(0);
            AttributeClass attributeClass2 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(queuedJobCount.getName()) : null;
            if (attributeClass != null) {
                queuedJobCount = new QueuedJobCount(attributeClass.getIntValue());
            }
            return (T)queuedJobCount;
        }
        if (clazz == PrinterIsAcceptingJobs.class) {
            AttributeClass attributeClass;
            PrinterIsAcceptingJobs printerIsAcceptingJobs = PrinterIsAcceptingJobs.ACCEPTING_JOBS;
            AttributeClass attributeClass3 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(printerIsAcceptingJobs.getName()) : null;
            if (attributeClass != null && attributeClass.getByteValue() == 0) {
                printerIsAcceptingJobs = PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS;
            }
            return (T)printerIsAcceptingJobs;
        }
        if (clazz == ColorSupported.class) {
            AttributeClass attributeClass;
            ColorSupported colorSupported = ColorSupported.SUPPORTED;
            AttributeClass attributeClass4 = attributeClass = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(colorSupported.getName()) : null;
            if (attributeClass != null && attributeClass.getByteValue() == 0) {
                colorSupported = ColorSupported.NOT_SUPPORTED;
            }
            return (T)colorSupported;
        }
        if (clazz == PDLOverrideSupported.class) {
            if (this.isCupsPrinter) {
                return (T)PDLOverrideSupported.NOT_ATTEMPTED;
            }
            return (T)PDLOverrideSupported.NOT_ATTEMPTED;
        }
        return null;
    }

    @Override
    public synchronized PrintServiceAttributeSet getAttributes() {
        this.init = false;
        this.initAttributes();
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        for (int i = 0; i < serviceAttributes.length; ++i) {
            Class clazz;
            Object t;
            String string = (String)serviceAttributes[i][1];
            if (this.getAttMap == null || !this.getAttMap.containsKey(string) || (t = this.getAttribute(clazz = (Class)serviceAttributes[i][0])) == null) continue;
            hashPrintServiceAttributeSet.add((Attribute)t);
        }
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    public boolean isIPPSupportedImages(String string) {
        if (this.supportedDocFlavors == null) {
            this.getSupportedDocFlavors();
        }
        if (string.equals("image/png") && this.pngImagesAdded) {
            return true;
        }
        if (string.equals("image/gif") && this.gifImagesAdded) {
            return true;
        }
        return string.equals("image/jpeg") && this.jpgImagesAdded;
    }

    private boolean isSupportedCopies(Copies copies) {
        int n;
        int n2;
        CopiesSupported copiesSupported = (CopiesSupported)this.getSupportedAttributeValues(Copies.class, null, null);
        int[][] nArray = copiesSupported.getMembers();
        if (nArray.length > 0 && nArray[0].length > 0) {
            n2 = nArray[0][0];
            n = nArray[0][1];
        } else {
            n2 = 1;
            n = MAXCOPIES;
        }
        int n3 = copies.getValue();
        return n3 >= n2 && n3 <= n;
    }

    private boolean isAutoSense(DocFlavor docFlavor) {
        return docFlavor.equals(DocFlavor.BYTE_ARRAY.AUTOSENSE) || docFlavor.equals(DocFlavor.INPUT_STREAM.AUTOSENSE) || docFlavor.equals(DocFlavor.URL.AUTOSENSE);
    }

    private synchronized boolean isSupportedMediaTray(MediaTray mediaTray) {
        this.initAttributes();
        if (this.mediaTrays != null) {
            for (int i = 0; i < this.mediaTrays.length; ++i) {
                if (!mediaTray.equals(this.mediaTrays[i])) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized boolean isSupportedMedia(MediaSizeName mediaSizeName) {
        this.initAttributes();
        if (mediaSizeName.equals((Media)this.getDefaultAttributeValue(Media.class))) {
            return true;
        }
        for (int i = 0; i < this.mediaSizeNames.length; ++i) {
            IPPPrintService.debug_println("isSupportedMedia, mediaSizeNames[i] " + this.mediaSizeNames[i]);
            if (!mediaSizeName.equals(this.mediaSizeNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isDestinationSupported(DocFlavor docFlavor, AttributeSet attributeSet) {
        return attributeSet == null || attributeSet.get(Destination.class) == null || docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE);
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        Class<? extends Attribute> clazz;
        if (attribute == null) {
            throw new NullPointerException("null attribute");
        }
        if (docFlavor != null) {
            if (!this.isDocFlavorSupported(docFlavor)) {
                throw new IllegalArgumentException(docFlavor + " is an unsupported flavor");
            }
            if (this.isAutoSense(docFlavor)) {
                return false;
            }
        }
        if (!this.isAttributeCategorySupported(clazz = attribute.getCategory())) {
            return false;
        }
        if (!this.isDestinationSupported(docFlavor, attributeSet)) {
            return false;
        }
        if (attribute.getCategory() == Chromaticity.class) {
            if (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE) || docFlavor.equals(DocFlavor.BYTE_ARRAY.GIF) || docFlavor.equals(DocFlavor.INPUT_STREAM.GIF) || docFlavor.equals(DocFlavor.URL.GIF) || docFlavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || docFlavor.equals(DocFlavor.INPUT_STREAM.JPEG) || docFlavor.equals(DocFlavor.URL.JPEG) || docFlavor.equals(DocFlavor.BYTE_ARRAY.PNG) || docFlavor.equals(DocFlavor.INPUT_STREAM.PNG) || docFlavor.equals(DocFlavor.URL.PNG)) {
                return attribute == Chromaticity.COLOR;
            }
            return false;
        }
        if (attribute.getCategory() == Copies.class) {
            return this.isSupportedCopies((Copies)attribute);
        }
        if (attribute.getCategory() == Destination.class) {
            URI uRI;
            return (docFlavor == null || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) || docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) && "file".equals((uRI = ((Destination)attribute).getURI()).getScheme()) && !uRI.getSchemeSpecificPart().equals("");
        }
        if (attribute.getCategory() == Media.class) {
            if (attribute instanceof MediaSizeName) {
                return this.isSupportedMedia((MediaSizeName)attribute);
            }
            if (attribute instanceof MediaTray) {
                return this.isSupportedMediaTray((MediaTray)attribute);
            }
        } else if (attribute.getCategory() == PageRanges.class) {
            if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                return false;
            }
        } else if (attribute.getCategory() == SheetCollate.class) {
            if (docFlavor != null && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PAGEABLE) && !docFlavor.equals(DocFlavor.SERVICE_FORMATTED.PRINTABLE)) {
                return false;
            }
        } else {
            if (attribute.getCategory() == Sides.class) {
                Sides[] sidesArray = (Sides[])this.getSupportedAttributeValues(Sides.class, docFlavor, attributeSet);
                if (sidesArray != null) {
                    for (int i = 0; i < sidesArray.length; ++i) {
                        if (sidesArray[i] != (Sides)attribute) continue;
                        return true;
                    }
                }
                return false;
            }
            if (attribute.getCategory() == OrientationRequested.class) {
                OrientationRequested[] orientationRequestedArray = (OrientationRequested[])this.getSupportedAttributeValues(OrientationRequested.class, docFlavor, attributeSet);
                if (orientationRequestedArray != null) {
                    for (int i = 0; i < orientationRequestedArray.length; ++i) {
                        if (orientationRequestedArray[i] != (OrientationRequested)attribute) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized Object getDefaultAttributeValue(Class<? extends Attribute> clazz) {
        PrintRequestAttribute printRequestAttribute;
        if (clazz == null) {
            throw new NullPointerException("null category");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not an Attribute");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        this.initAttributes();
        String string = null;
        for (int i = 0; i < printReqAttribDefault.length; ++i) {
            printRequestAttribute = (PrintRequestAttribute)printReqAttribDefault[i];
            if (printRequestAttribute.getCategory() != clazz) continue;
            string = printRequestAttribute.getName();
            break;
        }
        String string2 = string + "-default";
        PrintRequestAttribute printRequestAttribute2 = printRequestAttribute = this.getAttMap != null ? (AttributeClass)this.getAttMap.get(string2) : null;
        if (clazz == Copies.class) {
            if (printRequestAttribute != null) {
                return new Copies(((AttributeClass)((Object)printRequestAttribute)).getIntValue());
            }
            return new Copies(1);
        }
        if (clazz == Chromaticity.class) {
            return Chromaticity.COLOR;
        }
        if (clazz == Destination.class) {
            try {
                return new Destination(new File("out.ps").toURI());
            }
            catch (SecurityException securityException) {
                try {
                    return new Destination(new URI("file:out.ps"));
                }
                catch (URISyntaxException uRISyntaxException) {
                    return null;
                }
            }
        }
        if (clazz == Fidelity.class) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (clazz == Finishings.class) {
            return Finishings.NONE;
        }
        if (clazz == JobName.class) {
            return new JobName("Java Printing", null);
        }
        if (clazz == JobSheets.class) {
            if (printRequestAttribute != null && ((AttributeClass)((Object)printRequestAttribute)).getStringValue().equals("none")) {
                return JobSheets.NONE;
            }
            return JobSheets.STANDARD;
        }
        if (clazz == Media.class) {
            this.defaultMediaIndex = 0;
            if (this.mediaSizeNames.length == 0) {
                String string3 = Locale.getDefault().getCountry();
                if (string3 != null && (string3.equals("") || string3.equals(Locale.US.getCountry()) || string3.equals(Locale.CANADA.getCountry()))) {
                    return MediaSizeName.NA_LETTER;
                }
                return MediaSizeName.ISO_A4;
            }
            if (printRequestAttribute != null) {
                String string4 = ((AttributeClass)((Object)printRequestAttribute)).getStringValue();
                if (this.isCupsPrinter) {
                    for (int i = 0; i < this.customMediaSizeNames.length; ++i) {
                        if (this.customMediaSizeNames[i].toString().indexOf(string4) == -1) continue;
                        this.defaultMediaIndex = i;
                        return this.mediaSizeNames[this.defaultMediaIndex];
                    }
                } else {
                    for (int i = 0; i < this.mediaSizeNames.length; ++i) {
                        if (this.mediaSizeNames[i].toString().indexOf(string4) == -1) continue;
                        this.defaultMediaIndex = i;
                        return this.mediaSizeNames[this.defaultMediaIndex];
                    }
                }
            }
            return this.mediaSizeNames[this.defaultMediaIndex];
        }
        if (clazz == MediaPrintableArea.class) {
            float f;
            float f2;
            MediaPrintableArea[] mediaPrintableAreaArray;
            if (this.cps != null && (mediaPrintableAreaArray = this.cps.getMediaPrintableArea()) != null) {
                if (this.defaultMediaIndex == -1) {
                    this.getDefaultAttributeValue(Media.class);
                }
                return mediaPrintableAreaArray[this.defaultMediaIndex];
            }
            String string5 = Locale.getDefault().getCountry();
            if (string5 != null && (string5.equals("") || string5.equals(Locale.US.getCountry()) || string5.equals(Locale.CANADA.getCountry()))) {
                f2 = MediaSize.NA.LETTER.getX(25400) - 2.0f;
                f = MediaSize.NA.LETTER.getY(25400) - 2.0f;
            } else {
                f2 = MediaSize.ISO.A4.getX(25400) - 2.0f;
                f = MediaSize.ISO.A4.getY(25400) - 2.0f;
            }
            return new MediaPrintableArea(0.25f, 0.25f, f2, f, 25400);
        }
        if (clazz == NumberUp.class) {
            return new NumberUp(1);
        }
        if (clazz == OrientationRequested.class) {
            if (printRequestAttribute != null) {
                switch (((AttributeClass)((Object)printRequestAttribute)).getIntValue()) {
                    default: {
                        return OrientationRequested.PORTRAIT;
                    }
                    case 4: {
                        return OrientationRequested.LANDSCAPE;
                    }
                    case 5: {
                        return OrientationRequested.REVERSE_LANDSCAPE;
                    }
                    case 6: 
                }
                return OrientationRequested.REVERSE_PORTRAIT;
            }
            return OrientationRequested.PORTRAIT;
        }
        if (clazz == PageRanges.class) {
            if (printRequestAttribute != null) {
                int[] nArray = ((AttributeClass)((Object)printRequestAttribute)).getIntRangeValue();
                return new PageRanges(nArray[0], nArray[1]);
            }
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        if (clazz == RequestingUserName.class) {
            String string6 = "";
            try {
                string6 = System.getProperty("user.name", "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return new RequestingUserName(string6, null);
        }
        if (clazz == SheetCollate.class) {
            return SheetCollate.UNCOLLATED;
        }
        if (clazz == Sides.class) {
            if (printRequestAttribute != null) {
                if (((AttributeClass)((Object)printRequestAttribute)).getStringValue().endsWith("long-edge")) {
                    return Sides.TWO_SIDED_LONG_EDGE;
                }
                if (((AttributeClass)((Object)printRequestAttribute)).getStringValue().endsWith("short-edge")) {
                    return Sides.TWO_SIDED_SHORT_EDGE;
                }
            }
            return Sides.ONE_SIDED;
        }
        return null;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNotifier() {
        IPPPrintService iPPPrintService = this;
        synchronized (iPPPrintService) {
            if (this.notifier != null) {
                this.notifier.wake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        IPPPrintService iPPPrintService = this;
        synchronized (iPPPrintService) {
            if (printServiceAttributeListener == null) {
                return;
            }
            if (this.notifier == null) {
                this.notifier = new ServiceNotifier(this);
            }
            this.notifier.addListener(printServiceAttributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        IPPPrintService iPPPrintService = this;
        synchronized (iPPPrintService) {
            if (printServiceAttributeListener == null || this.notifier == null) {
                return;
            }
            this.notifier.removeListener(printServiceAttributeListener);
            if (this.notifier.isEmpty()) {
                this.notifier.stopNotifier();
                this.notifier = null;
            }
        }
    }

    @Override
    public String getName() {
        return this.printer;
    }

    @Override
    public boolean usesClass(Class clazz) {
        return clazz == PSPrinterJob.class;
    }

    public static HttpURLConnection getIPPConnection(URL uRL) {
        HttpURLConnection httpURLConnection;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            return null;
        }
        if (!(httpURLConnection instanceof HttpURLConnection)) {
            return null;
        }
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestProperty("Content-type", "application/ipp");
        return httpURLConnection;
    }

    public synchronized boolean isPostscript() {
        block5: {
            if (this.isPS == null) {
                this.isPS = Boolean.TRUE;
                if (this.isCupsPrinter) {
                    try {
                        String string;
                        this.urlConnection = IPPPrintService.getIPPConnection(new URL(this.myURL + ".ppd"));
                        InputStream inputStream = this.urlConnection.getInputStream();
                        if (inputStream == null) break block5;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("ISO-8859-1")));
                        while ((string = bufferedReader.readLine()) != null) {
                            if (!string.startsWith("*cupsFilter:")) continue;
                            this.isPS = Boolean.FALSE;
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        IPPPrintService.debug_println(" isPostscript, e= " + iOException);
                    }
                }
            }
        }
        return this.isPS;
    }

    private void opGetAttributes() {
        try {
            boolean bl;
            IPPPrintService.debug_println("IPPPrintService>> opGetAttributes myURI " + this.myURI + " myURL " + this.myURL);
            AttributeClass[] attributeClassArray = new AttributeClass[]{AttributeClass.ATTRIBUTES_CHARSET, AttributeClass.ATTRIBUTES_NATURAL_LANGUAGE};
            AttributeClass[] attributeClassArray2 = new AttributeClass[]{AttributeClass.ATTRIBUTES_CHARSET, AttributeClass.ATTRIBUTES_NATURAL_LANGUAGE, new AttributeClass("printer-uri", 69, "" + this.myURI)};
            OutputStream outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return IPPPrintService.this.urlConnection.getOutputStream();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            if (outputStream == null) {
                return;
            }
            boolean bl2 = bl = this.myURI == null ? IPPPrintService.writeIPPRequest(outputStream, OP_GET_ATTRIBUTES, attributeClassArray) : IPPPrintService.writeIPPRequest(outputStream, OP_GET_ATTRIBUTES, attributeClassArray2);
            if (bl) {
                InputStream inputStream = null;
                inputStream = this.urlConnection.getInputStream();
                if (inputStream != null) {
                    HashMap[] hashMapArray = IPPPrintService.readIPPResponse(inputStream);
                    if (hashMapArray != null && hashMapArray.length > 0) {
                        this.getAttMap = hashMapArray[0];
                    }
                } else {
                    IPPPrintService.debug_println("IPPPrintService>> opGetAttributes - null input stream");
                }
                inputStream.close();
            }
            outputStream.close();
        }
        catch (IOException iOException) {
            IPPPrintService.debug_println("IPPPrintService>> opGetAttributes - input/output stream: " + iOException);
        }
    }

    public static boolean writeIPPRequest(OutputStream outputStream, String string, AttributeClass[] attributeClassArray) {
        OutputStreamWriter outputStreamWriter;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IPPPrintService.debug_println("IPPPrintService>> writeIPPRequest, UTF-8 not supported? Exception: " + unsupportedEncodingException);
            return false;
        }
        IPPPrintService.debug_println("IPPPrintService>> writeIPPRequest, op code= " + string);
        char[] cArray = new char[]{(char)Byte.parseByte(string.substring(0, 2), 16), (char)Byte.parseByte(string.substring(2, 4), 16)};
        char[] cArray2 = new char[]{'\u0001', '\u0001', '\u0000', '\u0001'};
        try {
            outputStreamWriter.write(cArray2, 0, 2);
            outputStreamWriter.write(cArray, 0, 2);
            cArray2[0] = '\u0000';
            cArray2[1] = '\u0000';
            outputStreamWriter.write(cArray2, 0, 4);
            cArray2[0] = '\u0001';
            outputStreamWriter.write(cArray2[0]);
            for (int i = 0; i < attributeClassArray.length; ++i) {
                AttributeClass attributeClass = attributeClassArray[i];
                outputStreamWriter.write(attributeClass.getType());
                char[] cArray3 = attributeClass.getLenChars();
                outputStreamWriter.write(cArray3, 0, 2);
                outputStreamWriter.write("" + attributeClass, 0, attributeClass.getName().length());
                if (attributeClass.getType() < 53 || attributeClass.getType() > 73) continue;
                String string2 = (String)attributeClass.getObjectValue();
                cArray2[0] = '\u0000';
                cArray2[1] = (char)string2.length();
                outputStreamWriter.write(cArray2, 0, 2);
                outputStreamWriter.write(string2, 0, string2.length());
            }
            outputStreamWriter.write(3);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            IPPPrintService.debug_println("IPPPrintService>> writeIPPRequest, IPPPrintService Exception in writeIPPRequest: " + iOException);
            return false;
        }
        return true;
    }

    public static HashMap[] readIPPResponse(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = new byte[MAX_ATTRIBUTE_LENGTH];
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (dataInputStream.read(byArray, 0, 8) > -1 && byArray[2] == 0) {
                int n = 0;
                short s = 0;
                String string = null;
                int n2 = 68;
                ArrayList arrayList = new ArrayList();
                HashMap<String, AttributeClass> hashMap = new HashMap<String, AttributeClass>();
                byArray[0] = dataInputStream.readByte();
                while (byArray[0] >= 1 && byArray[0] <= 4 && byArray[0] != 3) {
                    AttributeClass attributeClass;
                    byte[] byArray2;
                    IPPPrintService.debug_println("IPPPrintService>> readIPPResponse, checking group tag,  response[0]= " + byArray[0]);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    n = 0;
                    string = null;
                    byArray[0] = dataInputStream.readByte();
                    while (byArray[0] >= 16 && byArray[0] <= 74) {
                        s = dataInputStream.readShort();
                        if (s != 0 && string != null) {
                            byteArrayOutputStream.write(n);
                            byteArrayOutputStream.flush();
                            byteArrayOutputStream.close();
                            byArray2 = byteArrayOutputStream.toByteArray();
                            if (hashMap.containsKey(string)) {
                                arrayList.add(hashMap);
                                hashMap = new HashMap();
                            }
                            if (n2 >= 33) {
                                attributeClass = new AttributeClass(string, n2, byArray2);
                                hashMap.put(attributeClass.getName(), attributeClass);
                                IPPPrintService.debug_println("IPPPrintService>> readIPPResponse " + attributeClass);
                            }
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            n = 0;
                        }
                        if (n == 0) {
                            n2 = byArray[0];
                        }
                        if (s != 0) {
                            if (s > MAX_ATTRIBUTE_LENGTH) {
                                byArray = new byte[s];
                            }
                            dataInputStream.read(byArray, 0, s);
                            string = new String(byArray, 0, (int)s);
                        }
                        s = dataInputStream.readShort();
                        byteArrayOutputStream.write(s);
                        if (s > MAX_ATTRIBUTE_LENGTH) {
                            byArray = new byte[s];
                        }
                        dataInputStream.read(byArray, 0, s);
                        byteArrayOutputStream.write(byArray, 0, s);
                        ++n;
                        byArray[0] = dataInputStream.readByte();
                    }
                    if (string == null) continue;
                    byteArrayOutputStream.write(n);
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                    if (n != 0 && hashMap.containsKey(string)) {
                        arrayList.add(hashMap);
                        hashMap = new HashMap();
                    }
                    byArray2 = byteArrayOutputStream.toByteArray();
                    attributeClass = new AttributeClass(string, n2, byArray2);
                    hashMap.put(attributeClass.getName(), attributeClass);
                }
                dataInputStream.close();
                if (hashMap != null && hashMap.size() > 0) {
                    arrayList.add(hashMap);
                }
                return arrayList.toArray(new HashMap[arrayList.size()]);
            }
            IPPPrintService.debug_println("IPPPrintService>> readIPPResponse client error, IPP status code-" + Integer.toHexString(byArray[2]) + " & " + Integer.toHexString(byArray[3]));
            return null;
        }
        catch (IOException iOException) {
            IPPPrintService.debug_println("IPPPrintService>> readIPPResponse: " + iOException);
            if (debugPrint) {
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public String toString() {
        return "IPP Printer : " + this.getName();
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof IPPPrintService && ((IPPPrintService)object).getName().equals(this.getName());
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction(FORCE_PIPE_PROP));
        debugPrint = "true".equalsIgnoreCase(string);
        MAXCOPIES = 1000;
        MAX_ATTRIBUTE_LENGTH = (short)255;
        printReqAttribDefault = new Object[]{Chromaticity.COLOR, new Copies(1), Fidelity.FIDELITY_FALSE, Finishings.NONE, new JobName("", Locale.getDefault()), JobSheets.NONE, MediaSizeName.NA_LETTER, new NumberUp(1), OrientationRequested.PORTRAIT, new PageRanges(1), new RequestingUserName("", Locale.getDefault()), Sides.ONE_SIDED};
        serviceAttributes = new Object[][]{{ColorSupported.class, "color-supported"}, {PagesPerMinute.class, "pages-per-minute"}, {PagesPerMinuteColor.class, "pages-per-minute-color"}, {PDLOverrideSupported.class, "pdl-override-supported"}, {PrinterInfo.class, "printer-info"}, {PrinterIsAcceptingJobs.class, "printer-is-accepting-jobs"}, {PrinterLocation.class, "printer-location"}, {PrinterMakeAndModel.class, "printer-make-and-model"}, {PrinterMessageFromOperator.class, "printer-message-from-operator"}, {PrinterMoreInfo.class, "printer-more-info"}, {PrinterMoreInfoManufacturer.class, "printer-more-info-manufacturer"}, {PrinterName.class, "printer-name"}, {PrinterState.class, "printer-state"}, {PrinterStateReasons.class, "printer-state-reasons"}, {PrinterURI.class, "printer-uri"}, {QueuedJobCount.class, "queued-job-count"}};
        appPDF = new DocFlavor[]{DocFlavor.BYTE_ARRAY.PDF, DocFlavor.INPUT_STREAM.PDF, DocFlavor.URL.PDF};
        appPostScript = new DocFlavor[]{DocFlavor.BYTE_ARRAY.POSTSCRIPT, DocFlavor.INPUT_STREAM.POSTSCRIPT, DocFlavor.URL.POSTSCRIPT};
        appOctetStream = new DocFlavor[]{DocFlavor.BYTE_ARRAY.AUTOSENSE, DocFlavor.INPUT_STREAM.AUTOSENSE, DocFlavor.URL.AUTOSENSE};
        textPlain = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_8, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16BE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_UTF_16LE, DocFlavor.BYTE_ARRAY.TEXT_PLAIN_US_ASCII, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_8, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16BE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_UTF_16LE, DocFlavor.INPUT_STREAM.TEXT_PLAIN_US_ASCII, DocFlavor.URL.TEXT_PLAIN_UTF_8, DocFlavor.URL.TEXT_PLAIN_UTF_16, DocFlavor.URL.TEXT_PLAIN_UTF_16BE, DocFlavor.URL.TEXT_PLAIN_UTF_16LE, DocFlavor.URL.TEXT_PLAIN_US_ASCII, DocFlavor.CHAR_ARRAY.TEXT_PLAIN, DocFlavor.STRING.TEXT_PLAIN, DocFlavor.READER.TEXT_PLAIN};
        textPlainHost = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_PLAIN_HOST, DocFlavor.INPUT_STREAM.TEXT_PLAIN_HOST, DocFlavor.URL.TEXT_PLAIN_HOST};
        imageJPG = new DocFlavor[]{DocFlavor.BYTE_ARRAY.JPEG, DocFlavor.INPUT_STREAM.JPEG, DocFlavor.URL.JPEG};
        imageGIF = new DocFlavor[]{DocFlavor.BYTE_ARRAY.GIF, DocFlavor.INPUT_STREAM.GIF, DocFlavor.URL.GIF};
        imagePNG = new DocFlavor[]{DocFlavor.BYTE_ARRAY.PNG, DocFlavor.INPUT_STREAM.PNG, DocFlavor.URL.PNG};
        textHtml = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_8, DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_16, DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_16BE, DocFlavor.BYTE_ARRAY.TEXT_HTML_UTF_16LE, DocFlavor.BYTE_ARRAY.TEXT_HTML_US_ASCII, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_8, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_16, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_16BE, DocFlavor.INPUT_STREAM.TEXT_HTML_UTF_16LE, DocFlavor.INPUT_STREAM.TEXT_HTML_US_ASCII, DocFlavor.URL.TEXT_HTML_UTF_8, DocFlavor.URL.TEXT_HTML_UTF_16, DocFlavor.URL.TEXT_HTML_UTF_16BE, DocFlavor.URL.TEXT_HTML_UTF_16LE, DocFlavor.URL.TEXT_HTML_US_ASCII};
        textHtmlHost = new DocFlavor[]{DocFlavor.BYTE_ARRAY.TEXT_HTML_HOST, DocFlavor.INPUT_STREAM.TEXT_HTML_HOST, DocFlavor.URL.TEXT_HTML_HOST};
        appPCL = new DocFlavor[]{DocFlavor.BYTE_ARRAY.PCL, DocFlavor.INPUT_STREAM.PCL, DocFlavor.URL.PCL};
        allDocFlavors = new Object[]{appPDF, appPostScript, appOctetStream, textPlain, imageJPG, imageGIF, imagePNG, textHtml, appPCL};
    }

    private class ExtFinishing
    extends Finishings {
        ExtFinishing(int n) {
            super(100);
        }

        EnumSyntax[] getAll() {
            EnumSyntax[] enumSyntaxArray = super.getEnumValueTable();
            return enumSyntaxArray;
        }
    }
}

