/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.EventQueue;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Set;
import sun.awt.AppContext;
import sun.awt.EventListenerAggregate;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.ClipboardTransferable;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.TransferableProxy;

public abstract class SunClipboard
extends Clipboard
implements PropertyChangeListener {
    private AppContext contentsContext = null;
    private final Object CLIPBOARD_FLAVOR_LISTENER_KEY;
    private volatile int numberOfFlavorListeners = 0;
    private volatile Set currentDataFlavors;

    public SunClipboard(String string) {
        super(string);
        this.CLIPBOARD_FLAVOR_LISTENER_KEY = new StringBuffer(string + "_CLIPBOARD_FLAVOR_LISTENER_KEY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        if (transferable == null) {
            throw new NullPointerException("contents");
        }
        this.initContext();
        ClipboardOwner clipboardOwner2 = this.owner;
        Transferable transferable2 = this.contents;
        try {
            this.owner = clipboardOwner;
            this.contents = new TransferableProxy(transferable, true);
            this.setContentsNative(transferable);
            if (clipboardOwner2 == null || clipboardOwner2 == clipboardOwner) return;
        }
        catch (Throwable throwable) {
            if (clipboardOwner2 == null || clipboardOwner2 == clipboardOwner) throw throwable;
            EventQueue.invokeLater(new Runnable(clipboardOwner2, transferable2){
                final /* synthetic */ ClipboardOwner val$oldOwner;
                final /* synthetic */ Transferable val$oldContents;
                {
                    this.val$oldOwner = clipboardOwner;
                    this.val$oldContents = transferable;
                }

                public void run() {
                    this.val$oldOwner.lostOwnership(SunClipboard.this, this.val$oldContents);
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initContext() {
        AppContext appContext = AppContext.getAppContext();
        if (this.contentsContext != appContext) {
            AppContext appContext2 = appContext;
            synchronized (appContext2) {
                if (appContext.isDisposed()) {
                    throw new IllegalStateException("Can't set contents from disposed AppContext");
                }
                appContext.addPropertyChangeListener("disposed", this);
            }
            if (this.contentsContext != null) {
                this.contentsContext.removePropertyChangeListener("disposed", this);
            }
            this.contentsContext = appContext;
        }
    }

    public synchronized Transferable getContents(Object object) {
        if (this.contents != null) {
            return this.contents;
        }
        return new ClipboardTransferable(this);
    }

    private synchronized Transferable getContextContents() {
        AppContext appContext = AppContext.getAppContext();
        return appContext == this.contentsContext ? this.contents : null;
    }

    public DataFlavor[] getAvailableDataFlavors() {
        Transferable transferable = this.getContextContents();
        if (transferable != null) {
            return transferable.getTransferDataFlavors();
        }
        long[] lArray = this.getClipboardFormatsOpenClose();
        return DataTransferer.getInstance().getFlavorsForFormatsAsArray(lArray, SunClipboard.getDefaultFlavorTable());
    }

    public boolean isDataFlavorAvailable(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            throw new NullPointerException("flavor");
        }
        Transferable transferable = this.getContextContents();
        if (transferable != null) {
            return transferable.isDataFlavorSupported(dataFlavor);
        }
        long[] lArray = this.getClipboardFormatsOpenClose();
        return SunClipboard.formatArrayAsDataFlavorSet(lArray).contains(dataFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor == null) {
            throw new NullPointerException("flavor");
        }
        Transferable transferable = this.getContextContents();
        if (transferable != null) {
            return transferable.getTransferData(dataFlavor);
        }
        long l = 0L;
        byte[] byArray = null;
        Transferable transferable2 = null;
        try {
            this.openClipboard(null);
            long[] lArray = this.getClipboardFormats();
            Long l2 = (Long)DataTransferer.getInstance().getFlavorsForFormats(lArray, SunClipboard.getDefaultFlavorTable()).get(dataFlavor);
            if (l2 == null) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            l = l2;
            byArray = this.getClipboardData(l);
            if (DataTransferer.getInstance().isLocaleDependentTextFormat(l)) {
                transferable2 = this.createLocaleTransferable(lArray);
            }
        }
        finally {
            this.closeClipboard();
        }
        return DataTransferer.getInstance().translateBytes(byArray, dataFlavor, l, transferable2);
    }

    protected Transferable createLocaleTransferable(long[] lArray) throws IOException {
        return null;
    }

    public void openClipboard(SunClipboard sunClipboard) {
    }

    public void closeClipboard() {
    }

    public abstract long getID();

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("disposed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
            AppContext appContext = (AppContext)propertyChangeEvent.getSource();
            this.lostOwnershipLater(appContext);
        }
    }

    protected void lostOwnershipImpl() {
        this.lostOwnershipLater(null);
    }

    protected void lostOwnershipLater(final AppContext appContext) {
        AppContext appContext2 = this.contentsContext;
        if (appContext2 == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SunClipboard sunClipboard = SunClipboard.this;
                ClipboardOwner clipboardOwner = null;
                Transferable transferable = null;
                SunClipboard sunClipboard2 = sunClipboard;
                synchronized (sunClipboard2) {
                    AppContext appContext2 = sunClipboard.contentsContext;
                    if (appContext2 == null) {
                        return;
                    }
                    if (appContext != null && appContext2 != appContext) {
                        return;
                    }
                    clipboardOwner = sunClipboard.owner;
                    transferable = sunClipboard.contents;
                    sunClipboard.contentsContext = null;
                    sunClipboard.owner = null;
                    sunClipboard.contents = null;
                    sunClipboard.clearNativeContext();
                    appContext2.removePropertyChangeListener("disposed", sunClipboard);
                }
                if (clipboardOwner != null) {
                    clipboardOwner.lostOwnership(sunClipboard, transferable);
                }
            }
        };
        SunToolkit.postEvent(appContext2, new PeerEvent(this, runnable, 1L));
    }

    protected abstract void clearNativeContext();

    protected abstract void setContentsNative(Transferable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] getClipboardFormatsOpenClose() {
        try {
            this.openClipboard(null);
            long[] lArray = this.getClipboardFormats();
            return lArray;
        }
        finally {
            this.closeClipboard();
        }
    }

    protected abstract long[] getClipboardFormats();

    protected abstract byte[] getClipboardData(long var1) throws IOException;

    private static Set formatArrayAsDataFlavorSet(long[] lArray) {
        return lArray == null ? null : DataTransferer.getInstance().getFlavorsForFormatsAsSet(lArray, SunClipboard.getDefaultFlavorTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFlavorListener(FlavorListener flavorListener) {
        if (flavorListener == null) {
            return;
        }
        AppContext appContext = AppContext.getAppContext();
        EventListenerAggregate eventListenerAggregate = (EventListenerAggregate)appContext.get(this.CLIPBOARD_FLAVOR_LISTENER_KEY);
        if (eventListenerAggregate == null) {
            eventListenerAggregate = new EventListenerAggregate(FlavorListener.class);
            appContext.put(this.CLIPBOARD_FLAVOR_LISTENER_KEY, eventListenerAggregate);
        }
        eventListenerAggregate.add(flavorListener);
        if (this.numberOfFlavorListeners++ == 0) {
            long[] lArray = null;
            try {
                this.openClipboard(null);
                lArray = this.getClipboardFormats();
            }
            catch (IllegalStateException illegalStateException) {
            }
            finally {
                this.closeClipboard();
            }
            this.currentDataFlavors = SunClipboard.formatArrayAsDataFlavorSet(lArray);
            this.registerClipboardViewerChecked();
        }
    }

    public synchronized void removeFlavorListener(FlavorListener flavorListener) {
        if (flavorListener == null) {
            return;
        }
        AppContext appContext = AppContext.getAppContext();
        EventListenerAggregate eventListenerAggregate = (EventListenerAggregate)appContext.get(this.CLIPBOARD_FLAVOR_LISTENER_KEY);
        if (eventListenerAggregate.remove(flavorListener) && --this.numberOfFlavorListeners == 0) {
            this.unregisterClipboardViewerChecked();
            this.currentDataFlavors = null;
        }
    }

    public synchronized FlavorListener[] getFlavorListeners() {
        EventListenerAggregate eventListenerAggregate = (EventListenerAggregate)AppContext.getAppContext().get(this.CLIPBOARD_FLAVOR_LISTENER_KEY);
        return eventListenerAggregate == null ? new FlavorListener[]{} : (FlavorListener[])eventListenerAggregate.getListenersCopy();
    }

    public boolean areFlavorListenersRegistered() {
        return this.numberOfFlavorListeners > 0;
    }

    protected abstract void registerClipboardViewerChecked();

    protected abstract void unregisterClipboardViewerChecked();

    public void checkChange(long[] lArray) {
        Set set = this.currentDataFlavors;
        this.currentDataFlavors = SunClipboard.formatArrayAsDataFlavorSet(lArray);
        if (set != null && this.currentDataFlavors != null && ((Object)set).equals(this.currentDataFlavors)) {
            return;
        }
        for (AppContext appContext : AppContext.getAppContexts()) {
            EventListenerAggregate eventListenerAggregate;
            if (appContext == null || appContext.isDisposed() || (eventListenerAggregate = (EventListenerAggregate)appContext.get(this.CLIPBOARD_FLAVOR_LISTENER_KEY)) == null) continue;
            FlavorListener[] flavorListenerArray = (FlavorListener[])eventListenerAggregate.getListenersInternal();
            for (int i = 0; i < flavorListenerArray.length; ++i) {
                class SunFlavorChangeNotifier
                implements Runnable {
                    private final FlavorListener flavorListener;

                    SunFlavorChangeNotifier(FlavorListener flavorListener) {
                        this.flavorListener = flavorListener;
                    }

                    public void run() {
                        if (this.flavorListener != null) {
                            this.flavorListener.flavorsChanged(new FlavorEvent(SunClipboard.this));
                        }
                    }
                }
                SunToolkit.postEvent(appContext, new PeerEvent(this, new SunFlavorChangeNotifier(flavorListenerArray[i]), 1L));
            }
        }
    }

    public static FlavorTable getDefaultFlavorTable() {
        return (FlavorTable)SystemFlavorMap.getDefaultFlavorMap();
    }
}

