/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.spi;

import com.sun.rowset.providers.RIOptimisticProvider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLPermission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.sql.rowset.spi.ProviderImpl;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncFactory {
    private static SyncFactory syncFactory = null;
    public static String ROWSET_SYNC_PROVIDER = "rowset.provider.classname";
    public static String ROWSET_SYNC_VENDOR = "rowset.provider.vendor";
    public static String ROWSET_SYNC_PROVIDER_VERSION = "rowset.provider.version";
    private static String ROWSET_PROPERTIES = "rowset.properties";
    private static String default_provider = "com.sun.rowset.providers.RIOptimisticProvider";
    private static final SQLPermission SET_SYNCFACTORY_PERMISSION = new SQLPermission("setSyncFactory");
    private static Context ic;
    private static Logger rsLogger;
    private static Level rsLevel;
    private static Hashtable implementations;
    private static Object logSync;
    private static PrintWriter logWriter;
    private static String colon;
    private static String strFileSep;
    private static boolean jndiCtxEstablished;
    private static boolean debug;
    private static int providerImplIndex;
    private static boolean lazyJNDICtxRefresh;

    private SyncFactory() {
    }

    public static synchronized void registerProvider(String string) throws SyncFactoryException {
        ProviderImpl providerImpl = new ProviderImpl();
        providerImpl.setClassname(string);
        SyncFactory.initMapIfNecessary();
        implementations.put(string, providerImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SyncFactory getSyncFactory() {
        if (syncFactory != null) return syncFactory;
        Class<SyncFactory> clazz = SyncFactory.class;
        synchronized (SyncFactory.class) {
            if (syncFactory != null) return syncFactory;
            syncFactory = new SyncFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return syncFactory;
        }
    }

    public static synchronized void unregisterProvider(String string) throws SyncFactoryException {
        SyncFactory.initMapIfNecessary();
        if (implementations.containsKey(string)) {
            implementations.remove(string);
        }
    }

    private static synchronized void initMapIfNecessary() throws SyncFactoryException {
        final Properties properties = new Properties();
        if (implementations == null) {
            String string;
            implementations = new Hashtable();
            try {
                try {
                    string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return System.getProperty("rowset.properties");
                        }
                    });
                }
                catch (Exception exception) {
                    System.out.println("errorget rowset.properties: " + exception);
                    string = null;
                }
                if (string != null) {
                    ROWSET_PROPERTIES = string;
                    properties.load(new FileInputStream(ROWSET_PROPERTIES));
                    SyncFactory.parseProperties(properties);
                }
                ROWSET_PROPERTIES = "javax" + strFileSep + "sql" + strFileSep + "rowset" + strFileSep + "rowset.properties";
                final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void run() throws SyncFactoryException, IOException, FileNotFoundException {
                            InputStream inputStream = null;
                            try {
                                InputStream inputStream2 = inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(ROWSET_PROPERTIES) : classLoader.getResourceAsStream(ROWSET_PROPERTIES);
                                if (inputStream == null) {
                                    throw new SyncFactoryException("Resource " + ROWSET_PROPERTIES + " not found");
                                }
                                properties.load(inputStream);
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof SyncFactoryException) {
                        throw (SyncFactoryException)exception;
                    }
                    SyncFactoryException syncFactoryException = new SyncFactoryException();
                    syncFactoryException.initCause(privilegedActionException.getException());
                    throw syncFactoryException;
                }
                SyncFactory.parseProperties(properties);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SyncFactoryException("Cannot locate properties file: " + fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new SyncFactoryException("IOException: " + iOException);
            }
            properties.clear();
            try {
                string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(ROWSET_SYNC_PROVIDER);
                    }
                });
            }
            catch (Exception exception) {
                string = null;
            }
            if (string != null) {
                int n = 0;
                if (string.indexOf(colon) > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, colon);
                    while (stringTokenizer.hasMoreElements()) {
                        properties.put(ROWSET_SYNC_PROVIDER + "." + n, stringTokenizer.nextToken());
                        ++n;
                    }
                } else {
                    properties.put(ROWSET_SYNC_PROVIDER, string);
                }
                SyncFactory.parseProperties(properties);
            }
        }
    }

    private static void parseProperties(Properties properties) {
        ProviderImpl providerImpl = null;
        String string = null;
        String[] stringArray = null;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            int n = string2.length();
            if (!string2.startsWith(ROWSET_SYNC_PROVIDER)) continue;
            providerImpl = new ProviderImpl();
            providerImpl.setIndex(providerImplIndex++);
            stringArray = n == ROWSET_SYNC_PROVIDER.length() ? SyncFactory.getPropertyNames(false) : SyncFactory.getPropertyNames(true, string2.substring(n - 1));
            string = properties.getProperty(stringArray[0]);
            providerImpl.setClassname(string);
            providerImpl.setVendor(properties.getProperty(stringArray[1]));
            providerImpl.setVersion(properties.getProperty(stringArray[2]));
            implementations.put(string, providerImpl);
        }
    }

    private static String[] getPropertyNames(boolean bl) {
        return SyncFactory.getPropertyNames(bl, null);
    }

    private static String[] getPropertyNames(boolean bl, String string) {
        String string2 = ".";
        String[] stringArray = new String[]{ROWSET_SYNC_PROVIDER, ROWSET_SYNC_VENDOR, ROWSET_SYNC_PROVIDER_VERSION};
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i] + string2 + string;
            }
            return stringArray;
        }
        return stringArray;
    }

    private static void showImpl(ProviderImpl providerImpl) {
        System.out.println("Provider implementation:");
        System.out.println("Classname: " + providerImpl.getClassname());
        System.out.println("Vendor: " + providerImpl.getVendor());
        System.out.println("Version: " + providerImpl.getVersion());
        System.out.println("Impl index: " + providerImpl.getIndex());
    }

    public static SyncProvider getInstance(String string) throws SyncFactoryException {
        SyncFactory.initMapIfNecessary();
        SyncFactory.initJNDIContext();
        ProviderImpl providerImpl = (ProviderImpl)implementations.get(string);
        if (providerImpl == null) {
            return new RIOptimisticProvider();
        }
        try {
            ReflectUtil.checkPackageAccess(string);
        }
        catch (AccessControlException accessControlException) {
            SyncFactoryException syncFactoryException = new SyncFactoryException();
            syncFactoryException.initCause(accessControlException);
            throw syncFactoryException;
        }
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(string, true, classLoader);
            if (clazz != null) {
                return (SyncProvider)clazz.newInstance();
            }
            return new RIOptimisticProvider();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SyncFactoryException("IllegalAccessException: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new SyncFactoryException("InstantiationException: " + instantiationException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SyncFactoryException("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
    }

    public static Enumeration<SyncProvider> getRegisteredProviders() throws SyncFactoryException {
        SyncFactory.initMapIfNecessary();
        return implementations.elements();
    }

    public static void setLogger(Logger logger) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_SYNCFACTORY_PERMISSION);
        }
        rsLogger = logger;
    }

    public static void setLogger(Logger logger, Level level) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_SYNCFACTORY_PERMISSION);
        }
        rsLogger = logger;
        rsLogger.setLevel(level);
    }

    public static Logger getLogger() throws SyncFactoryException {
        if (rsLogger == null) {
            throw new SyncFactoryException("(SyncFactory) : No logger has been set");
        }
        return rsLogger;
    }

    public static void setJNDIContext(Context context) throws SyncFactoryException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_SYNCFACTORY_PERMISSION);
        }
        if (context == null) {
            throw new SyncFactoryException("Invalid JNDI context supplied");
        }
        ic = context;
        jndiCtxEstablished = true;
    }

    private static void initJNDIContext() throws SyncFactoryException {
        if (jndiCtxEstablished && ic != null && !lazyJNDICtxRefresh) {
            try {
                SyncFactory.parseProperties(SyncFactory.parseJNDIContext());
                lazyJNDICtxRefresh = true;
            }
            catch (NamingException namingException) {
                namingException.printStackTrace();
                throw new SyncFactoryException("SPI: NamingException: " + namingException.getExplanation());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SyncFactoryException("SPI: Exception: " + exception.getMessage());
            }
        }
    }

    private static Properties parseJNDIContext() throws NamingException {
        NamingEnumeration<Binding> namingEnumeration = ic.listBindings("");
        Properties properties = new Properties();
        SyncFactory.enumerateBindings(namingEnumeration, properties);
        return properties;
    }

    private static void enumerateBindings(NamingEnumeration namingEnumeration, Properties properties) throws NamingException {
        boolean bl = false;
        try {
            Binding binding = null;
            Object object = null;
            String string = null;
            while (namingEnumeration.hasMore()) {
                binding = (Binding)namingEnumeration.next();
                string = binding.getName();
                object = binding.getObject();
                if (!(ic.lookup(string) instanceof Context) && ic.lookup(string) instanceof SyncProvider) {
                    bl = true;
                }
                if (!bl) continue;
                SyncProvider syncProvider = (SyncProvider)object;
                properties.put(ROWSET_SYNC_PROVIDER, syncProvider.getProviderID());
                bl = false;
            }
        }
        catch (NotContextException notContextException) {
            namingEnumeration.next();
            SyncFactory.enumerateBindings(namingEnumeration, properties);
        }
    }

    static {
        logSync = new Object();
        logWriter = null;
        colon = ":";
        strFileSep = "/";
        jndiCtxEstablished = false;
        debug = false;
        providerImplIndex = 0;
        lazyJNDICtxRefresh = false;
    }
}

