/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.net.ResourceManager;
import sun.security.action.LoadLibraryAction;

class PlainDatagramSocketImpl
extends DatagramSocketImpl {
    private int timeout = 0;
    private int trafficClass = 0;
    private boolean connected = false;
    private InetAddress connectedAddress = null;
    private int connectedPort = -1;
    private int multicastInterface = 0;
    private boolean loopbackMode = true;
    private int ttl = -1;
    private FileDescriptor fd1;
    private int fduse = -1;
    private int lastfd = -1;
    private InetAddress anyLocalBoundAddr = null;
    private static float version;
    private static String exclBindProp;
    private static boolean exclusiveBind;
    private boolean reuseAddressEmulated;
    private boolean isReuseAddress;

    PlainDatagramSocketImpl() {
    }

    protected synchronized void create() throws SocketException {
        this.fd = new FileDescriptor();
        this.fd1 = new FileDescriptor();
        ResourceManager.beforeUdpCreate();
        try {
            this.datagramSocketCreate();
        }
        catch (SocketException socketException) {
            ResourceManager.afterUdpClose();
            this.fd = null;
            this.fd1 = null;
            throw socketException;
        }
    }

    protected synchronized void bind(int n, InetAddress inetAddress) throws SocketException {
        this.bind0(n, inetAddress, exclusiveBind);
        if (inetAddress.isAnyLocalAddress()) {
            this.anyLocalBoundAddr = inetAddress;
        }
    }

    protected synchronized native void bind0(int var1, InetAddress var2, boolean var3) throws SocketException;

    protected native void send(DatagramPacket var1) throws IOException;

    protected void connect(InetAddress inetAddress, int n) throws SocketException {
        this.connect0(inetAddress, n);
        this.connectedAddress = inetAddress;
        this.connectedPort = n;
        this.connected = true;
    }

    protected void disconnect() {
        this.disconnect0(this.connectedAddress.holder().getFamily());
        this.connected = false;
        this.connectedAddress = null;
        this.connectedPort = -1;
    }

    protected synchronized native int peek(InetAddress var1) throws IOException;

    protected synchronized native int peekData(DatagramPacket var1) throws IOException;

    protected synchronized void bind0(int n, InetAddress inetAddress) throws SocketException {
        this.bind0(n, inetAddress, exclusiveBind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        try {
            this.receive0(datagramPacket);
            Object var3_2 = null;
            this.fduse = -1;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.fduse = -1;
            throw throwable;
        }
    }

    protected synchronized native void receive0(DatagramPacket var1) throws IOException;

    protected native void setTimeToLive(int var1) throws IOException;

    protected native int getTimeToLive() throws IOException;

    protected native void setTTL(byte var1) throws IOException;

    protected native byte getTTL() throws IOException;

    protected void join(InetAddress inetAddress) throws IOException {
        this.join(inetAddress, null);
    }

    protected void leave(InetAddress inetAddress) throws IOException {
        this.leave(inetAddress, null);
    }

    protected void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.join(((InetSocketAddress)socketAddress).getAddress(), networkInterface);
    }

    private native void join(InetAddress var1, NetworkInterface var2) throws IOException;

    protected void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.leave(((InetSocketAddress)socketAddress).getAddress(), networkInterface);
    }

    private native void leave(InetAddress var1, NetworkInterface var2) throws IOException;

    protected void close() {
        if (this.fd != null || this.fd1 != null) {
            this.datagramSocketClose();
            ResourceManager.afterUdpClose();
            this.fd = null;
            this.fd1 = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void setOption(int n, Object object) throws SocketException {
        if (this.fd == null && this.fd1 == null) {
            throw new SocketException("Socket Closed");
        }
        switch (n) {
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for SO_TIMEOUT");
                }
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n2;
                return;
            }
            case 3: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for IP_TOS");
                }
                this.trafficClass = (Integer)object;
                break;
            }
            case 4: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for SO_REUSEADDR");
            }
            case 32: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for SO_BROADCAST");
            }
            case 15: {
                throw new SocketException("Cannot re-bind Socket");
            }
            case 4097: 
            case 4098: {
                if (object != null && object instanceof Integer && (Integer)object >= 0) break;
                throw new SocketException("bad argument for SO_SNDBUF or SO_RCVBUF");
            }
            case 16: {
                if (object != null && object instanceof InetAddress) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF");
            }
            case 31: {
                if (object != null && object instanceof NetworkInterface) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF2");
            }
            case 18: {
                if (object != null && object instanceof Boolean) break;
                throw new SocketException("bad argument for IP_MULTICAST_LOOP");
            }
            default: {
                throw new SocketException("invalid option: " + n);
            }
        }
        this.socketSetOption(n, object);
    }

    public Object getOption(int n) throws SocketException {
        Object object;
        if (this.fd == null && this.fd1 == null) {
            throw new SocketException("Socket Closed");
        }
        if (n == 4 && this.reuseAddressEmulated) {
            return this.isReuseAddress;
        }
        switch (n) {
            case 4102: {
                object = new Integer(this.timeout);
                break;
            }
            case 3: {
                object = this.socketGetOption(n);
                if ((Integer)object != -1) break;
                object = new Integer(this.trafficClass);
                break;
            }
            case 15: {
                if (this.fd != null && this.fd1 != null) {
                    return this.anyLocalBoundAddr;
                }
            }
            case 4: 
            case 16: 
            case 18: 
            case 31: 
            case 32: 
            case 4097: 
            case 4098: {
                object = this.socketGetOption(n);
                break;
            }
            default: {
                throw new SocketException("invalid option: " + n);
            }
        }
        return object;
    }

    protected void socketSetOption(int n, Object object) throws SocketException {
        if (n == 4 && exclusiveBind && this.localPort != 0) {
            this.reuseAddressEmulated = true;
            this.isReuseAddress = (Boolean)object;
        } else {
            this.socketNativeSetOption(n, object);
        }
    }

    private native void datagramSocketCreate() throws SocketException;

    private native void datagramSocketClose();

    private native void socketNativeSetOption(int var1, Object var2) throws SocketException;

    private native Object socketGetOption(int var1) throws SocketException;

    private native void connect0(InetAddress var1, int var2) throws SocketException;

    private native void disconnect0(int var1);

    native int dataAvailable();

    private static native void init();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        PlainDatagramSocketImpl.init();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (System.getProperties().getProperty("os.name").startsWith("Windows")) {
                    version = Float.parseFloat(System.getProperties().getProperty("os.version"));
                }
                exclBindProp = System.getProperty("sun.net.useExclusiveBind");
                return null;
            }
        });
        if ((double)version > 0.0 && exclBindProp != null) {
            exclusiveBind = exclBindProp.length() == 0 ? true : Boolean.parseBoolean(exclBindProp);
        } else if ((double)version >= 6.0) {
            exclusiveBind = true;
        }
    }
}

