/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessBuilder {
    private List<String> command;
    private File directory;
    private Map<String, String> environment;
    private boolean redirectErrorStream;

    public ProcessBuilder(List<String> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.command = list;
    }

    public ProcessBuilder(String ... stringArray) {
        this.command = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            this.command.add(string);
        }
    }

    public ProcessBuilder command(List<String> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.command = list;
        return this;
    }

    public ProcessBuilder command(String ... stringArray) {
        this.command = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            this.command.add(string);
        }
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public Map<String, String> environment() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv.*"));
        }
        if (this.environment == null) {
            this.environment = ProcessEnvironment.environment();
        }
        assert (this.environment != null);
        return this.environment;
    }

    ProcessBuilder environment(String[] stringArray) {
        assert (this.environment == null);
        if (stringArray != null) {
            this.environment = ProcessEnvironment.emptyEnvironment(stringArray.length);
            assert (this.environment != null);
            for (String string : stringArray) {
                int n;
                if (string.indexOf(0) != -1) {
                    string = string.replaceFirst("\u0000.*", "");
                }
                if ((n = string.indexOf(61, 0)) == -1) continue;
                this.environment.put(string.substring(0, n), string.substring(n + 1));
            }
        }
        return this;
    }

    public File directory() {
        return this.directory;
    }

    public ProcessBuilder directory(File file) {
        this.directory = file;
        return this;
    }

    public boolean redirectErrorStream() {
        return this.redirectErrorStream;
    }

    public ProcessBuilder redirectErrorStream(boolean bl) {
        this.redirectErrorStream = bl;
        return this;
    }

    public Process start() throws IOException {
        String[] stringArray = this.command.toArray(new String[this.command.size()]);
        for (String i : stringArray = (String[])stringArray.clone()) {
            if (i != null) continue;
            throw new NullPointerException();
        }
        String string = stringArray[0];
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec(string);
        }
        String string2 = this.directory == null ? null : this.directory.toString();
        for (int iOException = 1; iOException < stringArray.length; ++iOException) {
            if (stringArray[iOException].indexOf(0) < 0) continue;
            throw new IOException("invalid null character in command");
        }
        try {
            return ProcessImpl.start(stringArray, this.environment, string2, this.redirectErrorStream);
        }
        catch (IOException illegalArgumentException) {
            throw this.processException(illegalArgumentException, securityManager, string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.processException(illegalArgumentException, securityManager, string, string2);
        }
    }

    private IOException processException(Exception exception, SecurityManager securityManager, String string, String string2) {
        String string3 = ": " + exception.getMessage();
        Exception exception2 = exception;
        if (exception instanceof IOException && securityManager != null) {
            try {
                securityManager.checkRead(string);
            }
            catch (AccessControlException accessControlException) {
                string3 = "";
                exception2 = accessControlException;
            }
        }
        return new IOException("Cannot run program \"" + string + "\"" + (string2 == null ? "" : " (in directory \"" + string2 + "\")") + string3, exception2);
    }
}

