/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.xml;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ContextClassloaderLocal<V> {
    private static final String FAILED_TO_CREATE_NEW_INSTANCE = "FAILED_TO_CREATE_NEW_INSTANCE";
    private WeakHashMap<ClassLoader, V> CACHE = new WeakHashMap();

    ContextClassloaderLocal() {
    }

    public V get() throws Error {
        ClassLoader classLoader = ContextClassloaderLocal.getContextClassLoader();
        V v = this.CACHE.get(classLoader);
        if (v == null) {
            v = this.createNewInstance();
            this.CACHE.put(classLoader, v);
        }
        return v;
    }

    public void set(V v) {
        this.CACHE.put(ContextClassloaderLocal.getContextClassLoader(), v);
    }

    protected abstract V initialValue() throws Exception;

    private V createNewInstance() {
        try {
            return this.initialValue();
        }
        catch (Exception exception) {
            throw new Error(ContextClassloaderLocal.format(FAILED_TO_CREATE_NEW_INSTANCE, this.getClass().getName()), exception);
        }
    }

    private static String format(String string, Object ... objectArray) {
        String string2 = ResourceBundle.getBundle(ContextClassloaderLocal.class.getName()).getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    private static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }
}

