/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.HelperNodeList;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ElementProxy {
    protected static final Logger log = Logger.getLogger(ElementProxy.class.getName());
    protected Element _constructionElement = null;
    protected String _baseURI = null;
    protected Document _doc = null;
    private static Map<String, String> prefixMappings = new ConcurrentHashMap<String, String>();

    public ElementProxy() {
    }

    public ElementProxy(Document document) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        this._doc = document;
        this._constructionElement = this.createElementForFamilyLocal(this._doc, this.getBaseNamespace(), this.getBaseLocalName());
    }

    public ElementProxy(Element element, String string) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setElement(\"" + element.getTagName() + "\", \"" + string + "\")");
        }
        this._doc = element.getOwnerDocument();
        this._constructionElement = element;
        this._baseURI = string;
        this.guaranteeThatElementInCorrectSpace();
    }

    public abstract String getBaseNamespace();

    public abstract String getBaseLocalName();

    protected Element createElementForFamilyLocal(Document document, String string, String string2) {
        Element element = null;
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else {
            String string3 = this.getBaseNamespace();
            String string4 = ElementProxy.getDefaultPrefix(string3);
            if (string4 == null || string4.length() == 0) {
                element = document.createElementNS(string, string2);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
            } else {
                element = document.createElementNS(string, string4 + ":" + string2);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string4, string);
            }
        }
        return element;
    }

    public static Element createElementForFamily(Document document, String string, String string2) {
        Element element = null;
        String string3 = ElementProxy.getDefaultPrefix(string);
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else if (string3 == null || string3.length() == 0) {
            element = document.createElementNS(string, string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
        } else {
            element = document.createElementNS(string, string3 + ":" + string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string3, string);
        }
        return element;
    }

    public void setElement(Element element, String string) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setElement(" + element.getTagName() + ", \"" + string + "\"");
        }
        this._doc = element.getOwnerDocument();
        this._constructionElement = element;
        this._baseURI = string;
    }

    public final Element getElement() {
        return this._constructionElement;
    }

    public final NodeList getElementPlusReturns() {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(this._doc.createTextNode("\n"));
        helperNodeList.appendChild(this.getElement());
        helperNodeList.appendChild(this._doc.createTextNode("\n"));
        return helperNodeList;
    }

    public Document getDocument() {
        return this._doc;
    }

    public String getBaseURI() {
        return this._baseURI;
    }

    void guaranteeThatElementInCorrectSpace() throws XMLSecurityException {
        String string = this.getBaseLocalName();
        String string2 = this.getBaseNamespace();
        String string3 = this._constructionElement.getLocalName();
        String string4 = this._constructionElement.getNamespaceURI();
        if (!string2.equals(string4) && !string.equals(string3)) {
            Object[] objectArray = new Object[]{string4 + ":" + string3, string2 + ":" + string};
            throw new XMLSecurityException("xml.WrongElement", objectArray);
        }
    }

    public void addBigIntegerElement(BigInteger bigInteger, String string) {
        if (bigInteger != null) {
            Element element = XMLUtils.createElementInSignatureSpace(this._doc, string);
            Base64.fillElementWithBigInteger(element, bigInteger);
            this._constructionElement.appendChild(element);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void addBase64Element(byte[] byArray, String string) {
        if (byArray != null) {
            Element element = Base64.encodeToElement(this._doc, string, byArray);
            this._constructionElement.appendChild(element);
            if (!XMLUtils.ignoreLineBreaks()) {
                this._constructionElement.appendChild(this._doc.createTextNode("\n"));
            }
        }
    }

    public void addTextElement(String string, String string2) {
        Element element = XMLUtils.createElementInSignatureSpace(this._doc, string2);
        Text text = this._doc.createTextNode(string);
        element.appendChild(text);
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addBase64Text(byte[] byArray) {
        if (byArray != null) {
            Text text = XMLUtils.ignoreLineBreaks() ? this._doc.createTextNode(Base64.encode(byArray)) : this._doc.createTextNode("\n" + Base64.encode(byArray) + "\n");
            this._constructionElement.appendChild(text);
        }
    }

    public void addText(String string) {
        if (string != null) {
            Text text = this._doc.createTextNode(string);
            this._constructionElement.appendChild(text);
        }
    }

    public BigInteger getBigIntegerFromChildElement(String string, String string2) throws Base64DecodingException {
        return Base64.decodeBigIntegerFromText(XMLUtils.selectNodeText(this._constructionElement.getFirstChild(), string2, string, 0));
    }

    @Deprecated
    public byte[] getBytesFromChildElement(String string, String string2) throws XMLSecurityException {
        Element element = XMLUtils.selectNode(this._constructionElement.getFirstChild(), string2, string, 0);
        return Base64.decode(element);
    }

    public String getTextFromChildElement(String string, String string2) {
        return XMLUtils.selectNode(this._constructionElement.getFirstChild(), string2, string, 0).getTextContent();
    }

    public byte[] getBytesFromTextChild() throws XMLSecurityException {
        return Base64.decode(XMLUtils.getFullTextChildrenFromElement(this._constructionElement));
    }

    public String getTextFromTextChild() {
        return XMLUtils.getFullTextChildrenFromElement(this._constructionElement);
    }

    public int length(String string, String string2) {
        int n = 0;
        for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!string2.equals(node.getLocalName()) || !string.equals(node.getNamespaceURI())) continue;
            ++n;
        }
        return n;
    }

    public void setXPathNamespaceContext(String string, String string2) throws XMLSecurityException {
        if (string == null || string.length() == 0) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        if (string.equals("xmlns")) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        String string3 = string.startsWith("xmlns:") ? string : "xmlns:" + string;
        Attr attr = this._constructionElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string3);
        if (attr != null) {
            if (!attr.getNodeValue().equals(string2)) {
                Object[] objectArray = new Object[]{string3, this._constructionElement.getAttributeNS(null, string3)};
                throw new XMLSecurityException("namespacePrefixAlreadyUsedByOtherURI", objectArray);
            }
            return;
        }
        this._constructionElement.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
    }

    public static void setDefaultPrefix(String string, String string2) throws XMLSecurityException {
        String string3;
        JavaUtils.checkRegisterPermission();
        if (prefixMappings.containsValue(string2) && !(string3 = prefixMappings.get(string)).equals(string2)) {
            Object[] objectArray = new Object[]{string2, string, string3};
            throw new XMLSecurityException("prefix.AlreadyAssigned", objectArray);
        }
        if ("http://www.w3.org/2000/09/xmldsig#".equals(string)) {
            XMLUtils.setDsPrefix(string2);
        }
        if ("http://www.w3.org/2001/04/xmlenc#".equals(string)) {
            XMLUtils.setXencPrefix(string2);
        }
        prefixMappings.put(string, string2);
    }

    public static void registerDefaultPrefixes() throws XMLSecurityException {
        ElementProxy.setDefaultPrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        ElementProxy.setDefaultPrefix("http://www.w3.org/2001/04/xmlenc#", "xenc");
        ElementProxy.setDefaultPrefix("http://www.w3.org/2009/xmlenc11#", "xenc11");
        ElementProxy.setDefaultPrefix("http://www.xmlsecurity.org/experimental#", "experimental");
        ElementProxy.setDefaultPrefix("http://www.w3.org/2002/04/xmldsig-filter2", "dsig-xpath-old");
        ElementProxy.setDefaultPrefix("http://www.w3.org/2002/06/xmldsig-filter2", "dsig-xpath");
        ElementProxy.setDefaultPrefix("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
        ElementProxy.setDefaultPrefix("http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter", "xx");
    }

    public static String getDefaultPrefix(String string) {
        return prefixMappings.get(string);
    }

    protected void setLocalIdAttribute(String string, String string2) {
        if (string2 != null) {
            Attr attr = this.getDocument().createAttributeNS(null, string);
            attr.setValue(string2);
            this.getElement().setAttributeNodeNS(attr);
            this.getElement().setIdAttributeNode(attr, true);
        } else {
            this.getElement().removeAttributeNS(null, string);
        }
    }
}

