/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Toolkit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractDataLine
extends AbstractLine
implements DataLine {
    private final AudioFormat defaultFormat;
    private final int defaultBufferSize;
    protected final Object lock = new Object();
    protected AudioFormat format;
    protected int bufferSize;
    protected boolean running = false;
    private boolean started = false;
    private boolean active = false;

    protected AbstractDataLine(DataLine.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
        this(info, abstractMixer, controlArray, null, -1);
    }

    protected AbstractDataLine(DataLine.Info info, AbstractMixer abstractMixer, Control[] controlArray, AudioFormat audioFormat, int n) {
        super(info, abstractMixer, controlArray);
        this.defaultFormat = audioFormat != null ? audioFormat : new AudioFormat(44100.0f, 16, 2, true, Platform.isBigEndian());
        this.defaultBufferSize = n > 0 ? n : (int)(this.defaultFormat.getFrameRate() / 2.0f) * this.defaultFormat.getFrameSize();
        this.format = this.defaultFormat;
        this.bufferSize = this.defaultBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (!this.isOpen()) {
                Toolkit.isFullySpecifiedAudioFormat(audioFormat);
                this.mixer.open(this);
                try {
                    this.implOpen(audioFormat, n);
                    this.setOpen(true);
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.mixer.close(this);
                    throw lineUnavailableException;
                }
            } else {
                if (!audioFormat.matches(this.getFormat())) {
                    throw new IllegalStateException("Line is already open with format " + this.getFormat() + " and bufferSize " + this.getBufferSize());
                }
                if (n > 0) {
                    this.setBufferSize(n);
                }
            }
        }
    }

    public final void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.open(audioFormat, -1);
    }

    public int available() {
        return 0;
    }

    public void drain() {
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.mixer;
        synchronized (object) {
            if (this.isOpen() && !this.isStartedRunning()) {
                this.mixer.start(this);
                this.implStart();
                this.running = true;
            }
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mixer;
        synchronized (object) {
            if (this.isOpen() && this.isStartedRunning()) {
                this.implStop();
                this.mixer.stop(this);
                this.running = false;
                if (this.started && !this.isActive()) {
                    this.setStarted(false);
                }
            }
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public final boolean isRunning() {
        return this.started;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final long getMicrosecondPosition() {
        long l = this.getLongFramePosition();
        if (l != -1L) {
            l = Toolkit.frames2micros(this.getFormat(), l);
        }
        return l;
    }

    public final AudioFormat getFormat() {
        return this.format;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final int setBufferSize(int n) {
        return this.getBufferSize();
    }

    public float getLevel() {
        return -1.0f;
    }

    final boolean isStartedRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setActive(boolean bl) {
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.active != bl) {
                this.active = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setStarted(boolean bl) {
        boolean bl2 = false;
        long l = this.getLongFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.started != bl) {
                this.started = bl;
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.START, l));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.STOP, l));
            }
        }
    }

    final void setEOM() {
        this.setStarted(false);
    }

    public final void open() throws LineUnavailableException {
        this.open(this.format, this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (this.isOpen()) {
                this.stop();
                this.setOpen(false);
                this.implClose();
                this.mixer.close(this);
                this.format = this.defaultFormat;
                this.bufferSize = this.defaultBufferSize;
            }
        }
    }

    abstract void implOpen(AudioFormat var1, int var2) throws LineUnavailableException;

    abstract void implClose();

    abstract void implStart();

    abstract void implStop();
}

