/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.SSLAlgorithmDecomposer;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import sun.security.util.AlgorithmConstraints;
import sun.security.util.CryptoPrimitive;
import sun.security.util.DisabledAlgorithmConstraints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SSLAlgorithmConstraints
implements AlgorithmConstraints {
    private static final AlgorithmConstraints tlsDisabledAlgConstraints = new DisabledAlgorithmConstraints("jdk.tls.disabledAlgorithms", new SSLAlgorithmDecomposer());
    private static final AlgorithmConstraints x509DisabledAlgConstraints = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms", new SSLAlgorithmDecomposer(true));
    private AlgorithmConstraints userAlgConstraints = null;
    private AlgorithmConstraints peerAlgConstraints = null;
    private boolean enabledX509DisabledAlgConstraints = true;
    static final AlgorithmConstraints DEFAULT = new SSLAlgorithmConstraints(null);
    static final AlgorithmConstraints DEFAULT_SSL_ONLY = new SSLAlgorithmConstraints((SSLSocket)null, false);

    SSLAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
        this.userAlgConstraints = algorithmConstraints;
    }

    SSLAlgorithmConstraints(SSLSocket sSLSocket, boolean bl) {
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLEngine sSLEngine, boolean bl) {
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLSocket sSLSocket, String[] stringArray, boolean bl) {
        if (sSLSocket != null) {
            this.peerAlgConstraints = new SupportedSignatureAlgorithmConstraints(stringArray);
        }
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLEngine sSLEngine, String[] stringArray, boolean bl) {
        if (sSLEngine != null) {
            this.peerAlgConstraints = new SupportedSignatureAlgorithmConstraints(stringArray);
        }
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    public boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        boolean bl = true;
        if (this.peerAlgConstraints != null) {
            bl = this.peerAlgConstraints.permits(set, string, algorithmParameters);
        }
        if (bl && this.userAlgConstraints != null) {
            bl = this.userAlgConstraints.permits(set, string, algorithmParameters);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, string, algorithmParameters);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, string, algorithmParameters);
        }
        return bl;
    }

    public boolean permits(Set<CryptoPrimitive> set, Key key) {
        boolean bl = true;
        if (this.peerAlgConstraints != null) {
            bl = this.peerAlgConstraints.permits(set, key);
        }
        if (bl && this.userAlgConstraints != null) {
            bl = this.userAlgConstraints.permits(set, key);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, key);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, key);
        }
        return bl;
    }

    public boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        boolean bl = true;
        if (this.peerAlgConstraints != null) {
            bl = this.peerAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl && this.userAlgConstraints != null) {
            bl = this.userAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SupportedSignatureAlgorithmConstraints
    implements AlgorithmConstraints {
        private String[] supportedAlgorithms;

        SupportedSignatureAlgorithmConstraints(String[] stringArray) {
            this.supportedAlgorithms = stringArray != null ? (String[])stringArray.clone() : null;
        }

        public boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            if (set == null || set.isEmpty()) {
                throw new IllegalArgumentException("No cryptographic primitive specified");
            }
            if (this.supportedAlgorithms == null || this.supportedAlgorithms.length == 0) {
                return false;
            }
            int n = string.indexOf("and");
            if (n > 0) {
                string = string.substring(0, n);
            }
            for (String string2 : this.supportedAlgorithms) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
            return false;
        }

        public final boolean permits(Set<CryptoPrimitive> set, Key key) {
            return true;
        }

        public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            return this.permits(set, string, algorithmParameters);
        }
    }
}

