/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ExtendedSSLParameters;
import com.sun.net.ssl.internal.ssl.ExtendedSSLSession;
import com.sun.net.ssl.internal.ssl.JsseJce;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLAlgorithmConstraints;
import com.sun.net.ssl.internal.ssl.SSLEngineImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import sun.security.util.AlgorithmConstraints;
import sun.security.util.HostnameChecker;
import sun.security.validator.KeyStores;
import sun.security.validator.Validator;

final class X509TrustManagerImpl
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final String validatorType;
    private final Collection<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters pkixParams;
    private volatile Validator clientValidator;
    private volatile Validator serverValidator;
    private static final Debug debug = Debug.getInstance("ssl");

    X509TrustManagerImpl(String string, KeyStore keyStore) throws KeyStoreException {
        this.validatorType = string;
        this.pkixParams = null;
        this.trustedCerts = keyStore == null ? Collections.emptySet() : KeyStores.getTrustedCerts((KeyStore)keyStore);
        this.showTrustedCerts();
    }

    X509TrustManagerImpl(String string, PKIXBuilderParameters pKIXBuilderParameters) {
        this.validatorType = string;
        this.pkixParams = pKIXBuilderParameters;
        Validator validator = this.getValidator("tls server");
        this.trustedCerts = validator.getTrustedCertificates();
        this.serverValidator = validator;
        this.showTrustedCerts();
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, (Socket)null, true);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, (Socket)null, false);
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.trustedCerts.size()];
        this.trustedCerts.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, socket, true);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, socket, false);
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, sSLEngine, true);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, sSLEngine, false);
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, String string2, String string3) throws CertificateException {
        this.checkClientTrusted(x509CertificateArray, string);
        X509TrustManagerImpl.checkIdentity(string2, x509CertificateArray[0], string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Validator checkTrustedInit(X509Certificate[] x509CertificateArray, String string, boolean bl) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or zero-length authentication type");
        }
        Validator validator = null;
        if (bl) {
            validator = this.clientValidator;
            if (validator == null) {
                X509TrustManagerImpl x509TrustManagerImpl = this;
                synchronized (x509TrustManagerImpl) {
                    validator = this.clientValidator;
                    if (validator == null) {
                        this.clientValidator = validator = this.getValidator("tls client");
                    }
                }
            }
        } else {
            validator = this.serverValidator;
            if (validator == null) {
                X509TrustManagerImpl x509TrustManagerImpl = this;
                synchronized (x509TrustManagerImpl) {
                    validator = this.serverValidator;
                    if (validator == null) {
                        this.serverValidator = validator = this.getValidator("tls server");
                    }
                }
            }
        }
        return validator;
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket, boolean bl) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        Validator validator = this.checkTrustedInit(x509CertificateArray, string, bl);
        SSLAlgorithmConstraints sSLAlgorithmConstraints = null;
        if (socket != null && socket.isConnected() && socket instanceof SSLSocketImpl) {
            Object object;
            x509CertificateArray2 = (X509Certificate[])socket;
            SSLSession sSLSession = x509CertificateArray2.getHandshakeSession();
            if (sSLSession == null) {
                throw new CertificateException("No handshake session");
            }
            String string2 = ((ExtendedSSLParameters)x509CertificateArray2.getSSLParameters()).getEndpointIdentificationAlgorithm();
            if (string2 != null && string2.length() != 0) {
                object = sSLSession.getPeerHost();
                X509TrustManagerImpl.checkIdentity((String)object, x509CertificateArray[0], string2);
            }
            object = ProtocolVersion.valueOf(sSLSession.getProtocol());
            if (((ProtocolVersion)object).v >= ProtocolVersion.TLS12.v) {
                if (sSLSession instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)sSLSession;
                    String[] stringArray = extendedSSLSession.getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints((SSLSocket)x509CertificateArray2, stringArray, false);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints((SSLSocket)x509CertificateArray2, false);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints((SSLSocket)x509CertificateArray2, false);
            }
        }
        x509CertificateArray2 = null;
        x509CertificateArray2 = bl ? X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, null) : X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, string);
        if (debug != null && Debug.isOn("trustmanager")) {
            System.out.println("Found trusted certificate:");
            System.out.println(x509CertificateArray2[x509CertificateArray2.length - 1]);
        }
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine, boolean bl) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        Validator validator = this.checkTrustedInit(x509CertificateArray, string, bl);
        SSLAlgorithmConstraints sSLAlgorithmConstraints = null;
        if (sSLEngine != null) {
            Object object;
            x509CertificateArray2 = ((SSLEngineImpl)sSLEngine).getHandshakeSession();
            if (x509CertificateArray2 == null) {
                throw new CertificateException("No handshake session");
            }
            String string2 = ((ExtendedSSLParameters)sSLEngine.getSSLParameters()).getEndpointIdentificationAlgorithm();
            if (string2 != null && string2.length() != 0) {
                object = x509CertificateArray2.getPeerHost();
                X509TrustManagerImpl.checkIdentity((String)object, x509CertificateArray[0], string2);
            }
            object = ProtocolVersion.valueOf(x509CertificateArray2.getProtocol());
            if (((ProtocolVersion)object).v >= ProtocolVersion.TLS12.v) {
                if (x509CertificateArray2 instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)x509CertificateArray2;
                    String[] stringArray = extendedSSLSession.getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, stringArray, false);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, false);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, false);
            }
        }
        x509CertificateArray2 = null;
        x509CertificateArray2 = bl ? X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, null) : X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, string);
        if (debug != null && Debug.isOn("trustmanager")) {
            System.out.println("Found trusted certificate:");
            System.out.println(x509CertificateArray2[x509CertificateArray2.length - 1]);
        }
    }

    private void showTrustedCerts() {
        if (debug != null && Debug.isOn("trustmanager")) {
            for (X509Certificate x509Certificate : this.trustedCerts) {
                System.out.println("adding as trusted cert:");
                System.out.println("  Subject: " + x509Certificate.getSubjectX500Principal());
                System.out.println("  Issuer:  " + x509Certificate.getIssuerX500Principal());
                System.out.println("  Algorithm: " + x509Certificate.getPublicKey().getAlgorithm() + "; Serial number: 0x" + x509Certificate.getSerialNumber().toString(16));
                System.out.println("  Valid from " + x509Certificate.getNotBefore() + " until " + x509Certificate.getNotAfter());
                System.out.println();
            }
        }
    }

    private Validator getValidator(String string) {
        Validator validator = this.pkixParams == null ? Validator.getInstance(this.validatorType, string, this.trustedCerts) : Validator.getInstance(this.validatorType, string, this.pkixParams);
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] validate(Validator validator, X509Certificate[] x509CertificateArray, AlgorithmConstraints algorithmConstraints, String string) throws CertificateException {
        Object object = JsseJce.beginFipsProvider();
        try {
            X509Certificate[] x509CertificateArray2 = validator.validate(x509CertificateArray, null, algorithmConstraints, string);
            return x509CertificateArray2;
        }
        finally {
            JsseJce.endFipsProvider(object);
        }
    }

    static void checkIdentity(String string, X509Certificate x509Certificate, String string2) throws CertificateException {
        if (string2 != null && string2.length() != 0) {
            if (string != null && string.startsWith("[") && string.endsWith("]")) {
                string = string.substring(1, string.length() - 1);
            }
            if (string2.equalsIgnoreCase("HTTPS")) {
                HostnameChecker.getInstance((byte)1).match(string, x509Certificate);
            } else if (string2.equalsIgnoreCase("LDAP") || string2.equalsIgnoreCase("LDAPS")) {
                HostnameChecker.getInstance((byte)2).match(string, x509Certificate);
            } else {
                throw new CertificateException("Unknown identification algorithm: " + string2);
            }
        }
    }
}

