/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.ExtensionType;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.HelloExtension;
import com.sun.net.ssl.internal.ssl.SignatureAndHashAlgorithm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.SSLProtocolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SignatureAlgorithmsExtension
extends HelloExtension {
    private Collection<SignatureAndHashAlgorithm> algorithms;
    private int algorithmsLen;

    SignatureAlgorithmsExtension(Collection<SignatureAndHashAlgorithm> collection) {
        super(ExtensionType.EXT_SIGNATURE_ALGORITHMS);
        this.algorithms = new ArrayList<SignatureAndHashAlgorithm>(collection);
        this.algorithmsLen = SignatureAndHashAlgorithm.sizeInRecord() * this.algorithms.size();
    }

    SignatureAlgorithmsExtension(HandshakeInStream handshakeInStream, int n) throws IOException {
        super(ExtensionType.EXT_SIGNATURE_ALGORITHMS);
        int n2;
        this.algorithmsLen = handshakeInStream.getInt16();
        if (this.algorithmsLen == 0 || this.algorithmsLen + 2 != n) {
            throw new SSLProtocolException("Invalid " + this.type + " extension");
        }
        this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
        int n3 = 0;
        for (n2 = this.algorithmsLen; n2 > 1; n2 -= 2) {
            int n4 = handshakeInStream.getInt8();
            int n5 = handshakeInStream.getInt8();
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.valueOf(n4, n5, ++n3);
            this.algorithms.add(signatureAndHashAlgorithm);
        }
        if (n2 != 0) {
            throw new SSLProtocolException("Invalid server_name extension");
        }
    }

    Collection<SignatureAndHashAlgorithm> getSignAlgorithms() {
        return this.algorithms;
    }

    @Override
    int length() {
        return 6 + this.algorithmsLen;
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(this.type.id);
        handshakeOutStream.putInt16(this.algorithmsLen + 2);
        handshakeOutStream.putInt16(this.algorithmsLen);
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : this.algorithms) {
            handshakeOutStream.putInt8(signatureAndHashAlgorithm.getHashValue());
            handshakeOutStream.putInt8(signatureAndHashAlgorithm.getSignatureValue());
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : this.algorithms) {
            if (bl) {
                stringBuffer.append(", " + signatureAndHashAlgorithm.getAlgorithmName());
                continue;
            }
            stringBuffer.append(signatureAndHashAlgorithm.getAlgorithmName());
            bl = true;
        }
        return "Extension " + this.type + ", signature_algorithms: " + stringBuffer;
    }
}

