/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.ExtendedSSLParameters;
import com.sun.net.ssl.internal.ssl.ExtendedSSLSession;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLAlgorithmConstraints;
import com.sun.net.ssl.internal.ssl.SSLEngineImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import com.sun.net.ssl.internal.ssl.X509TrustManagerImpl;
import java.net.Socket;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.util.AlgorithmConstraints;

final class AbstractTrustManagerWrapper
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final X509TrustManager tm;

    AbstractTrustManagerWrapper(X509TrustManager x509TrustManager) {
        this.tm = x509TrustManager;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, socket, true);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, socket, false);
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, sSLEngine, true);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, sSLEngine, false);
    }

    private void checkAdditionalTrust(X509Certificate[] x509CertificateArray, String string, Socket socket, boolean bl) throws CertificateException {
        if (socket != null && socket.isConnected() && socket instanceof SSLSocketImpl) {
            Object object;
            SSLSocketImpl sSLSocketImpl = (SSLSocketImpl)socket;
            SSLSession sSLSession = sSLSocketImpl.getHandshakeSession();
            if (sSLSession == null) {
                throw new CertificateException("No handshake session");
            }
            String string2 = ((ExtendedSSLParameters)sSLSocketImpl.getSSLParameters()).getEndpointIdentificationAlgorithm();
            if (string2 != null && string2.length() != 0) {
                object = sSLSession.getPeerHost();
                X509TrustManagerImpl.checkIdentity((String)object, x509CertificateArray[0], string2);
            }
            object = ProtocolVersion.valueOf(sSLSession.getProtocol());
            SSLAlgorithmConstraints sSLAlgorithmConstraints = null;
            if (((ProtocolVersion)object).v >= ProtocolVersion.TLS12.v) {
                if (sSLSession instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)sSLSession;
                    String[] stringArray = extendedSSLSession.getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocketImpl, stringArray, true);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocketImpl, true);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocketImpl, true);
            }
            this.checkAlgorithmConstraints(x509CertificateArray, sSLAlgorithmConstraints);
        }
    }

    private void checkAdditionalTrust(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine, boolean bl) throws CertificateException {
        if (sSLEngine != null) {
            Object object;
            SSLSession sSLSession = ((SSLEngineImpl)sSLEngine).getHandshakeSession();
            if (sSLSession == null) {
                throw new CertificateException("No handshake session");
            }
            String string2 = ((ExtendedSSLParameters)sSLEngine.getSSLParameters()).getEndpointIdentificationAlgorithm();
            if (string2 != null && string2.length() != 0) {
                object = sSLSession.getPeerHost();
                X509TrustManagerImpl.checkIdentity((String)object, x509CertificateArray[0], string2);
            }
            object = ProtocolVersion.valueOf(sSLSession.getProtocol());
            SSLAlgorithmConstraints sSLAlgorithmConstraints = null;
            if (((ProtocolVersion)object).v >= ProtocolVersion.TLS12.v) {
                if (sSLSession instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)sSLSession;
                    String[] stringArray = extendedSSLSession.getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, stringArray, true);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, true);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, true);
            }
            this.checkAlgorithmConstraints(x509CertificateArray, sSLAlgorithmConstraints);
        }
    }

    private void checkAlgorithmConstraints(X509Certificate[] x509CertificateArray, AlgorithmConstraints algorithmConstraints) throws CertificateException {
        try {
            int n = x509CertificateArray.length - 1;
            HashSet hashSet = new HashSet();
            X509Certificate[] x509CertificateArray2 = this.tm.getAcceptedIssuers();
            if (x509CertificateArray2 != null && x509CertificateArray2.length > 0) {
                Collections.addAll(hashSet, x509CertificateArray2);
            }
            if (hashSet.contains(x509CertificateArray[n])) {
                --n;
            }
            if (n >= 0) {
                AlgorithmChecker algorithmChecker = new AlgorithmChecker(algorithmConstraints);
                algorithmChecker.init(false);
                for (int i = n; i >= 0; --i) {
                    X509Certificate x509Certificate = x509CertificateArray[i];
                    algorithmChecker.check(x509Certificate, Collections.<String>emptySet());
                }
            }
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertificateException("Certificates does not conform to algorithm constraints");
        }
    }
}

