/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.DeployCacheJarAccess;
import com.sun.deploy.cache.DeployCacheJarAccessImpl;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class SigningInfo {
    private static DeployCacheJarAccess jarAccess = DeployCacheJarAccessImpl.getJarAccess();
    private CacheEntry ce = null;
    private URL location = null;
    private String version = null;
    private boolean fileInCache;
    private boolean jarIsEmpty;
    private String jarFilePath = null;
    private boolean wasChecked = false;

    public static Certificate[] toCertificateArray(List list) {
        Object object;
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof CertChain) {
                n += ((CertChain)object).getLength();
                continue;
            }
            return null;
        }
        object = new Certificate[n];
        iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Certificate[] certificateArray = ((CertChain)iterator.next()).getCertificates();
            System.arraycopy(certificateArray, 0, object, n2, certificateArray.length);
            n2 += certificateArray.length;
        }
        return object;
    }

    private static boolean setContains(List list, Object object) {
        if (list == null || object == null) {
            return false;
        }
        Iterator iterator = list.iterator();
        if (Config.isJavaVersionAtLeast15()) {
            CertPath certPath = null;
            CertPath certPath2 = ((CodeSigner)object).getSignerCertPath();
            while (iterator.hasNext()) {
                certPath = ((CodeSigner)iterator.next()).getSignerCertPath();
                if (!certPath2.equals(certPath)) continue;
                return true;
            }
            return false;
        }
        while (iterator.hasNext()) {
            if (!object.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static List overlapChainLists(List list, List list2) {
        if (list == null || list2 == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!SigningInfo.setContains(list2, e)) continue;
            arrayList.add(e);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public static List overlapSigners(List list, CodeSigner[] codeSignerArray) {
        ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
        for (int i = 0; i < codeSignerArray.length; ++i) {
            if (list != null && !SigningInfo.setContains(list, codeSignerArray[i])) continue;
            arrayList.add(codeSignerArray[i]);
        }
        return arrayList;
    }

    public static List overlapCertificateChains(List list, Certificate[] certificateArray) {
        CertChain certChain;
        ArrayList<CertChain> arrayList = new ArrayList<CertChain>();
        int n = 0;
        while ((certChain = SigningInfo.getAChain(certificateArray, n)) != null) {
            if (list == null || list.contains(certChain)) {
                arrayList.add(certChain);
            }
            n += certChain.getLength();
        }
        return arrayList;
    }

    private static CertChain getAChain(Certificate[] certificateArray, int n) {
        if (n > certificateArray.length - 1) {
            return null;
        }
        int n2 = 0;
        for (n2 = n; n2 < certificateArray.length - 1 && ((Object)((X509Certificate)certificateArray[n2 + 1]).getSubjectDN()).equals(((X509Certificate)certificateArray[n2]).getIssuerDN()); ++n2) {
        }
        return new CertChain(certificateArray, n, n2);
    }

    public SigningInfo(URL uRL, String string) {
        this.location = uRL;
        this.version = string;
        boolean bl = false;
        try {
            this.jarFilePath = DownloadEngine.getCachedResourceFilePath((URL)uRL, (String)string);
            this.fileInCache = true;
        }
        catch (IOException iOException) {
            if (string != null) {
                try {
                    this.jarFilePath = DownloadEngine.getCachedResourceFilePath((URL)uRL, null);
                    bl = true;
                }
                catch (IOException iOException2) {
                    this.fileInCache = false;
                }
            }
            this.fileInCache = false;
        }
        if (this.fileInCache && Cache.isCacheEnabled()) {
            this.ce = Cache.getCacheEntry((URL)uRL, null, (String)(bl ? null : string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List check() throws IOException, JARSigningException {
        List list = null;
        if (this.ce != null) {
            JarFile jarFile = this.ce.getJarFile();
            Trace.println((String)("Validating cached jar url=" + this.ce.getURL() + " ffile=" + this.ce.getResourceFilename() + " " + jarFile), (TraceLevel)TraceLevel.SECURITY);
            list = this.getCommonCodeSignersForJar(jarFile);
            if (list != null && list.isEmpty()) {
                list = null;
                throw new JARSigningException(this.location, this.version, 1);
            }
            this.wasChecked = true;
        } else {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(this.jarFilePath);
                list = this.getCommonCodeSignersForJar(jarFile);
                if (list != null && list.isEmpty()) {
                    list = null;
                    throw new JARSigningException(this.location, this.version, 1);
                }
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
        }
        return list;
    }

    public long getCachedVerificationTimestampt() {
        if (this.ce != null) {
            return this.ce.getValidationTimestampt();
        }
        return 0L;
    }

    public List getCertificates() {
        if (this.ce != null) {
            if (Globals.isJavaVersionAtLeast15()) {
                return SigningInfo.overlapSigners(null, this.ce.getCodeSigners());
            }
            return SigningInfo.overlapCertificateChains(null, this.ce.getCertificates());
        }
        return null;
    }

    public boolean isFileKnownToBeNotCached() {
        return !this.fileInCache;
    }

    public boolean isJarKnownToBeEmpty() {
        return this.jarIsEmpty;
    }

    public boolean isKnownToBeValidated() {
        return this.ce != null && this.ce.getValidationTimestampt() != 0L;
    }

    public boolean isKnownToBeSigned() {
        if (this.ce != null) {
            return this.ce.isKnownToBeSigned();
        }
        return false;
    }

    public Map getTrustedEntries() {
        if (this.ce != null) {
            return this.ce.getCachedTrustedEntries();
        }
        return null;
    }

    public void updateCacheIfNeeded(boolean bl, Map map, long l, long l2) {
        if (!this.wasChecked) {
            return;
        }
        this.updateCache(bl, map, l, l2);
    }

    public void updateCache(boolean bl, Map map, long l, long l2) {
        if (this.ce != null) {
            this.ce.updateValidationResults(bl, map, l, l2);
        }
    }

    List getCommonCodeSignersForJar(JarFile jarFile) throws IOException {
        List list = null;
        boolean bl = false;
        try {
            boolean bl2 = Globals.isJavaVersionAtLeast15();
            if (jarAccess != null) {
                jarAccess.getCodeSource(jarFile, new URL("http:"), "/NOP");
                CodeSource[] codeSourceArray = jarAccess.getCodeSources(jarFile, null);
                jarAccess.setEagerValidation(jarFile, true);
                Enumeration enumeration = jarAccess.entryNames(jarFile, codeSourceArray);
                while (enumeration.hasMoreElements() && (list == null || !list.isEmpty())) {
                    Serializable[] serializableArray;
                    String string = (String)enumeration.nextElement();
                    CodeSource codeSource = jarAccess.getCodeSource(jarFile, null, string);
                    bl = true;
                    if (bl2) {
                        serializableArray = codeSource.getCodeSigners();
                        if (serializableArray == null) {
                            Trace.println((String)("Found unsigned entry: " + string), (TraceLevel)TraceLevel.SECURITY);
                            throw new JARSigningException(this.location, this.version, 3);
                        }
                        list = SigningInfo.overlapSigners(list, (CodeSigner[])serializableArray);
                        continue;
                    }
                    serializableArray = codeSource.getCertificates();
                    if (serializableArray == null) {
                        Trace.println((String)("Found unsigned entry: " + string), (TraceLevel)TraceLevel.SECURITY);
                        throw new JARSigningException(this.location, this.version, 3);
                    }
                    list = SigningInfo.overlapCertificateChains(list, (Certificate[])serializableArray);
                }
                if (bl2 && !JarUtil.allJarEntriesSigned((JarFile)jarFile)) {
                    throw new JARSigningException(this.location, this.version, 3);
                }
            } else {
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements() && (list == null || !list.isEmpty())) {
                    Serializable[] serializableArray;
                    byte[] byArray = new byte[8192];
                    JarEntry jarEntry = enumeration.nextElement();
                    if (JarUtil.canSkipEntry((ZipEntry)jarEntry)) continue;
                    bl = true;
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    while (inputStream.read(byArray, 0, byArray.length) != -1) {
                    }
                    inputStream.close();
                    if (bl2) {
                        serializableArray = jarEntry.getCodeSigners();
                        if (serializableArray == null) {
                            Trace.println((String)("Found unsigned entry: " + jarEntry.getName()), (TraceLevel)TraceLevel.SECURITY);
                            throw new JARSigningException(this.location, this.version, 3);
                        }
                        list = SigningInfo.overlapSigners(list, (CodeSigner[])serializableArray);
                        continue;
                    }
                    serializableArray = jarEntry.getCertificates();
                    if (serializableArray == null) {
                        Trace.println((String)("Found unsigned entry: " + jarEntry.getName()), (TraceLevel)TraceLevel.SECURITY);
                        throw new JARSigningException(this.location, this.version, 3);
                    }
                    list = SigningInfo.overlapCertificateChains(list, (Certificate[])serializableArray);
                }
            }
        }
        catch (JARSigningException jARSigningException) {
            throw jARSigningException;
        }
        catch (IOException iOException) {
            throw new JARSigningException(this.location, this.version, 2, (Exception)iOException);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(this.location, this.version, 2, (Exception)securityException);
        }
        this.jarIsEmpty = !bl;
        return list;
    }

    static class CertChain {
        Certificate[] certs;

        CertChain(Certificate[] certificateArray, int n, int n2) {
            this.certs = new Certificate[n2 - n + 1];
            for (int i = 0; i < this.certs.length; ++i) {
                this.certs[i] = certificateArray[n + i];
            }
        }

        Certificate[] getCertificates() {
            return this.certs;
        }

        int getLength() {
            return this.certs.length;
        }

        public int hashCode() {
            if (this.certs.length == 0) {
                return 0;
            }
            return this.certs[0].hashCode();
        }

        public boolean equals(Object object) {
            CertChain certChain = (CertChain)object;
            if (certChain == null || certChain.getLength() != this.getLength()) {
                return false;
            }
            for (int i = 0; i < this.certs.length; ++i) {
                if (certChain.certs[i].equals(this.certs[i])) continue;
                return false;
            }
            return true;
        }
    }
}

