/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.pkcs11.P11ECKeyFactory;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.provider.ParameterCache;
import sun.security.rsa.RSAKeyFactory;

final class P11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private int keySize;
    private AlgorithmParameterSpec params;
    private BigInteger rsaPublicExponent = RSAKeyGenParameterSpec.F4;
    private SecureRandom random;

    P11KeyPairGenerator(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
        if (string.equals("EC")) {
            this.initialize(256, null);
        } else {
            this.initialize(1024, null);
        }
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.token.ensureValid();
        try {
            this.checkKeySize(n, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
        this.keySize = n;
        this.params = null;
        this.random = secureRandom;
        if (this.algorithm.equals("EC")) {
            this.params = P11ECKeyFactory.getECParameterSpec(n);
            if (this.params == null) {
                throw new InvalidParameterException("No EC parameters available for key size " + n + " bits");
            }
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.token.ensureValid();
        if (this.algorithm.equals("DH")) {
            if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DHParameterSpec required for Diffie-Hellman");
            }
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            int n = dHParameterSpec.getP().bitLength();
            this.checkKeySize(n, dHParameterSpec);
            this.keySize = n;
            this.params = dHParameterSpec;
        } else if (this.algorithm.equals("RSA")) {
            if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RSAKeyGenParameterSpec required for RSA");
            }
            RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
            int n = rSAKeyGenParameterSpec.getKeysize();
            this.checkKeySize(n, rSAKeyGenParameterSpec);
            this.keySize = n;
            this.params = null;
            this.rsaPublicExponent = rSAKeyGenParameterSpec.getPublicExponent();
        } else if (this.algorithm.equals("DSA")) {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DSAParameterSpec required for DSA");
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
            int n = dSAParameterSpec.getP().bitLength();
            this.checkKeySize(n, dSAParameterSpec);
            this.keySize = n;
            this.params = dSAParameterSpec;
        } else if (this.algorithm.equals("EC")) {
            ECParameterSpec eCParameterSpec;
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                eCParameterSpec = P11ECKeyFactory.getECParameterSpec((ECParameterSpec)algorithmParameterSpec);
                if (eCParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("Unsupported curve: " + algorithmParameterSpec);
                }
            } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
                eCParameterSpec = P11ECKeyFactory.getECParameterSpec(string);
                if (eCParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("Unknown curve name: " + string);
                }
            } else {
                throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
            }
            int n = eCParameterSpec.getCurve().getField().getFieldSize();
            this.checkKeySize(n, eCParameterSpec);
            this.keySize = n;
            this.params = eCParameterSpec;
        } else {
            throw new ProviderException("Unknown algorithm: " + this.algorithm);
        }
        this.random = secureRandom;
    }

    private void checkKeySize(int n, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (this.algorithm.equals("EC")) {
            if (n < 112) {
                throw new InvalidAlgorithmParameterException("Key size must be at least 112 bit");
            }
            if (n > 2048) {
                throw new InvalidAlgorithmParameterException("Key size must be at most 2048 bit");
            }
            return;
        }
        if (this.algorithm.equals("RSA")) {
            BigInteger bigInteger = this.rsaPublicExponent;
            if (algorithmParameterSpec != null) {
                bigInteger = ((RSAKeyGenParameterSpec)algorithmParameterSpec).getPublicExponent();
            }
            try {
                RSAKeyFactory.checkKeyLengths(n, bigInteger, 512, 65536);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidAlgorithmParameterException(invalidKeyException.getMessage());
            }
            return;
        }
        if (n < 512) {
            throw new InvalidAlgorithmParameterException("Key size must be at least 512 bit");
        }
        if (this.algorithm.equals("DH")) {
            if (algorithmParameterSpec != null) {
                if (n > 65536) {
                    throw new InvalidAlgorithmParameterException("Key size must be at most 65536 bit");
                }
            } else if (n != 2048 && (n > 1024 || (n & 0x3F) != 0)) {
                throw new InvalidAlgorithmParameterException(this.algorithm + " key must be multiples of 64 if less than 1024 bits" + ", or 2048 bits");
            }
        } else if (n > 1024 || (n & 0x3F) != 0) {
            throw new InvalidAlgorithmParameterException("Key size must be a multiple of 64 and at most 1024 bits");
        }
    }

    public KeyPair generateKeyPair() {
        Object object;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2;
        long l;
        this.token.ensureValid();
        if (this.algorithm.equals("RSA")) {
            l = 0L;
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(289L, this.keySize), new CK_ATTRIBUTE(290L, this.rsaPublicExponent)};
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{};
        } else if (this.algorithm.equals("DSA")) {
            l = 1L;
            if (this.params == null) {
                try {
                    object = ParameterCache.getDSAParameterSpec(this.keySize, this.random);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException("Could not generate DSA parameters", generalSecurityException);
                }
            } else {
                object = (DSAParameterSpec)this.params;
            }
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L, ((DSAParameterSpec)object).getP()), new CK_ATTRIBUTE(305L, ((DSAParameterSpec)object).getQ()), new CK_ATTRIBUTE(306L, ((DSAParameterSpec)object).getG())};
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{};
        } else if (this.algorithm.equals("DH")) {
            int n;
            l = 2L;
            if (this.params == null) {
                try {
                    object = ParameterCache.getDHParameterSpec(this.keySize, this.random);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException("Could not generate DH parameters", generalSecurityException);
                }
                n = 0;
            } else {
                object = (DHParameterSpec)this.params;
                n = ((DHParameterSpec)object).getL();
            }
            if (n <= 0) {
                n = this.keySize >= 1024 ? 768 : 512;
            }
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L, ((DHParameterSpec)object).getP()), new CK_ATTRIBUTE(306L, ((DHParameterSpec)object).getG())};
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(352L, n)};
        } else if (this.algorithm.equals("EC")) {
            l = 3L;
            object = P11ECKeyFactory.encodeParameters((ECParameterSpec)this.params);
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L, object)};
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{};
        } else {
            throw new ProviderException("Unknown algorithm: " + this.algorithm);
        }
        object = null;
        try {
            object = this.token.getObjSession();
            cK_ATTRIBUTEArray2 = this.token.getAttributes("generate", 2L, l, cK_ATTRIBUTEArray2);
            cK_ATTRIBUTEArray = this.token.getAttributes("generate", 3L, l, cK_ATTRIBUTEArray);
            long[] lArray = this.token.p11.C_GenerateKeyPair(((Session)object).id(), new CK_MECHANISM(this.mechanism), cK_ATTRIBUTEArray2, cK_ATTRIBUTEArray);
            PublicKey publicKey = P11Key.publicKey((Session)object, lArray[0], this.algorithm, this.keySize, cK_ATTRIBUTEArray2);
            PrivateKey privateKey = P11Key.privateKey((Session)object, lArray[1], this.algorithm, this.keySize, cK_ATTRIBUTEArray);
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            return keyPair;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException(pKCS11Exception);
        }
        finally {
            this.token.releaseSession((Session)object);
        }
    }
}

