/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.security.DeployManifestChecker;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.jar.Attributes;
import sun.misc.Resource;
import sun.plugin2.applet.Applet2ClassLoader;
import sun.plugin2.applet.Applet2IllegalArgumentException;

class Applet2ObjectInputStream
extends ObjectInputStream {
    private ClassLoader loader;
    private static boolean firstCheck = true;

    public Applet2ObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(inputStream);
        if (classLoader == null) {
            throw new Applet2IllegalArgumentException("appletillegalargumentexception.objectinputstream");
        }
        this.loader = classLoader;
    }

    private Class primitiveType(char c) {
        switch (c) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (string.startsWith("[")) {
            Class<?> clazz;
            int n = 1;
            while (string.charAt(n) == '[') {
                ++n;
            }
            if (string.charAt(n) == 'L') {
                clazz = this.loader.loadClass(string.substring(n + 1, string.length() - 1));
            } else {
                if (string.length() != n + 1) {
                    throw new ClassNotFoundException(string);
                }
                clazz = this.primitiveType(string.charAt(n));
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = 0;
            }
            return Array.newInstance(clazz, nArray).getClass();
        }
        if (firstCheck) {
            firstCheck = false;
            Applet2ClassLoader applet2ClassLoader = (Applet2ClassLoader)this.loader;
            Resource resource = applet2ClassLoader.getResourceAsResource(string + ".class");
            if (resource != null && resource.getManifest() != null) {
                DeployManifestChecker.verifyMainClass((String)string, (Attributes)resource.getManifest().getMainAttributes());
            }
        }
        return this.loader.loadClass(string);
    }
}

