/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.protocol.jar;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.DeployCacheHandler;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.URLEncoder;
import com.sun.deploy.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.awt.AppContext;
import sun.net.www.protocol.jar.JarURLConnection;
import sun.plugin.net.protocol.jar.Handler;

public class CachedJarURLConnection
extends JarURLConnection {
    private URL jarFileURL = null;
    private URL jarFileURLOverride = null;
    private String entryName;
    private JarEntry jarEntry;
    private JarFile jarFile;
    private String contentType;
    private boolean useJarCache = false;
    private Map headerFields = new HashMap();

    public CachedJarURLConnection(URL uRL, Handler handler) throws MalformedURLException, IOException {
        super(uRL, handler);
        this.getJarFileURL();
        this.entryName = this.getEntryName();
    }

    public synchronized URL getJarFileURL() {
        if (this.jarFileURLOverride != null) {
            return this.jarFileURLOverride;
        }
        if (this.jarFileURL == null) {
            this.jarFileURL = super.getJarFileURL();
            try {
                this.jarFileURL = new URL(URLUtil.canonicalize((String)this.jarFileURL.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.jarFileURL;
    }

    public synchronized JarFile getJarFile() throws IOException {
        this.jarFile = this.getJarFileInternal();
        try {
            return (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (CachedJarURLConnection.this.jarFile instanceof CachedJarFile) {
                        try {
                            return ((CachedJarFile)CachedJarURLConnection.this.jarFile).clone();
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            throw new IOException(cloneNotSupportedException.getMessage());
                        }
                    }
                    String string = CachedJarURLConnection.this.jarFile.getName();
                    if (new File(string).exists()) {
                        return new JarFile(CachedJarURLConnection.this.jarFile.getName());
                    }
                    return CachedJarURLConnection.this.jarFile;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getCause().getMessage());
        }
    }

    public synchronized JarFile getJarFileInternal() throws IOException {
        String string;
        if (this.jarFile != null) {
            return this.jarFile;
        }
        if (Cache.isCacheEnabled() && Cache.isSupportedProtocol((URL)this.jarFileURL) && (string = (String)AppContext.getAppContext().get(Config.getAppContextKeyPrefix() + this.jarFileURL.toString())) != null) {
            this.jarFileURLOverride = new URL(URLUtil.canonicalize((String)(this.jarFileURL.toString() + "?" + URLEncoder.encode((String)"version-id", (String)"UTF-8") + "=" + URLEncoder.encode((String)string, (String)"UTF-8"))));
            String string2 = Cache.getCacheEntryVersion((URL)this.jarFileURL, null);
            if (string2 != null && !string2.equals(string)) {
                this.jarFileURLOverride = new URL(this.jarFileURLOverride.toString() + "&" + URLEncoder.encode((String)"current-version-id", (String)"UTF-8") + "=" + URLEncoder.encode((String)string2, (String)"UTF-8"));
            }
        }
        this.connect();
        this.jarFileURLOverride = null;
        return this.jarFile;
    }

    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    public String getHeaderField(String string) {
        String string2 = null;
        try {
            this.connect();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        List list = (List)this.headerFields.get(string);
        if (list != null) {
            string2 = (String)list.get(0);
        }
        return string2;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            URL uRL = new URL(this.jarFileURL.getProtocol(), this.jarFileURL.getHost(), this.jarFileURL.getPort(), this.jarFileURL.getPath());
            boolean bl = false;
            try {
                bl = DeployCacheHandler.resourceNotCached((String)uRL.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (Cache.isSupportedProtocol((URL)this.jarFileURL) && Cache.isCacheEnabled() && !bl) {
                String string = (String)AppContext.getAppContext().get(Config.getAppContextKeyPrefix() + uRL.toString());
                this.setUseCaches(false);
                if ("file".equalsIgnoreCase((string == null ? this.jarFileURL : uRL).getProtocol()) && !this.isLocalJREJar(string == null ? this.jarFileURL : uRL)) {
                    DownloadEngine.getResource((URL)(string == null ? this.jarFileURL : uRL), null, (String)string, null, (boolean)true);
                } else {
                    super.connect();
                }
                this.jarFile = DownloadEngine.getCachedJarFile((URL)(string == null ? this.jarFileURL : uRL), (String)string);
                this.headerFields = DownloadEngine.getCachedHeaders((URL)(string == null ? this.jarFileURL : uRL), null, (String)string, null, (boolean)false);
                Cache.addLoadedResource((URL)(string == null ? this.jarFileURL : uRL), null, (String)string);
                if (this.jarFile != null) {
                    this.useJarCache = true;
                } else {
                    super.connect();
                    this.jarFile = super.getJarFile();
                }
            } else {
                super.connect();
                this.jarFile = super.getJarFile();
            }
            if (this.entryName != null) {
                this.jarEntry = this.jarFile.getJarEntry(this.entryName);
                if (this.jarEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        if (!this.useJarCache) {
            return super.getInputStream();
        }
        InputStream inputStream = null;
        if (this.entryName == null) {
            throw new IOException("no entry name specified");
        }
        if (this.jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
        }
        inputStream = this.jarFile.getInputStream(this.jarEntry);
        return inputStream;
    }

    public Object getContent() throws IOException {
        Object object = null;
        this.connect();
        if (!this.useJarCache) {
            return super.getContent();
        }
        object = this.entryName == null ? this.getJarFile() : super.getContent();
        return object;
    }

    public String getContentType() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.useJarCache) {
            return super.getContentType();
        }
        if (this.contentType == null) {
            if (this.entryName == null) {
                this.contentType = "x-java/jar";
            } else {
                try {
                    this.connect();
                    InputStream inputStream = this.getJarFileInternal().getInputStream(this.jarEntry);
                    this.contentType = CachedJarURLConnection.guessContentTypeFromStream(new BufferedInputStream(inputStream));
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.contentType == null) {
                this.contentType = CachedJarURLConnection.guessContentTypeFromName(this.entryName);
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
        }
        return this.contentType;
    }

    public int getContentLength() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.useJarCache) {
            return super.getContentLength();
        }
        if (this.jarEntry != null) {
            return (int)this.jarEntry.getSize();
        }
        return -1;
    }

    private boolean isLocalJREJar(URL uRL) throws IOException {
        final String string = Config.getLongPathName((String)Config.getJREHome());
        String string2 = null;
        try {
            string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new File(string).toURI().toURL().getPath();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new IOException(privilegedActionException.getCause().getMessage());
        }
        return uRL.getPath().startsWith(string2);
    }
}

