/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.xml;

import hr.iii.fiskal.xml.EchoResponse;
import hr.iii.fiskal.xml.NacinPlacanjaResponse;
import hr.iii.fiskal.xml.NapojnicaResponse;
import hr.iii.fiskal.xml.PrateciDokumentResponse;
import hr.iii.fiskal.xml.ProstorResponse;
import hr.iii.fiskal.xml.ProvjeraResponse;
import hr.iii.fiskal.xml.RacunPDResponse;
import hr.iii.fiskal.xml.RacunResponse;
import hr.iii.fiskal.xml.Response;
import hr.iii.fiskal.xml.XmLRecordUnknowException;
import hr.iii.fiskal.xml.XmlRecord;
import hr.iii.fiskal.xml.XmlRecordException;
import hr.iii.fiskal.xml.XmlRecordIOException;
import hr.iii.fiskal.xml.XmlRecordParseException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResponseFactory {
    public Response createResponse(InputStream is) throws XmlRecordException, Exception {
        boolean bCheckSign = false;
        Response response = null;
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(false);
        try {
            doc = dbf.newDocumentBuilder().parse(is);
            NodeList nodeList = doc.getElementsByTagName("*");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                String nodeName = node.getNodeName();
                int sepPos = nodeName.indexOf(58);
                if (sepPos != 3) continue;
                doc.renameNode(node, "http://www.apis-it.hr/fin/2012/types/f73", "tns" + nodeName.substring(sepPos));
            }
        }
        catch (SAXException e) {
            throw new XmlRecordParseException(XmlRecordException.NEISPRAVAN_ODGOVOR, e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new XmlRecordIOException(XmlRecordException.NEUSPJELO_CITANJE_ODGOVORA, e.getMessage(), e.getCause());
        }
        catch (ParserConfigurationException e) {
            throw new XmlRecordParseException(XmlRecordException.NEISPRAVAN_ODGOVOR, e.getMessage(), e.getCause());
        }
        if (doc.getElementsByTagName("tns:RacunOdgovor").item(0) != null) {
            response = new RacunResponse();
            bCheckSign = true;
        } else if (doc.getElementsByTagName("tns:RacunPDOdgovor").item(0) != null) {
            response = new RacunPDResponse();
            bCheckSign = true;
        } else if (doc.getElementsByTagName("tns:PrateciDokumentiOdgovor").item(0) != null) {
            response = new PrateciDokumentResponse();
            bCheckSign = true;
        } else if (doc.getElementsByTagName("tns:ProvjeraOdgovor").item(0) != null) {
            response = new ProvjeraResponse();
            bCheckSign = true;
        } else if (doc.getElementsByTagName("tns:NapojnicaOdgovor").item(0) != null) {
            response = new NapojnicaResponse();
            bCheckSign = true;
        } else if (doc.getElementsByTagName("tns:PromijeniNacPlacOdgovor").item(0) != null) {
            response = new NacinPlacanjaResponse();
            bCheckSign = true;
        } else if (doc.getElementsByTagName("tns:EchoResponse").item(0) != null) {
            response = new EchoResponse();
            bCheckSign = false;
        } else if (doc.getElementsByTagName("tns:PoslovniProstorOdgovor").item(0) != null) {
            response = new ProstorResponse();
            bCheckSign = true;
        } else {
            XmlRecord xml = new XmlRecord(doc);
            String str = xml.getString();
            throw new XmLRecordUnknowException(XmlRecordException.NEISPRAVAN_ODGOVOR, "Primljen je nepoznati odgovor");
        }
        response.setDocument(doc);
        if (bCheckSign && !response.ValidateSign()) {
            throw new XmlRecordException(XmlRecordException.NEISPRAVAN_POTPIS_ODGOVORA, "Neispravan digitalni potpis odgovora");
        }
        return response;
    }
}

