/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.xml;

import hr.iii.fiskal.AppContext;
import hr.iii.fiskal.Statistics;
import hr.iii.fiskal.xml.EchoRequest;
import hr.iii.fiskal.xml.NacinPlacanjaRequest;
import hr.iii.fiskal.xml.NapojnicaRequest;
import hr.iii.fiskal.xml.PDF417CodeRequest;
import hr.iii.fiskal.xml.PrateciDokumentRequest;
import hr.iii.fiskal.xml.ProstorRequest;
import hr.iii.fiskal.xml.ProvjeraRequest;
import hr.iii.fiskal.xml.QRCodeRequest;
import hr.iii.fiskal.xml.RacunPDRequest;
import hr.iii.fiskal.xml.RacunRequest;
import hr.iii.fiskal.xml.Request;
import hr.iii.fiskal.xml.XmLRecordUnknowException;
import hr.iii.fiskal.xml.XmlRecordException;
import hr.iii.fiskal.xml.XmlRecordIOException;
import hr.iii.fiskal.xml.XmlRecordParseException;
import hr.iii.fiskal.xml.ZastKodPDRequest;
import hr.iii.fiskal.xml.ZastKodRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RequestFactory {
    private String RemoveProlog(String inputString) {
        int msgOff = inputString.indexOf("?>");
        if (msgOff > 0) {
            return inputString.substring(msgOff + 2);
        }
        return inputString;
    }

    private String RemoveSoapEnvelope(String inputString) {
        int soapOff = inputString.indexOf(":Body>");
        if (soapOff > 0) {
            String message = inputString.substring(soapOff + 6);
            if ((soapOff = message.indexOf(":Body>")) > 0) {
                while (soapOff > 0 && message.charAt(soapOff--) != '<') {
                }
                if (soapOff >= 0) {
                    return message.substring(0, soapOff);
                }
            }
            return message;
        }
        return inputString;
    }

    public Request createRequest(String inputString) throws XmlRecordParseException, XmlRecordIOException, XmLRecordUnknowException {
        String message = this.RemoveSoapEnvelope(this.RemoveProlog(inputString));
        Request request = null;
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(message.getBytes("UTF-8"));
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(is);
        }
        catch (SAXException e) {
            throw new XmlRecordParseException(XmlRecordException.NEISPRAVAN_ZAHTJEV, e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new XmlRecordIOException(XmlRecordException.NEUSPJELO_CITANJE_ZAHTJEVA, e.getMessage(), e.getCause());
        }
        catch (ParserConfigurationException e) {
            throw new XmlRecordParseException(XmlRecordException.NEISPRAVAN_ZAHTJEV, e.getMessage(), e.getCause());
        }
        Statistics stats = AppContext.getContext().getStatistics();
        if (doc.getElementsByTagName("tns:RacunZahtjev").item(0) != null) {
            request = new RacunRequest();
            stats.incRacunRequestCount();
        } else if (doc.getElementsByTagName("tns:RacunPDZahtjev").item(0) != null) {
            request = new RacunPDRequest();
            stats.incRacunRequestCount();
        } else if (doc.getElementsByTagName("tns:PrateciDokumentiZahtjev").item(0) != null) {
            request = new PrateciDokumentRequest();
            stats.incRacunRequestCount();
        } else if (doc.getElementsByTagName("tns:ProvjeraZahtjev").item(0) != null) {
            request = new ProvjeraRequest();
        } else if (doc.getElementsByTagName("tns:EchoRequest").item(0) != null) {
            request = new EchoRequest();
            stats.incEchoRequestCount();
        } else if (doc.getElementsByTagName("tns:NapojnicaZahtjev").item(0) != null) {
            request = new NapojnicaRequest();
            stats.incNapojnicaRequest();
        } else if (doc.getElementsByTagName("tns:PromijeniNacPlacZahtjev>").item(0) != null) {
            request = new NacinPlacanjaRequest();
            stats.incNacinPlacanjaRequest();
        } else if (doc.getElementsByTagName("tns:ProvjeraZahtjev").item(0) != null) {
            request = new ProstorRequest();
            stats.incProstorRequestCount();
        } else if (doc.getElementsByTagName("tns:ZastKodZahtjev").item(0) != null) {
            request = new ZastKodRequest();
            stats.incZastKodRequestCount();
        } else if (doc.getElementsByTagName("tns:ZastKodPDZahtjev").item(0) != null) {
            request = new ZastKodPDRequest();
            stats.incZastKodRequestCount();
        } else if (doc.getElementsByTagName("tns:QRCodeRequest").item(0) != null) {
            request = new QRCodeRequest();
            stats.incQRCodeRequestCount();
        } else if (doc.getElementsByTagName("tns:PDF417CodeRequest").item(0) != null) {
            request = new PDF417CodeRequest();
            stats.incQRCodeRequestCount();
        } else {
            stats.incUnknownRequestCount();
            throw new XmLRecordUnknowException(XmlRecordException.NEISPRAVAN_ZAHTJEV, "Nepoznati zahtjev");
        }
        request.setDocument(doc);
        return request;
    }
}

