/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.xml;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import hr.iii.fiskal.pdf417.PDF417Writer;
import hr.iii.fiskal.xml.PDF417CodeRequest;
import hr.iii.fiskal.xml.Request;
import hr.iii.fiskal.xml.Response;
import hr.iii.fiskal.xml.XmlRecord;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EnumMap;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PDF417CodeResponse
extends Response {
    public static final String TAG = "tns:PDF417CodeResponse";

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public XmlRecord createAnswer(Request request) {
        XmlRecord xml = this.createXml(request);
        Node nodeResponse = xml.getDocument().getElementsByTagName("Response").item(0);
        try {
            String base64 = PDF417CodeResponse.getPDF417Code(request);
            Element QRelement = xml.getDocument().createElement("PDF417Code");
            QRelement.setTextContent(base64);
            nodeResponse.appendChild(QRelement);
            FileOutputStream fileOuputStream = null;
            try {
                PDF417CodeRequest pdf417CodeRequest = (PDF417CodeRequest)request;
                fileOuputStream = new FileOutputStream("pdf417code." + pdf417CodeRequest.getBitMapType());
                fileOuputStream.write(Base64.decodeBase64(base64));
                fileOuputStream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            Element nodeSifraGreske = xml.getDocument().createElement("SifraGreske");
            nodeSifraGreske.setTextContent("I99");
            nodeResponse.appendChild(nodeSifraGreske);
            Element nodePorukaGreske = xml.getDocument().createElement("PorukaGreske");
            nodePorukaGreske.setTextContent(e.getMessage());
            nodeResponse.appendChild(nodePorukaGreske);
        }
        return xml;
    }

    public static String getPDF417Code(Request request) throws Exception {
        PDF417CodeRequest pdf417CodeRequest = (PDF417CodeRequest)request;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String barCodeString = pdf417CodeRequest.getText();
        EnumMap<EncodeHintType, Object> hints = null;
        hints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hints.put(EncodeHintType.MARGIN, Integer.valueOf(pdf417CodeRequest.getMargin()));
        hints.put(EncodeHintType.ERROR_CORRECTION, Integer.valueOf(pdf417CodeRequest.getErrorcorrectionlevel()));
        hints.put(EncodeHintType.PDF417_COMPACTION, (Object)pdf417CodeRequest.getCompactionMode());
        PDF417Writer writer = new PDF417Writer();
        writer.setAspectRatio(pdf417CodeRequest.getAspectratio());
        try {
            BitMatrix bitMatrix = writer.encode(barCodeString, BarcodeFormat.PDF_417, pdf417CodeRequest.getWidth(), pdf417CodeRequest.getHeight(), hints);
            MatrixToImageWriter.writeToStream(bitMatrix, pdf417CodeRequest.getBitMapType(), out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String(Base64.encodeBase64(out.toByteArray()));
    }
}

