/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.xml;

import hr.iii.fiskal.pdf417.encoder.Compaction;
import hr.iii.fiskal.xml.Request;
import hr.iii.fiskal.xml.XmlRecordSignException;
import org.w3c.dom.Node;

public class PDF417CodeRequest
extends Request {
    public static final String TAG = "tns:PDF417CodeRequest";
    private String text = "";
    private int width = 1;
    private int height = 1;
    private int errorcorrectionlevel = 4;
    private int margin = 30;
    private int aspectratio = 6;
    private String bitMapType = "gif";
    private Compaction compactionMode = Compaction.BYTE;

    @Override
    public void prepareRequest() throws XmlRecordSignException {
        try {
            Node node = this.getDocument().getElementsByTagName("tns:Text").item(0);
            if (null != node) {
                this.text = node.getTextContent();
            }
            if (null != (node = this.getDocument().getElementsByTagName("tns:Width").item(0))) {
                this.width = Integer.parseInt(node.getTextContent());
            }
            if (null != (node = this.getDocument().getElementsByTagName("tns:Height").item(0))) {
                this.height = Integer.parseInt(node.getTextContent());
            }
            if (null != (node = this.getDocument().getElementsByTagName("tns:BitmapType").item(0))) {
                this.bitMapType = node.getTextContent();
            }
            if (null != (node = this.getDocument().getElementsByTagName("tns:ErrorCorrectionLevel").item(0))) {
                this.errorcorrectionlevel = Integer.parseInt(node.getTextContent());
            }
            if (null != (node = this.getDocument().getElementsByTagName("tns:AspectRatio").item(0))) {
                this.aspectratio = Integer.parseInt(node.getTextContent());
            }
            if (null != (node = this.getDocument().getElementsByTagName("tns:Compaction").item(0))) {
                String str = node.getTextContent();
                this.compactionMode = str.equalsIgnoreCase("TEXT") ? Compaction.TEXT : (str.equalsIgnoreCase("BYTE") ? Compaction.BYTE : (str.equalsIgnoreCase("NUMERIC") ? Compaction.NUMERIC : Compaction.AUTO));
            }
            if (null != (node = this.getDocument().getElementsByTagName("tns:Margin").item(0))) {
                this.aspectratio = Integer.parseInt(node.getTextContent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        String string = this.getTag() + ": ";
        try {
            String text = this.getDocument().getElementsByTagName("tns:Text").item(0).getTextContent();
            string = string + text;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public String getTag() {
        return TAG;
    }

    public String getText() {
        return this.text;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getBitMapType() {
        return this.bitMapType;
    }

    public int getErrorcorrectionlevel() {
        return this.errorcorrectionlevel;
    }

    public int getAspectratio() {
        return this.aspectratio;
    }

    public int getMargin() {
        return this.margin;
    }

    public Compaction getCompactionMode() {
        return this.compactionMode;
    }
}

