/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import sun.misc.CharacterEncoder;
import sun.misc.HexDumpEncoder;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.util.CRLReason;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.Extension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCSPResponse {
    private static ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean dump;
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID;
    private static final ObjectIdentifier OCSP_NONCE_EXTENSION_OID;
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private static final long MAX_CLOCK_SKEW = 900000L;
    private List<X509CertImpl> certs;
    private X509CertImpl signerCert = null;
    private X500Principal responderName = null;
    private KeyIdentifier responderKeyId = null;

    OCSPResponse(byte[] byArray, Date date, List<X509Certificate> list) throws IOException, CertPathValidatorException {
        Object object;
        Object object2;
        X509CertImpl[] x509CertImplArray;
        DerValue[] derValueArray;
        int n;
        Object object3;
        if (dump) {
            object3 = new HexDumpEncoder();
            debug.println("\nOCSPResponse bytes...");
            debug.println(((CharacterEncoder)object3).encode(byArray) + "\n");
        }
        object3 = new DerValue(byArray);
        if (((DerValue)object3).tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream = ((DerValue)object3).getData();
        int n2 = derInputStream.getEnumerated();
        if (n2 < 0 || n2 >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + n2);
        }
        this.responseStatus = rsvalues[n2];
        if (debug != null) {
            debug.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            this.certs = new ArrayList<X509CertImpl>();
            return;
        }
        object3 = derInputStream.getDerValue();
        if (!((DerValue)object3).isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue derValue = ((DerValue)object3).data.getDerValue();
        if (derValue.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derInputStream = derValue.data;
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (objectIdentifier.equals((Object)OCSP_BASIC_RESPONSE_OID)) {
            if (debug != null) {
                debug.println("OCSP response type: basic");
            }
        } else {
            if (debug != null) {
                debug.println("OCSP response type: " + objectIdentifier);
            }
            throw new IOException("Unsupported OCSP response type: " + objectIdentifier);
        }
        DerInputStream derInputStream2 = new DerInputStream(derInputStream.getOctetString());
        DerValue[] derValueArray2 = derInputStream2.getSequence(2);
        if (derValueArray2.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue derValue2 = derValueArray2[0];
        byte[] byArray2 = derValueArray2[0].toByteArray();
        if (derValue2.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream3 = derValue2.data;
        DerValue derValue3 = derInputStream3.getDerValue();
        if (derValue3.isContextSpecific((byte)0) && derValue3.isConstructed() && derValue3.isContextSpecific()) {
            derValue3 = derValue3.data.getDerValue();
            n = derValue3.getInteger();
            if (derValue3.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            derValue3 = derInputStream3.getDerValue();
        }
        if ((n = (int)((byte)(derValue3.tag & 0x1F))) == 1) {
            this.responderName = new X500Principal(derValue3.getData().toByteArray());
            if (debug != null) {
                debug.println("Responder's name: " + this.responderName);
            }
        } else if (n == 2) {
            this.responderKeyId = new KeyIdentifier(derValue3.getData().getOctetString());
            if (debug != null) {
                debug.println("Responder's key ID: " + Debug.toString(this.responderKeyId.getIdentifier()));
            }
        } else {
            throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 1 or 2");
        }
        derValue3 = derInputStream3.getDerValue();
        if (debug != null) {
            derValueArray = derValue3.getGeneralizedTime();
            debug.println("OCSP response produced at: " + derValueArray);
        }
        derValueArray = derInputStream3.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(derValueArray.length);
        if (debug != null) {
            debug.println("OCSP number of SingleResponses: " + derValueArray.length);
        }
        for (int i = 0; i < derValueArray.length; ++i) {
            SingleResponse singleResponse = new SingleResponse(derValueArray[i], date);
            this.singleResponseMap.put(singleResponse.getCertId(), singleResponse);
        }
        if (derInputStream3.available() > 0 && (derValue3 = derInputStream3.getDerValue()).isContextSpecific((byte)1)) {
            DerValue[] derValueArray3 = derValue3.data.getSequence(3);
            for (int i = 0; i < derValueArray3.length; ++i) {
                x509CertImplArray = new Extension(derValueArray3[i]);
                if (debug != null) {
                    debug.println("OCSP extension: " + x509CertImplArray);
                }
                if (x509CertImplArray.getExtensionId().equals((Object)OCSP_NONCE_EXTENSION_OID) || !x509CertImplArray.isCritical()) continue;
                throw new IOException("Unsupported OCSP criticial extension: " + x509CertImplArray.getExtensionId());
            }
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray2[1]);
        byte[] byArray3 = derValueArray2[2].getBitString();
        x509CertImplArray = null;
        if (derValueArray2.length > 3) {
            object2 = derValueArray2[3];
            if (!((DerValue)object2).isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            object = ((DerValue)object2).getData().getSequence(3);
            x509CertImplArray = new X509CertImpl[((DerValue[])object).length];
            try {
                for (int i = 0; i < ((DerValue[])object).length; ++i) {
                    x509CertImplArray[i] = new X509CertImpl(((DerValue)object[i]).toByteArray());
                    if (debug == null) continue;
                    debug.println("OCSP response cert #" + (i + 1) + ": " + x509CertImplArray[i].getSubjectX500Principal());
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException("Bad encoding in X509 Certificate", certificateException);
            }
        }
        object2 = list.get(0);
        if (x509CertImplArray != null && x509CertImplArray[0] != null) {
            object = x509CertImplArray[0];
            if (debug != null) {
                debug.println("Signer certificate name: " + ((X509CertImpl)object).getSubjectX500Principal());
                byte[] byArray4 = ((X509CertImpl)object).getSubjectKeyIdentifier();
                if (byArray4 != null) {
                    debug.println("Signer certificate key ID: " + String.format("0x%0" + byArray4.length * 2 + "x", new BigInteger(1, byArray4)));
                }
            }
            byte[] byArray5 = null;
            for (X509Certificate x509Certificate : list) {
                List<String> list2;
                if (((Certificate)object).equals(x509Certificate)) {
                    object2 = x509Certificate;
                    if (debug == null) break;
                    debug.println("Signer certificate is a trusted responder");
                    break;
                }
                if (!((X509CertImpl)object).getIssuerX500Principal().equals(x509Certificate.getSubjectX500Principal())) continue;
                if (byArray5 == null && (byArray5 = ((X509CertImpl)object).getIssuerKeyIdentifier()) == null && debug != null) {
                    debug.println("No issuer key identifier (AKID) in the signer certificate");
                }
                byte[] byArray6 = null;
                if (byArray5 != null && (byArray6 = OCSPChecker.getKeyId(x509Certificate)) != null) {
                    if (!Arrays.equals(byArray5, byArray6)) continue;
                    if (debug != null) {
                        debug.println("Issuer certificate key ID: " + String.format("0x%0" + byArray5.length * 2 + "x", new BigInteger(1, byArray5)));
                    }
                }
                try {
                    list2 = ((X509CertImpl)object).getExtendedKeyUsage();
                    if (list2 == null) continue;
                    if (!list2.contains(KP_OCSP_SIGNING_OID)) {
                    }
                }
                catch (CertificateParsingException certificateParsingException) {}
                continue;
                list2 = new AlgorithmChecker(new TrustAnchor(x509Certificate, null));
                ((AlgorithmChecker)((Object)list2)).init(false);
                ((AlgorithmChecker)((Object)list2)).check((Certificate)object, Collections.<String>emptySet());
                try {
                    if (date == null) {
                        ((X509CertImpl)object).checkValidity();
                    } else {
                        ((X509CertImpl)object).checkValidity(date);
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                    if (debug == null) continue;
                    debug.println("Responder's certificate not within the validity period " + generalSecurityException);
                    continue;
                }
                Extension extension = ((X509CertImpl)object).getExtension(PKIXExtensions.OCSPNoCheck_Id);
                if (extension != null && debug != null) {
                    debug.println("Responder's certificate includes the extension id-pkix-ocsp-nocheck.");
                }
                try {
                    ((X509CertImpl)object).verify(x509Certificate.getPublicKey());
                    object2 = object;
                    if (debug == null) break;
                    debug.println("Signer certificate was issued by a trusted responder");
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object2 = null;
                }
            }
        }
        if (object2 != null) {
            AlgorithmChecker.check(((Certificate)object2).getPublicKey(), algorithmId);
            if (!this.verifyResponse(byArray2, (X509Certificate)object2, algorithmId, byArray3)) {
                throw new CertPathValidatorException("Error verifying OCSP Responder's signature");
            }
        } else {
            throw new CertPathValidatorException("Responder's certificate is not trusted for signing OCSP responses");
        }
    }

    ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifyResponse(byte[] byArray, X509Certificate x509Certificate, AlgorithmId algorithmId, byte[] byArray2) throws CertPathValidatorException {
        try {
            Signature signature = Signature.getInstance(algorithmId.getName());
            signature.initVerify(x509Certificate.getPublicKey());
            signature.update(byArray);
            if (signature.verify(byArray2)) {
                if (debug != null) {
                    debug.println("Verified signature of OCSP Responder");
                }
                return true;
            }
            if (debug != null) {
                debug.println("Error verifying signature of OCSP Responder");
            }
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertPathValidatorException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertPathValidatorException(noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new CertPathValidatorException(signatureException);
        }
    }

    SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    /*
     * Unable to fully structure code
     */
    static {
        if (OCSPResponse.debug == null) ** GOTO lbl-1000
        if (Debug.isOn("ocsp")) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        OCSPResponse.dump = v0;
        OCSPResponse.OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
        OCSPResponse.OCSP_NONCE_EXTENSION_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }

    static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private static CRLReason[] values = CRLReason.values();
        private final CRLReason revocationReason;

        private SingleResponse(DerValue derValue, Date date) throws CertPathValidatorException, IOException {
            if (derValue.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream derInputStream = derValue.data;
            this.certId = new CertId(derInputStream.getDerValue().data);
            DerValue derValue2 = derInputStream.getDerValue();
            short s = (byte)(derValue2.tag & 0x1F);
            if (s == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derValue2.data.getGeneralizedTime();
                if (derValue2.data.available() != 0) {
                    int n;
                    DerValue derValue3 = derValue2.data.getDerValue();
                    s = (byte)(derValue3.tag & 0x1F);
                    this.revocationReason = s == 0 ? ((n = derValue3.data.getEnumerated()) >= 0 && n < values.length ? values[n] : CRLReason.UNSPECIFIED) : CRLReason.UNSPECIFIED;
                } else {
                    this.revocationReason = CRLReason.UNSPECIFIED;
                }
                if (debug != null) {
                    debug.println("Revocation time: " + this.revocationTime);
                    debug.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = CRLReason.UNSPECIFIED;
                if (s == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (s == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = derInputStream.getGeneralizedTime();
            if (derInputStream.available() == 0) {
                this.nextUpdate = null;
            } else {
                derValue2 = derInputStream.getDerValue();
                s = (byte)(derValue2.tag & 0x1F);
                this.nextUpdate = s == 0 ? derValue2.data.getGeneralizedTime() : null;
            }
            long l = System.currentTimeMillis();
            Date date2 = new Date(l + 900000L);
            Date date3 = new Date(l - 900000L);
            if (debug != null) {
                String string = "";
                if (this.nextUpdate != null) {
                    string = " until " + this.nextUpdate;
                }
                debug.println("OCSP response validity interval is from " + this.thisUpdate + string);
                debug.println("Checking validity of OCSP response on: " + new Date(l));
            }
            if (date2.before(this.thisUpdate) || date3.after(this.nextUpdate != null ? this.nextUpdate : this.thisUpdate)) {
                throw new IOException("Response is unreliable: its validity interval is out-of-date");
            }
        }

        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        private CertId getCertId() {
            return this.certId;
        }

        public Date getRevocationTime() {
            return (Date)this.revocationTime.clone();
        }

        public CRLReason getRevocationReason() {
            return this.revocationReason;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SingleResponse:  \n");
            stringBuilder.append(this.certId);
            stringBuilder.append("\nCertStatus: " + (Object)((Object)this.certStatus) + "\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                stringBuilder.append("revocationTime is " + this.revocationTime + "\n");
                stringBuilder.append("revocationReason is " + (Object)((Object)this.revocationReason) + "\n");
            }
            stringBuilder.append("thisUpdate is " + this.thisUpdate + "\n");
            if (this.nextUpdate != null) {
                stringBuilder.append("nextUpdate is " + this.nextUpdate + "\n");
            }
            return stringBuilder.toString();
        }
    }

    public static class UnreliableException
    extends CertificateException {
        UnreliableException() {
            super("OCSP Response is unreliable: its validity interval is out-of-date");
        }
    }
}

