/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import sun.security.action.GetBooleanAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyGenerator {
    private static final int CLASSFILE_MAJOR_VERSION = 49;
    private static final int CLASSFILE_MINOR_VERSION = 0;
    private static final int CONSTANT_UTF8 = 1;
    private static final int CONSTANT_UNICODE = 2;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_FIELD = 9;
    private static final int CONSTANT_METHOD = 10;
    private static final int CONSTANT_INTERFACEMETHOD = 11;
    private static final int CONSTANT_NAMEANDTYPE = 12;
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SUPER = 32;
    private static final int opc_aconst_null = 1;
    private static final int opc_iconst_0 = 3;
    private static final int opc_bipush = 16;
    private static final int opc_sipush = 17;
    private static final int opc_ldc = 18;
    private static final int opc_ldc_w = 19;
    private static final int opc_iload = 21;
    private static final int opc_lload = 22;
    private static final int opc_fload = 23;
    private static final int opc_dload = 24;
    private static final int opc_aload = 25;
    private static final int opc_iload_0 = 26;
    private static final int opc_lload_0 = 30;
    private static final int opc_fload_0 = 34;
    private static final int opc_dload_0 = 38;
    private static final int opc_aload_0 = 42;
    private static final int opc_astore = 58;
    private static final int opc_astore_0 = 75;
    private static final int opc_aastore = 83;
    private static final int opc_pop = 87;
    private static final int opc_dup = 89;
    private static final int opc_ireturn = 172;
    private static final int opc_lreturn = 173;
    private static final int opc_freturn = 174;
    private static final int opc_dreturn = 175;
    private static final int opc_areturn = 176;
    private static final int opc_return = 177;
    private static final int opc_getstatic = 178;
    private static final int opc_putstatic = 179;
    private static final int opc_getfield = 180;
    private static final int opc_invokevirtual = 182;
    private static final int opc_invokespecial = 183;
    private static final int opc_invokestatic = 184;
    private static final int opc_invokeinterface = 185;
    private static final int opc_new = 187;
    private static final int opc_anewarray = 189;
    private static final int opc_athrow = 191;
    private static final int opc_checkcast = 192;
    private static final int opc_wide = 196;
    private static final String superclassName = "java/lang/reflect/Proxy";
    private static final String handlerFieldName = "h";
    private static final boolean saveGeneratedFiles = AccessController.doPrivileged(new GetBooleanAction("sun.misc.ProxyGenerator.saveGeneratedFiles"));
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    private String className;
    private Class[] interfaces;
    private ConstantPool cp = new ConstantPool();
    private List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private List<MethodInfo> methods = new ArrayList<MethodInfo>();
    private Map<String, List<ProxyMethod>> proxyMethods = new HashMap<String, List<ProxyMethod>>();
    private int proxyMethodCount = 0;

    public static byte[] generateProxyClass(final String string, Class[] classArray) {
        ProxyGenerator proxyGenerator = new ProxyGenerator(string, classArray);
        final byte[] byArray = proxyGenerator.generateClassFile();
        if (saveGeneratedFiles) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Object object;
                        String string3 = string;
                        int n = string.lastIndexOf(46);
                        if (n > 0) {
                            string3 = string.substring(0, n);
                            object = new File(ProxyGenerator.dotToSlash(string3));
                            ((File)object).mkdirs();
                            String string2 = string.substring(n + 1, string.length());
                            string3 = new File((File)object, string2).toString();
                        }
                        object = new FileOutputStream(string3 + ".class");
                        ((FileOutputStream)object).write(byArray);
                        ((FileOutputStream)object).close();
                        return null;
                    }
                    catch (IOException iOException) {
                        throw new InternalError("I/O exception saving generated file: " + iOException);
                    }
                }
            });
        }
        return byArray;
    }

    private ProxyGenerator(String string, Class[] classArray) {
        this.className = string;
        this.interfaces = classArray;
    }

    private byte[] generateClassFile() {
        this.addProxyMethod(hashCodeMethod, Object.class);
        this.addProxyMethod(equalsMethod, Object.class);
        this.addProxyMethod(toStringMethod, Object.class);
        for (int i = 0; i < this.interfaces.length; ++i) {
            Method[] object2 = this.interfaces[i].getMethods();
            for (int iOException = 0; iOException < object2.length; ++iOException) {
                this.addProxyMethod(object2[iOException], this.interfaces[i]);
            }
        }
        for (List<ProxyMethod> list : this.proxyMethods.values()) {
            ProxyGenerator.checkReturnTypes(list);
        }
        try {
            this.methods.add(this.generateConstructor());
            for (List<ProxyMethod> list : this.proxyMethods.values()) {
                for (ProxyMethod proxyMethod : list) {
                    this.fields.add(new FieldInfo(proxyMethod.methodFieldName, "Ljava/lang/reflect/Method;", 10));
                    this.methods.add(proxyMethod.generateMethod());
                }
            }
            this.methods.add(this.generateStaticInitializer());
        }
        catch (IOException iOException) {
            throw new InternalError("unexpected I/O Exception");
        }
        if (this.methods.size() > 65535) {
            throw new IllegalArgumentException("method limit exceeded");
        }
        if (this.fields.size() > 65535) {
            throw new IllegalArgumentException("field limit exceeded");
        }
        this.cp.getClass(ProxyGenerator.dotToSlash(this.className));
        this.cp.getClass(superclassName);
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.cp.getClass(ProxyGenerator.dotToSlash(this.interfaces[i].getName()));
        }
        this.cp.setReadOnly();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(-889275714);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(49);
            this.cp.write(dataOutputStream);
            dataOutputStream.writeShort(49);
            dataOutputStream.writeShort(this.cp.getClass(ProxyGenerator.dotToSlash(this.className)));
            dataOutputStream.writeShort(this.cp.getClass(superclassName));
            dataOutputStream.writeShort(this.interfaces.length);
            for (int i = 0; i < this.interfaces.length; ++i) {
                dataOutputStream.writeShort(this.cp.getClass(ProxyGenerator.dotToSlash(this.interfaces[i].getName())));
            }
            dataOutputStream.writeShort(this.fields.size());
            for (FieldInfo fieldInfo : this.fields) {
                fieldInfo.write(dataOutputStream);
            }
            dataOutputStream.writeShort(this.methods.size());
            for (MethodInfo methodInfo : this.methods) {
                methodInfo.write(dataOutputStream);
            }
            dataOutputStream.writeShort(0);
        }
        catch (IOException iOException) {
            throw new InternalError("unexpected I/O Exception");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void addProxyMethod(Method method, Class clazz) {
        String string = method.getName();
        Class[] classArray = method.getParameterTypes();
        Class<?> clazz2 = method.getReturnType();
        Class[] classArray2 = method.getExceptionTypes();
        String string2 = string + ProxyGenerator.getParameterDescriptors(classArray);
        List<ProxyMethod> list = this.proxyMethods.get(string2);
        if (list != null) {
            for (ProxyMethod proxyMethod : list) {
                if (clazz2 != proxyMethod.returnType) continue;
                ArrayList<Class> arrayList = new ArrayList<Class>();
                ProxyGenerator.collectCompatibleTypes(classArray2, proxyMethod.exceptionTypes, arrayList);
                ProxyGenerator.collectCompatibleTypes(proxyMethod.exceptionTypes, classArray2, arrayList);
                proxyMethod.exceptionTypes = new Class[arrayList.size()];
                proxyMethod.exceptionTypes = arrayList.toArray(proxyMethod.exceptionTypes);
                return;
            }
        } else {
            list = new ArrayList<ProxyMethod>(3);
            this.proxyMethods.put(string2, list);
        }
        list.add(new ProxyMethod(string, classArray, clazz2, classArray2, clazz));
    }

    private static void checkReturnTypes(List<ProxyMethod> list) {
        if (list.size() < 2) {
            return;
        }
        LinkedList<Class> linkedList = new LinkedList<Class>();
        block0: for (ProxyMethod proxyMethod : list) {
            Class clazz = proxyMethod.returnType;
            if (clazz.isPrimitive()) {
                throw new IllegalArgumentException("methods with same signature " + ProxyGenerator.getFriendlyMethodSignature(proxyMethod.methodName, proxyMethod.parameterTypes) + " but incompatible return types: " + clazz.getName() + " and others");
            }
            boolean bl = false;
            ListIterator<Class> listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                Class clazz2 = (Class)listIterator.next();
                if (clazz.isAssignableFrom(clazz2)) {
                    assert (!bl);
                    continue block0;
                }
                if (!clazz2.isAssignableFrom(clazz)) continue;
                if (!bl) {
                    listIterator.set(clazz);
                    bl = true;
                    continue;
                }
                listIterator.remove();
            }
            if (bl) continue;
            linkedList.add(clazz);
        }
        if (linkedList.size() > 1) {
            ProxyMethod proxyMethod = list.get(0);
            throw new IllegalArgumentException("methods with same signature " + ProxyGenerator.getFriendlyMethodSignature(proxyMethod.methodName, proxyMethod.parameterTypes) + " but incompatible return types: " + linkedList);
        }
    }

    private MethodInfo generateConstructor() throws IOException {
        MethodInfo methodInfo = new MethodInfo("<init>", "(Ljava/lang/reflect/InvocationHandler;)V", 1);
        DataOutputStream dataOutputStream = new DataOutputStream(methodInfo.code);
        this.code_aload(0, dataOutputStream);
        this.code_aload(1, dataOutputStream);
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(this.cp.getMethodRef(superclassName, "<init>", "(Ljava/lang/reflect/InvocationHandler;)V"));
        dataOutputStream.writeByte(177);
        methodInfo.maxStack = (short)10;
        methodInfo.maxLocals = (short)2;
        methodInfo.declaredExceptions = new short[0];
        return methodInfo;
    }

    private MethodInfo generateStaticInitializer() throws IOException {
        short s;
        MethodInfo methodInfo = new MethodInfo("<clinit>", "()V", 8);
        int n = 1;
        short s2 = 0;
        DataOutputStream dataOutputStream = new DataOutputStream(methodInfo.code);
        for (List<ProxyMethod> list : this.proxyMethods.values()) {
            for (ProxyMethod proxyMethod : list) {
                proxyMethod.codeFieldInitialization(dataOutputStream);
            }
        }
        dataOutputStream.writeByte(177);
        short s3 = s = (short)methodInfo.code.size();
        methodInfo.exceptionTable.add(new ExceptionTableEntry(s2, s3, s, this.cp.getClass("java/lang/NoSuchMethodException")));
        this.code_astore(n, dataOutputStream);
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(this.cp.getClass("java/lang/NoSuchMethodError"));
        dataOutputStream.writeByte(89);
        this.code_aload(n, dataOutputStream);
        dataOutputStream.writeByte(182);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/Throwable", "getMessage", "()Ljava/lang/String;"));
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/NoSuchMethodError", "<init>", "(Ljava/lang/String;)V"));
        dataOutputStream.writeByte(191);
        s = (short)methodInfo.code.size();
        methodInfo.exceptionTable.add(new ExceptionTableEntry(s2, s3, s, this.cp.getClass("java/lang/ClassNotFoundException")));
        this.code_astore(n, dataOutputStream);
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(this.cp.getClass("java/lang/NoClassDefFoundError"));
        dataOutputStream.writeByte(89);
        this.code_aload(n, dataOutputStream);
        dataOutputStream.writeByte(182);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/Throwable", "getMessage", "()Ljava/lang/String;"));
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V"));
        dataOutputStream.writeByte(191);
        if (methodInfo.code.size() > 65535) {
            throw new IllegalArgumentException("code size limit exceeded");
        }
        methodInfo.maxStack = (short)10;
        methodInfo.maxLocals = (short)(n + 1);
        methodInfo.declaredExceptions = new short[0];
        return methodInfo;
    }

    private void code_iload(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 21, 26, dataOutputStream);
    }

    private void code_lload(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 22, 30, dataOutputStream);
    }

    private void code_fload(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 23, 34, dataOutputStream);
    }

    private void code_dload(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 24, 38, dataOutputStream);
    }

    private void code_aload(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 25, 42, dataOutputStream);
    }

    private void code_astore(int n, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n, 58, 75, dataOutputStream);
    }

    private void codeLocalLoadStore(int n, int n2, int n3, DataOutputStream dataOutputStream) throws IOException {
        assert (n >= 0 && n <= 65535);
        if (n <= 3) {
            dataOutputStream.writeByte(n3 + n);
        } else if (n <= 255) {
            dataOutputStream.writeByte(n2);
            dataOutputStream.writeByte(n & 0xFF);
        } else {
            dataOutputStream.writeByte(196);
            dataOutputStream.writeByte(n2);
            dataOutputStream.writeShort(n & 0xFFFF);
        }
    }

    private void code_ldc(int n, DataOutputStream dataOutputStream) throws IOException {
        assert (n >= 0 && n <= 65535);
        if (n <= 255) {
            dataOutputStream.writeByte(18);
            dataOutputStream.writeByte(n & 0xFF);
        } else {
            dataOutputStream.writeByte(19);
            dataOutputStream.writeShort(n & 0xFFFF);
        }
    }

    private void code_ipush(int n, DataOutputStream dataOutputStream) throws IOException {
        if (n >= -1 && n <= 5) {
            dataOutputStream.writeByte(3 + n);
        } else if (n >= -128 && n <= 127) {
            dataOutputStream.writeByte(16);
            dataOutputStream.writeByte(n & 0xFF);
        } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            dataOutputStream.writeByte(17);
            dataOutputStream.writeShort(n & 0xFFFF);
        } else {
            throw new AssertionError();
        }
    }

    private void codeClassForName(Class clazz, DataOutputStream dataOutputStream) throws IOException {
        this.code_ldc(this.cp.getString(clazz.getName()), dataOutputStream);
        dataOutputStream.writeByte(184);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"));
    }

    private static String dotToSlash(String string) {
        return string.replace('.', '/');
    }

    private static String getMethodDescriptor(Class[] classArray, Class clazz) {
        return ProxyGenerator.getParameterDescriptors(classArray) + (clazz == Void.TYPE ? "V" : ProxyGenerator.getFieldType(clazz));
    }

    private static String getParameterDescriptors(Class[] classArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(ProxyGenerator.getFieldType(classArray[i]));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static String getFieldType(Class clazz) {
        if (clazz.isPrimitive()) {
            return PrimitiveTypeInfo.get((Class)clazz).baseTypeString;
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + ProxyGenerator.dotToSlash(clazz.getName()) + ";";
    }

    private static String getFriendlyMethodSignature(String string, Class[] classArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            Class<?> clazz = classArray[i];
            int n = 0;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
                ++n;
            }
            stringBuilder.append(clazz.getName());
            while (n-- > 0) {
                stringBuilder.append("[]");
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static int getWordsPerType(Class clazz) {
        if (clazz == Long.TYPE || clazz == Double.TYPE) {
            return 2;
        }
        return 1;
    }

    private static void collectCompatibleTypes(Class[] classArray, Class[] classArray2, List<Class> list) {
        block0: for (int i = 0; i < classArray.length; ++i) {
            if (list.contains(classArray[i])) continue;
            for (int j = 0; j < classArray2.length; ++j) {
                if (!classArray2[j].isAssignableFrom(classArray[i])) continue;
                list.add(classArray[i]);
                continue block0;
            }
        }
    }

    private static List<Class> computeUniqueCatchList(Class[] classArray) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        arrayList.add(Error.class);
        arrayList.add(RuntimeException.class);
        block0: for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            if (clazz.isAssignableFrom(Throwable.class)) {
                arrayList.clear();
                break;
            }
            if (!Throwable.class.isAssignableFrom(clazz)) continue;
            int n = 0;
            while (n < arrayList.size()) {
                Class clazz2 = (Class)arrayList.get(n);
                if (clazz2.isAssignableFrom(clazz)) continue block0;
                if (clazz.isAssignableFrom(clazz2)) {
                    arrayList.remove(n);
                    continue;
                }
                ++n;
            }
            arrayList.add(clazz);
        }
        return arrayList;
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    private static class ConstantPool {
        private List<Entry> pool = new ArrayList<Entry>(32);
        private Map<Object, Short> map = new HashMap<Object, Short>(16);
        private boolean readOnly = false;

        private ConstantPool() {
        }

        public short getUtf8(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return this.getValue(string);
        }

        public short getInteger(int n) {
            return this.getValue(new Integer(n));
        }

        public short getFloat(float f) {
            return this.getValue(new Float(f));
        }

        public short getClass(String string) {
            short s = this.getUtf8(string);
            return this.getIndirect(new IndirectEntry(7, s));
        }

        public short getString(String string) {
            short s = this.getUtf8(string);
            return this.getIndirect(new IndirectEntry(8, s));
        }

        public short getFieldRef(String string, String string2, String string3) {
            short s = this.getClass(string);
            short s2 = this.getNameAndType(string2, string3);
            return this.getIndirect(new IndirectEntry(9, s, s2));
        }

        public short getMethodRef(String string, String string2, String string3) {
            short s = this.getClass(string);
            short s2 = this.getNameAndType(string2, string3);
            return this.getIndirect(new IndirectEntry(10, s, s2));
        }

        public short getInterfaceMethodRef(String string, String string2, String string3) {
            short s = this.getClass(string);
            short s2 = this.getNameAndType(string2, string3);
            return this.getIndirect(new IndirectEntry(11, s, s2));
        }

        public short getNameAndType(String string, String string2) {
            short s = this.getUtf8(string);
            short s2 = this.getUtf8(string2);
            return this.getIndirect(new IndirectEntry(12, s, s2));
        }

        public void setReadOnly() {
            this.readOnly = true;
        }

        public void write(OutputStream outputStream) throws IOException {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeShort(this.pool.size() + 1);
            for (Entry entry : this.pool) {
                entry.write(dataOutputStream);
            }
        }

        private short addEntry(Entry entry) {
            this.pool.add(entry);
            if (this.pool.size() >= 65535) {
                throw new IllegalArgumentException("constant pool size limit exceeded");
            }
            return (short)this.pool.size();
        }

        private short getValue(Object object) {
            Short s = this.map.get(object);
            if (s != null) {
                return s;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition: " + object);
            }
            short s2 = this.addEntry(new ValueEntry(object));
            this.map.put(object, new Short(s2));
            return s2;
        }

        private short getIndirect(IndirectEntry indirectEntry) {
            Short s = this.map.get(indirectEntry);
            if (s != null) {
                return s;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition");
            }
            short s2 = this.addEntry(indirectEntry);
            this.map.put(indirectEntry, new Short(s2));
            return s2;
        }

        private static abstract class Entry {
            private Entry() {
            }

            public abstract void write(DataOutputStream var1) throws IOException;
        }

        private static class IndirectEntry
        extends Entry {
            private int tag;
            private short index0;
            private short index1;

            public IndirectEntry(int n, short s) {
                this.tag = n;
                this.index0 = s;
                this.index1 = 0;
            }

            public IndirectEntry(int n, short s, short s2) {
                this.tag = n;
                this.index0 = s;
                this.index1 = s2;
            }

            public void write(DataOutputStream dataOutputStream) throws IOException {
                dataOutputStream.writeByte(this.tag);
                dataOutputStream.writeShort(this.index0);
                if (this.tag == 9 || this.tag == 10 || this.tag == 11 || this.tag == 12) {
                    dataOutputStream.writeShort(this.index1);
                }
            }

            public int hashCode() {
                return this.tag + this.index0 + this.index1;
            }

            public boolean equals(Object object) {
                if (object instanceof IndirectEntry) {
                    IndirectEntry indirectEntry = (IndirectEntry)object;
                    if (this.tag == indirectEntry.tag && this.index0 == indirectEntry.index0 && this.index1 == indirectEntry.index1) {
                        return true;
                    }
                }
                return false;
            }
        }

        private static class ValueEntry
        extends Entry {
            private Object value;

            public ValueEntry(Object object) {
                this.value = object;
            }

            public void write(DataOutputStream dataOutputStream) throws IOException {
                if (this.value instanceof String) {
                    dataOutputStream.writeByte(1);
                    dataOutputStream.writeUTF((String)this.value);
                } else if (this.value instanceof Integer) {
                    dataOutputStream.writeByte(3);
                    dataOutputStream.writeInt((Integer)this.value);
                } else if (this.value instanceof Float) {
                    dataOutputStream.writeByte(4);
                    dataOutputStream.writeFloat(((Float)this.value).floatValue());
                } else if (this.value instanceof Long) {
                    dataOutputStream.writeByte(5);
                    dataOutputStream.writeLong((Long)this.value);
                } else if (this.value instanceof Double) {
                    dataOutputStream.writeDouble(6.0);
                    dataOutputStream.writeDouble((Double)this.value);
                } else {
                    throw new InternalError("bogus value entry: " + this.value);
                }
            }
        }
    }

    private static class ExceptionTableEntry {
        public short startPc;
        public short endPc;
        public short handlerPc;
        public short catchType;

        public ExceptionTableEntry(short s, short s2, short s3, short s4) {
            this.startPc = s;
            this.endPc = s2;
            this.handlerPc = s3;
            this.catchType = s4;
        }
    }

    private class FieldInfo {
        public int accessFlags;
        public String name;
        public String descriptor;

        public FieldInfo(String string, String string2, int n) {
            this.name = string;
            this.descriptor = string2;
            this.accessFlags = n;
            ProxyGenerator.this.cp.getUtf8(string);
            ProxyGenerator.this.cp.getUtf8(string2);
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.accessFlags);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.name));
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.descriptor));
            dataOutputStream.writeShort(0);
        }
    }

    private class MethodInfo {
        public int accessFlags;
        public String name;
        public String descriptor;
        public short maxStack;
        public short maxLocals;
        public ByteArrayOutputStream code = new ByteArrayOutputStream();
        public List<ExceptionTableEntry> exceptionTable = new ArrayList<ExceptionTableEntry>();
        public short[] declaredExceptions;

        public MethodInfo(String string, String string2, int n) {
            this.name = string;
            this.descriptor = string2;
            this.accessFlags = n;
            ProxyGenerator.this.cp.getUtf8(string);
            ProxyGenerator.this.cp.getUtf8(string2);
            ProxyGenerator.this.cp.getUtf8("Code");
            ProxyGenerator.this.cp.getUtf8("Exceptions");
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.accessFlags);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.name));
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.descriptor));
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8("Code"));
            dataOutputStream.writeInt(12 + this.code.size() + 8 * this.exceptionTable.size());
            dataOutputStream.writeShort(this.maxStack);
            dataOutputStream.writeShort(this.maxLocals);
            dataOutputStream.writeInt(this.code.size());
            this.code.writeTo(dataOutputStream);
            dataOutputStream.writeShort(this.exceptionTable.size());
            for (ExceptionTableEntry exceptionTableEntry : this.exceptionTable) {
                dataOutputStream.writeShort(exceptionTableEntry.startPc);
                dataOutputStream.writeShort(exceptionTableEntry.endPc);
                dataOutputStream.writeShort(exceptionTableEntry.handlerPc);
                dataOutputStream.writeShort(exceptionTableEntry.catchType);
            }
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8("Exceptions"));
            dataOutputStream.writeInt(2 + 2 * this.declaredExceptions.length);
            dataOutputStream.writeShort(this.declaredExceptions.length);
            for (int i = 0; i < this.declaredExceptions.length; ++i) {
                dataOutputStream.writeShort(this.declaredExceptions[i]);
            }
        }
    }

    private static class PrimitiveTypeInfo {
        public String baseTypeString;
        public String wrapperClassName;
        public String wrapperValueOfDesc;
        public String unwrapMethodName;
        public String unwrapMethodDesc;
        private static Map<Class, PrimitiveTypeInfo> table = new HashMap<Class, PrimitiveTypeInfo>();

        private static void add(Class clazz, Class clazz2) {
            table.put(clazz, new PrimitiveTypeInfo(clazz, clazz2));
        }

        private PrimitiveTypeInfo(Class clazz, Class clazz2) {
            assert (clazz.isPrimitive());
            this.baseTypeString = Array.newInstance(clazz, 0).getClass().getName().substring(1);
            this.wrapperClassName = ProxyGenerator.dotToSlash(clazz2.getName());
            this.wrapperValueOfDesc = "(" + this.baseTypeString + ")L" + this.wrapperClassName + ";";
            this.unwrapMethodName = clazz.getName() + "Value";
            this.unwrapMethodDesc = "()" + this.baseTypeString;
        }

        public static PrimitiveTypeInfo get(Class clazz) {
            return table.get(clazz);
        }

        static {
            PrimitiveTypeInfo.add(Byte.TYPE, Byte.class);
            PrimitiveTypeInfo.add(Character.TYPE, Character.class);
            PrimitiveTypeInfo.add(Double.TYPE, Double.class);
            PrimitiveTypeInfo.add(Float.TYPE, Float.class);
            PrimitiveTypeInfo.add(Integer.TYPE, Integer.class);
            PrimitiveTypeInfo.add(Long.TYPE, Long.class);
            PrimitiveTypeInfo.add(Short.TYPE, Short.class);
            PrimitiveTypeInfo.add(Boolean.TYPE, Boolean.class);
        }
    }

    private class ProxyMethod {
        public String methodName;
        public Class[] parameterTypes;
        public Class returnType;
        public Class[] exceptionTypes;
        public Class fromClass;
        public String methodFieldName;

        private ProxyMethod(String string, Class[] classArray, Class clazz, Class[] classArray2, Class clazz2) {
            this.methodName = string;
            this.parameterTypes = classArray;
            this.returnType = clazz;
            this.exceptionTypes = classArray2;
            this.fromClass = clazz2;
            this.methodFieldName = "m" + ProxyGenerator.this.proxyMethodCount++;
        }

        private MethodInfo generateMethod() throws IOException {
            short s;
            int n;
            String string = ProxyGenerator.getMethodDescriptor(this.parameterTypes, this.returnType);
            MethodInfo methodInfo = new MethodInfo(this.methodName, string, 17);
            int[] nArray = new int[this.parameterTypes.length];
            int n2 = 1;
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n2;
                n2 += ProxyGenerator.getWordsPerType(this.parameterTypes[n]);
            }
            n = n2;
            short s2 = 0;
            DataOutputStream dataOutputStream = new DataOutputStream(methodInfo.code);
            ProxyGenerator.this.code_aload(0, dataOutputStream);
            dataOutputStream.writeByte(180);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(ProxyGenerator.superclassName, ProxyGenerator.handlerFieldName, "Ljava/lang/reflect/InvocationHandler;"));
            ProxyGenerator.this.code_aload(0, dataOutputStream);
            dataOutputStream.writeByte(178);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(ProxyGenerator.dotToSlash(ProxyGenerator.this.className), this.methodFieldName, "Ljava/lang/reflect/Method;"));
            if (this.parameterTypes.length > 0) {
                ProxyGenerator.this.code_ipush(this.parameterTypes.length, dataOutputStream);
                dataOutputStream.writeByte(189);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass("java/lang/Object"));
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    dataOutputStream.writeByte(89);
                    ProxyGenerator.this.code_ipush(i, dataOutputStream);
                    this.codeWrapArgument(this.parameterTypes[i], nArray[i], dataOutputStream);
                    dataOutputStream.writeByte(83);
                }
            } else {
                dataOutputStream.writeByte(1);
            }
            dataOutputStream.writeByte(185);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getInterfaceMethodRef("java/lang/reflect/InvocationHandler", "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;"));
            dataOutputStream.writeByte(4);
            dataOutputStream.writeByte(0);
            if (this.returnType == Void.TYPE) {
                dataOutputStream.writeByte(87);
                dataOutputStream.writeByte(177);
            } else {
                this.codeUnwrapReturnValue(this.returnType, dataOutputStream);
            }
            short s3 = s = (short)methodInfo.code.size();
            List list = ProxyGenerator.computeUniqueCatchList(this.exceptionTypes);
            if (list.size() > 0) {
                for (Class clazz : list) {
                    methodInfo.exceptionTable.add(new ExceptionTableEntry(s2, s3, s, ProxyGenerator.this.cp.getClass(ProxyGenerator.dotToSlash(clazz.getName()))));
                }
                dataOutputStream.writeByte(191);
                s = (short)methodInfo.code.size();
                methodInfo.exceptionTable.add(new ExceptionTableEntry(s2, s3, s, ProxyGenerator.this.cp.getClass("java/lang/Throwable")));
                ProxyGenerator.this.code_astore(n, dataOutputStream);
                dataOutputStream.writeByte(187);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass("java/lang/reflect/UndeclaredThrowableException"));
                dataOutputStream.writeByte(89);
                ProxyGenerator.this.code_aload(n, dataOutputStream);
                dataOutputStream.writeByte(183);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef("java/lang/reflect/UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V"));
                dataOutputStream.writeByte(191);
            }
            if (methodInfo.code.size() > 65535) {
                throw new IllegalArgumentException("code size limit exceeded");
            }
            methodInfo.maxStack = (short)10;
            methodInfo.maxLocals = (short)(n + 1);
            methodInfo.declaredExceptions = new short[this.exceptionTypes.length];
            for (int i = 0; i < this.exceptionTypes.length; ++i) {
                methodInfo.declaredExceptions[i] = ProxyGenerator.this.cp.getClass(ProxyGenerator.dotToSlash(this.exceptionTypes[i].getName()));
            }
            return methodInfo;
        }

        private void codeWrapArgument(Class clazz, int n, DataOutputStream dataOutputStream) throws IOException {
            if (clazz.isPrimitive()) {
                PrimitiveTypeInfo primitiveTypeInfo = PrimitiveTypeInfo.get(clazz);
                if (clazz == Integer.TYPE || clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE) {
                    ProxyGenerator.this.code_iload(n, dataOutputStream);
                } else if (clazz == Long.TYPE) {
                    ProxyGenerator.this.code_lload(n, dataOutputStream);
                } else if (clazz == Float.TYPE) {
                    ProxyGenerator.this.code_fload(n, dataOutputStream);
                } else if (clazz == Double.TYPE) {
                    ProxyGenerator.this.code_dload(n, dataOutputStream);
                } else {
                    throw new AssertionError();
                }
                dataOutputStream.writeByte(184);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef(primitiveTypeInfo.wrapperClassName, "valueOf", primitiveTypeInfo.wrapperValueOfDesc));
            } else {
                ProxyGenerator.this.code_aload(n, dataOutputStream);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void codeUnwrapReturnValue(Class clazz, DataOutputStream dataOutputStream) throws IOException {
            if (clazz.isPrimitive()) {
                PrimitiveTypeInfo primitiveTypeInfo = PrimitiveTypeInfo.get(clazz);
                dataOutputStream.writeByte(192);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass(primitiveTypeInfo.wrapperClassName));
                dataOutputStream.writeByte(182);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef(primitiveTypeInfo.wrapperClassName, primitiveTypeInfo.unwrapMethodName, primitiveTypeInfo.unwrapMethodDesc));
                if (clazz == Integer.TYPE || clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE) {
                    dataOutputStream.writeByte(172);
                    return;
                } else if (clazz == Long.TYPE) {
                    dataOutputStream.writeByte(173);
                    return;
                } else if (clazz == Float.TYPE) {
                    dataOutputStream.writeByte(174);
                    return;
                } else {
                    if (clazz != Double.TYPE) throw new AssertionError();
                    dataOutputStream.writeByte(175);
                }
                return;
            } else {
                dataOutputStream.writeByte(192);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass(ProxyGenerator.dotToSlash(clazz.getName())));
                dataOutputStream.writeByte(176);
            }
        }

        private void codeFieldInitialization(DataOutputStream dataOutputStream) throws IOException {
            ProxyGenerator.this.codeClassForName(this.fromClass, dataOutputStream);
            ProxyGenerator.this.code_ldc(ProxyGenerator.this.cp.getString(this.methodName), dataOutputStream);
            ProxyGenerator.this.code_ipush(this.parameterTypes.length, dataOutputStream);
            dataOutputStream.writeByte(189);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass("java/lang/Class"));
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                dataOutputStream.writeByte(89);
                ProxyGenerator.this.code_ipush(i, dataOutputStream);
                if (this.parameterTypes[i].isPrimitive()) {
                    PrimitiveTypeInfo primitiveTypeInfo = PrimitiveTypeInfo.get(this.parameterTypes[i]);
                    dataOutputStream.writeByte(178);
                    dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(primitiveTypeInfo.wrapperClassName, "TYPE", "Ljava/lang/Class;"));
                } else {
                    ProxyGenerator.this.codeClassForName(this.parameterTypes[i], dataOutputStream);
                }
                dataOutputStream.writeByte(83);
            }
            dataOutputStream.writeByte(182);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef("java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;"));
            dataOutputStream.writeByte(179);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(ProxyGenerator.dotToSlash(ProxyGenerator.this.className), this.methodFieldName, "Ljava/lang/reflect/Method;"));
        }
    }
}

