/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import sun.awt.AWTAccessor;
import sun.awt.GlobalCursorManager;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

public final class XGlobalCursorManager
extends GlobalCursorManager {
    private Component nativeContainer;
    private static XGlobalCursorManager manager;

    static GlobalCursorManager getCursorManager() {
        if (manager == null) {
            manager = new XGlobalCursorManager();
        }
        return manager;
    }

    static void nativeUpdateCursor(Component component) {
        XGlobalCursorManager.getCursorManager().updateCursorLater(component);
    }

    protected void setCursor(Component component, Cursor cursor, boolean bl) {
        ComponentPeer componentPeer;
        Component component2;
        Cursor cursor2;
        if (component == null) {
            return;
        }
        CapableCursorAndComponent capableCursorAndComponent = null;
        if (bl) {
            cursor2 = cursor;
        } else {
            capableCursorAndComponent = CapableCursorAndComponent.getNew(component);
            cursor2 = capableCursorAndComponent.cursor;
        }
        Cursor cursor3 = cursor2;
        Component component3 = capableCursorAndComponent != null ? capableCursorAndComponent.component : null;
        Component component4 = component2 = bl ? this.nativeContainer : this.getNativeContainer(component);
        if (component2 != null && (componentPeer = AWTAccessor.getComponentAccessor().getPeer(component2)) instanceof XComponentPeer) {
            this.nativeContainer = component2;
            ((XComponentPeer)componentPeer).pSetCursor(cursor3, component3);
            XGlobalCursorManager.updateGrabbedCursor(cursor3);
        }
    }

    private static void updateGrabbedCursor(Cursor cursor) {
        XBaseWindow xBaseWindow = XAwtState.getGrabWindow();
        if (xBaseWindow instanceof XWindowPeer) {
            XWindowPeer xWindowPeer = (XWindowPeer)xBaseWindow;
            xWindowPeer.pSetCursor(cursor);
        }
    }

    protected void updateCursorOutOfJava() {
        XGlobalCursorManager.updateGrabbedCursor(Cursor.getPredefinedCursor(0));
    }

    private Component getNativeContainer(Component component) {
        while (component != null && AWTAccessor.getComponentAccessor().getPeer(component) instanceof LightweightPeer) {
            component = AWTAccessor.getComponentAccessor().getParent(component);
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCursorPos(Point point) {
        if (!((XToolkit)Toolkit.getDefaultToolkit()).getLastCursorPos(point)) {
            XToolkit.awtLock();
            try {
                long l = XToolkit.getDisplay();
                long l2 = XlibWrapper.RootWindow(l, XlibWrapper.DefaultScreen(l));
                XlibWrapper.XQueryPointer(l, l2, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
                point.x = XlibWrapper.unsafe.getInt(XlibWrapper.larg3);
                point.y = XlibWrapper.unsafe.getInt(XlibWrapper.larg4);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    protected Component findHeavyweightUnderCursor() {
        return XAwtState.getComponentMouseEntered();
    }

    protected Component findComponentAt(Container container, int n, int n2) {
        return container.findComponentAt(n, n2);
    }

    protected Point getLocationOnScreen(Component component) {
        return component.getLocationOnScreen();
    }

    protected Component findHeavyweightUnderCursor(boolean bl) {
        return this.findHeavyweightUnderCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getCursor(Cursor cursor) {
        long l = 0L;
        int n = 0;
        try {
            l = AWTAccessor.getCursorAccessor().getPData(cursor);
            n = AWTAccessor.getCursorAccessor().getType(cursor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (l != 0L) {
            return l;
        }
        long l2 = 0L;
        switch (n) {
            case 0: {
                l2 = 68L;
                break;
            }
            case 1: {
                l2 = 34L;
                break;
            }
            case 2: {
                l2 = 152L;
                break;
            }
            case 3: {
                l2 = 150L;
                break;
            }
            case 4: {
                l2 = 12L;
                break;
            }
            case 6: {
                l2 = 134L;
                break;
            }
            case 5: {
                l2 = 14L;
                break;
            }
            case 7: {
                l2 = 136L;
                break;
            }
            case 9: {
                l2 = 16L;
                break;
            }
            case 8: {
                l2 = 138L;
                break;
            }
            case 10: {
                l2 = 70L;
                break;
            }
            case 11: {
                l2 = 96L;
                break;
            }
            case 12: {
                l2 = 60L;
                break;
            }
            case 13: {
                l2 = 52L;
            }
        }
        XToolkit.awtLock();
        try {
            l = XlibWrapper.XCreateFontCursor(XToolkit.getDisplay(), (int)l2);
        }
        finally {
            XToolkit.awtUnlock();
        }
        XGlobalCursorManager.setPData(cursor, l);
        return l;
    }

    static void setPData(Cursor cursor, long l) {
        try {
            AWTAccessor.getCursorAccessor().setPData(cursor, l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static final class CapableCursorAndComponent {
        final Cursor cursor;
        final Component component;

        private CapableCursorAndComponent(Cursor cursor, Component component) {
            this.cursor = cursor;
            this.component = component;
        }

        static CapableCursorAndComponent getNew(Component component) {
            AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
            Component component2 = component;
            while (component2 != null && !(component2 instanceof Window) && componentAccessor.isEnabled(component2) && componentAccessor.isVisible(component2) && componentAccessor.isDisplayable(component2)) {
                component2 = componentAccessor.getParent(component2);
            }
            if (component2 instanceof Window) {
                return componentAccessor.isEnabled(component2) && componentAccessor.isVisible(component2) && componentAccessor.isDisplayable(component2) && componentAccessor.isEnabled(component) ? new CapableCursorAndComponent(componentAccessor.getCursor(component), component) : new CapableCursorAndComponent(Cursor.getPredefinedCursor(0), null);
            }
            if (component2 == null) {
                return new CapableCursorAndComponent(null, null);
            }
            return CapableCursorAndComponent.getNew(componentAccessor.getParent(component2));
        }
    }
}

