/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDnDConstants;
import sun.awt.X11.XDragSourceContextPeer;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XErrorHandlerUtil;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class XDnDDragSourceProtocol
extends XDragSourceProtocol {
    private static final Logger logger = Logger.getLogger("sun.awt.X11.xembed.xdnd.XDnDDragSourceProtocol");
    private static final Unsafe unsafe = XlibWrapper.unsafe;

    protected XDnDDragSourceProtocol(XDragSourceProtocolListener xDragSourceProtocolListener) {
        super(xDragSourceProtocolListener);
    }

    static XDragSourceProtocol createInstance(XDragSourceProtocolListener xDragSourceProtocolListener) {
        return new XDnDDragSourceProtocol(xDragSourceProtocolListener);
    }

    public String getProtocolName() {
        return "XDnD";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDragImpl(int n, Transferable transferable, Map map, long[] lArray) throws InvalidDnDOperationException, IllegalArgumentException, XException {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        long l = XDragSourceProtocol.getDragSourceWindow();
        long l2 = Native.allocateLongArray(3);
        int n2 = 0;
        try {
            if ((n & 1) != 0) {
                Native.putLong(l2, n2, XDnDConstants.XA_XdndActionCopy.getAtom());
                ++n2;
            }
            if ((n & 2) != 0) {
                Native.putLong(l2, n2, XDnDConstants.XA_XdndActionMove.getAtom());
                ++n2;
            }
            if ((n & 0x40000000) != 0) {
                Native.putLong(l2, n2, XDnDConstants.XA_XdndActionLink.getAtom());
                ++n2;
            }
            XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndActionList.setAtomData(l, 4L, l2, n2);
            XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
            if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                this.cleanup();
                throw new XException("Cannot write XdndActionList property");
            }
        }
        finally {
            unsafe.freeMemory(l2);
            l2 = 0L;
        }
        l2 = Native.allocateLongArray(lArray.length);
        try {
            Native.put(l2, lArray);
            XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndTypeList.setAtomData(l, 4L, l2, lArray.length);
            XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
            if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                this.cleanup();
                throw new XException("Cannot write XdndActionList property");
            }
        }
        finally {
            unsafe.freeMemory(l2);
            l2 = 0L;
        }
        if (!XDnDConstants.XDnDSelection.setOwner(transferable, map, lArray, 0L)) {
            this.cleanup();
            throw new InvalidDnDOperationException("Cannot acquire selection ownership");
        }
    }

    private boolean processXdndStatus(XClientMessageEvent xClientMessageEvent) {
        int n = 0;
        if (xClientMessageEvent.get_data(0) != this.getTargetWindow()) {
            return true;
        }
        if ((xClientMessageEvent.get_data(1) & 1L) != 0L) {
            n = XDnDConstants.getJavaActionForXDnDAction(xClientMessageEvent.get_data(4));
        }
        this.getProtocolListener().handleDragReply(n);
        return true;
    }

    private boolean processXdndFinished(XClientMessageEvent xClientMessageEvent) {
        if (xClientMessageEvent.get_data(0) != this.getTargetWindow()) {
            return true;
        }
        if (this.getTargetProtocolVersion() >= 5) {
            boolean bl = (xClientMessageEvent.get_data(1) & 1L) != 0L;
            int n = XDnDConstants.getJavaActionForXDnDAction(xClientMessageEvent.get_data(2));
            this.getProtocolListener().handleDragFinished(bl, n);
        } else {
            this.getProtocolListener().handleDragFinished();
        }
        this.finalizeDrop();
        return true;
    }

    public boolean processClientMessage(XClientMessageEvent xClientMessageEvent) {
        if (xClientMessageEvent.get_message_type() == XDnDConstants.XA_XdndStatus.getAtom()) {
            return this.processXdndStatus(xClientMessageEvent);
        }
        if (xClientMessageEvent.get_message_type() == XDnDConstants.XA_XdndFinished.getAtom()) {
            return this.processXdndFinished(xClientMessageEvent);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XDragSourceProtocol.TargetWindowInfo getTargetWindowInfo(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(l, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
        int n = windowPropertyGetter.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
        if (n == 0 && windowPropertyGetter.getData() != 0L && windowPropertyGetter.getActualType() == 4L) {
            int n2 = (int)Native.getLong(windowPropertyGetter.getData());
            windowPropertyGetter.dispose();
            if (n2 >= 3) {
                int n3;
                long l2;
                block18: {
                    l2 = 0L;
                    n3 = n2 < 5 ? n2 : 5;
                    WindowPropertyGetter windowPropertyGetter2 = new WindowPropertyGetter(l, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                    try {
                        n = windowPropertyGetter2.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                        if (n == 0 && windowPropertyGetter2.getData() != 0L && windowPropertyGetter2.getActualType() == 33L) {
                            l2 = Native.getLong(windowPropertyGetter2.getData());
                        }
                    }
                    finally {
                        windowPropertyGetter2.dispose();
                    }
                    if (l2 != 0L) {
                        WindowPropertyGetter windowPropertyGetter3 = new WindowPropertyGetter(l2, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                        try {
                            n = windowPropertyGetter3.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                            if (n != 0 || windowPropertyGetter3.getData() == 0L || windowPropertyGetter3.getActualType() != 33L || Native.getLong(windowPropertyGetter3.getData()) != l2) {
                                l2 = 0L;
                                break block18;
                            }
                            WindowPropertyGetter windowPropertyGetter4 = new WindowPropertyGetter(l2, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
                            try {
                                n = windowPropertyGetter4.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                                if (n != 0 || windowPropertyGetter4.getData() == 0L || windowPropertyGetter4.getActualType() != 4L) {
                                    l2 = 0L;
                                }
                            }
                            finally {
                                windowPropertyGetter4.dispose();
                            }
                        }
                        finally {
                            windowPropertyGetter3.dispose();
                        }
                    }
                }
                return new XDragSourceProtocol.TargetWindowInfo(l2, n3);
            }
        } else {
            windowPropertyGetter.dispose();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEnterMessage(long[] lArray, int n, int n2, long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        assert (lArray != null);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(XDnDConstants.XA_XdndEnter.getAtom());
            xClientMessageEvent.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            long l2 = this.getTargetProtocolVersion() << 24;
            xClientMessageEvent.set_data(1, l2 |= lArray.length > 3 ? 1L : 0L);
            xClientMessageEvent.set_data(2, lArray.length > 0 ? lArray[0] : 0L);
            xClientMessageEvent.set_data(3, lArray.length > 1 ? lArray[1] : 0L);
            xClientMessageEvent.set_data(4, lArray.length > 2 ? lArray[2] : 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMoveMessage(int n, int n2, int n3, int n4, long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(XDnDConstants.XA_XdndPosition.getAtom());
            xClientMessageEvent.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            xClientMessageEvent.set_data(1, 0L);
            xClientMessageEvent.set_data(2, n << 16 | n2);
            xClientMessageEvent.set_data(3, l);
            xClientMessageEvent.set_data(4, XDnDConstants.getXDnDActionForJavaAction(n3));
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLeaveMessage(long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(XDnDConstants.XA_XdndLeave.getAtom());
            xClientMessageEvent.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            xClientMessageEvent.set_data(1, 0L);
            xClientMessageEvent.set_data(2, 0L);
            xClientMessageEvent.set_data(3, 0L);
            xClientMessageEvent.set_data(4, 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDropMessage(int n, int n2, int n3, int n4, long l) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(this.getTargetWindow());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(XDnDConstants.XA_XdndDrop.getAtom());
            xClientMessageEvent.set_data(0, XDragSourceProtocol.getDragSourceWindow());
            xClientMessageEvent.set_data(1, 0L);
            xClientMessageEvent.set_data(2, l);
            xClientMessageEvent.set_data(3, 0L);
            xClientMessageEvent.set_data(4, 0L);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, xClientMessageEvent.pData);
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    public boolean processProxyModeEvent(XClientMessageEvent xClientMessageEvent, long l) {
        if (xClientMessageEvent.get_message_type() == XDnDConstants.XA_XdndStatus.getAtom() || xClientMessageEvent.get_message_type() == XDnDConstants.XA_XdndFinished.getAtom()) {
            if (xClientMessageEvent.get_message_type() == XDnDConstants.XA_XdndFinished.getAtom()) {
                XDragSourceContextPeer.setProxyModeSourceWindow(0L);
            }
            if (xClientMessageEvent.get_window() == l) {
                return false;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("        sourceWindow=" + l + " get_window=" + xClientMessageEvent.get_window() + " xclient=" + xClientMessageEvent);
            }
            xClientMessageEvent.set_data(0, xClientMessageEvent.get_window());
            xClientMessageEvent.set_window(l);
            assert (XToolkit.isAWTLockHeldByCurrentThread());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), l, false, 0L, xClientMessageEvent.pData);
            return true;
        }
        return false;
    }

    public void run() {
        this.cleanup();
    }
}

