/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.Rfc2253Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rdn
implements Serializable,
Comparable<Object> {
    private transient ArrayList entries;
    private static final int DEFAULT_SIZE = 1;
    private static final long serialVersionUID = -5994465067210009656L;
    private static final String escapees = ",=+<>#;\"\\";

    public Rdn(Attributes attributes) throws InvalidNameException {
        if (attributes.size() == 0) {
            throw new InvalidNameException("Attributes cannot be empty");
        }
        this.entries = new ArrayList(attributes.size());
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        try {
            int n = 0;
            while (namingEnumeration.hasMore()) {
                RdnEntry rdnEntry = new RdnEntry();
                Attribute attribute = namingEnumeration.next();
                rdnEntry.type = attribute.getID();
                rdnEntry.value = attribute.get();
                this.entries.add(n, rdnEntry);
                ++n;
            }
        }
        catch (NamingException namingException) {
            InvalidNameException invalidNameException = new InvalidNameException(namingException.getMessage());
            invalidNameException.initCause(namingException);
            throw invalidNameException;
        }
        this.sort();
    }

    public Rdn(String string) throws InvalidNameException {
        this.entries = new ArrayList(1);
        new Rfc2253Parser(string).parseRdn(this);
    }

    public Rdn(Rdn rdn) {
        this.entries = new ArrayList(rdn.entries.size());
        this.entries.addAll(rdn.entries);
    }

    public Rdn(String string, Object object) throws InvalidNameException {
        if (object == null) {
            throw new NullPointerException("Cannot set value to null");
        }
        if (string.equals("") || this.isEmptyValue(object)) {
            throw new InvalidNameException("type or value cannot be empty, type:" + string + " value:" + object);
        }
        this.entries = new ArrayList(1);
        this.put(string, object);
    }

    private boolean isEmptyValue(Object object) {
        return object instanceof String && object.equals("") || object instanceof byte[] && ((byte[])object).length == 0;
    }

    Rdn() {
        this.entries = new ArrayList(1);
    }

    Rdn put(String string, Object object) {
        RdnEntry rdnEntry = new RdnEntry();
        rdnEntry.type = string;
        if (object instanceof byte[]) {
            rdnEntry.value = ((byte[])object).clone();
        } else {
            rdnEntry.value = object;
        }
        this.entries.add(rdnEntry);
        return this;
    }

    void sort() {
        if (this.entries.size() > 1) {
            Collections.sort(this.entries);
        }
    }

    public Object getValue() {
        return ((RdnEntry)this.entries.get(0)).getValue();
    }

    public String getType() {
        return ((RdnEntry)this.entries.get(0)).getType();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.entries.size();
        if (n > 0) {
            stringBuilder.append(this.entries.get(0));
        }
        for (int i = 1; i < n; ++i) {
            stringBuilder.append('+');
            stringBuilder.append(this.entries.get(i));
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof Rdn)) {
            throw new ClassCastException("The obj is not a Rdn");
        }
        if (object == this) {
            return 0;
        }
        Rdn rdn = (Rdn)object;
        int n = Math.min(this.entries.size(), rdn.entries.size());
        for (int i = 0; i < n; ++i) {
            int n2 = ((RdnEntry)this.entries.get(i)).compareTo(rdn.entries.get(i));
            if (n2 == 0) continue;
            return n2;
        }
        return this.entries.size() - rdn.entries.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rdn)) {
            return false;
        }
        Rdn rdn = (Rdn)object;
        if (this.entries.size() != rdn.size()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get(i).equals(rdn.entries.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.entries.size(); ++i) {
            n += this.entries.get(i).hashCode();
        }
        return n;
    }

    public Attributes toAttributes() {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        for (int i = 0; i < this.entries.size(); ++i) {
            RdnEntry rdnEntry = (RdnEntry)this.entries.get(i);
            Attribute attribute = basicAttributes.put(rdnEntry.getType(), rdnEntry.getValue());
            if (attribute == null) continue;
            attribute.add(rdnEntry.getValue());
            basicAttributes.put(attribute);
        }
        return basicAttributes;
    }

    public int size() {
        return this.entries.size();
    }

    public static String escapeValue(Object object) {
        return object instanceof byte[] ? Rdn.escapeBinaryValue((byte[])object) : Rdn.escapeStringValue((String)object);
    }

    private static String escapeStringValue(String string) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(2 * string.length());
        for (n2 = 0; n2 < cArray.length && Rdn.isWhitespace(cArray[n2]); ++n2) {
        }
        for (n = cArray.length - 1; n >= 0 && Rdn.isWhitespace(cArray[n]); --n) {
        }
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (i < n2 || i > n || escapees.indexOf(c) >= 0) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static String escapeBinaryValue(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(1 + 2 * byArray.length);
        stringBuilder.append("#");
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuilder.append(Character.forDigit(0xF & by >>> 4, 16));
            stringBuilder.append(Character.forDigit(0xF & by, 16));
        }
        return stringBuilder.toString();
    }

    public static Object unescapeValue(String string) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        for (n2 = 0; n2 < n3 && Rdn.isWhitespace(cArray[n2]); ++n2) {
        }
        while (n2 < n3 && Rdn.isWhitespace(cArray[n3 - 1])) {
            --n3;
        }
        if (n3 != cArray.length && n2 < n3 && cArray[n3 - 1] == '\\') {
            ++n3;
        }
        if (n2 >= n3) {
            return "";
        }
        if (cArray[n2] == '#') {
            return Rdn.decodeHexPairs(cArray, ++n2, n3);
        }
        if (cArray[n2] == '\"' && cArray[n3 - 1] == '\"') {
            ++n2;
            --n3;
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        int n4 = -1;
        for (n = n2; n < n3; ++n) {
            if (cArray[n] == '\\' && n + 1 < n3) {
                if (!Character.isLetterOrDigit(cArray[n + 1])) {
                    stringBuilder.append(cArray[++n]);
                    n4 = n;
                    continue;
                }
                byte[] byArray = Rdn.getUtf8Octets(cArray, n, n3);
                if (byArray.length > 0) {
                    try {
                        stringBuilder.append(new String(byArray, "UTF8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    n += byArray.length * 3 - 1;
                    continue;
                }
                throw new IllegalArgumentException("Not a valid attribute string value:" + string + ",improper usage of backslash");
            }
            stringBuilder.append(cArray[n]);
        }
        n = stringBuilder.length();
        if (Rdn.isWhitespace(stringBuilder.charAt(n - 1)) && n4 != n3 - 1) {
            stringBuilder.setLength(n - 1);
        }
        return stringBuilder.toString();
    }

    private static byte[] decodeHexPairs(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[(n2 - n) / 2];
        int n3 = 0;
        while (n + 1 < n2) {
            int n4 = Character.digit(cArray[n], 16);
            int n5 = Character.digit(cArray[n + 1], 16);
            if (n4 < 0 || n5 < 0) break;
            byArray[n3] = (byte)((n4 << 4) + n5);
            n += 2;
            ++n3;
        }
        if (n != n2) {
            throw new IllegalArgumentException("Illegal attribute value: " + new String(cArray));
        }
        return byArray;
    }

    private static byte[] getUtf8Octets(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[(n2 - n) / 3];
        int n3 = 0;
        while (n + 2 < n2 && cArray[n++] == '\\') {
            int n4 = Character.digit(cArray[n++], 16);
            int n5 = Character.digit(cArray[n++], 16);
            if (n4 < 0 || n5 < 0) break;
            byArray[n3++] = (byte)((n4 << 4) + n5);
        }
        if (n3 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\r';
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.entries = new ArrayList(1);
        String string = (String)objectInputStream.readObject();
        try {
            new Rfc2253Parser(string).parseRdn(this);
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name: " + string);
        }
    }

    private static class RdnEntry
    implements Comparable {
        private String type;
        private Object value;
        private String comparable = null;

        private RdnEntry() {
        }

        String getType() {
            return this.type;
        }

        Object getValue() {
            return this.value;
        }

        public int compareTo(Object object) {
            RdnEntry rdnEntry = (RdnEntry)object;
            int n = this.type.compareToIgnoreCase(rdnEntry.type);
            if (n != 0) {
                return n;
            }
            if (this.value.equals(rdnEntry.value)) {
                return 0;
            }
            return this.getValueComparable().compareTo(rdnEntry.getValueComparable());
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof RdnEntry)) {
                return false;
            }
            RdnEntry rdnEntry = (RdnEntry)object;
            return this.type.equalsIgnoreCase(rdnEntry.type) && this.getValueComparable().equals(rdnEntry.getValueComparable());
        }

        public int hashCode() {
            return this.type.toUpperCase(Locale.ENGLISH).hashCode() + this.getValueComparable().hashCode();
        }

        public String toString() {
            return this.type + "=" + Rdn.escapeValue(this.value);
        }

        private String getValueComparable() {
            if (this.comparable != null) {
                return this.comparable;
            }
            this.comparable = this.value instanceof byte[] ? Rdn.escapeBinaryValue((byte[])this.value) : ((String)this.value).toUpperCase(Locale.ENGLISH);
            return this.comparable;
        }
    }
}

