/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.NameImplEnumerator;

class NameImpl {
    private static final byte LEFT_TO_RIGHT = 1;
    private static final byte RIGHT_TO_LEFT = 2;
    private static final byte FLAT = 0;
    private Vector components;
    private byte syntaxDirection = 1;
    private String syntaxSeparator = "/";
    private String syntaxSeparator2 = null;
    private boolean syntaxCaseInsensitive = false;
    private boolean syntaxTrimBlanks = false;
    private String syntaxEscape = "\\";
    private String syntaxBeginQuote1 = "\"";
    private String syntaxEndQuote1 = "\"";
    private String syntaxBeginQuote2 = "'";
    private String syntaxEndQuote2 = "'";
    private String syntaxAvaSeparator = null;
    private String syntaxTypevalSeparator = null;
    private static final int STYLE_NONE = 0;
    private static final int STYLE_QUOTE1 = 1;
    private static final int STYLE_QUOTE2 = 2;
    private static final int STYLE_ESCAPE = 3;
    private int escapingStyle = 0;

    private final boolean isA(String string, int n, String string2) {
        return string2 != null && string.startsWith(string2, n);
    }

    private final boolean isMeta(String string, int n) {
        return this.isA(string, n, this.syntaxEscape) || this.isA(string, n, this.syntaxBeginQuote1) || this.isA(string, n, this.syntaxBeginQuote2) || this.isSeparator(string, n);
    }

    private final boolean isSeparator(String string, int n) {
        return this.isA(string, n, this.syntaxSeparator) || this.isA(string, n, this.syntaxSeparator2);
    }

    private final int skipSeparator(String string, int n) {
        if (this.isA(string, n, this.syntaxSeparator)) {
            n += this.syntaxSeparator.length();
        } else if (this.isA(string, n, this.syntaxSeparator2)) {
            n += this.syntaxSeparator2.length();
        }
        return n;
    }

    private final int extractComp(String string, int n, int n2, Vector vector) throws InvalidNameException {
        boolean bl = true;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(n2);
        while (n < n2) {
            if (bl && ((bl2 = this.isA(string, n, this.syntaxBeginQuote1)) || this.isA(string, n, this.syntaxBeginQuote2))) {
                String string2;
                String string3 = bl2 ? this.syntaxBeginQuote1 : this.syntaxBeginQuote2;
                String string4 = string2 = bl2 ? this.syntaxEndQuote1 : this.syntaxEndQuote2;
                if (this.escapingStyle == 0) {
                    this.escapingStyle = bl2 ? 1 : 2;
                }
                n += string3.length();
                while (n < n2 && !string.startsWith(string2, n)) {
                    if (this.isA(string, n, this.syntaxEscape) && this.isA(string, n + this.syntaxEscape.length(), string2)) {
                        n += this.syntaxEscape.length();
                    }
                    stringBuffer.append(string.charAt(n));
                    ++n;
                }
                if (n >= n2) {
                    throw new InvalidNameException(string + ": no close quote");
                }
                if ((n += string2.length()) == n2 || this.isSeparator(string, n)) break;
                throw new InvalidNameException(string + ": close quote appears before end of component");
            }
            if (this.isSeparator(string, n)) break;
            if (this.isA(string, n, this.syntaxEscape)) {
                if (this.isMeta(string, n + this.syntaxEscape.length())) {
                    n += this.syntaxEscape.length();
                    if (this.escapingStyle == 0) {
                        this.escapingStyle = 3;
                    }
                } else if (n + this.syntaxEscape.length() >= n2) {
                    throw new InvalidNameException(string + ": unescaped " + this.syntaxEscape + " at end of component");
                }
            } else if (this.isA(string, n, this.syntaxTypevalSeparator) && ((bl2 = this.isA(string, n + this.syntaxTypevalSeparator.length(), this.syntaxBeginQuote1)) || this.isA(string, n + this.syntaxTypevalSeparator.length(), this.syntaxBeginQuote2))) {
                String string5 = bl2 ? this.syntaxBeginQuote1 : this.syntaxBeginQuote2;
                String string6 = bl2 ? this.syntaxEndQuote1 : this.syntaxEndQuote2;
                n += this.syntaxTypevalSeparator.length();
                stringBuffer.append(this.syntaxTypevalSeparator + string5);
                n += string5.length();
                while (n < n2 && !string.startsWith(string6, n)) {
                    if (this.isA(string, n, this.syntaxEscape) && this.isA(string, n + this.syntaxEscape.length(), string6)) {
                        n += this.syntaxEscape.length();
                    }
                    stringBuffer.append(string.charAt(n));
                    ++n;
                }
                if (n >= n2) {
                    throw new InvalidNameException(string + ": typeval no close quote");
                }
                stringBuffer.append(string6);
                if ((n += string6.length()) == n2 || this.isSeparator(string, n)) break;
                throw new InvalidNameException(string.substring(n) + ": typeval close quote appears before end of component");
            }
            stringBuffer.append(string.charAt(n++));
            bl = false;
        }
        if (this.syntaxDirection == 2) {
            vector.insertElementAt(stringBuffer.toString(), 0);
        } else {
            vector.addElement(stringBuffer.toString());
        }
        return n;
    }

    private static boolean getBoolean(Properties properties, String string) {
        return NameImpl.toBoolean(properties.getProperty(string));
    }

    private static boolean toBoolean(String string) {
        return string != null && string.toLowerCase(Locale.ENGLISH).equals("true");
    }

    private final void recordNamingConvention(Properties properties) {
        String string = properties.getProperty("jndi.syntax.direction", "flat");
        if (string.equals("left_to_right")) {
            this.syntaxDirection = 1;
        } else if (string.equals("right_to_left")) {
            this.syntaxDirection = (byte)2;
        } else if (string.equals("flat")) {
            this.syntaxDirection = 0;
        } else {
            throw new IllegalArgumentException(string + "is not a valid value for the jndi.syntax.direction property");
        }
        if (this.syntaxDirection != 0) {
            this.syntaxSeparator = properties.getProperty("jndi.syntax.separator");
            this.syntaxSeparator2 = properties.getProperty("jndi.syntax.separator2");
            if (this.syntaxSeparator == null) {
                throw new IllegalArgumentException("jndi.syntax.separator property required for non-flat syntax");
            }
        } else {
            this.syntaxSeparator = null;
        }
        this.syntaxEscape = properties.getProperty("jndi.syntax.escape");
        this.syntaxCaseInsensitive = NameImpl.getBoolean(properties, "jndi.syntax.ignorecase");
        this.syntaxTrimBlanks = NameImpl.getBoolean(properties, "jndi.syntax.trimblanks");
        this.syntaxBeginQuote1 = properties.getProperty("jndi.syntax.beginquote");
        this.syntaxEndQuote1 = properties.getProperty("jndi.syntax.endquote");
        if (this.syntaxEndQuote1 == null && this.syntaxBeginQuote1 != null) {
            this.syntaxEndQuote1 = this.syntaxBeginQuote1;
        } else if (this.syntaxBeginQuote1 == null && this.syntaxEndQuote1 != null) {
            this.syntaxBeginQuote1 = this.syntaxEndQuote1;
        }
        this.syntaxBeginQuote2 = properties.getProperty("jndi.syntax.beginquote2");
        this.syntaxEndQuote2 = properties.getProperty("jndi.syntax.endquote2");
        if (this.syntaxEndQuote2 == null && this.syntaxBeginQuote2 != null) {
            this.syntaxEndQuote2 = this.syntaxBeginQuote2;
        } else if (this.syntaxBeginQuote2 == null && this.syntaxEndQuote2 != null) {
            this.syntaxBeginQuote2 = this.syntaxEndQuote2;
        }
        this.syntaxAvaSeparator = properties.getProperty("jndi.syntax.separator.ava");
        this.syntaxTypevalSeparator = properties.getProperty("jndi.syntax.separator.typeval");
    }

    NameImpl(Properties properties) {
        if (properties != null) {
            this.recordNamingConvention(properties);
        }
        this.components = new Vector();
    }

    NameImpl(Properties properties, String string) throws InvalidNameException {
        this(properties);
        boolean bl = this.syntaxDirection == 2;
        boolean bl2 = true;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            n2 = this.extractComp(string, n2, n, this.components);
            String string3 = string2 = bl ? (String)this.components.firstElement() : (String)this.components.lastElement();
            if (string2.length() >= 1) {
                bl2 = false;
            }
            if (n2 >= n || (n2 = this.skipSeparator(string, n2)) != n || bl2) continue;
            if (bl) {
                this.components.insertElementAt("", 0);
                continue;
            }
            this.components.addElement("");
        }
    }

    NameImpl(Properties properties, Enumeration enumeration) {
        this(properties);
        while (enumeration.hasMoreElements()) {
            this.components.addElement(enumeration.nextElement());
        }
    }

    private final String stringifyComp(String string) {
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer(n);
        if (this.syntaxSeparator != null && string.indexOf(this.syntaxSeparator) >= 0) {
            if (this.syntaxBeginQuote1 != null) {
                string2 = this.syntaxBeginQuote1;
                string3 = this.syntaxEndQuote1;
            } else if (this.syntaxBeginQuote2 != null) {
                string2 = this.syntaxBeginQuote2;
                string3 = this.syntaxEndQuote2;
            } else if (this.syntaxEscape != null) {
                bl = true;
            }
        }
        if (this.syntaxSeparator2 != null && string.indexOf(this.syntaxSeparator2) >= 0) {
            if (this.syntaxBeginQuote1 != null) {
                if (string2 == null) {
                    string2 = this.syntaxBeginQuote1;
                    string3 = this.syntaxEndQuote1;
                }
            } else if (this.syntaxBeginQuote2 != null) {
                if (string2 == null) {
                    string2 = this.syntaxBeginQuote2;
                    string3 = this.syntaxEndQuote2;
                }
            } else if (this.syntaxEscape != null) {
                bl2 = true;
            }
        }
        if (string2 != null) {
            stringBuffer = stringBuffer.append(string2);
            int n2 = 0;
            while (n2 < n) {
                if (string.startsWith(string3, n2)) {
                    stringBuffer.append(this.syntaxEscape).append(string3);
                    n2 += string3.length();
                    continue;
                }
                stringBuffer.append(string.charAt(n2++));
            }
            stringBuffer.append(string3);
        } else {
            boolean bl3 = true;
            int n3 = 0;
            while (n3 < n) {
                if (bl3 && this.isA(string, n3, this.syntaxBeginQuote1)) {
                    stringBuffer.append(this.syntaxEscape).append(this.syntaxBeginQuote1);
                    n3 += this.syntaxBeginQuote1.length();
                } else if (bl3 && this.isA(string, n3, this.syntaxBeginQuote2)) {
                    stringBuffer.append(this.syntaxEscape).append(this.syntaxBeginQuote2);
                    n3 += this.syntaxBeginQuote2.length();
                } else if (this.isA(string, n3, this.syntaxEscape)) {
                    if (n3 + this.syntaxEscape.length() >= n) {
                        stringBuffer.append(this.syntaxEscape);
                    } else if (this.isMeta(string, n3 + this.syntaxEscape.length())) {
                        stringBuffer.append(this.syntaxEscape);
                    }
                    stringBuffer.append(this.syntaxEscape);
                    n3 += this.syntaxEscape.length();
                } else if (bl && string.startsWith(this.syntaxSeparator, n3)) {
                    stringBuffer.append(this.syntaxEscape).append(this.syntaxSeparator);
                    n3 += this.syntaxSeparator.length();
                } else if (bl2 && string.startsWith(this.syntaxSeparator2, n3)) {
                    stringBuffer.append(this.syntaxEscape).append(this.syntaxSeparator2);
                    n3 += this.syntaxSeparator2.length();
                } else {
                    stringBuffer.append(string.charAt(n3++));
                }
                bl3 = false;
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            String string = this.syntaxDirection == 2 ? this.stringifyComp((String)this.components.elementAt(n - 1 - i)) : this.stringifyComp((String)this.components.elementAt(i));
            if (i != 0 && this.syntaxSeparator != null) {
                stringBuffer.append(this.syntaxSeparator);
            }
            if (string.length() >= 1) {
                bl = false;
            }
            stringBuffer = stringBuffer.append(string);
        }
        if (bl && n >= 1 && this.syntaxSeparator != null) {
            stringBuffer = stringBuffer.append(this.syntaxSeparator);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        NameImpl nameImpl;
        if (object != null && object instanceof NameImpl && (nameImpl = (NameImpl)object).size() == this.size()) {
            Enumeration enumeration = this.getAll();
            Enumeration enumeration2 = nameImpl.getAll();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)enumeration2.nextElement();
                if (this.syntaxTrimBlanks) {
                    string = string.trim();
                    string2 = string2.trim();
                }
                if (!(this.syntaxCaseInsensitive ? !string.equalsIgnoreCase(string2) : !string.equals(string2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(NameImpl nameImpl) {
        if (this == nameImpl) {
            return 0;
        }
        int n = this.size();
        int n2 = nameImpl.size();
        int n3 = Math.min(n, n2);
        int n4 = 0;
        int n5 = 0;
        while (n3-- != 0) {
            int n6;
            String string = this.get(n4++);
            String string2 = nameImpl.get(n5++);
            if (this.syntaxTrimBlanks) {
                string = string.trim();
                string2 = string2.trim();
            }
            if ((n6 = this.syntaxCaseInsensitive ? string.compareToIgnoreCase(string2) : string.compareTo(string2)) == 0) continue;
            return n6;
        }
        return n - n2;
    }

    public int size() {
        return this.components.size();
    }

    public Enumeration getAll() {
        return this.components.elements();
    }

    public String get(int n) {
        return (String)this.components.elementAt(n);
    }

    public Enumeration getPrefix(int n) {
        if (n < 0 || n > this.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return new NameImplEnumerator(this.components, 0, n);
    }

    public Enumeration getSuffix(int n) {
        int n2 = this.size();
        if (n < 0 || n > n2) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return new NameImplEnumerator(this.components, n, n2);
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    public boolean startsWith(int n, Enumeration enumeration) {
        if (n < 0 || n > this.size()) {
            return false;
        }
        try {
            Enumeration enumeration2 = this.getPrefix(n);
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                String string2 = (String)enumeration.nextElement();
                if (this.syntaxTrimBlanks) {
                    string = string.trim();
                    string2 = string2.trim();
                }
                if (!(this.syntaxCaseInsensitive ? !string.equalsIgnoreCase(string2) : !string.equals(string2))) continue;
                return false;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return true;
    }

    public boolean endsWith(int n, Enumeration enumeration) {
        int n2 = this.size() - n;
        if (n2 < 0 || n2 > this.size()) {
            return false;
        }
        try {
            Enumeration enumeration2 = this.getSuffix(n2);
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                String string2 = (String)enumeration.nextElement();
                if (this.syntaxTrimBlanks) {
                    string = string.trim();
                    string2 = string2.trim();
                }
                if (!(this.syntaxCaseInsensitive ? !string.equalsIgnoreCase(string2) : !string.equals(string2))) continue;
                return false;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return true;
    }

    public boolean addAll(Enumeration enumeration) throws InvalidNameException {
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            try {
                Object e = enumeration.nextElement();
                if (this.size() > 0 && this.syntaxDirection == 0) {
                    throw new InvalidNameException("A flat name can only have a single component");
                }
                this.components.addElement(e);
                bl = true;
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        return bl;
    }

    public boolean addAll(int n, Enumeration enumeration) throws InvalidNameException {
        boolean bl = false;
        int n2 = n;
        while (enumeration.hasMoreElements()) {
            try {
                Object e = enumeration.nextElement();
                if (this.size() > 0 && this.syntaxDirection == 0) {
                    throw new InvalidNameException("A flat name can only have a single component");
                }
                this.components.insertElementAt(e, n2);
                bl = true;
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void add(String string) throws InvalidNameException {
        if (this.size() > 0 && this.syntaxDirection == 0) {
            throw new InvalidNameException("A flat name can only have a single component");
        }
        this.components.addElement(string);
    }

    public void add(int n, String string) throws InvalidNameException {
        if (this.size() > 0 && this.syntaxDirection == 0) {
            throw new InvalidNameException("A flat name can only zero or one component");
        }
        this.components.insertElementAt(string, n);
    }

    public Object remove(int n) {
        Object e = this.components.elementAt(n);
        this.components.removeElementAt(n);
        return e;
    }

    public int hashCode() {
        int n = 0;
        Enumeration enumeration = this.getAll();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.syntaxTrimBlanks) {
                string = string.trim();
            }
            if (this.syntaxCaseInsensitive) {
                string = string.toLowerCase(Locale.ENGLISH);
            }
            n += string.hashCode();
        }
        return n;
    }
}

