/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.io.SerializablePermission;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIIIOPServerImpl
extends RMIServerImpl {
    private static final AccessControlContext STUB_ACC;
    private final Map env;
    private final AccessControlContext callerACC;

    public RMIIIOPServerImpl(Map<String, ?> map) throws IOException {
        super(map);
        this.env = map == null ? Collections.EMPTY_MAP : map;
        this.callerACC = AccessController.getContext();
    }

    @Override
    protected void export() throws IOException {
        PortableRemoteObject.exportObject(this);
    }

    @Override
    protected String getProtocol() {
        return "iiop";
    }

    @Override
    public Remote toStub() throws IOException {
        if (System.getSecurityManager() == null) {
            return PortableRemoteObject.toStub(this);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Remote>(){

                @Override
                public Remote run() throws Exception {
                    return PortableRemoteObject.toStub(RMIIIOPServerImpl.this);
                }
            }, STUB_ACC);
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof NoSuchObjectException) {
                throw (NoSuchObjectException)privilegedActionException.getException();
            }
            throw new RuntimeException("Unexpected exception type", privilegedActionException.getException());
        }
    }

    @Override
    protected RMIConnection makeClient(String string, Subject subject) throws IOException {
        if (string == null) {
            throw new NullPointerException("Null connectionId");
        }
        RMIConnectionImpl rMIConnectionImpl = new RMIConnectionImpl(this, string, this.getDefaultClassLoader(), subject, this.env);
        PortableRemoteObject.exportObject(rMIConnectionImpl);
        return rMIConnectionImpl;
    }

    @Override
    protected void closeClient(RMIConnection rMIConnection) throws IOException {
        PortableRemoteObject.unexportObject(rMIConnection);
    }

    @Override
    protected void closeServer() throws IOException {
        PortableRemoteObject.unexportObject(this);
    }

    @Override
    RMIConnection doNewClient(final Object object) throws IOException {
        if (this.callerACC == null) {
            throw new SecurityException("AccessControlContext cannot be null");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<RMIConnection>(){

                @Override
                public RMIConnection run() throws IOException {
                    return RMIIIOPServerImpl.this.superDoNewClient(object);
                }
            }, this.callerACC);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    RMIConnection superDoNewClient(Object object) throws IOException {
        return super.doNewClient(object);
    }

    static {
        Permissions permissions = new Permissions();
        permissions.add(new SerializablePermission("enableSubclassImplementation"));
        STUB_ACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }
}

