/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectLongBufferRU;
import java.nio.LongBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectLongBufferU
extends LongBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(long[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object viewedBuffer;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectLongBufferU(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.viewedBuffer = directBuffer;
    }

    public LongBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 3;
        assert (n4 >= 0);
        return new DirectLongBufferU(this, -1, 0, n3, n3, n4);
    }

    public LongBuffer duplicate() {
        return new DirectLongBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public LongBuffer asReadOnlyBuffer() {
        return new DirectLongBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int n) {
        return this.address + ((long)n << 3);
    }

    public long get() {
        return unsafe.getLong(this.ix(this.nextGetIndex()));
    }

    public long get(int n) {
        return unsafe.getLong(this.ix(this.checkIndex(n)));
    }

    public LongBuffer get(long[] lArray, int n, int n2) {
        if ((long)n2 << 3 > 6L) {
            int n3;
            DirectLongBufferU.checkBounds(n, n2, lArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToLongArray(this.ix(n4), lArray, (long)n << 3, (long)n2 << 3);
            } else {
                Bits.copyToArray(this.ix(n4), lArray, arrayBaseOffset, (long)n << 3, (long)n2 << 3);
            }
            this.position(n4 + n2);
        } else {
            super.get(lArray, n, n2);
        }
        return this;
    }

    public LongBuffer put(long l) {
        unsafe.putLong(this.ix(this.nextPutIndex()), l);
        return this;
    }

    public LongBuffer put(int n, long l) {
        unsafe.putLong(this.ix(this.checkIndex(n)), l);
        return this;
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer instanceof DirectLongBufferU) {
            int n;
            if (longBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectLongBufferU directLongBufferU = (DirectLongBufferU)longBuffer;
            int n2 = directLongBufferU.position();
            int n3 = directLongBufferU.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directLongBufferU.ix(n2), this.ix(n5), (long)n4 << 3);
            directLongBufferU.position(n2 + n4);
            this.position(n5 + n4);
        } else if (longBuffer.hb != null) {
            int n = longBuffer.position();
            int n8 = longBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(longBuffer.hb, longBuffer.offset + n, n9);
            longBuffer.position(n + n9);
        } else {
            super.put(longBuffer);
        }
        return this;
    }

    public LongBuffer put(long[] lArray, int n, int n2) {
        if ((long)n2 << 3 > 6L) {
            int n3;
            DirectLongBufferU.checkBounds(n, n2, lArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromLongArray(lArray, (long)n << 3, this.ix(n4), (long)n2 << 3);
            } else {
                Bits.copyFromArray(lArray, arrayBaseOffset, (long)n << 3, this.ix(n4), (long)n2 << 3);
            }
            this.position(n4 + n2);
        } else {
            super.put(lArray, n, n2);
        }
        return this;
    }

    public LongBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), (long)n3 << 3);
        this.position(n3);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

