/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.streaming;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.streaming.ContextClassloaderLocal;
import com.sun.xml.internal.ws.streaming.XMLReaderException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.WebServiceException;

public abstract class XMLStreamWriterFactory {
    private static final Logger LOGGER = Logger.getLogger(XMLStreamWriterFactory.class.getName());
    private static volatile ContextClassloaderLocal<XMLStreamWriterFactory> writerFactory = new ContextClassloaderLocal<XMLStreamWriterFactory>(){

        @Override
        protected XMLStreamWriterFactory initialValue() {
            XMLOutputFactory xMLOutputFactory = null;
            if (Boolean.getBoolean(XMLStreamWriterFactory.class.getName() + ".woodstox")) {
                try {
                    xMLOutputFactory = (XMLOutputFactory)Class.forName("com.ctc.wstx.stax.WstxOutputFactory").newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (xMLOutputFactory == null) {
                xMLOutputFactory = XMLOutputFactory.newInstance();
            }
            XMLStreamWriterFactory xMLStreamWriterFactory = null;
            if (!Boolean.getBoolean(XMLStreamWriterFactory.class.getName() + ".noPool")) {
                xMLStreamWriterFactory = Zephyr.newInstance(xMLOutputFactory);
            }
            if (xMLStreamWriterFactory == null && xMLOutputFactory.getClass().getName().equals("com.ctc.wstx.stax.WstxOutputFactory")) {
                xMLStreamWriterFactory = new NoLock(xMLOutputFactory);
            }
            if (xMLStreamWriterFactory == null) {
                xMLStreamWriterFactory = new Default(xMLOutputFactory);
            }
            LOGGER.fine("XMLStreamWriterFactory instance is = " + xMLStreamWriterFactory);
            return xMLStreamWriterFactory;
        }
    };

    public abstract XMLStreamWriter doCreate(OutputStream var1);

    public abstract XMLStreamWriter doCreate(OutputStream var1, String var2);

    public abstract void doRecycle(XMLStreamWriter var1);

    public static void recycle(XMLStreamWriter xMLStreamWriter) {
        XMLStreamWriterFactory.get().doRecycle(xMLStreamWriter);
    }

    @NotNull
    public static XMLStreamWriterFactory get() {
        return writerFactory.get();
    }

    public static void set(@NotNull XMLStreamWriterFactory xMLStreamWriterFactory) {
        if (xMLStreamWriterFactory == null) {
            throw new IllegalArgumentException();
        }
        writerFactory.set(xMLStreamWriterFactory);
    }

    public static XMLStreamWriter create(OutputStream outputStream) {
        return XMLStreamWriterFactory.get().doCreate(outputStream);
    }

    public static XMLStreamWriter create(OutputStream outputStream, String string) {
        return XMLStreamWriterFactory.get().doCreate(outputStream, string);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) {
        return XMLStreamWriterFactory.create(outputStream);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string) {
        return XMLStreamWriterFactory.create(outputStream, string);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string, boolean bl) {
        return XMLStreamWriterFactory.create(outputStream, string);
    }

    public static final class Default
    extends XMLStreamWriterFactory {
        private final XMLOutputFactory xof;

        public Default(XMLOutputFactory xMLOutputFactory) {
            this.xof = xMLOutputFactory;
        }

        public XMLStreamWriter doCreate(OutputStream outputStream) {
            return this.doCreate(outputStream, "UTF-8");
        }

        public synchronized XMLStreamWriter doCreate(OutputStream outputStream, String string) {
            try {
                return this.xof.createXMLStreamWriter(outputStream, string);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        public void doRecycle(XMLStreamWriter xMLStreamWriter) {
        }
    }

    public static final class NoLock
    extends XMLStreamWriterFactory {
        private final XMLOutputFactory xof;

        public NoLock(XMLOutputFactory xMLOutputFactory) {
            this.xof = xMLOutputFactory;
        }

        public XMLStreamWriter doCreate(OutputStream outputStream) {
            return this.doCreate(outputStream, "UTF-8");
        }

        public XMLStreamWriter doCreate(OutputStream outputStream, String string) {
            try {
                return this.xof.createXMLStreamWriter(outputStream, string);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        public void doRecycle(XMLStreamWriter xMLStreamWriter) {
        }
    }

    public static interface RecycleAware {
        public void onRecycled();
    }

    public static final class Zephyr
    extends XMLStreamWriterFactory {
        private final XMLOutputFactory xof;
        private final ThreadLocal<XMLStreamWriter> pool = new ThreadLocal();
        private final Method resetMethod;
        private final Method setOutputMethod;
        private final Class zephyrClass;

        public static XMLStreamWriterFactory newInstance(XMLOutputFactory xMLOutputFactory) {
            try {
                Class<?> clazz = xMLOutputFactory.createXMLStreamWriter(new StringWriter()).getClass();
                if (!clazz.getName().startsWith("com.sun.xml.internal.stream.")) {
                    return null;
                }
                return new Zephyr(xMLOutputFactory, clazz);
            }
            catch (XMLStreamException xMLStreamException) {
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }

        private Zephyr(XMLOutputFactory xMLOutputFactory, Class clazz) throws NoSuchMethodException {
            this.xof = xMLOutputFactory;
            this.zephyrClass = clazz;
            this.setOutputMethod = clazz.getMethod("setOutput", StreamResult.class, String.class);
            this.resetMethod = clazz.getMethod("reset", new Class[0]);
        }

        @Nullable
        private XMLStreamWriter fetch() {
            XMLStreamWriter xMLStreamWriter = this.pool.get();
            if (xMLStreamWriter == null) {
                return null;
            }
            this.pool.set(null);
            return xMLStreamWriter;
        }

        public XMLStreamWriter doCreate(OutputStream outputStream) {
            return this.doCreate(outputStream, "UTF-8");
        }

        public XMLStreamWriter doCreate(OutputStream outputStream, String string) {
            XMLStreamWriter xMLStreamWriter = this.fetch();
            if (xMLStreamWriter != null) {
                try {
                    this.resetMethod.invoke(xMLStreamWriter, new Object[0]);
                    this.setOutputMethod.invoke(xMLStreamWriter, new StreamResult(outputStream), string);
                    return xMLStreamWriter;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new XMLReaderException("stax.cantCreate", new Object[]{illegalAccessException});
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new XMLReaderException("stax.cantCreate", new Object[]{invocationTargetException});
                }
            }
            try {
                return this.xof.createXMLStreamWriter(outputStream, string);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        public void doRecycle(XMLStreamWriter xMLStreamWriter) {
            if (this.zephyrClass.isInstance(xMLStreamWriter)) {
                try {
                    xMLStreamWriter.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new WebServiceException(xMLStreamException);
                }
                this.pool.set(xMLStreamWriter);
            }
            if (xMLStreamWriter instanceof RecycleAware) {
                ((RecycleAware)((Object)xMLStreamWriter)).onRecycled();
            }
        }
    }
}

