/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.PUSH;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ApplyTemplates;
import com.sun.org.apache.xalan.internal.xsltc.compiler.AttributeValueTemplate;
import com.sun.org.apache.xalan.internal.xsltc.compiler.CallTemplate;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Choose;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Comment;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Copy;
import com.sun.org.apache.xalan.internal.xsltc.compiler.CopyOf;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ForEach;
import com.sun.org.apache.xalan.internal.xsltc.compiler.If;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Instruction;
import com.sun.org.apache.xalan.internal.xsltc.compiler.LiteralAttribute;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Number;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Otherwise;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ProcessingInstruction;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SimpleAttributeValue;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SyntaxTreeNode;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Text;
import com.sun.org.apache.xalan.internal.xsltc.compiler.UseAttributeSets;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ValueOf;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Variable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.When;
import com.sun.org.apache.xalan.internal.xsltc.compiler.XslAttribute;
import com.sun.org.apache.xalan.internal.xsltc.compiler.XslElement;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Util;
import com.sun.org.apache.xml.internal.serializer.ElemDesc;
import com.sun.org.apache.xml.internal.serializer.ToHTMLStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.xml.internal.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LiteralElement
extends Instruction {
    private String _name;
    private LiteralElement _literalElemParent = null;
    private List<SyntaxTreeNode> _attributeElements = null;
    private Map<String, String> _accessedPrefixes = null;
    private boolean _allAttributesUnique = false;
    private static final String XMLNS_STRING = "xmlns";

    LiteralElement() {
    }

    public QName getName() {
        return this._qname;
    }

    @Override
    public void display(int n) {
        this.indent(n);
        Util.println("LiteralElement name = " + this._name);
        this.displayContents(n + 4);
    }

    private String accessedNamespace(String string) {
        String string2;
        if (this._literalElemParent != null && (string2 = this._literalElemParent.accessedNamespace(string)) != null) {
            return string2;
        }
        return this._accessedPrefixes != null ? this._accessedPrefixes.get(string) : null;
    }

    public void registerNamespace(String string, String string2, SymbolTable symbolTable, boolean bl) {
        String string3;
        if (this._literalElemParent != null && (string3 = this._literalElemParent.accessedNamespace(string)) != null && string3.equals(string2)) {
            return;
        }
        if (this._accessedPrefixes == null) {
            this._accessedPrefixes = new Hashtable<String, String>();
        } else if (!bl && (string3 = this._accessedPrefixes.get(string)) != null) {
            if (string3.equals(string2)) {
                return;
            }
            string = symbolTable.generateNamespacePrefix();
        }
        if (!string.equals("xml")) {
            this._accessedPrefixes.put(string, string2);
        }
    }

    private String translateQName(QName qName, SymbolTable symbolTable) {
        String string;
        String string2 = qName.getLocalPart();
        String string3 = qName.getPrefix();
        if (string3 == null) {
            string3 = "";
        } else if (string3.equals(XMLNS_STRING)) {
            return XMLNS_STRING;
        }
        String string4 = symbolTable.lookupPrefixAlias(string3);
        if (string4 != null) {
            symbolTable.excludeNamespaces(string3);
            string3 = string4;
        }
        if ((string = this.lookupNamespace(string3)) == null) {
            return string2;
        }
        this.registerNamespace(string3, string, symbolTable, false);
        if (string3 != "") {
            return string3 + ":" + string2;
        }
        return string2;
    }

    public void addAttribute(SyntaxTreeNode syntaxTreeNode) {
        if (this._attributeElements == null) {
            this._attributeElements = new ArrayList<SyntaxTreeNode>(2);
        }
        this._attributeElements.add(syntaxTreeNode);
    }

    public void setFirstAttribute(SyntaxTreeNode syntaxTreeNode) {
        if (this._attributeElements == null) {
            this._attributeElements = new ArrayList<SyntaxTreeNode>(2);
        }
        this._attributeElements.add(0, syntaxTreeNode);
    }

    @Override
    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        if (this._attributeElements != null) {
            for (SyntaxTreeNode syntaxTreeNode : this._attributeElements) {
                syntaxTreeNode.typeCheck(symbolTable);
            }
        }
        this.typeCheckContents(symbolTable);
        return Type.Void;
    }

    public Set<Map.Entry<String, String>> getNamespaceScope(SyntaxTreeNode syntaxTreeNode) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (syntaxTreeNode != null) {
            Map<String, String> map = syntaxTreeNode.getPrefixMapping();
            if (map != null) {
                for (String string : map.keySet()) {
                    if (hashMap.containsKey(string)) continue;
                    hashMap.put(string, map.get(string));
                }
            }
            syntaxTreeNode = syntaxTreeNode.getParent();
        }
        return hashMap.entrySet();
    }

    @Override
    public void parseContents(Parser parser) {
        Object object;
        String string;
        SymbolTable symbolTable = parser.getSymbolTable();
        symbolTable.setCurrentNode(this);
        SyntaxTreeNode syntaxTreeNode = this.getParent();
        if (syntaxTreeNode != null && syntaxTreeNode instanceof LiteralElement) {
            this._literalElemParent = (LiteralElement)syntaxTreeNode;
        }
        this._name = this.translateQName(this._qname, symbolTable);
        int n = this._attributes.getLength();
        for (int i = 0; i < n; ++i) {
            QName qName = parser.getQName(this._attributes.getQName(i));
            String object22 = qName.getNamespace();
            string = this._attributes.getValue(i);
            if (qName == parser.getUseAttributeSets()) {
                if (!Util.isValidQNames(string)) {
                    object = new ErrorMsg("INVALID_QNAME_ERR", (Object)string, this);
                    parser.reportError(3, (ErrorMsg)object);
                }
                this.setFirstAttribute(new UseAttributeSets(string, parser));
                continue;
            }
            if (qName == parser.getExtensionElementPrefixes()) {
                symbolTable.excludeNamespaces(string);
                continue;
            }
            if (qName == parser.getExcludeResultPrefixes()) {
                symbolTable.excludeNamespaces(string);
                continue;
            }
            object = qName.getPrefix();
            if (object != null && ((String)object).equals(XMLNS_STRING) || object == null && qName.getLocalPart().equals(XMLNS_STRING) || object22 != null && object22.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            String string2 = this.translateQName(qName, symbolTable);
            LiteralAttribute literalAttribute = new LiteralAttribute(string2, string, parser, this);
            this.addAttribute(literalAttribute);
            literalAttribute.setParent(this);
            literalAttribute.parseContents(parser);
        }
        Set<Map.Entry<String, String>> set = this.getNamespaceScope(this);
        for (Map.Entry entry : set) {
            string = (String)entry.getKey();
            if (string.equals("xml") || (object = this.lookupNamespace(string)) == null || symbolTable.isExcludedNamespace((String)object)) continue;
            this.registerNamespace(string, (String)object, symbolTable, true);
        }
        this.parseChildren(parser);
        for (int i = 0; i < n; ++i) {
            QName qName = parser.getQName(this._attributes.getQName(i));
            string = this._attributes.getValue(i);
            if (qName == parser.getExtensionElementPrefixes()) {
                symbolTable.unExcludeNamespaces(string);
                continue;
            }
            if (qName != parser.getExcludeResultPrefixes()) continue;
            symbolTable.unExcludeNamespaces(string);
        }
    }

    @Override
    protected boolean contextDependent() {
        return this.dependentContents();
    }

    @Override
    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        this._allAttributesUnique = this.checkAttributesUnique();
        instructionList.append(methodGenerator.loadHandler());
        instructionList.append(new PUSH(constantPoolGen, this._name));
        instructionList.append(DUP2);
        instructionList.append(methodGenerator.startElement());
        int n = 0;
        while (n < this.elementCount()) {
            SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)this.elementAt(n);
            if (syntaxTreeNode instanceof Variable) {
                syntaxTreeNode.translate(classGenerator, methodGenerator);
                this.removeElement(syntaxTreeNode);
                continue;
            }
            ++n;
        }
        if (this._accessedPrefixes != null) {
            boolean bl = false;
            for (Map.Entry<String, String> entry : this._accessedPrefixes.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (string2 == "" && string == "") continue;
                if (string == "") {
                    bl = true;
                }
                instructionList.append(methodGenerator.loadHandler());
                instructionList.append(new PUSH(constantPoolGen, string));
                instructionList.append(new PUSH(constantPoolGen, string2));
                instructionList.append(methodGenerator.namespace());
            }
            if (!bl && this._parent instanceof XslElement && ((XslElement)this._parent).declaresDefaultNS()) {
                instructionList.append(methodGenerator.loadHandler());
                instructionList.append(new PUSH(constantPoolGen, ""));
                instructionList.append(new PUSH(constantPoolGen, ""));
                instructionList.append(methodGenerator.namespace());
            }
        }
        if (this._attributeElements != null) {
            for (SyntaxTreeNode syntaxTreeNode : this._attributeElements) {
                if (syntaxTreeNode instanceof XslAttribute) continue;
                syntaxTreeNode.translate(classGenerator, methodGenerator);
            }
        }
        this.translateContents(classGenerator, methodGenerator);
        instructionList.append(methodGenerator.endElement());
    }

    private boolean isHTMLOutput() {
        return this.getStylesheet().getOutputMethod() == 2;
    }

    public ElemDesc getElemDesc() {
        if (this.isHTMLOutput()) {
            return ToHTMLStream.getElemDesc(this._name);
        }
        return null;
    }

    public boolean allAttributesUnique() {
        return this._allAttributesUnique;
    }

    private boolean checkAttributesUnique() {
        boolean bl = this.canProduceAttributeNodes(this, true);
        if (bl) {
            return false;
        }
        if (this._attributeElements != null) {
            int n = this._attributeElements.size();
            HashMap<String, SyntaxTreeNode> hashMap = null;
            for (int i = 0; i < n; ++i) {
                XslAttribute xslAttribute;
                SyntaxTreeNode syntaxTreeNode;
                SyntaxTreeNode syntaxTreeNode2;
                SyntaxTreeNode syntaxTreeNode3 = this._attributeElements.get(i);
                if (syntaxTreeNode3 instanceof UseAttributeSets) {
                    return false;
                }
                if (!(syntaxTreeNode3 instanceof XslAttribute)) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<String, SyntaxTreeNode>();
                    for (int j = 0; j < i; ++j) {
                        syntaxTreeNode2 = this._attributeElements.get(j);
                        if (!(syntaxTreeNode2 instanceof LiteralAttribute)) continue;
                        syntaxTreeNode = (LiteralAttribute)syntaxTreeNode2;
                        hashMap.put(((LiteralAttribute)syntaxTreeNode).getName(), syntaxTreeNode);
                    }
                }
                if ((syntaxTreeNode2 = (xslAttribute = (XslAttribute)syntaxTreeNode3).getName()) instanceof AttributeValueTemplate) {
                    return false;
                }
                if (!(syntaxTreeNode2 instanceof SimpleAttributeValue)) continue;
                syntaxTreeNode = (SimpleAttributeValue)syntaxTreeNode2;
                String string = ((SimpleAttributeValue)syntaxTreeNode).toString();
                if (string != null && hashMap.get(string) != null) {
                    return false;
                }
                if (string == null) continue;
                hashMap.put(string, xslAttribute);
            }
        }
        return true;
    }

    private boolean canProduceAttributeNodes(SyntaxTreeNode syntaxTreeNode, boolean bl) {
        List<SyntaxTreeNode> list = syntaxTreeNode.getContents();
        for (SyntaxTreeNode syntaxTreeNode2 : list) {
            Object object;
            if (syntaxTreeNode2 instanceof Text) {
                object = (Text)syntaxTreeNode2;
                if (((Text)object).isIgnore()) continue;
                return false;
            }
            if (syntaxTreeNode2 instanceof LiteralElement || syntaxTreeNode2 instanceof ValueOf || syntaxTreeNode2 instanceof XslElement || syntaxTreeNode2 instanceof Comment || syntaxTreeNode2 instanceof Number || syntaxTreeNode2 instanceof ProcessingInstruction) {
                return false;
            }
            if (syntaxTreeNode2 instanceof XslAttribute) {
                if (bl) continue;
                return true;
            }
            if (syntaxTreeNode2 instanceof CallTemplate || syntaxTreeNode2 instanceof ApplyTemplates || syntaxTreeNode2 instanceof Copy || syntaxTreeNode2 instanceof CopyOf) {
                return true;
            }
            if ((syntaxTreeNode2 instanceof If || syntaxTreeNode2 instanceof ForEach) && this.canProduceAttributeNodes(syntaxTreeNode2, false)) {
                return true;
            }
            if (!(syntaxTreeNode2 instanceof Choose)) continue;
            object = syntaxTreeNode2.getContents();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SyntaxTreeNode syntaxTreeNode3 = (SyntaxTreeNode)iterator.next();
                if (!(syntaxTreeNode3 instanceof When) && !(syntaxTreeNode3 instanceof Otherwise) || !this.canProduceAttributeNodes(syntaxTreeNode3, false)) continue;
                return true;
            }
        }
        return false;
    }
}

