/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractLine;
import java.util.Vector;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;

abstract class AbstractMixer
extends AbstractLine
implements Mixer {
    protected static final int PCM = 0;
    protected static final int ULAW = 1;
    protected static final int ALAW = 2;
    private final Mixer.Info mixerInfo;
    protected Line.Info[] sourceLineInfo;
    protected Line.Info[] targetLineInfo;
    private boolean started = false;
    private boolean manuallyOpened = false;
    private final Vector sourceLines = new Vector();
    private final Vector targetLines = new Vector();

    protected AbstractMixer(Mixer.Info info, Control[] controlArray, Line.Info[] infoArray, Line.Info[] infoArray2) {
        super(new Line.Info(Mixer.class), null, controlArray);
        this.mixer = this;
        if (controlArray == null) {
            controlArray = new Control[]{};
        }
        this.mixerInfo = info;
        this.sourceLineInfo = infoArray;
        this.targetLineInfo = infoArray2;
    }

    public final Mixer.Info getMixerInfo() {
        return this.mixerInfo;
    }

    public final Line.Info[] getSourceLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy(this.sourceLineInfo, 0, infoArray, 0, this.sourceLineInfo.length);
        return infoArray;
    }

    public final Line.Info[] getTargetLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.targetLineInfo.length];
        System.arraycopy(this.targetLineInfo, 0, infoArray, 0, this.targetLineInfo.length);
        return infoArray;
    }

    public final Line.Info[] getSourceLineInfo(Line.Info info) {
        int n;
        Vector<Line.Info> vector = new Vector<Line.Info>();
        for (n = 0; n < this.sourceLineInfo.length; ++n) {
            if (!info.matches(this.sourceLineInfo[n])) continue;
            vector.addElement(this.sourceLineInfo[n]);
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        for (n = 0; n < infoArray.length; ++n) {
            infoArray[n] = (Line.Info)vector.elementAt(n);
        }
        return infoArray;
    }

    public final Line.Info[] getTargetLineInfo(Line.Info info) {
        int n;
        Vector<Line.Info> vector = new Vector<Line.Info>();
        for (n = 0; n < this.targetLineInfo.length; ++n) {
            if (!info.matches(this.targetLineInfo[n])) continue;
            vector.addElement(this.targetLineInfo[n]);
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        for (n = 0; n < infoArray.length; ++n) {
            infoArray[n] = (Line.Info)vector.elementAt(n);
        }
        return infoArray;
    }

    public final boolean isLineSupported(Line.Info info) {
        int n;
        for (n = 0; n < this.sourceLineInfo.length; ++n) {
            if (!info.matches(this.sourceLineInfo[n])) continue;
            return true;
        }
        for (n = 0; n < this.targetLineInfo.length; ++n) {
            if (!info.matches(this.targetLineInfo[n])) continue;
            return true;
        }
        return false;
    }

    public abstract Line getLine(Line.Info var1) throws LineUnavailableException;

    public abstract int getMaxLines(Line.Info var1);

    protected abstract void implOpen() throws LineUnavailableException;

    protected abstract void implStart();

    protected abstract void implStop();

    protected abstract void implClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Line[] getSourceLines() {
        Line[] lineArray;
        Vector vector = this.sourceLines;
        synchronized (vector) {
            lineArray = new Line[this.sourceLines.size()];
            for (int i = 0; i < lineArray.length; ++i) {
                lineArray[i] = (Line)this.sourceLines.elementAt(i);
            }
        }
        return lineArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Line[] getTargetLines() {
        Line[] lineArray;
        Vector vector = this.targetLines;
        synchronized (vector) {
            lineArray = new Line[this.targetLines.size()];
            for (int i = 0; i < lineArray.length; ++i) {
                lineArray[i] = (Line)this.targetLines.elementAt(i);
            }
        }
        return lineArray;
    }

    public final void synchronize(Line[] lineArray, boolean bl) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public final void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public final boolean isSynchronizationSupported(Line[] lineArray, boolean bl) {
        return false;
    }

    public final synchronized void open() throws LineUnavailableException {
        this.open(true);
    }

    final synchronized void open(boolean bl) throws LineUnavailableException {
        if (!this.isOpen()) {
            this.implOpen();
            this.setOpen(true);
            if (bl) {
                this.manuallyOpened = true;
            }
        }
    }

    final synchronized void open(Line line) throws LineUnavailableException {
        if (this.equals(line)) {
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.open(false);
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo()) && !this.targetLines.contains(line)) {
            this.open(false);
            this.targetLines.addElement(line);
        }
    }

    final synchronized void close(Line line) {
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty() && !this.manuallyOpened) {
            this.close();
        }
    }

    public final synchronized void close() {
        if (this.isOpen()) {
            int n;
            Line[] lineArray = this.getSourceLines();
            for (n = 0; n < lineArray.length; ++n) {
                lineArray[n].close();
            }
            lineArray = this.getTargetLines();
            for (n = 0; n < lineArray.length; ++n) {
                lineArray[n].close();
            }
            this.implClose();
            this.setOpen(false);
        }
        this.manuallyOpened = false;
    }

    final synchronized void start(Line line) {
        if (this.equals(line)) {
            return;
        }
        if (!this.started) {
            this.implStart();
            this.started = true;
        }
    }

    final synchronized void stop(Line line) {
        if (this.equals(line)) {
            return;
        }
        Vector vector = (Vector)this.sourceLines.clone();
        for (int i = 0; i < vector.size(); ++i) {
            AbstractDataLine abstractDataLine;
            if (!(vector.elementAt(i) instanceof AbstractDataLine) || !(abstractDataLine = (AbstractDataLine)vector.elementAt(i)).isStartedRunning() || abstractDataLine.equals(line)) continue;
            return;
        }
        Vector vector2 = (Vector)this.targetLines.clone();
        for (int i = 0; i < vector2.size(); ++i) {
            AbstractDataLine abstractDataLine;
            if (!(vector2.elementAt(i) instanceof AbstractDataLine) || !(abstractDataLine = (AbstractDataLine)vector2.elementAt(i)).isStartedRunning() || abstractDataLine.equals(line)) continue;
            return;
        }
        this.started = false;
        this.implStop();
    }

    boolean isSourceLine(Line.Info info) {
        for (int i = 0; i < this.sourceLineInfo.length; ++i) {
            if (!info.matches(this.sourceLineInfo[i])) continue;
            return true;
        }
        return false;
    }

    final boolean isTargetLine(Line.Info info) {
        for (int i = 0; i < this.targetLineInfo.length; ++i) {
            if (!info.matches(this.targetLineInfo[i])) continue;
            return true;
        }
        return false;
    }

    final Line.Info getLineInfo(Line.Info info) {
        int n;
        if (info == null) {
            return null;
        }
        for (n = 0; n < this.sourceLineInfo.length; ++n) {
            if (!info.matches(this.sourceLineInfo[n])) continue;
            return this.sourceLineInfo[n];
        }
        for (n = 0; n < this.targetLineInfo.length; ++n) {
            if (!info.matches(this.targetLineInfo[n])) continue;
            return this.targetLineInfo[n];
        }
        return null;
    }
}

