/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.cache.AssociationDesc;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import sun.awt.AppContext;

public class AppInfo {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_APPLET = 2;
    public static final int TYPE_LIBRARY = 3;
    public static final int TYPE_INSTALLER = 4;
    public static final int ICON_SIZE = 48;
    public static final int TITLE_MAX = 40;
    public static final int VENDOR_MAX = 40;
    public static final int URL_MAX = 80;
    private static final String JNLP_FROM_UNKNOWN_SOURCE = "tag93872907981234for.jnlp";
    private int type = 0;
    private String title = null;
    private String vendor = null;
    private URL from = null;
    private URL mainJNLP = null;
    private URL documentBase = null;
    private URL iconRef = null;
    private String iconVersion = null;
    private boolean desktopHint = false;
    private boolean menuHint = false;
    private String submenu = null;
    private AssociationDesc[] associations = new AssociationDesc[0];
    private URL lapURL = null;

    public AppInfo() {
        this.type = 2;
        AppContext appContext = AppContext.getAppContext();
        Object object = appContext.get("deploy.trust.decider.app.name");
        if (object != null) {
            this.title = object.toString();
        }
    }

    public AppInfo(int n, String string, String string2, URL uRL, URL uRL2, URL uRL3, String string3, boolean bl, boolean bl2, String string4, AssociationDesc[] associationDescArray) {
        this.type = n;
        this.title = string;
        this.vendor = string2;
        this.from = uRL;
        this.mainJNLP = uRL2;
        this.iconRef = uRL3;
        this.iconVersion = string3;
        this.desktopHint = bl;
        this.menuHint = bl2;
        this.submenu = string4;
        this.associations = associationDescArray;
        this.lapURL = uRL;
    }

    private AppInfo(AppInfo appInfo) {
        this.type = appInfo.type;
        this.title = appInfo.title;
        this.vendor = appInfo.vendor;
        this.from = appInfo.from;
        this.mainJNLP = appInfo.mainJNLP;
        this.documentBase = appInfo.documentBase;
        this.iconRef = appInfo.iconRef;
        this.iconVersion = appInfo.iconVersion;
        this.desktopHint = appInfo.desktopHint;
        this.menuHint = appInfo.menuHint;
        this.submenu = appInfo.submenu;
        this.associations = appInfo.associations;
        this.lapURL = appInfo.lapURL;
    }

    private String limitString(String string, int n) {
        if (string != null && string.length() > n) {
            return string.substring(0, n - 4) + " ...";
        }
        return string;
    }

    public int getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVendor() {
        return this.vendor;
    }

    public URL getFrom() {
        return this.from;
    }

    public URL getMainJNLP() {
        return this.mainJNLP;
    }

    public URL getDocumentBase() {
        return this.documentBase;
    }

    public URL getIconRef() {
        return this.iconRef;
    }

    public String getIconVersion() {
        return this.iconVersion;
    }

    public boolean getDesktopHint() {
        return this.desktopHint;
    }

    public boolean getMenuHint() {
        return this.menuHint;
    }

    public String getSubmenu() {
        return this.submenu;
    }

    public AssociationDesc[] getAssociations() {
        return this.associations;
    }

    public URL getLapURL() {
        return this.lapURL;
    }

    public String getDisplayTitle() {
        return this.limitString(this.title, 40);
    }

    public String getDisplayVendor() {
        return this.limitString(this.vendor, 40);
    }

    public String getDisplayFrom() {
        return AppInfo.truncatedURL(this.from);
    }

    public String getDisplayMainJNLP() {
        if (this.isJNLPSourceUnknown()) {
            return ResourceManager.getMessage("deployment.dialog.jnlp.downloaded");
        }
        return AppInfo.truncatedURL(this.mainJNLP);
    }

    public String getDisplayMainJNLPTooltip() {
        String string = "";
        if (this.isJNLPSourceUnknown()) {
            string = ResourceManager.getMessage("deployment.dialog.jnlp.downloaded.tooltip");
        } else if (this.mainJNLP != null) {
            string = this.getMainJNLP().toString();
        }
        return string;
    }

    private boolean isJNLPSourceUnknown() {
        return this.mainJNLP != null && this.mainJNLP.getProtocol().equals("file");
    }

    public String getDisplayDocumentBase() {
        return AppInfo.truncatedURL(this.documentBase);
    }

    public boolean shouldDisplayMainJNLP() {
        if (this.mainJNLP == null) {
            return false;
        }
        return this.isDifferent(this.from, this.mainJNLP);
    }

    public boolean shouldDisplayDocumentBase() {
        if (this.documentBase == null || "file".equals(this.documentBase.getProtocol()) && "".equals(this.documentBase.getHost())) {
            return false;
        }
        if (this.mainJNLP == null) {
            return this.isDifferent(this.from, this.documentBase);
        }
        return this.isDifferent(this.from, this.documentBase) && this.isDifferent(this.mainJNLP, this.documentBase);
    }

    private boolean isDifferent(URL uRL, URL uRL2) {
        return !uRL.getHost().equals(uRL2.getHost()) || uRL.getPort() != uRL2.getPort() || !uRL.getProtocol().equals(uRL2.getProtocol());
    }

    public boolean isMultiHost() {
        return this.shouldDisplayDocumentBase() || this.shouldDisplayMainJNLP();
    }

    public URL[] getMultiHostUrls() {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        linkedList.add(this.getFrom());
        if (this.shouldDisplayMainJNLP()) {
            linkedList.add(this.getMainJNLP());
        }
        if (this.shouldDisplayDocumentBase()) {
            linkedList.add(this.getDocumentBase());
        }
        return linkedList.toArray(new URL[linkedList.size()]);
    }

    public static String truncatedURL(URL uRL) {
        int n;
        if (uRL == null) {
            return "";
        }
        String string = uRL.getProtocol() + "://" + uRL.getHost();
        int n2 = uRL.getPort();
        if (n2 != -1) {
            string = string + ":" + Integer.toString(n2);
        }
        if ((n = string.length()) <= 80) {
            return string;
        }
        return string.substring(0, 77) + "...";
    }

    public void setTitleFromJar(URL uRL, String string) {
        if (uRL == null) {
            Trace.println("Location is null, setting title to blank");
            this.setTitle("");
            return;
        }
        try {
            Object object;
            JarFile jarFile = null;
            Object object2 = null;
            object2 = Cache.isCacheEnabled() ? Cache.getCacheEntry(uRL, null, string) : MemoryCache.getLoadedResource(uRL.toString());
            if (object2 instanceof CacheEntry) {
                object = (CacheEntry)object2;
                jarFile = ((CacheEntry)object).getJarFile();
            } else if (object2 instanceof JarFile) {
                jarFile = (JarFile)object2;
            } else {
                this.setTitle("");
                return;
            }
            object = "";
            object = jarFile.getManifest().getMainAttributes().getValue("Application-Name");
            if (object == null) {
                Trace.println("Missing Application Name: manifest attribute for: " + uRL);
                object = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            }
            this.setTitle((String)object);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public void setFrom(URL uRL) {
        this.from = uRL;
    }

    public void setMainJNLP(URL uRL) {
        this.mainJNLP = uRL;
    }

    public void setDocumentBase(URL uRL) {
        this.documentBase = uRL;
    }

    public void setIconRef(URL uRL) {
        this.iconRef = uRL;
    }

    public void setIconVersion(String string) {
        this.iconVersion = string;
    }

    public void setDesktopHint(boolean bl) {
        this.desktopHint = bl;
    }

    public void setMenuHint(boolean bl) {
        this.menuHint = bl;
    }

    public void setSubmenu(String string) {
        this.submenu = string;
    }

    public void setAssociations(AssociationDesc[] associationDescArray) {
        this.associations = associationDescArray;
    }

    public void setLapURL(URL uRL) {
        this.lapURL = uRL;
    }

    public static AppInfo createSingleHostAppInfo(AppInfo appInfo) {
        AppInfo appInfo2 = new AppInfo(appInfo);
        appInfo2.setDocumentBase(null);
        appInfo2.setMainJNLP(null);
        return appInfo2;
    }

    public static URL getJNLPFromUnknownSource() {
        try {
            return new File("", JNLP_FROM_UNKNOWN_SOURCE).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }
}

