/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.util.Trace;
import java.io.IOException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import sun.security.validator.PKIXValidator;

final class DeployCertPathChecker
extends PKIXCertPathChecker {
    private int remainingCerts;
    private PKIXValidator pv;
    private static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final Set extSet = Collections.singleton("2.16.840.1.113730.1.1");
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";

    DeployCertPathChecker(PKIXValidator pKIXValidator) {
        this.pv = pKIXValidator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        String string = null;
        if (collection != null && !collection.isEmpty()) {
            collection.remove(OID_NETSCAPE_CERT_TYPE);
        }
        --this.remainingCerts;
        if (this.remainingCerts == 0) {
            return;
        }
        try {
            if (x509Certificate.getExtensionValue(OID_BASIC_CONSTRAINTS) != null) {
                if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) == null) return;
                if (CertUtils.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) return;
                Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.bitvalue");
                string = ResourceManager.getMessage("trustdecider.check.basicconstraints.bitvalue");
                throw new CertPathValidatorException(string);
            }
            if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null) {
                if (CertUtils.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) return;
                Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.certtypebit");
                string = ResourceManager.getMessage("trustdecider.check.basicconstraints.certtypebit");
                throw new CertPathValidatorException(string);
            }
            Trace.msgSecurityPrintln("trustdecider.check.basicconstraints.extensionvalue");
            string = ResourceManager.getMessage("trustdecider.check.basicconstraints.extensionvalue");
            throw new CertPathValidatorException(string);
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException();
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException();
        }
    }

    public Set getSupportedExtensions() {
        return extSet;
    }

    public boolean isForwardCheckingSupported() {
        return true;
    }

    public void init(boolean bl) throws CertPathValidatorException {
        this.remainingCerts = this.pv.getCertPathLength();
    }
}

