/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.HashMap;

public class BrowserKeystore {
    private static Object cryptoManager = null;
    private static boolean initializeJSS = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$reflect$InvocationHandler;
    static /* synthetic */ Class array$C;

    public static void registerSecurityProviders() {
        if (Config.isJavaVersionAtLeast15()) {
            Provider provider;
            Class<?> clazz;
            Service service = ServiceManager.getService();
            if (service.isIExplorer()) {
                try {
                    clazz = Class.forName("com.sun.deploy.security.MSCryptoProvider", true, ClassLoader.getSystemClassLoader());
                    if (clazz != null) {
                        provider = (Provider)clazz.newInstance();
                        Security.insertProviderAt(provider, Security.getProviders().length + 1);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (service.isNetscape()) {
                if (BrowserKeystore.isJSSCryptoConfigured()) {
                    Trace.msgSecurityPrintln("browserkeystore.jss.config");
                    try {
                        clazz = Class.forName("com.sun.deploy.security.MozillaJSSProvider", true, ClassLoader.getSystemClassLoader());
                        if (clazz != null) {
                            provider = (Provider)clazz.newInstance();
                            Security.insertProviderAt(provider, Security.getProviders().length + 1);
                        }
                    }
                    catch (Throwable throwable) {
                        Trace.msgSecurityPrintln("browserkeystore.jss.notconfig");
                    }
                } else {
                    Trace.msgSecurityPrintln("browserkeystore.jss.notconfig");
                }
            }
        }
    }

    static synchronized Object getJSSCryptoManager() {
        if (cryptoManager == null && !initializeJSS) {
            initializeJSS = true;
            String string = null;
            string = Config.getInstance().isBrowserFireFox() ? Config.getInstance().getFireFoxUserProfileDirectory() : Config.getInstance().getMozillaUserProfileDirectory();
            Trace.msgSecurityPrintln("browserkeystore.mozilla.dir", new Object[]{string});
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName("org.mozilla.jss.CryptoManager$InitializationValues", true, ClassLoader.getSystemClassLoader());
                    Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BrowserKeystore.class$("java.lang.String")) : class$java$lang$String);
                    Object obj = constructor.newInstance(string);
                    Field field = clazz.getField("installJSSProvider");
                    field.setBoolean(obj, false);
                    Class<?> clazz2 = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
                    Method method = clazz2.getMethod("initialize", clazz);
                    Object object = method.invoke(null, obj);
                    Method method2 = clazz2.getMethod("getInstance", null);
                    Object object2 = method2.invoke(null, null);
                    Class<?> clazz3 = Class.forName("org.mozilla.jss.util.PasswordCallback", true, ClassLoader.getSystemClassLoader());
                    Method method3 = clazz2.getMethod("setPasswordCallback", clazz3);
                    JSSPasswordCallbackInvocationHandler jSSPasswordCallbackInvocationHandler = new JSSPasswordCallbackInvocationHandler();
                    Class<?> clazz4 = Proxy.getProxyClass(ClassLoader.getSystemClassLoader(), clazz3);
                    Object obj2 = clazz4.getConstructor(class$java$lang$reflect$InvocationHandler == null ? (class$java$lang$reflect$InvocationHandler = BrowserKeystore.class$("java.lang.reflect.InvocationHandler")) : class$java$lang$reflect$InvocationHandler).newInstance(jSSPasswordCallbackInvocationHandler);
                    method3.invoke(object2, obj2);
                    cryptoManager = object2;
                    Trace.msgSecurityPrintln("browserkeystore.jss.yes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Trace.msgSecurityPrintln("browserkeystore.jss.no");
                    return null;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Trace.msgSecurityPrintln("browserkeystore.jss.no");
                    return null;
                }
            }
        }
        return cryptoManager;
    }

    public static boolean isJSSCryptoConfigured() {
        return BrowserKeystore.getJSSCryptoManager() != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class JSSPasswordCallbackInvocationHandler
    implements InvocationHandler {
        private HashMap passwordAttempts = new HashMap();

        private JSSPasswordCallbackInvocationHandler() {
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2;
            if (objectArray != null && objectArray[0] != null) {
                object2 = objectArray[0];
                Class<?> clazz = object2.getClass();
                Method method2 = clazz.getMethod("getName", null);
                String string = (String)method2.invoke(object2, null);
                String string2 = method.getName();
                Integer n = (Integer)this.passwordAttempts.get(string);
                if (n == null || n < 2) {
                    if (n == null) {
                        this.passwordAttempts.put(string, new Integer(1));
                    } else {
                        this.passwordAttempts.put(string, new Integer(n + 1));
                    }
                    char[] cArray = this.getPasswordDialog(string);
                    Class<?> clazz2 = Class.forName("org.mozilla.jss.util.Password", true, ClassLoader.getSystemClassLoader());
                    Class[] classArray = new Class[]{array$C == null ? (array$C = BrowserKeystore.class$("[C")) : array$C};
                    Constructor<?> constructor = clazz2.getConstructor(classArray);
                    if (cArray != null) {
                        Object[] objectArray2 = new Object[]{cArray};
                        return constructor.newInstance(objectArray2);
                    }
                }
            }
            object2 = Class.forName("org.mozilla.jss.util.PasswordCallback$GiveUpException", true, ClassLoader.getSystemClassLoader());
            throw (Throwable)((Class)object2).newInstance();
        }

        private char[] getPasswordDialog(String string) {
            MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage("browserkeystore.password.dialog.text"));
            Object[] objectArray = new Object[]{string};
            String string2 = messageFormat.format(objectArray);
            CredentialInfo credentialInfo = UIFactory.showPasswordDialog(null, ResourceManager.getMessage("password.dialog.title"), string2, false, false, null, false);
            if (credentialInfo == null) {
                return null;
            }
            return credentialInfo.getPassword();
        }
    }
}

