/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.panel.CertificatesDialog;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class SecurityPanel
extends JPanel {
    public SecurityPanel() {
        this.initComponents();
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(new TitledBorder(new EtchedBorder()), this.getMessage("security.certificates.border.text"), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(this.getMessage("security.certificates.restore_button.text"));
        jButton.setMnemonic(ResourceManager.getVKCode("security.certificates.restore_button.mnemonic"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityPanel.this.certsRestoreBtnActionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText(this.getMessage("security.certs_restore_btn.tooltip"));
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(this.getMessage("security.certificates.button.text"));
        jButton2.setMnemonic(ResourceManager.getVKCode("security.certificates.button.mnemonic"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecurityPanel.this.certsBtnActionPerformed(actionEvent);
            }
        });
        jButton2.setToolTipText(this.getMessage("security.certs_btn.tooltip"));
        jPanel2.add(jButton2);
        JSmartTextArea jSmartTextArea = new JSmartTextArea(this.getMessage("security.certificates.desc.text"));
        jPanel.add((Component)jSmartTextArea, "North");
        jPanel.add((Component)jPanel2, "Center");
        this.add((Component)jPanel, "Center");
    }

    private void certsBtnActionPerformed(ActionEvent actionEvent) {
        CertificatesDialog certificatesDialog = new CertificatesDialog((Frame)((JFrame)this.getTopLevelAncestor()), true);
        certificatesDialog.setLocationRelativeTo(this);
        certificatesDialog.setVisible(true);
    }

    private void certsRestoreBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        int n = UIFactory.showWarningDialog(this.getTopLevelAncestor(), null, ResourceManager.getString("cert.restore_dialog.masthead"), ResourceManager.getString("cert.restore_dialog.message"), ResourceManager.getString("cert.restore_dialog.title"), ResourceManager.getString("cert.restore_dialog.btn_restore.text"), ResourceManager.getString("cert.restore_dialog.btn_cancel.text"), 1);
        if (n == 0 && !(bl = this.restoreSecurityPrompt())) {
            this.showRestoringSecurityPromptFailDialog();
        }
    }

    private boolean restoreSecurityPrompt() {
        CertStore certStore = DeploySigningCertStore.getUserCertStore();
        boolean bl = true;
        bl = bl && this.clearCertStore(certStore);
        bl = bl && Cache.removeRemeberedDecisions();
        return bl;
    }

    private boolean clearCertStore(CertStore certStore) {
        boolean bl = true;
        try {
            certStore.load(true);
            Collection collection = certStore.getCertificates();
            if (collection != null && collection.size() > 0) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    certStore.remove((Certificate)iterator.next());
                }
                certStore.save();
            }
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            bl = false;
        }
        return bl;
    }

    private void showRestoringSecurityPromptFailDialog() {
        UIFactory.showInformationDialog(this.getTopLevelAncestor(), ResourceManager.getMessage("cert.restore_dialog.fail.masthead"), ResourceManager.getMessage("cert.restore_dialog.fail.text"), ResourceManager.getMessage("cert.restore_dialog.fail.caption"));
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }
}

