/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.BaseLocalApplicationProperties;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class DefaultLocalApplicationProperties
extends BaseLocalApplicationProperties {
    private boolean _dirty;
    private long _lastAccessed;

    public DefaultLocalApplicationProperties(URL uRL, String string, boolean bl) {
        super(uRL, string, bl);
        this._properties = this.getLocalApplicationPropertiesStorage(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, String string2) {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            this._dirty = true;
            super.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesNewVersionExist() {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            long l = Cache.getLastAccessed(Environment.isSystemCacheMode());
            if (l == 0L) {
                return false;
            }
            if (l > this._lastAccessed) {
                return true;
            }
        }
        return false;
    }

    public synchronized void store() throws IOException {
        this.putLocalApplicationPropertiesStorage(this, this._properties);
        this._dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIfNecessary() {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            if (!this._dirty && this.doesNewVersionExist()) {
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            Properties properties;
            this._properties = properties = this.getLocalApplicationPropertiesStorage(this);
            this._dirty = false;
        }
    }

    private Properties getLocalApplicationPropertiesStorage(DefaultLocalApplicationProperties defaultLocalApplicationProperties) {
        Properties properties = new Properties();
        try {
            URL uRL = defaultLocalApplicationProperties.getLocation();
            String string = defaultLocalApplicationProperties.getVersionId();
            if (uRL != null) {
                char c = defaultLocalApplicationProperties.isApplicationDescriptor() ? (char)'A' : 'E';
                byte[] byArray = Cache.getLapData(c, uRL, string, true);
                if (byArray != null) {
                    properties.load(new ByteArrayInputStream(byArray));
                    String string2 = (String)properties.get("locallyInstalled");
                    if (string2 != null) {
                        this._isLocallyInstalledSystem = Boolean.valueOf(string2);
                    }
                }
                if ((byArray = Cache.getLapData(c, uRL, string, false)) != null) {
                    properties.load(new ByteArrayInputStream(byArray));
                }
                this._lastAccessed = System.currentTimeMillis();
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        return properties;
    }

    private void putLocalApplicationPropertiesStorage(DefaultLocalApplicationProperties defaultLocalApplicationProperties, Properties properties) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, "LAP");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byteArrayOutputStream.close();
        char c = defaultLocalApplicationProperties.isApplicationDescriptor() ? (char)'A' : 'E';
        Cache.putLapData(c, defaultLocalApplicationProperties.getLocation(), defaultLocalApplicationProperties.getVersionId(), byteArrayOutputStream.toByteArray());
        this._lastAccessed = System.currentTimeMillis();
    }
}

