/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.xml;

import hr.iii.fiskal.AppContext;
import hr.iii.fiskal.AppKeyStoreException;
import hr.iii.fiskal.xml.Request;
import hr.iii.fiskal.xml.XmlRecordException;
import hr.iii.fiskal.xml.XmlRecordSignException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SignedRequest
extends Request {
    protected void sign() throws XmlRecordSignException {
        String idZaglavlja = this.getReferenceId();
        try {
            String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
            String keyName = this.getOIB();
            KeyStore.PrivateKeyEntry keyEntry = AppContext.getContext().getPrivateKey(keyName);
            if (keyEntry == null) {
                throw new XmlRecordSignException(XmlRecordException.POGRESAN_OIB, "Nepoznati OIB, certifikat nije pronadjen");
            }
            ArrayList<Transform> transforms = new ArrayList<Transform>();
            transforms.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            transforms.add(fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null));
            Reference ref = fac.newReference("#" + idZaglavlja, fac.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null), transforms, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null), Collections.singletonList(ref));
            X509Certificate cert = (X509Certificate)keyEntry.getCertificate();
            KeyInfoFactory keyInfoFactory = fac.getKeyInfoFactory();
            ArrayList<Object> x509Content = new ArrayList<Object>();
            X509IssuerSerial issuer = keyInfoFactory.newX509IssuerSerial(cert.getIssuerX500Principal().getName(), cert.getSerialNumber());
            x509Content.add(cert);
            x509Content.add(issuer);
            X509Data xd = keyInfoFactory.newX509Data(x509Content);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(xd));
            XMLSignature signature = fac.newXMLSignature(si, keyInfo);
            DOMSignContext dsc = new DOMSignContext(keyEntry.getPrivateKey(), (Node)this.getDocument().getDocumentElement());
            signature.sign(dsc);
        }
        catch (InstantiationException e) {
            throw new XmlRecordSignException(XmlRecordException.INTERNA_GRESKA, e.getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new XmlRecordSignException(XmlRecordException.INTERNA_GRESKA, e.getMessage(), e.getCause());
        }
        catch (ClassNotFoundException e) {
            throw new XmlRecordSignException(XmlRecordException.INTERNA_GRESKA, e.getMessage(), e.getCause());
        }
        catch (NoSuchAlgorithmException e) {
            throw new XmlRecordSignException(XmlRecordException.NEISPRAVAN_CERTIFIKAT, e.getMessage(), e.getCause());
        }
        catch (UnrecoverableEntryException e) {
            throw new XmlRecordSignException(XmlRecordException.INTERNA_GRESKA, e.getMessage(), e.getCause());
        }
        catch (KeyStoreException e) {
            throw new XmlRecordSignException(XmlRecordException.NEISPRAVAN_KEYSTORE, e.getMessage(), e.getCause());
        }
        catch (AppKeyStoreException e) {
            throw new XmlRecordSignException(XmlRecordException.INTERNA_GRESKA, e.getMessage(), e.getCause());
        }
        catch (MarshalException e) {
            throw new XmlRecordSignException(XmlRecordException.INTERNA_GRESKA, e.getMessage(), e.getCause());
        }
        catch (XMLSignatureException e) {
            throw new XmlRecordSignException(XmlRecordException.NEISPRAVAN_CERTIFIKAT, e.getMessage(), e.getCause());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new XmlRecordSignException(XmlRecordException.INTERNA_GRESKA, e.getMessage(), e.getCause());
        }
    }

    protected void setRequestId() {
        Node zaglavlje;
        Node uuid = this.getDocument().getElementsByTagName("tns:IdPoruke").item(0);
        if (uuid == null && (zaglavlje = this.getDocument().getElementsByTagName("tns:Zaglavlje").item(0)) != null) {
            uuid = this.getDocument().createElement("tns:IdPoruke");
            zaglavlje.insertBefore(uuid, zaglavlje.getFirstChild());
        }
        if (uuid.getTextContent().isEmpty()) {
            uuid.setTextContent(UUID.randomUUID().toString());
        }
    }

    public String getOIB() {
        String testOIB = AppContext.getContext().getTestOIB();
        Node oib = this.getDocument().getElementsByTagName("tns:Oib").item(0);
        if (testOIB != null && testOIB.length() > 0) {
            oib.setTextContent(testOIB);
        }
        return oib.getTextContent();
    }

    private String getReferenceId() {
        Element zaglavlje = (Element)this.getDocument().getElementsByTagName(this.getReferenceName()).item(0);
        zaglavlje.setAttribute("Id", "idReference");
        zaglavlje.setIdAttribute("Id", true);
        return "idReference";
    }

    protected String getReferenceName() {
        return this.getTag();
    }
}

