/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.xml;

import hr.iii.fiskal.AppContext;
import hr.iii.fiskal.AppKeyStoreException;
import hr.iii.fiskal.xml.SignedRequest;
import hr.iii.fiskal.xml.XmlRecordException;
import hr.iii.fiskal.xml.XmlRecordSignException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import org.w3c.dom.Node;

public class PrateciDokumentRequest
extends SignedRequest {
    public static final String TAG = "tns:PrateciDokumentiZahtjev";

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public void prepareRequest() throws XmlRecordSignException {
        this.setRequestId();
        this.setProtectedCode();
        this.sign();
    }

    protected void setProtectedCode() throws XmlRecordSignException {
        String oib;
        Node racun;
        Node kod = this.getDocument().getElementsByTagName("tns:ZastKodPD").item(0);
        if (kod == null && (racun = this.getDocument().getElementsByTagName("tns:PrateciDokument").item(0)) != null) {
            kod = this.getDocument().createElement("tns:ZastKodPD");
            Node NakDost = this.getDocument().getElementsByTagName("tns:NakDost").item(0);
            racun.insertBefore(kod, NakDost);
        }
        if (kod == null) {
            return;
        }
        if (!kod.getTextContent().isEmpty()) {
            return;
        }
        String medjurezultat = oib = this.getOIB();
        String datumVrijeme = this.getDocument().getElementsByTagName("tns:DatVrijeme").item(0).getTextContent();
        medjurezultat = medjurezultat + datumVrijeme.substring(0, 10) + " " + datumVrijeme.substring(11);
        medjurezultat = medjurezultat + this.getDocument().getElementsByTagName("tns:BrOznPD").item(0).getTextContent();
        medjurezultat = medjurezultat + this.getDocument().getElementsByTagName("tns:OznPosPr").item(0).getTextContent();
        medjurezultat = medjurezultat + this.getDocument().getElementsByTagName("tns:OznNapUr").item(0).getTextContent();
        medjurezultat = medjurezultat + this.getDocument().getElementsByTagName("tns:IznosUkupno").item(0).getTextContent();
        try {
            Signature strSig = Signature.getInstance("SHA256withRSA");
            KeyStore.PrivateKeyEntry keyEntry = AppContext.getContext().getPrivateKey(oib);
            if (keyEntry == null) {
                throw new XmlRecordSignException(XmlRecordException.POGRESAN_OIB, "Nepoznati OIB, certifikat nije pronadjen");
            }
            strSig.initSign(keyEntry.getPrivateKey());
            strSig.update(medjurezultat.getBytes());
            String signed = new String(strSig.sign());
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] digest = md5.digest(signed.getBytes());
            String rezultatIspis = PrateciDokumentRequest.toHex(digest);
            kod.setTextContent(rezultatIspis);
        }
        catch (UnrecoverableEntryException e) {
            throw new XmlRecordSignException(XmlRecordException.NEISPRAVAN_KEYSTORE, e.getMessage(), e.getCause());
        }
        catch (AppKeyStoreException e) {
            throw new XmlRecordSignException(XmlRecordException.NEISPRAVAN_KEYSTORE, e.getMessage(), e.getCause());
        }
        catch (InvalidKeyException e) {
            throw new XmlRecordSignException(XmlRecordException.NEISPRAVAN_CERTIFIKAT, e.getMessage(), e.getCause());
        }
        catch (SignatureException e) {
            throw new XmlRecordSignException(XmlRecordException.NEISPRAVAN_CERTIFIKAT, e.getMessage(), e.getCause());
        }
        catch (KeyStoreException e) {
            throw new XmlRecordSignException(XmlRecordException.POGRESAN_OIB, e.getMessage(), e.getCause());
        }
        catch (NoSuchAlgorithmException e) {
            throw new XmlRecordSignException(XmlRecordException.INTERNA_GRESKA, e.getMessage(), e.getCause());
        }
    }

    private static String toHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (int i = 0; i < a.length; ++i) {
            sb.append(Character.forDigit((a[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(a[i] & 0xF, 16));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        String string = this.getTag() + ": ";
        try {
            string = string + this.getDocument().getElementsByTagName("tns:IdPoruke").item(0).getTextContent() + " / ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String datumVrijeme = this.getDocument().getElementsByTagName("tns:DatumVrijeme").item(0).getTextContent() + " / ";
            string = string + datumVrijeme.substring(0, 10) + " " + datumVrijeme.substring(11);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = string + this.getDocument().getElementsByTagName("tns:OznPosPr").item(0).getTextContent() + " / ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = string + this.getDocument().getElementsByTagName("tns:BrOznRac").item(0).getTextContent() + " /  ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

