/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.ui;

import hr.iii.fiskal.AppContext;
import hr.iii.fiskal.AppKeyStoreException;
import hr.iii.util.http.server.AbstractHttpHandler;
import hr.iii.util.http.server.forms.FilePart;
import hr.iii.util.http.server.forms.HttpFormParser;
import hr.iii.util.http.server.forms.ParamPart;
import hr.iii.util.http.server.forms.Part;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;

public class KeyStoreHandler
extends AbstractHttpHandler {
    private String fillCertTable(String newHtml) {
        String alias2;
        Enumeration<String> aliases;
        String keyTable = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        try {
            aliases = AppContext.getContext().getKeyStore().aliases();
            while (aliases.hasMoreElements()) {
                alias2 = aliases.nextElement();
                KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)AppContext.getContext().getKeyStore().getEntry(alias2, new KeyStore.PasswordProtection(AppContext.getContext().getKeyStorePassword().toCharArray()));
                if (keyEntry == null) {
                    return newHtml.replace("%ERROR%", "lozinka  nije ispravna");
                }
                X509Certificate cert = (X509Certificate)keyEntry.getCertificate();
                String notAfter = dateFormat.format(cert.getNotAfter());
                String notBefore = dateFormat.format(cert.getNotBefore());
                String aliasKey = alias2.replace("#", "_");
                keyTable = keyTable + "<tr><td><input type=\"button\" value=\"X\" style=\"background-color: red; color: white\"  onClick = \"deleteKey('" + aliasKey + "')\"></td><td>  " + alias2 + "  </td><td>  " + cert.getSubjectX500Principal().getName() + "  </td><td> " + notBefore + " </td><td> " + notAfter + "</td></tr>";
            }
        }
        catch (Exception alias2) {
            // empty catch block
        }
        try {
            aliases = AppContext.getContext().getServerKeyStore().aliases();
            while (aliases.hasMoreElements()) {
                alias2 = aliases.nextElement();
                X509Certificate cert = (X509Certificate)AppContext.getContext().getServerKeyStore().getCertificate(alias2);
                String notAfter = dateFormat.format(cert.getNotAfter());
                String notBefore = dateFormat.format(cert.getNotBefore());
                String aliasKey = alias2.replace("#", "_");
                keyTable = keyTable + "<tr><td><input type=\"button\" value=\"X\" style=\"background-color: red; color: white\"  onClick = \"deleteKey('" + aliasKey + "')\"></td><td>  " + alias2 + "  </td><td>  " + cert.getSubjectX500Principal().getName() + "  </td><td> " + notBefore + " </td><td> " + notAfter + "</td></tr>";
            }
        }
        catch (Exception alias3) {
            // empty catch block
        }
        for (int i = 0; i < 10; ++i) {
            keyTable = keyTable + "<tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>";
        }
        return newHtml.replace("%KEYS%", keyTable);
    }

    private byte[] createErrorResponse(String uri, String msg) throws IOException {
        byte[] response = this.createResponse(uri);
        String newHtml = new String(response);
        newHtml = this.fillCertTable(newHtml);
        newHtml = newHtml.replace("%ERROR%", "GRE\u0160KA: " + msg);
        return newHtml.getBytes();
    }

    private byte[] createOkResponse(String uri, String msg) throws IOException {
        byte[] response = this.createResponse(uri);
        String newHtml = new String(response);
        newHtml = this.fillCertTable(newHtml);
        newHtml = newHtml.replace("%ERROR%", msg);
        return newHtml.getBytes();
    }

    @Override
    protected byte[] createPostResponse(String uri, HttpFormParser parser) throws IOException {
        block41: {
            Integer action = null;
            if (uri.toLowerCase().indexOf("delete") > 0) {
                return this.deleteKey(uri);
            }
            if (parser == null) {
                return this.createErrorResponse(uri, "HTML sintaksna gre\u0161ka");
            }
            Part part = null;
            FilePart filePart = null;
            ParamPart paramPart = null;
            while ((part = parser.readNextPart()) != null) {
                if (part.getName().equals("keystore")) {
                    if (!part.isFile()) {
                        return this.createErrorResponse(uri, "HTML sintaksna gre\u0161ka");
                    }
                    filePart = (FilePart)part;
                    filePart.writeTo(new File("ks.tmp"));
                    continue;
                }
                if (part.getName().equals("password")) {
                    if (!part.isParam()) {
                        return this.createErrorResponse(uri, "HTML sintaksna gre\u0161ka");
                    }
                    paramPart = (ParamPart)part;
                    continue;
                }
                if (part.getName().equals("deleteOld")) {
                    action = 1;
                    continue;
                }
                if (part.getName().equals("saveNew")) {
                    action = 0;
                    continue;
                }
                return this.createErrorResponse(uri, "HTML sintaksna gre\u0161ka");
            }
            if (null == action) {
                return this.createErrorResponse(uri, "HTML sintaksna gre\u0161ka");
            }
            if (action == 1) {
                try {
                    AppContext.getContext().removeOldCertificates();
                }
                catch (Exception e) {
                    return this.createErrorResponse(uri, e.getLocalizedMessage());
                }
                return this.createOkResponse(uri, "Certifikati su uspje\u0161no obrisani !!!");
            }
            if (filePart == null || null == filePart.getFileName() || filePart.getFileName().isEmpty()) {
                return this.createErrorResponse(uri, "HTML sintaksna gre\u0161ka\nNije poslana datoteka certifikata");
            }
            if (paramPart == null) {
                return this.createErrorResponse(uri, "HTML sintaksna gre\u0161ka\nNije poslana lozinka certifikata");
            }
            String oib = null;
            KeyStore.PrivateKeyEntry keyEntry = null;
            KeyStore pks = null;
            try {
                pks = KeyStore.getInstance("pkcs12");
                pks.load(new FileInputStream("ks.tmp"), paramPart.getStringValue().toCharArray());
            }
            catch (Exception e) {
                try {
                    CertificateFactory factory2 = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)factory2.generateCertificate(new FileInputStream("ks.tmp"));
                    if (cert.getIssuerX500Principal().getName().toUpperCase().indexOf("FINA") < 0) {
                        return this.createErrorResponse(uri, "certifikat nije izdala FINA");
                    }
                    oib = cert.getSubjectX500Principal().getName();
                    if (oib.indexOf("fiskalcis") >= 0) {
                        oib = "serverapp";
                    } else if (oib.indexOf("cis.porezna-uprava.hr") >= 0) {
                        oib = "serverssl";
                    } else if (oib.indexOf("cistest.apis-it.hr") >= 0) {
                        oib = "serverssl";
                    } else {
                        pks = KeyStore.getInstance("X.509");
                        pks.load(new FileInputStream("ks.tmp"), paramPart.getStringValue().toCharArray());
                        if (cert.getIssuerX500Principal().getName().toUpperCase().indexOf("FINA") < 0) {
                            return this.createErrorResponse(uri, "certifikat nije izdala FINA");
                        }
                        oib = cert.getSubjectX500Principal().getName();
                        int oibOff = oib.indexOf("HR");
                        if (oibOff < 0) {
                            return this.createErrorResponse(uri, "ovo nije certifikat fiskalizacije");
                        }
                        oib = oib.substring(oibOff + 2, oibOff + 2 + 11);
                        try {
                            AppContext.getContext().addPrivateKey(oib, keyEntry);
                        }
                        catch (AppKeyStoreException e1) {
                            return this.createErrorResponse(uri, "interna gre\u0161ka");
                        }
                        return this.createOkResponse(uri, "Certifikat je uspje\u0161no spremljen !!!");
                    }
                    try {
                        AppContext.getContext().addCertifikate(oib, cert);
                    }
                    catch (AppKeyStoreException e2) {
                        return this.createErrorResponse(uri, "interna gre\u0161ka");
                    }
                    return this.createOkResponse(uri, "Certifikat je uspje\u0161no spremljen !!!");
                }
                catch (Exception e1) {
                    if (e.getCause() instanceof BadPaddingException) {
                        return this.createErrorResponse(uri, "lozinka  nije ispravna");
                    }
                    return this.createErrorResponse(uri, "datoteka certifikata nije ispravna");
                }
            }
            try {
                Enumeration<String> aliases = pks.aliases();
                if (!aliases.hasMoreElements()) break block41;
                String alias = aliases.nextElement();
                keyEntry = (KeyStore.PrivateKeyEntry)pks.getEntry(alias, new KeyStore.PasswordProtection(paramPart.getStringValue().toCharArray()));
                if (keyEntry == null) {
                    return this.createErrorResponse(uri, "lozinka  nije ispravna");
                }
                X509Certificate cert = (X509Certificate)keyEntry.getCertificate();
                if (cert.getIssuerX500Principal().getName().toUpperCase().indexOf("FINA") < 0) {
                    return this.createErrorResponse(uri, "certifikat nije izdala FINA");
                }
                oib = cert.getSubjectX500Principal().getName();
                int oibOff = oib.indexOf("HR");
                if (oibOff < 0) {
                    return this.createErrorResponse(uri, "ovo nije certifikat fiskalizacije");
                }
                oib = oib.substring(oibOff + 2, oibOff + 2 + 11);
                try {
                    AppContext.getContext().addPrivateKey(oib, keyEntry);
                }
                catch (AppKeyStoreException e) {
                    return this.createErrorResponse(uri, "interna gre\u0161ka");
                }
                return this.createOkResponse(uri, "Certifikat je uspje\u0161no spremljen !!!");
            }
            catch (Exception e) {
                if (e.getCause() instanceof BadPaddingException) {
                    return this.createErrorResponse(uri, "lozinka  nije ispravna");
                }
                return this.createErrorResponse(uri, "datoteka certifikata nije ispravna");
            }
        }
        return this.createErrorResponse(uri, "interna gre\u0161ka");
    }

    protected byte[] deleteKey(String uri) throws IOException {
        String alias = uri.substring(uri.toLowerCase().indexOf("delete/") + 7).replace("_", "#");
        try {
            if (alias.toLowerCase().indexOf("serverapp") >= 0 || alias.toLowerCase().indexOf("serverssl") >= 0) {
                AppContext.getContext().removeCertificate(alias);
            } else {
                AppContext.getContext().removePrivateKey(alias);
            }
        }
        catch (AppKeyStoreException e) {
            return this.createErrorResponse(uri, "Brisanje nije uspjelo");
        }
        return this.createOkResponse(uri, "Certifikat je uspje\u0161no obrisan !!!");
    }

    @Override
    protected byte[] prepareResponse(byte[] response) {
        String newHtml = new String(response);
        newHtml = newHtml.replace("%ERROR%", "");
        newHtml = this.fillCertTable(newHtml);
        return newHtml.getBytes();
    }

    @Override
    protected byte[] createResponse(String uri) throws IOException {
        return this.createResponseFromFile("ks.html");
    }
}

