/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.soapssl;

import hr.iii.fiskal.AppContext;
import hr.iii.fiskal.AppKeyStoreException;
import hr.iii.fiskal.soapssl.SSLSoapException;
import hr.iii.fiskal.soapssl.SoapMessage;
import hr.iii.fiskal.xml.Response;
import hr.iii.fiskal.xml.ResponseFactory;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.apache.http.util.EntityUtils;

public class SSLClient {
    private URL url = null;
    private Response response = null;
    public static final int HTTP_IO_ERROR = -1;
    public static final int HTTP_OK = 200;
    public static final int HTTP_SOAP_ERROR = 500;

    public SSLClient(String strUrl) {
        this.setURL(strUrl);
    }

    public void setURL(String strUrl) {
        try {
            this.url = new URL(strUrl);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void post(SoapMessage message) throws AppKeyStoreException, MalformedURLException, SSLSoapException {
        Logger logger = Logger.getLogger("hr.iii.fiskal.proxy");
        long start = System.currentTimeMillis();
        HttpClient httpclient = AppContext.getContext().getHttpsClient(this.url);
        PoolingClientConnectionManager cm = (PoolingClientConnectionManager)httpclient.getConnectionManager();
        PoolStats stats = cm.getTotalStats();
        HttpPost httppost = new HttpPost(this.url.toString());
        try {
            logger.fine("SSL Send: " + message.getSoapMessage().length() + " bytes (stats " + stats.getAvailable() + ", " + stats.getLeased() + ", " + stats.getPending() + ")");
            httppost.setEntity(new StringEntity(message.getSoapMessage(), "UTF-8"));
            httppost.setHeader("Content-type", "text/xml; charset=UTF-8");
            ExecutorService executor = Executors.newSingleThreadExecutor();
            List futures = executor.invokeAll(Arrays.asList(new KillableHttpClient(httpclient, httppost)), AppContext.getContext().getSSLTimeout(), TimeUnit.MILLISECONDS);
            executor.shutdown();
            if (futures.get(0).isCancelled()) {
                httppost.abort();
                throw new SSLSoapException("SSL Client timed out");
            }
            HttpResponse httpResponse = (HttpResponse)futures.get(0).get();
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                byte[] bytes = EntityUtils.toByteArray(entity);
                ResponseFactory responseFactory = new ResponseFactory();
                this.response = responseFactory.createResponse(new ByteArrayInputStream(bytes));
                logger.fine("SSL Receive: " + this.response.toString());
                EntityUtils.consume(entity);
            }
        }
        catch (Exception e) {
            httppost.abort();
            long elapsed = System.currentTimeMillis() - start;
            logger.fine("SSL Send : " + message.getSoapMessage().length() + " bytes, Gre\u0161ka: " + e.getMessage() + "(" + elapsed + " ms)");
            throw new SSLSoapException(e.getMessage(), e.getCause());
        }
        long elapsed = System.currentTimeMillis() - start;
        logger.fine("SSL Done in " + elapsed + " ms");
    }

    public Response getResponse() {
        return this.response;
    }

    private static class KillableHttpClient
    implements Callable<HttpResponse> {
        HttpClient httpClient = null;
        HttpPost httpPost = null;

        private KillableHttpClient(HttpClient client, HttpPost post) {
            this.httpClient = client;
            this.httpPost = post;
        }

        @Override
        public HttpResponse call() throws Exception {
            return this.httpClient.execute(this.httpPost);
        }
    }
}

