/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal;

import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Statistics {
    private Long connectedClients = 0L;
    private Long unknowRequest = 0L;
    private Long racunRequest = 0L;
    private Long prostorRequest = 0L;
    private Long echoRequest = 0L;
    private Long zastKodRequest = 0L;
    private Long qrCodeRequest = 0L;
    private Long napojnicaRequest = 0L;
    private Long nacinPlacanjaRequest = 0L;
    private Long jirs = 0L;
    private HashMap<String, ErrorStats> errorCodes = new HashMap();
    private Long lastCommElapsed = 0L;
    private Long averageCommElapsed = 0L;
    private Long averageCommCount = 0L;
    private String lastClient = "";
    private Date lastClientTime = new Date();

    public synchronized void Reset() {
        this.connectedClients = 0L;
        this.unknowRequest = 0L;
        this.racunRequest = 0L;
        this.jirs = 0L;
        this.prostorRequest = 0L;
        this.echoRequest = 0L;
        this.zastKodRequest = 0L;
        this.averageCommElapsed = 0L;
        this.averageCommCount = 0L;
        this.errorCodes.clear();
    }

    public synchronized void incUnknownRequestCount() {
        Long l = this.unknowRequest;
        Long l2 = this.unknowRequest = Long.valueOf(this.unknowRequest + 1L);
    }

    public synchronized void incQRCodeRequestCount() {
        Long l = this.qrCodeRequest;
        Long l2 = this.qrCodeRequest = Long.valueOf(this.qrCodeRequest + 1L);
    }

    public synchronized void incRacunRequestCount() {
        Long l = this.racunRequest;
        Long l2 = this.racunRequest = Long.valueOf(this.racunRequest + 1L);
    }

    public synchronized void incJirCount() {
        Long l = this.jirs;
        Long l2 = this.jirs = Long.valueOf(this.jirs + 1L);
    }

    public synchronized void incConnectedClients() {
        Long l = this.connectedClients;
        Long l2 = this.connectedClients = Long.valueOf(this.connectedClients + 1L);
    }

    public synchronized void decConnectedClients() {
        Long l = this.connectedClients;
        Long l2 = this.connectedClients = Long.valueOf(this.connectedClients - 1L);
    }

    public synchronized void incProstorRequestCount() {
        Long l = this.prostorRequest;
        Long l2 = this.prostorRequest = Long.valueOf(this.prostorRequest + 1L);
    }

    public synchronized void incEchoRequestCount() {
        Long l = this.echoRequest;
        Long l2 = this.echoRequest = Long.valueOf(this.echoRequest + 1L);
    }

    public synchronized void incZastKodRequestCount() {
        Long l = this.zastKodRequest;
        Long l2 = this.zastKodRequest = Long.valueOf(this.zastKodRequest + 1L);
    }

    public void incNacinPlacanjaRequest() {
        Long l = this.nacinPlacanjaRequest;
        Long l2 = this.nacinPlacanjaRequest = Long.valueOf(this.nacinPlacanjaRequest + 1L);
    }

    public void incNapojnicaRequest() {
        Long l = this.napojnicaRequest;
        Long l2 = this.napojnicaRequest = Long.valueOf(this.napojnicaRequest + 1L);
    }

    public synchronized void incErrorCode(String errorCode) {
        long count = 0L;
        ErrorStats err = null;
        if (this.errorCodes.containsKey(errorCode)) {
            err = this.errorCodes.get(errorCode);
            count = err.count;
        }
        ++count;
        if (err == null) {
            err = new ErrorStats();
        }
        err.count = count;
        err.updated = new Date();
        this.errorCodes.put(errorCode, err);
    }

    public synchronized void setAverageCommElapsed(long elapsed) {
        this.lastCommElapsed = elapsed;
        Long l = this.averageCommCount;
        Long l2 = this.averageCommCount = Long.valueOf(this.averageCommCount + 1L);
        if (this.averageCommCount > 1000L) {
            this.averageCommElapsed = (this.averageCommElapsed + elapsed) / this.averageCommCount;
            this.averageCommCount = 1L;
        } else {
            this.averageCommElapsed = this.averageCommElapsed + elapsed;
        }
    }

    public synchronized void setLastClient(InetSocketAddress client) {
        this.lastClient = client.getAddress().toString();
        this.lastClientTime = new Date();
    }

    public synchronized Long getUnknownRequestCount() {
        return this.unknowRequest;
    }

    public synchronized Long getRacunRequestCount() {
        return this.racunRequest;
    }

    public synchronized Long getJirCount() {
        return this.jirs;
    }

    public synchronized Long getConnectedClients() {
        return this.connectedClients;
    }

    public synchronized Long getProstorRequestCount() {
        return this.prostorRequest;
    }

    public synchronized Long getEchoRequestCount() {
        return this.echoRequest;
    }

    public synchronized Long getZastKodRequestCount() {
        return this.zastKodRequest;
    }

    public Long getQrCodeRequest() {
        return this.qrCodeRequest;
    }

    public Long getNapojnicaRequest() {
        return this.napojnicaRequest;
    }

    public Long getNacinPlacanjaRequest() {
        return this.nacinPlacanjaRequest;
    }

    public synchronized HashMap<String, ErrorStats> getErrorCodeCount() {
        return new HashMap<String, ErrorStats>(this.errorCodes);
    }

    public synchronized Long getAverageCommElapsed() {
        if (this.averageCommCount > 0L) {
            return this.averageCommElapsed / this.averageCommCount;
        }
        return this.averageCommElapsed;
    }

    public synchronized Long getLastCommElapsed() {
        return this.lastCommElapsed;
    }

    public synchronized String getLastClient() {
        return this.lastClient;
    }

    public synchronized Date getLastClientDate() {
        return this.lastClientTime;
    }

    public synchronized String toString() {
        return "";
    }

    public synchronized String toXml() {
        String newXml = "<STATS>";
        String errorTable = "<ERROR_TABLE>";
        for (Map.Entry<String, ErrorStats> pairs : this.errorCodes.entrySet()) {
            ErrorStats err = pairs.getValue();
            errorTable = errorTable + "<ERROR_ITEM><ERROR_ID>" + pairs.getKey() + "</ERROR_ID><ERROR_COUNT>" + err.count + "</ERROR_COUNT><ERROR_UPDATED>" + err.updated.toString() + "</ERROR_UPDATED></ERROR_ITEM>";
        }
        errorTable = errorTable + "</ERROR_TABLE>";
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String clientTime = formatter.format(this.lastClientTime);
        newXml = newXml + "<RACUN_REQUEST_COUNT>" + this.racunRequest.toString() + "</RACUN_REQUEST_COUNT>";
        newXml = newXml + "<RACUN_RESPONSE_COUNT>" + this.jirs.toString() + "</RACUN_RESPONSE_COUNT>";
        newXml = newXml + "<PROSTOR_REQUEST_COUNT>" + this.prostorRequest.toString() + "</PROSTOR_REQUEST_COUNT>";
        newXml = newXml + "<ECHO_REQUEST_COUNT>" + this.echoRequest.toString() + "</ECHO_REQUEST_COUNT>";
        newXml = newXml + "<ZASTKOD_REQUEST_COUNT>" + this.zastKodRequest.toString() + "</ZASTKOD_REQUEST_COUNT>";
        newXml = newXml + "<QRCODE_REQUEST_COUNT>" + this.qrCodeRequest.toString() + "</QRCODE_REQUEST_COUNT>";
        newXml = newXml + "<NAPOJNICA_REQUEST_COUNT>" + this.napojnicaRequest.toString() + "</NAPOJNICA_REQUEST_COUNT>";
        newXml = newXml + "<UNKNOWN_REQUEST_COUNT>" + this.unknowRequest.toString() + "</UNKNOWN_REQUEST_COUNT>";
        newXml = newXml + "<AVERAGE_COMM_ELAPSED>" + this.getAverageCommElapsed().toString() + "</AVERAGE_COMM_ELAPSED>";
        newXml = newXml + "<LAST_COMM_ELAPSED>" + this.lastCommElapsed.toString() + "</LAST_COMM_ELAPSED>";
        newXml = newXml + "<LAST_CLIENT>" + this.lastClient + "</LAST_CLIENT>";
        newXml = newXml + "<LAST_CLIENT_TIME>" + clientTime + "</LAST_CLIENT_TIME>";
        newXml = newXml + "<LAST_COMM_ELAPSED>" + this.lastCommElapsed.toString() + "</LAST_COMM_ELAPSED>";
        newXml = newXml + "<CONNECTED_CLIENTS>" + this.connectedClients.toString() + "</CONNECTED_CLIENTS>";
        newXml = newXml + errorTable;
        return newXml + "</STATS>";
    }

    public synchronized String toHtml(String html) {
        String newHtml = null;
        String errorTable = "";
        for (Map.Entry<String, ErrorStats> pairs : this.errorCodes.entrySet()) {
            ErrorStats err = pairs.getValue();
            errorTable = errorTable + "<tr><td>" + pairs.getKey() + "</td><td>" + err.count.toString() + "</td><td>" + err.updated.toString() + "</td></tr>";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String clientTime = formatter.format(this.lastClientTime);
        newHtml = html.replace("%RACUN_REQUEST_COUNT%", this.racunRequest.toString());
        newHtml = newHtml.replace("%RACUN_RESPONSE_COUNT%", this.jirs.toString());
        newHtml = newHtml.replace("%PROSTOR_REQUEST_COUNT%", this.prostorRequest.toString());
        newHtml = newHtml.replace("%ECHO_REQUEST_COUNT%", this.echoRequest.toString());
        newHtml = newHtml.replace("%ZASTKOD_REQUEST_COUNT%", this.zastKodRequest.toString());
        newHtml = newHtml.replace("%QRCODE_REQUEST_COUNT%", this.qrCodeRequest.toString());
        newHtml = newHtml.replace("%NAPOJNICA_REQUEST_COUNT%", this.napojnicaRequest.toString());
        newHtml = newHtml.replace("%UNKNOWN_REQUEST_COUNT%", this.unknowRequest.toString());
        newHtml = newHtml.replace("%AVERAGE_COMM_ELAPSED%", this.getAverageCommElapsed().toString());
        newHtml = newHtml.replace("%LAST_COMM_ELAPSED%", this.lastCommElapsed.toString());
        newHtml = newHtml.replace("%LAST_CLIENT%", this.lastClient);
        newHtml = newHtml.replace("%LAST_CLIENT_TIME%", clientTime);
        newHtml = newHtml.replace("%LAST_COMM_ELAPSED%", this.lastCommElapsed.toString());
        newHtml = newHtml.replace("%CONNECTED_CLIENTS%", this.connectedClients.toString());
        return newHtml.replace("%ERROR_TABLE%", errorTable);
    }

    private class ErrorStats {
        Long count;
        Date updated;

        private ErrorStats() {
        }
    }
}

