/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.StringQuoteUtil;
import com.sun.deploy.util.Trace;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParameterUtil {
    private ParameterUtil() {
    }

    public static boolean hasRunningVMRequiredArgs(String string) {
        Object object;
        if (string == null) {
            return true;
        }
        List<Object> list = new LinkedList();
        if (Config.isJavaVersionAtLeast15()) {
            try {
                object = ManagementFactory.getRuntimeMXBean();
                list = object.getInputArguments();
            }
            catch (Throwable throwable) {
                Trace.ignored(throwable);
            }
        }
        if (list.isEmpty()) {
            return string.trim().length() == 0;
        }
        object = StringQuoteUtil.parseCommandLine(string.trim());
        Set set = ParameterUtil.toVMParameters((List)object);
        Set set2 = ParameterUtil.toVMParameters(list);
        return set2.containsAll(set);
    }

    public static List mergeArgs(List list, List list2, int n) {
        Object object;
        Object object2;
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = ((String)object3.next()).trim();
            object = ParameterUtil.parseVMParameter((String)object2);
            linkedHashMap.put(object, object2);
        }
        object3 = list2.iterator();
        while (object3.hasNext()) {
            object2 = ((String)object3.next()).trim();
            object = ParameterUtil.parseVMParameter((String)object2);
            switch (n) {
                case 0: {
                    linkedHashMap.put(object, object2);
                    break;
                }
                case 2: {
                    if (linkedHashMap.containsKey(object)) break;
                    linkedHashMap.put(object, object2);
                    break;
                }
                case 1: {
                    if (linkedHashMap.containsKey(object) && Config.isSecureVmArg((String)object2)) break;
                    linkedHashMap.put(object, object2);
                    break;
                }
            }
        }
        object3 = new LinkedList();
        object2 = linkedHashMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            object3.add(object.getValue());
        }
        return object3;
    }

    private static Set toVMParameters(List list) {
        HashSet<VMParameter> hashSet = new HashSet<VMParameter>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = ((String)iterator.next()).trim();
            hashSet.add(ParameterUtil.parseVMParameter(string));
        }
        return hashSet;
    }

    private static VMParameter parseVMParameter(String string) {
        String string2 = string;
        if (string.indexOf(61) > 0) {
            string2 = string.split("=")[0];
        } else if (string.indexOf(58) > 0) {
            string2 = string.split(":")[0];
        } else if (string.startsWith("-Xms")) {
            string2 = "-Xms";
        } else if (string.startsWith("-Xmx")) {
            string2 = "-Xmx";
        } else if (string.startsWith("-Xss")) {
            string2 = "-Xss";
        }
        return new VMParameter(string2, string);
    }

    public static interface MergeMode {
        public static final int OVERRIDE_ALL = 0;
        public static final int OVERRIDE_INSECURE = 1;
        public static final int NO_OVERRIDE = 2;
    }

    private static class VMParameter {
        private String key;
        private String parameter;

        public VMParameter(String string, String string2) {
            this.key = string;
            this.parameter = string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof VMParameter)) {
                return false;
            }
            if (this.key.startsWith("-Xbootclasspath")) {
                return this.parameter.equals(((VMParameter)object).parameter);
            }
            return this.key.equals(((VMParameter)object).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String getKey() {
            return this.key;
        }

        public String getParameter() {
            return this.parameter;
        }
    }
}

