/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CachedJarFile;
import com.sun.deploy.cache.CachedJarFile14;
import com.sun.deploy.cache.CachedManifest;
import com.sun.deploy.cache.JarSigningData;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.SyncFileAccess;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.TrustedLibraries;
import com.sun.deploy.util.VersionString;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;

public class CacheEntry {
    public static int INCOMPLETE_FALSE = 0;
    public static int INCOMPLETE_TRUE = 1;
    public static int INCOMPLETE_ONHOLD = 2;
    public static int BUSY_FALSE = 0;
    public static int BUSY_TRUE = 1;
    private File indexFile = null;
    private SyncFileAccess indexFileSyncAccess = null;
    private File tempDataFile = null;
    private int busy = BUSY_TRUE;
    private int incomplete = 0;
    private int forceUpdate = 0;
    private int noHref = 0;
    private int cacheVersion = Cache.getCacheVersion();
    private int contentLength = 0;
    private int isShortcutImage = 0;
    private long lastModified = 0L;
    private long expirationDate = 0L;
    private String version = null;
    private String url = "";
    private String namespaceID = "";
    private MessageHeader headerFields = new MessageHeader();
    private String filename = null;
    private String codebaseIP = null;
    private long entryCreationTime = 0L;
    private long validationTimeStamp = 0L;
    private long certExpirationDate = 0L;
    private boolean knownToBeSigned = false;
    private long blacklistValidationTime = 0L;
    private long trustedLibrariesValidationTime = 0L;
    public static final byte PREVERIFY_FAILED = 2;
    public static final byte PREVERIFY_SUCCEEDED = 1;
    public static final byte PREVERIFY_NOTDONE = 0;
    private byte classVerificationStatus = 0;
    Map checkedJars = null;
    private boolean hasOnlySignedEntries = false;
    private boolean hasSingleCodeSource = false;
    private boolean hasMissingSignedEntries = false;
    private static final int section1Length = 128;
    private int section2Length = 0;
    private int section3Length = 0;
    private int section4Length = 0;
    private int section4CertsLength = 0;
    private int section4SignersLength = 0;
    private int section4Pre15Length = 0;
    private int section5Length = 0;
    private int reducedManifestLength = 0;
    private int reducedManifest2Length = 0;
    private boolean isProxiedHost = false;
    private static final String META_FILE_DIR = "META-INF/";
    private SoftReference manifestRef = null;
    private SoftReference signingDataRef = new SoftReference<Object>(null);
    private static boolean enhancedJarAccess;
    private volatile URL _url;

    public static boolean hasEnhancedJarAccess() {
        return enhancedJarAccess;
    }

    public void verifyJAR(URLClassLoader uRLClassLoader) {
        JarFile jarFile = this.getJarFile();
        if (jarFile == null) {
            return;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        boolean bl = false;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (string == null || !string.endsWith(".class")) continue;
            try {
                String string2 = string.substring(0, string.lastIndexOf(".class"));
                Class<?> clazz = Class.forName(string2.replace('/', '.'), false, uRLClassLoader);
                bl = true;
            }
            catch (Throwable throwable) {
                boolean bl3 = false;
                if (Environment.allowAltJavaFxRuntimeURL()) {
                    bl3 = true;
                    if (Trace.isTraceLevelEnabled(TraceLevel.CACHE)) {
                        throwable.printStackTrace();
                    }
                }
                if (bl3) continue;
                Trace.println("Class verification failed: " + throwable.getMessage() + " for " + this.getURL(), TraceLevel.CACHE);
                bl2 = true;
                break;
            }
        }
        if (bl && !bl2) {
            this.updateClassVerificationStatus((byte)1);
            Trace.println("CacheEntry:  Pre-verify done for all classes in " + this.getURL(), TraceLevel.CACHE);
            return;
        }
        this.updateClassVerificationStatus((byte)2);
        Trace.println("CacheEntry:  Cannot pre-verify all classes in " + this.getURL(), TraceLevel.CACHE);
    }

    public long getCreationTimespampt() {
        return this.entryCreationTime;
    }

    private boolean isOKToUseCachedSecurityValidation() {
        if (System.currentTimeMillis() > this.certExpirationDate) {
            return false;
        }
        if (Config.getBooleanProperty("deployment.security.validation.crl") || Config.getBooleanProperty("deployment.security.validation.ocsp")) {
            Trace.println("Certificate revocation enabled. Disable security validation optimizations.", TraceLevel.SECURITY);
            return false;
        }
        return true;
    }

    public long getValidationTimestampt() {
        if (!this.isOKToUseCachedSecurityValidation()) {
            this.resetValidationResults();
        }
        return this.validationTimeStamp;
    }

    private synchronized void resetValidationResults() {
        this.knownToBeSigned = false;
        this.validationTimeStamp = 0L;
    }

    private void updateBlacklistValidation() {
        this.resetValidationResults();
        if (Config.getBooleanProperty("deployment.security.blacklist.check")) {
            this.blacklistValidationTime = System.currentTimeMillis();
        }
    }

    private void updateTrustedLibrariesValidation() {
        this.trustedLibrariesValidationTime = System.currentTimeMillis();
    }

    public boolean isKnownToBeSigned() {
        if (!this.isOKToUseCachedSecurityValidation()) {
            this.resetValidationResults();
        }
        return this.knownToBeSigned;
    }

    public byte getClassesVerificationStatus() {
        return this.classVerificationStatus;
    }

    private void updateClassVerificationStatus(byte by) {
        this.classVerificationStatus = by;
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.println("Failed to update Class Verification result in the index", TraceLevel.CACHE);
            Trace.ignoredException(iOException);
        }
    }

    public boolean hasSigningInfo() {
        return this.section4Length != 0;
    }

    public void updateValidationResultsForApplet(boolean bl, Map map, long l, long l2) {
        Map map2;
        JarSigningData jarSigningData = this.getJarSigningData();
        if (jarSigningData == null) {
            return;
        }
        Map map3 = map2 = Config.isJavaVersionAtLeast15() ? jarSigningData.getSignerMap() : jarSigningData.getCertificateMap();
        if (map2 != null && this.hasStrictSingleSigning()) {
            Trace.println("updateValidationResultsForApplet update", TraceLevel.BASIC);
            this.updateValidationResults(bl, map, l, l2);
        }
    }

    public void updateValidationResults(boolean bl, Map map, long l, long l2) {
        this.knownToBeSigned = bl;
        this.validationTimeStamp = l;
        this.certExpirationDate = l2;
        this.checkedJars = map;
        Trace.println("Mark prevalidated: " + this.url + " " + bl + " tm=" + l + " cert=" + l2, TraceLevel.CACHE);
        try {
            this.updateSecurityValidationCache();
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.println("Failed to update list of trusted cached entries in the index", TraceLevel.CACHE);
            Trace.ignoredException(iOException);
        }
    }

    private void updateSecurityValidationCache() throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Object run() throws IOException {
                        RandomAccessFile randomAccessFile = null;
                        try {
                            randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                            CacheEntry.this.section5Length = 0;
                            if (CacheEntry.this.checkedJars != null && !CacheEntry.this.checkedJars.isEmpty()) {
                                Object object;
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(500);
                                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                                Set set = CacheEntry.this.checkedJars.entrySet();
                                dataOutputStream.writeInt(set.size());
                                Iterator iterator = set.iterator();
                                while (iterator.hasNext()) {
                                    object = iterator.next();
                                    dataOutputStream.writeUTF((String)object.getKey());
                                    dataOutputStream.writeLong((Long)object.getValue());
                                }
                                dataOutputStream.close();
                                byteArrayOutputStream.close();
                                object = byteArrayOutputStream.toByteArray();
                                randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length + CacheEntry.this.section4Length);
                                randomAccessFile.write((byte[])object);
                                CacheEntry.this.section5Length = ((Object)object).length;
                            }
                            Object var8_7 = null;
                            if (randomAccessFile == null) return null;
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (randomAccessFile == null) throw throwable;
                            CacheEntry.this.doUpdateHeader(randomAccessFile);
                            randomAccessFile.close();
                            throw throwable;
                        }
                        CacheEntry.this.doUpdateHeader(randomAccessFile);
                        randomAccessFile.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readSecurityValidationCache() throws IOException {
        if (this.section5Length != 0) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws IOException {
                        DataInputStream dataInputStream;
                        byte[] byArray = new byte[CacheEntry.this.section5Length];
                        RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                        try {
                            randomAccessFile.seek(128 + CacheEntry.this.section2Length + CacheEntry.this.section3Length + CacheEntry.this.section4Length);
                            randomAccessFile.readFully(byArray);
                            dataInputStream = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            randomAccessFile.close();
                            throw throwable;
                        }
                        randomAccessFile.close();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        dataInputStream = new DataInputStream(byteArrayInputStream);
                        HashMap<String, Long> hashMap = new HashMap<String, Long>();
                        for (int i = dataInputStream.readInt(); i > 0; --i) {
                            String string = dataInputStream.readUTF();
                            Long l = new Long(dataInputStream.readLong());
                            hashMap.put(string, l);
                        }
                        CacheEntry.this.checkedJars = hashMap;
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) return;
                throw (IOException)privilegedActionException.getException();
            }
        } else {
            this.checkedJars = null;
        }
    }

    public Map getCachedTrustedEntries() {
        if (this.section5Length == 0 && this.checkedJars == null) {
            return null;
        }
        if (this.checkedJars == null) {
            try {
                this.readSecurityValidationCache();
            }
            catch (IOException iOException) {
                Trace.println("Failed to read list of trusted cached entries from index", TraceLevel.CACHE);
                Trace.ignoredException(iOException);
            }
        }
        return this.checkedJars;
    }

    private void invalidateEntryDueToException(Throwable throwable) {
        Trace.println("Invalidating entry url=" + this.url + " file=" + this.indexFile.getAbsolutePath());
        Trace.ignored(throwable);
        this.invalidateEntry();
    }

    private void invalidateEntry() {
        this.setIncomplete(INCOMPLETE_TRUE);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    public void markIncompleteOnHold() {
        this.setBusy(BUSY_TRUE);
        this.invalidateEntry();
        this.setIncomplete(INCOMPLETE_ONHOLD);
    }

    public CacheEntry(File file) {
        this(file, false);
    }

    CacheEntry(File file, final boolean bl) {
        String string = file.getPath();
        this.filename = string.substring(0, string.length() - 4);
        this.indexFile = file;
        this.indexFileSyncAccess = new SyncFileAccess(this.indexFile);
        this.tempDataFile = new File(this.filename + "-temp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    CacheEntry.this.readIndexFile(bl);
                }
                catch (Throwable throwable) {
                    CacheEntry.this.invalidateEntryDueToException(throwable);
                }
                return null;
            }
        });
    }

    public void generateShortcutImage() throws IOException {
        if (this.getIsShortcutImage() == 0) {
            this.setIsShortcutImage(1);
            this.updateIndexHeaderOnDisk();
        }
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return ((Object)principal2).equals(principal = x509Certificate2.getSubjectDN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile openLockIndexFile(String string, boolean bl) throws IOException {
        RandomAccessFile randomAccessFile;
        block2: {
            SyncFileAccess.RandomAccessFileLock randomAccessFileLock = null;
            RandomAccessFile randomAccessFile2 = null;
            try {
                randomAccessFileLock = this.indexFileSyncAccess.openLockRandomAccessFile(string, 10000, bl);
                randomAccessFile = randomAccessFile2 = randomAccessFileLock != null ? randomAccessFileLock.getRandomAccessFile() : new RandomAccessFile(this.indexFile, string);
                Object var7_6 = null;
                if (randomAccessFileLock == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (randomAccessFileLock == null) break block3;
                    randomAccessFileLock.release();
                }
                throw throwable;
            }
            randomAccessFileLock.release();
        }
        return randomAccessFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readIndexFileOld() {
        var2_1 = null;
        try {
            block17: {
                if (!this.indexFile.exists()) ** GOTO lbl74
                var2_1 = this.openLockIndexFile("r", false);
                this.setBusy(var2_1.read());
                this.setIncomplete(var2_1.read());
                this.setCacheVersion(var2_1.readInt());
                if (this.getCacheVersion() != Cache.getCacheVersion() || !this.isValidEntry()) break block17;
                var2_1.close();
                var2_1 = null;
                this.readIndexFile();
                var6_2 = null;
                ** GOTO lbl67
            }
            if (this.getCacheVersion() == 602 && this.isValidEntry()) {
                this.setForceUpdate(var2_1.read());
                this.setNoHref(var2_1.read());
                this.setIsShortcutImage(var2_1.read());
                this.setContentLength(var2_1.readInt());
                this.setLastModified(var2_1.readLong());
                this.setExpirationDate(var2_1.readLong());
                this.setVersion(var2_1.readUTF());
                this.setURL(var2_1.readUTF());
                this.setNamespaceID(var2_1.readUTF());
                var3_10 = new File(this.getResourceFilename());
                if (!this.isRedirectEntry() && !var3_10.exists()) {
                    var2_1.close();
                    var2_1 = null;
                    this.invalidateEntry();
                }
            } else {
                var2_1.close();
                var2_1 = null;
                this.invalidateEntry();
            }
            if (!this.isIncomplete()) {
                this.readHeadersOld(var2_1);
            }
            ** GOTO lbl74
        }
        catch (IOException var3_11) {
            if (var2_1 != null) {
                try {
                    var2_1.close();
                    var2_1 = null;
                }
                catch (IOException var4_12) {
                    Trace.ignoredException(var4_12);
                }
            }
            this.invalidateEntryDueToException(var3_11);
            var6_4 = null;
            try {
                if (var2_1 == null) return;
                var2_1.close();
                return;
            }
            catch (IOException var7_8) {
                Trace.ignoredException(var7_8);
                return;
            }
        }
        {
            catch (Throwable var5_13) {
                var6_5 = null;
                ** try [egrp 3[TRYBLOCK] [7 : 273->284)] { 
lbl61:
                // 1 sources

                if (var2_1 == null) throw var5_13;
                var2_1.close();
                throw var5_13;
lbl64:
                // 1 sources

                catch (IOException var7_9) {
                    Trace.ignoredException(var7_9);
                }
                throw var5_13;
            }
lbl67:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [7 : 273->284)] { 
lbl68:
            // 1 sources

            if (var2_1 == null) return;
            var2_1.close();
            return;
lbl71:
            // 1 sources

            catch (IOException var7_6) {
                Trace.ignoredException(var7_6);
            }
            return;
lbl74:
            // 2 sources

            var6_3 = null;
            try {}
            catch (IOException var7_7) {}
            Trace.ignoredException(var7_7);
            return;
            if (var2_1 == null) return;
            var2_1.close();
            return;
        }
    }

    private void readIndexFile() {
        this.readIndexFile(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readIndexFile(boolean var1_1) {
        var2_2 = null;
        try {
            block25: {
                block23: {
                    block22: {
                        if (!this.indexFile.exists()) ** GOTO lbl170
                        var2_2 = this.openLockIndexFile("r", false);
                        var3_3 = new byte[128];
                        var4_5 = var2_2.read(var3_3);
                        var5_6 = new DataInputStream(new ByteArrayInputStream(var3_3, 0, var4_5));
                        this.setBusy(var5_6.readByte());
                        var6_7 = var5_6.readByte();
                        if (var1_1 && var6_7 == CacheEntry.INCOMPLETE_TRUE) {
                            var6_7 = CacheEntry.INCOMPLETE_ONHOLD;
                        }
                        this.setIncomplete(var6_7);
                        if (!this.isIncomplete()) break block22;
                        var11_8 = null;
                        ** GOTO lbl139
                    }
                    this.setCacheVersion(var5_6.readInt());
                    if (this.getCacheVersion() == Cache.getCacheVersion()) break block23;
                    var2_2.close();
                    var2_2 = null;
                    Trace.println("Trying to upgrade in place " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
                    this.readIndexFileOld();
                    this.cacheVersion = Cache.getCacheVersion();
                    var7_22 = this.isValidEntry();
                    try {
                        block24: {
                            this.setBusy(CacheEntry.BUSY_TRUE);
                            this.updateIndexHeaderOnDisk();
                            if (!var7_22) break block24;
                            this.writeFileToDisk(1, null, false);
                            Trace.println("Upgrade of entry done", TraceLevel.CACHE);
                            ** GOTO lbl146
                        }
                        Trace.println("Upgrade of incomplete entry done", TraceLevel.CACHE);
                    }
                    catch (IOException var8_24) {
                        this.setBusy(CacheEntry.BUSY_FALSE);
                        this.invalidateEntryDueToException(var8_24);
                    }
                    ** GOTO lbl146
                }
                this.setForceUpdate(var5_6.readByte());
                this.setNoHref(var5_6.readByte());
                this.setIsShortcutImage(var5_6.readByte());
                this.setContentLength(var5_6.readInt());
                this.setLastModified(var5_6.readLong());
                this.setExpirationDate(var5_6.readLong());
                var5_6.readLong();
                var5_6.readByte();
                this.section2Length = var5_6.readInt();
                this.section3Length = var5_6.readInt();
                this.section4Length = var5_6.readInt();
                this.section5Length = var5_6.readInt();
                var5_6.readLong();
                var5_6.readLong();
                var5_6.readByte();
                this.reducedManifestLength = var5_6.readInt();
                this.section4Pre15Length = var5_6.readInt();
                var5_6.readByte();
                var5_6.readByte();
                this.section4CertsLength = var5_6.readInt();
                this.section4SignersLength = var5_6.readInt();
                var5_6.readByte();
                var5_6.readLong();
                this.reducedManifest2Length = var5_6.readInt();
                this.setIsProxied(var5_6.readByte() == 1);
                var5_6.close();
                if (this.section2Length > 0) {
                    var3_3 = new byte[this.section2Length];
                    var2_2.read(var3_3);
                    var5_6 = new DataInputStream(new ByteArrayInputStream(var3_3));
                    this.setVersion(var5_6.readUTF());
                    this.setURL(var5_6.readUTF());
                    this.setNamespaceID(var5_6.readUTF());
                    this.setCodebaseIP(var5_6.readUTF());
                    this.readHeaders(var5_6);
                }
                var7_23 = new File(this.getResourceFilename());
                if (this.isRedirectEntry() || var7_23.exists()) break block25;
                this.setIncomplete(CacheEntry.INCOMPLETE_TRUE);
                ** GOTO lbl154
            }
            if (!this.hasSigningInfo() || this.section4Pre15Length != 0 || !CacheEntry.enhancedJarAccess || Cache.isSystemCacheEntry(this) && !Environment.isSystemCacheMode()) ** GOTO lbl170
            var2_2.close();
            var2_2 = null;
            Trace.println("Trying to update in place " + this.indexFile.getAbsolutePath(), TraceLevel.CACHE);
            this.cacheVersion = Cache.getCacheVersion();
            var8_25 = this.isValidEntry();
            try {
                this.setBusy(CacheEntry.BUSY_TRUE);
                this.updateIndexHeaderOnDisk();
                if (var8_25) {
                    Trace.println("Upgrade writing to disk for " + var7_23, TraceLevel.CACHE);
                    this.writeFileToDisk(1, null, false);
                    Trace.println("Upgrade of entry done", TraceLevel.CACHE);
                } else {
                    Trace.println("Upgrade of incomplete entry done", TraceLevel.CACHE);
                }
            }
            catch (IOException var9_26) {
                this.setBusy(CacheEntry.BUSY_FALSE);
                this.invalidateEntryDueToException(var9_26);
            }
            Trace.println("readIndexFile returning success", TraceLevel.CACHE);
            ** GOTO lbl162
        }
        catch (IOException var3_4) {
            this.setIncomplete(CacheEntry.INCOMPLETE_TRUE);
            Trace.ignoredException(var3_4);
            var11_13 = null;
            try {
                if (var2_2 == null) return;
                var2_2.close();
                return;
            }
            catch (IOException var12_20) {
                Trace.ignoredException(var12_20);
                return;
            }
        }
        {
            catch (Throwable var10_27) {
                var11_14 = null;
                ** try [egrp 4[TRYBLOCK] [13 : 785->796)] { 
lbl133:
                // 1 sources

                if (var2_2 == null) throw var10_27;
                var2_2.close();
                throw var10_27;
lbl136:
                // 1 sources

                catch (IOException var12_21) {
                    Trace.ignoredException(var12_21);
                }
                throw var10_27;
            }
lbl139:
            // 1 sources

            ** try [egrp 4[TRYBLOCK] [13 : 785->796)] { 
lbl140:
            // 1 sources

            if (var2_2 == null) return;
            var2_2.close();
            return;
lbl143:
            // 1 sources

            catch (IOException var12_15) {
                Trace.ignoredException(var12_15);
            }
            return;
lbl146:
            // 3 sources

            var11_9 = null;
            ** try [egrp 4[TRYBLOCK] [13 : 785->796)] { 
lbl148:
            // 1 sources

            if (var2_2 == null) return;
            var2_2.close();
            return;
lbl151:
            // 1 sources

            catch (IOException var12_16) {
                Trace.ignoredException(var12_16);
            }
            return;
lbl154:
            // 1 sources

            var11_10 = null;
            ** try [egrp 4[TRYBLOCK] [13 : 785->796)] { 
lbl156:
            // 1 sources

            if (var2_2 == null) return;
            var2_2.close();
            return;
lbl159:
            // 1 sources

            catch (IOException var12_17) {
                Trace.ignoredException(var12_17);
            }
            return;
lbl162:
            // 1 sources

            var11_11 = null;
            ** try [egrp 4[TRYBLOCK] [13 : 785->796)] { 
lbl164:
            // 1 sources

            if (var2_2 == null) return;
            var2_2.close();
            return;
lbl167:
            // 1 sources

            catch (IOException var12_18) {
                Trace.ignoredException(var12_18);
            }
            return;
lbl170:
            // 2 sources

            var11_12 = null;
            try {}
            catch (IOException var12_19) {}
            Trace.ignoredException(var12_19);
            return;
            if (var2_2 == null) return;
            var2_2.close();
            return;
        }
    }

    void processRedirectData(URL uRL, CacheEntry cacheEntry) throws IOException {
        this.setBusy(BUSY_FALSE);
        this.setIncomplete(INCOMPLETE_FALSE);
        this.setURL(uRL.toString());
        this.setLastModified(cacheEntry.getLastModified());
        this.setExpirationDate(cacheEntry.getExpirationDate());
        this.setVersion(cacheEntry.getVersion());
        this.headerFields = new MessageHeader();
        this.headerFields.add(null, String.valueOf(302));
        this.headerFields.add("Location", cacheEntry.getURL().toString());
        this.setHeaders(this.headerFields);
        this.writeFileToDisk();
    }

    public void setBusy(int n) {
        this.busy = n;
    }

    int getBusy() {
        return this.busy;
    }

    private void setCacheVersion(int n) {
        this.cacheVersion = n;
    }

    int getCacheVersion() {
        return this.cacheVersion;
    }

    public void setIncomplete(int n) {
        this.incomplete = n;
    }

    public int getIncomplete() {
        return this.incomplete;
    }

    boolean isIncomplete() {
        return this.getIncomplete() == INCOMPLETE_TRUE;
    }

    public boolean isValidEntry() {
        return this.busy == BUSY_FALSE && this.incomplete == INCOMPLETE_FALSE;
    }

    public void setIsShortcutImage(int n) {
        this.isShortcutImage = n;
    }

    public int getIsShortcutImage() {
        return this.isShortcutImage;
    }

    public synchronized void setIsProxied(boolean bl) {
        this.isProxiedHost = bl;
    }

    public synchronized boolean getIsProxied() {
        return this.isProxiedHost;
    }

    private void setForceUpdate(int n) {
        this.forceUpdate = n;
    }

    private int getForceUpdate() {
        return this.forceUpdate;
    }

    void setNoHref(int n) {
        this.noHref = n;
    }

    private int getNoHref() {
        return this.noHref;
    }

    boolean removeBefore(CacheEntry cacheEntry) {
        long l;
        long l2;
        if (this.isIncomplete()) {
            return true;
        }
        if (cacheEntry.isIncomplete()) {
            return false;
        }
        long l3 = this.getIndexFile().lastModified();
        if (l3 < (l2 = cacheEntry.getIndexFile().lastModified())) {
            return true;
        }
        if (l3 > l2) {
            return false;
        }
        long l4 = System.currentTimeMillis();
        long l5 = this.getExpirationDate();
        if (l5 != (l = cacheEntry.getExpirationDate())) {
            if (l5 < l4) {
                return true;
            }
            if (l < l4) {
                return false;
            }
        }
        return this.getContentLength() >= cacheEntry.getContentLength();
    }

    void setContentLength(int n) {
        this.contentLength = n;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    synchronized JarSigningData getJarSigningData() {
        if (this.signingDataRef == null) {
            return null;
        }
        JarSigningData jarSigningData = (JarSigningData)this.signingDataRef.get();
        if (jarSigningData == null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, JARSigningException {
                        Object object;
                        URL uRL = new URL(CacheEntry.this.url);
                        File file = new File(CacheEntry.this.filename);
                        JarVerifier jarVerifier = JarVerifier.create(uRL, CacheEntry.this.version, file, null);
                        jarVerifier.validate(null);
                        CacheEntry.this.hasOnlySignedEntries = jarVerifier.hasOnlySignedEntries();
                        CacheEntry.this.hasSingleCodeSource = jarVerifier.hasSingleCodeSource();
                        CacheEntry.this.hasMissingSignedEntries = jarVerifier.hasMissingSignedEntries();
                        if (!jarVerifier.getSignerCerts().isEmpty() && CacheEntry.this.hasStrictSingleSigning()) {
                            object = jarVerifier.getSignerMapCert();
                            object.clear();
                            object.put(null, jarVerifier.getSingleSignerIndicesCert());
                        }
                        if (!(object = jarVerifier.getSignersCS()).isEmpty() && CacheEntry.this.hasStrictSingleSigning()) {
                            Map map = jarVerifier.getSignerMap();
                            map.clear();
                            map.put(null, jarVerifier.getSingleSignerIndicesCS());
                        }
                        CacheEntry.this.signingDataRef = new SoftReference<JarSigningData>(JarSigningData.create(jarVerifier));
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Trace.ignoredException(privilegedActionException.getException());
                this.invalidateEntryDueToException(privilegedActionException.getException());
                this.signingDataRef = null;
            }
        }
        if (this.signingDataRef != null) {
            jarSigningData = (JarSigningData)this.signingDataRef.get();
        }
        return jarSigningData;
    }

    synchronized boolean hasStrictSingleSigning() {
        return this.hasOnlySignedEntries && this.hasSingleCodeSource && !this.hasMissingSignedEntries;
    }

    public synchronized Certificate[] getCertificates() {
        JarSigningData jarSigningData = this.getJarSigningData();
        return jarSigningData != null ? jarSigningData.getCertificates() : null;
    }

    public CodeSigner[] getCodeSigners() {
        JarSigningData jarSigningData = this.getJarSigningData();
        return jarSigningData != null ? jarSigningData.getCodeSigners() : null;
    }

    void setLastModified(long l) {
        this.lastModified = l;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void setExpirationDate(long l) {
        this.expirationDate = l;
    }

    public void updateExpirationInIndexFile(long l) {
        if (this.getExpirationDate() == l) {
            return;
        }
        this.setExpirationDate(l);
        try {
            this.updateIndexHeaderOnDisk();
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isExpired() {
        return this.expirationDate == 0L || System.currentTimeMillis() >= this.expirationDate;
    }

    void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    void setVersion(String string) {
        this.version = string == null || string.equals("") ? null : string;
    }

    public String getVersion() {
        return this.version;
    }

    private void setNamespaceID(String string) {
        this.namespaceID = string;
    }

    private String getNamespaceID() {
        return this.namespaceID;
    }

    public JarFile getJarFile() {
        JarFile jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Config.isJavaVersionAtLeast15()) {
                    CachedJarFile cachedJarFile = null;
                    try {
                        cachedJarFile = new CachedJarFile(CacheEntry.this);
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    return cachedJarFile;
                }
                CachedJarFile14 cachedJarFile14 = null;
                try {
                    cachedJarFile14 = new CachedJarFile14(CacheEntry.this);
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                return cachedJarFile14;
            }
        });
        return jarFile;
    }

    public String getResourceFilename() {
        return this.filename;
    }

    public File getDataFile() {
        File file = null;
        if (!this.isRedirectEntry() && this.filename != null && !this.url.equals("")) {
            file = new File(this.filename);
            MemoryCache.addResourceReference(file, this.url);
        }
        return file;
    }

    File getTempDataFile() {
        return this.tempDataFile;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public long getSize() {
        long l = 0L;
        if (this.getDataFile() != null) {
            l += this.getDataFile().length();
        }
        if (this.getIndexFile() != null) {
            l += this.getIndexFile().length();
        }
        return l;
    }

    void setHeaders(MessageHeader messageHeader) {
        this.headerFields = messageHeader;
    }

    public Map getHeaders() {
        return this.headerFields.getHeaders();
    }

    public boolean isHttpNoCacheEnabled() {
        String string = this.headerFields.getValue(this.headerFields.getKey("cache-control"));
        if (string != null && string.equals("no-cache")) {
            return true;
        }
        String string2 = this.headerFields.getValue(this.headerFields.getKey("pragma"));
        return string2 != null && string2.equals("no-cache");
    }

    boolean processTempDataFile(boolean bl, DownloadEngine.DownloadDelegate downloadDelegate, URL uRL, URL uRL2, String string) {
        Object object;
        boolean bl2 = false;
        if (bl) {
            object = null;
            String string2 = uRL2.getQuery().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (!string3.startsWith("current-version-id")) continue;
                object = string3.substring("current-version-id".length() + 1);
                break;
            }
            CacheEntry cacheEntry = null;
            cacheEntry = Cache.getCacheEntry(uRL, null, (String)object);
            File file = null;
            if (cacheEntry != null) {
                file = new File(cacheEntry.getResourceFilename());
            }
            File file2 = null;
            try {
                if (Trace.isTraceLevelEnabled(TraceLevel.NETWORK)) {
                    Trace.println(ResourceManager.getString("cacheEntry.applyJarDiff", uRL == null ? "" : uRL.toString(), (String)object, string), TraceLevel.NETWORK);
                }
                file2 = DownloadEngine.applyPatch(file, this.tempDataFile, uRL, string, downloadDelegate, this.filename);
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CacheEntry.this.tempDataFile.delete();
                    return null;
                }
            });
            if (file2 != null) {
                bl2 = true;
            }
        }
        if (((Boolean)(object = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(CacheEntry.this.tempDataFile.renameTo(new File(CacheEntry.this.filename)));
            }
        }))).booleanValue()) {
            bl2 = true;
        }
        return bl2;
    }

    public Manifest getManifest() {
        if (this.manifestRef == null) {
            return null;
        }
        CachedManifest cachedManifest = (CachedManifest)this.manifestRef.get();
        if (cachedManifest == null) {
            try {
                Manifest manifest;
                JarFile jarFile = this.getJarFile();
                if (jarFile != null && (manifest = jarFile.getManifest()) != null) {
                    cachedManifest = new CachedManifest(manifest);
                    cachedManifest.postprocess();
                    this.manifestRef = new SoftReference<CachedManifest>(cachedManifest);
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                this.invalidateEntryDueToException(iOException);
                this.manifestRef = null;
            }
        }
        return cachedManifest;
    }

    private void setCodebaseIP(String string) {
        this.codebaseIP = string;
    }

    public String getCodebaseIP() {
        return this.codebaseIP;
    }

    public void writeFileToDisk() throws IOException {
        this.writeFileToDisk(1, null);
    }

    private boolean hasMimeType(String string) {
        if (this.headerFields != null) {
            Object v = this.getHeaders().get("content-type");
            if (!(v instanceof List)) {
                return false;
            }
            List list = (List)v;
            return list.contains(string);
        }
        return false;
    }

    private boolean hasRequestType(String string) {
        if (this.headerFields != null) {
            Object v = this.getHeaders().get("deploy-request-content-type");
            if (!(v instanceof List)) {
                return false;
            }
            List list = (List)v;
            return list.contains(string);
        }
        return false;
    }

    public boolean isJarFile(String string) {
        if (this.hasRequestType("application/x-java-archive")) {
            return true;
        }
        int n = string.indexOf(";");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("?")) != -1) {
            string = string.substring(0, n);
        }
        return string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".jarjar") || this.hasMimeType("application/x-java-archive") || this.hasMimeType("application/java-archive") || this.hasMimeType("application/x-java-archive-diff");
    }

    public boolean isJNLPFile() {
        if (this.hasRequestType("application/x-java-jnlp-file")) {
            return true;
        }
        String string = this.url;
        int n = string.indexOf(";");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.indexOf("?")) != -1) {
            string = string.substring(0, n);
        }
        return string.toLowerCase().endsWith(".jnlp") || string.toLowerCase().endsWith(".jarjnlp");
    }

    public void updateIndexHeaderOnDisk() throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Object run() throws IOException {
                        RandomAccessFile randomAccessFile = null;
                        try {
                            randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                            CacheEntry.this.doUpdateHeader(randomAccessFile);
                            Object var3_2 = null;
                            if (randomAccessFile == null) return null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (randomAccessFile == null) throw throwable;
                            randomAccessFile.close();
                            throw throwable;
                        }
                        randomAccessFile.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    private void doUpdateHeader(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile != null) {
            randomAccessFile.seek(0L);
            randomAccessFile.write(this.prepareHeader());
        }
    }

    private byte[] prepareHeader() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(this.busy);
        dataOutputStream.writeByte(this.incomplete);
        dataOutputStream.writeInt(this.cacheVersion);
        dataOutputStream.writeByte(this.forceUpdate);
        dataOutputStream.writeByte(this.noHref);
        dataOutputStream.writeByte(this.isShortcutImage);
        dataOutputStream.writeInt(this.contentLength);
        dataOutputStream.writeLong(this.lastModified);
        dataOutputStream.writeLong(this.expirationDate);
        dataOutputStream.writeLong(this.validationTimeStamp);
        dataOutputStream.writeByte(this.knownToBeSigned ? 1 : 0);
        dataOutputStream.writeInt(this.section2Length);
        dataOutputStream.writeInt(this.section3Length);
        dataOutputStream.writeInt(this.section4Length);
        dataOutputStream.writeInt(this.section5Length);
        dataOutputStream.writeLong(this.blacklistValidationTime);
        dataOutputStream.writeLong(this.certExpirationDate);
        dataOutputStream.writeByte(this.classVerificationStatus);
        dataOutputStream.writeInt(this.reducedManifestLength);
        dataOutputStream.writeInt(this.section4Pre15Length);
        dataOutputStream.writeByte(this.hasOnlySignedEntries ? 1 : 0);
        dataOutputStream.writeByte(this.hasSingleCodeSource ? 1 : 0);
        dataOutputStream.writeInt(this.section4CertsLength);
        dataOutputStream.writeInt(this.section4SignersLength);
        dataOutputStream.writeByte(this.hasMissingSignedEntries ? 1 : 0);
        dataOutputStream.writeLong(this.trustedLibrariesValidationTime);
        dataOutputStream.writeInt(this.reducedManifest2Length);
        dataOutputStream.writeByte(this.getIsProxied() ? 1 : 0);
        dataOutputStream.flush();
        if (byteArrayOutputStream.size() < 128) {
            byte[] byArray = new byte[128 - byteArrayOutputStream.size()];
            dataOutputStream.write(byArray);
        }
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    synchronized void writeFileToDisk(int n, DownloadEngine.DownloadDelegate downloadDelegate) throws IOException {
        this.writeFileToDisk(n, downloadDelegate, true);
    }

    void writeFileToDisk(final int n, final DownloadEngine.DownloadDelegate downloadDelegate, final boolean bl) throws IOException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public Object run() throws IOException {
                        ZipFile zipFile;
                        block15: {
                            zipFile = null;
                            RandomAccessFile randomAccessFile = null;
                            CacheEntry.this.section2Length = 0;
                            CacheEntry.this.section3Length = 0;
                            CacheEntry.this.section4Length = 0;
                            CacheEntry.this.section4Pre15Length = 0;
                            CacheEntry.this.section4CertsLength = 0;
                            CacheEntry.this.section4SignersLength = 0;
                            CacheEntry.this.section5Length = 0;
                            CacheEntry.this.reducedManifestLength = 0;
                            CacheEntry.this.reducedManifest2Length = 0;
                            try {
                                try {
                                    Object object;
                                    String string;
                                    randomAccessFile = CacheEntry.this.openLockIndexFile("rw", false);
                                    byte[] byArray = CacheEntry.this.prepareHeader();
                                    randomAccessFile.write(byArray);
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                                    dataOutputStream.writeUTF(CacheEntry.this.getVersion() != null ? CacheEntry.this.getVersion() : "");
                                    dataOutputStream.writeUTF(CacheEntry.this.getURL());
                                    dataOutputStream.writeUTF(CacheEntry.this.getNamespaceID());
                                    InetAddress inetAddress = null;
                                    String string2 = "";
                                    if (CacheEntry.this.url != null && !CacheEntry.this.url.equals("") && (inetAddress = Cache.getHostIP(string = ((URL)(object = new URL(CacheEntry.this.url))).getHost())) != null) {
                                        string2 = inetAddress.getHostAddress();
                                    }
                                    dataOutputStream.writeUTF(string2);
                                    CacheEntry.this.writeHeaders(dataOutputStream);
                                    dataOutputStream.close();
                                    byteArrayOutputStream.close();
                                    CacheEntry.this.section2Length = byteArrayOutputStream.size();
                                    randomAccessFile.write(byteArrayOutputStream.toByteArray());
                                    if (CacheEntry.this.incomplete == 0) {
                                        if (CacheEntry.this.isJarFile(CacheEntry.this.url) && !CacheEntry.this.isRedirectEntry()) {
                                            zipFile = new JarFile(new File(CacheEntry.this.filename));
                                            object = new CachedManifest((JarFile)zipFile);
                                            CacheEntry.this.writeManifest(randomAccessFile, (JarFile)zipFile, (CachedManifest)object, n, downloadDelegate);
                                            ((CachedManifest)object).postprocess();
                                            CacheEntry.this.manifestRef = new SoftReference<Object>(object);
                                            zipFile.close();
                                        }
                                        if (bl) {
                                            DownloadEngine.addToUpdateCheckDoneList(CacheEntry.this.url);
                                        }
                                        Cache.addToCleanupThreadLoadedResourceList(CacheEntry.this.url);
                                        CacheEntry.this.setBusy(BUSY_FALSE);
                                        CacheEntry.this.setIncomplete(INCOMPLETE_FALSE);
                                        CacheEntry.this.updateBlacklistValidation();
                                        CacheEntry.this.updateTrustedLibrariesValidation();
                                        CacheEntry.this.doUpdateHeader(randomAccessFile);
                                    }
                                }
                                catch (Exception exception) {
                                    Trace.ignoredException(exception);
                                    if (randomAccessFile != null) {
                                        randomAccessFile.close();
                                        randomAccessFile = null;
                                    }
                                    if (zipFile != null) {
                                        zipFile.close();
                                        zipFile = null;
                                    }
                                    Cache.removeCacheEntry(CacheEntry.this);
                                    if (exception instanceof JARSigningException) {
                                        throw (JARSigningException)exception;
                                    }
                                    if (!(exception instanceof ZipException)) throw new IOException(exception.getMessage());
                                    throw new JARSigningException(new URL(CacheEntry.this.url), CacheEntry.this.version, 2, exception);
                                }
                                Object var11_11 = null;
                                if (randomAccessFile == null) break block15;
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                if (randomAccessFile != null) {
                                    randomAccessFile.close();
                                }
                                if (zipFile != null) {
                                    zipFile.close();
                                }
                                Cache.cleanup();
                                throw throwable;
                            }
                            randomAccessFile.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        Cache.cleanup();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!(privilegedActionException.getException() instanceof IOException)) break block2;
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    boolean isRedirectEntry() {
        return this.getRedirectFinalURL() != null;
    }

    public URL getRedirectFinalURL() {
        String string;
        Map map = this.getHeaders();
        List list = map == null ? null : (List)map.get("Location");
        String string2 = string = list == null || list.size() < 1 ? null : (String)list.get(0);
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
            }
        }
        return null;
    }

    private byte[] readBlock(final int n, final int n2) throws IOException {
        try {
            return (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    byte[] byArray;
                    block2: {
                        RandomAccessFile randomAccessFile = CacheEntry.this.openLockIndexFile("r", false);
                        try {
                            randomAccessFile.seek(n);
                            Object var2_2 = null;
                            byte[] byArray2 = new byte[n2];
                            randomAccessFile.readFully(byArray2);
                            byArray = byArray2;
                            Object var6_5 = null;
                            if (randomAccessFile == null) break block2;
                        }
                        catch (Throwable throwable) {
                            block3: {
                                Object var6_6 = null;
                                if (randomAccessFile == null) break block3;
                                randomAccessFile.close();
                            }
                            throw throwable;
                        }
                        randomAccessFile.close();
                    }
                    return byArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                throw (IOException)privilegedActionException.getException();
            }
            return null;
        }
    }

    byte[] getFullManifestBytes() throws IOException {
        if (this.reducedManifest2Length > 0) {
            int n = 128 + this.section2Length;
            int n2 = this.section3Length - this.reducedManifest2Length;
            return this.readBlock(n, n2);
        }
        if (this.reducedManifestLength > 0) {
            int n = 128 + this.section2Length + this.reducedManifestLength;
            int n3 = this.section3Length - this.reducedManifestLength;
            return this.readBlock(n, n3);
        }
        return null;
    }

    private static String asString(Certificate[] certificateArray) {
        if (certificateArray != null) {
            return Arrays.asList(certificateArray).toString();
        }
        return "null";
    }

    private CodeSigner[] convertCertArrayToSignerArray(Certificate[] certificateArray) throws IOException {
        try {
            int n;
            CodeSigner[] codeSignerArray;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<CertPath> arrayList = new ArrayList<CertPath>();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < certificateArray.length) {
                Serializable serializable;
                codeSignerArray = new ArrayList();
                n = n3;
                for (n = n3; n < certificateArray.length; ++n) {
                    serializable = null;
                    Serializable serializable2 = null;
                    if (certificateArray[n] instanceof X509Certificate) {
                        serializable = (X509Certificate)certificateArray[n];
                    }
                    serializable2 = n + 1 < certificateArray.length && certificateArray[n + 1] instanceof X509Certificate ? (X509Certificate)certificateArray[n + 1] : serializable;
                    codeSignerArray.add(serializable);
                    if (!CacheEntry.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                }
                n4 = n < certificateArray.length ? n + 1 : n;
                serializable = certificateFactory.generateCertPath((List<? extends Certificate>)codeSignerArray);
                codeSignerArray.clear();
                arrayList.add((CertPath)serializable);
                n3 = n4;
                ++n2;
            }
            codeSignerArray = new CodeSigner[n2];
            for (n = 0; n < n2; ++n) {
                codeSignerArray[n] = new CodeSigner((CertPath)arrayList.get(n), null);
            }
            return codeSignerArray;
        }
        catch (CertificateException certificateException) {
            throw new IOException("Error process signer certificates");
        }
    }

    private CodeSigner newCodeSigner(CodeSigner codeSigner) {
        CertPath certPath = codeSigner.getSignerCertPath();
        Timestamp timestamp = codeSigner.getTimestamp();
        CodeSigner codeSigner2 = new CodeSigner(certPath, this.newTimestamp(timestamp));
        return codeSigner2;
    }

    private Timestamp newTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Date date = timestamp.getTimestamp();
        CertPath certPath = timestamp.getSignerCertPath();
        return new Timestamp(date, certPath);
    }

    public String getNativeLibPath() {
        return this.getResourceFilename() + "-n";
    }

    private void validateJar(JarFile jarFile) throws IOException {
        Cloneable cloneable;
        Object object;
        URL uRL = new URL(this.url);
        CodeSource[] codeSourceArray = null;
        JavaUtilJarAccess javaUtilJarAccess = null;
        if (enhancedJarAccess) {
            JavaUtilJarAccess javaUtilJarAccess2 = javaUtilJarAccess = SharedSecrets.javaUtilJarAccess();
            codeSourceArray = javaUtilJarAccess2.getCodeSources(jarFile, uRL);
        }
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = null;
        if (!enhancedJarAccess) {
            enumeration = jarFile.entries();
        } else {
            object = javaUtilJarAccess;
            if (BlackList.checkJarFile(jarFile)) {
                throw new JARSigningException(uRL, this.version, 5);
            }
            if (TrustedLibraries.checkJarFile(jarFile)) {
                Trace.println("CacheEntry::validateJar - Trusted-Library " + Boolean.TRUE.toString(), TraceLevel.CACHE);
            }
            if (codeSourceArray != null) {
                cloneable = new ArrayList();
                for (int i = 0; i < codeSourceArray.length; ++i) {
                    if (codeSourceArray[i].getCertificates() == null) continue;
                    cloneable.add(codeSourceArray[i]);
                }
                if (cloneable.size() != codeSourceArray.length) {
                    codeSourceArray = cloneable.toArray(new CodeSource[cloneable.size()]);
                } else {
                    this.hasOnlySignedEntries = true;
                }
            }
            enumeration = object.entryNames(jarFile, codeSourceArray);
            if (codeSourceArray != null && codeSourceArray.length == 1) {
                this.hasSingleCodeSource = true;
            }
        }
        while (enumeration.hasMoreElements()) {
            if (!enhancedJarAccess) {
                cloneable = enumeration.nextElement();
                object = ((ZipEntry)cloneable).getName();
                if (!bl) {
                    try {
                        bl = BlackList.checkJarEntry(jarFile, (JarEntry)cloneable);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        throw new JARSigningException(new URL(this.url), this.version, 5, generalSecurityException);
                    }
                }
                if (!bl2) {
                    try {
                        bl2 = TrustedLibraries.checkJarEntry(jarFile, (JarEntry)cloneable);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        Trace.println("CacheEntry::validateJar - Trusted-Library " + Boolean.TRUE.toString(), TraceLevel.CACHE);
                    }
                }
                if (!JarUtil.canSkipEntry((ZipEntry)cloneable)) continue;
                continue;
            }
            object = (String)((Object)enumeration.nextElement());
            cloneable = jarFile.getJarEntry((String)object);
            if (cloneable != null) continue;
            this.hasMissingSignedEntries = true;
            Trace.println("signed entry \"" + (String)object + "\" missing from jar " + this.url, TraceLevel.CACHE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeManifest(RandomAccessFile randomAccessFile, JarFile jarFile, CachedManifest cachedManifest, int n, DownloadEngine.DownloadDelegate downloadDelegate) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Serializable[] serializableArray;
        Object object5;
        JavaUtilJarAccess javaUtilJarAccess;
        URL uRL = new URL(this.url);
        CodeSource[] codeSourceArray = null;
        JavaUtilJarAccess javaUtilJarAccess2 = null;
        if (enhancedJarAccess) {
            javaUtilJarAccess = javaUtilJarAccess2 = SharedSecrets.javaUtilJarAccess();
            codeSourceArray = javaUtilJarAccess.getCodeSources(jarFile, uRL);
        }
        javaUtilJarAccess = new ArrayList();
        ArrayList<CodeSigner> arrayList = new ArrayList<CodeSigner>();
        Certificate[] certificateArray = null;
        CodeSigner[] codeSignerArray = null;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap3 = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap4 = new HashMap<Object, Object>();
        HashMap<Object, JavaUtilJarAccess> hashMap5 = new HashMap<Object, JavaUtilJarAccess>();
        HashMap<Object, Object> hashMap6 = new HashMap<Object, Object>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FilterOutputStream filterOutputStream = null;
        byte[] byArray = new byte[2048];
        int n2 = jarFile.size();
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = null;
        int[] nArray2 = null;
        Enumeration<Object> enumeration = null;
        if (downloadDelegate != null) {
            downloadDelegate.validating(uRL, 0, n2);
        }
        if (!enhancedJarAccess) {
            enumeration = jarFile.entries();
        } else {
            Cloneable cloneable;
            object5 = javaUtilJarAccess2;
            if (BlackList.checkJarFile(jarFile)) {
                throw new JARSigningException(uRL, this.version, 5);
            }
            if (TrustedLibraries.checkJarFile(jarFile)) {
                cloneable = cachedManifest.getMainAttributes();
                ((Attributes)cloneable).putValue("Trusted-Library", Boolean.TRUE.toString());
            }
            if (codeSourceArray != null) {
                cloneable = new ArrayList();
                for (int i = 0; i < codeSourceArray.length; ++i) {
                    if (codeSourceArray[i].getCertificates() == null) continue;
                    cloneable.add(codeSourceArray[i]);
                }
                if (cloneable.size() != codeSourceArray.length) {
                    codeSourceArray = cloneable.toArray(new CodeSource[cloneable.size()]);
                } else {
                    this.hasOnlySignedEntries = true;
                }
            }
            enumeration = codeSourceArray != null && codeSourceArray.length > 0 ? object5.entryNames(jarFile, codeSourceArray) : jarFile.entries();
            if (codeSourceArray != null && codeSourceArray.length == 1) {
                int n4;
                certificateArray = codeSourceArray[0].getCertificates();
                nArray = new int[certificateArray.length];
                for (n4 = 0; n4 < certificateArray.length; ++n4) {
                    javaUtilJarAccess.add(certificateArray[n4]);
                    nArray[n4] = n4;
                }
                hashMap4.put(nArray, codeSourceArray[0]);
                if (Config.isJavaVersionAtLeast15()) {
                    codeSignerArray = codeSourceArray[0].getCodeSigners();
                    nArray2 = new int[codeSignerArray.length];
                    for (n4 = 0; n4 < codeSignerArray.length; ++n4) {
                        arrayList.add(codeSignerArray[n4]);
                        nArray2[n4] = n4;
                    }
                    hashMap3.put(nArray2, codeSourceArray[0]);
                }
                this.hasSingleCodeSource = true;
            }
        }
        while (enumeration.hasMoreElements()) {
            InputStream inputStream;
            JarEntry jarEntry;
            block76: {
                ++n3;
                if (!enhancedJarAccess || codeSourceArray == null || codeSourceArray.length <= 0) {
                    jarEntry = enumeration.nextElement();
                    object5 = jarEntry.getName();
                    if (!bl) {
                        try {
                            bl = BlackList.checkJarEntry(jarFile, jarEntry);
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            throw new JARSigningException(new URL(this.url), this.version, 5, generalSecurityException);
                        }
                    }
                    if (!bl2) {
                        try {
                            bl2 = TrustedLibraries.checkJarEntry(jarFile, jarEntry);
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            serializableArray = cachedManifest.getMainAttributes();
                            serializableArray.putValue("Trusted-Library", Boolean.TRUE.toString());
                        }
                    }
                    if (JarUtil.canSkipEntry(jarEntry)) {
                        continue;
                    }
                } else {
                    object5 = (String)((Object)enumeration.nextElement());
                    jarEntry = jarFile.getJarEntry((String)object5);
                    if (jarEntry == null) {
                        this.hasMissingSignedEntries = true;
                        Trace.println("signed entry \"" + (String)object5 + "\" missing from jar " + this.url, TraceLevel.CACHE);
                    }
                }
                inputStream = null;
                int n5 = 0;
                try {
                    try {
                        if (jarEntry != null) {
                            inputStream = jarFile.getInputStream(jarEntry);
                        }
                        if (inputStream != null && DownloadEngine.isNativeContentType(n) && ((String)object5).indexOf("/") == -1 && ((String)object5).indexOf("\\") == -1 && ((File)(object4 = new File((File)(object3 = new File(this.getNativeLibPath()).getCanonicalFile()), (String)object5).getCanonicalFile())).getParentFile().equals(object3)) {
                            ((File)object4).getParentFile().mkdirs();
                            filterOutputStream = new BufferedOutputStream(new FileOutputStream((File)object4));
                        }
                        if (inputStream != null) {
                            while ((n5 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                                if (filterOutputStream == null) continue;
                                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n5);
                            }
                        }
                        object2 = null;
                        if (filterOutputStream == null) break block76;
                    }
                    catch (SecurityException securityException) {
                        throw new JARSigningException(uRL, this.version, 2, securityException);
                    }
                }
                catch (Throwable throwable) {
                    object2 = null;
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                        filterOutputStream = null;
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                filterOutputStream.close();
                filterOutputStream = null;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (this.hasSingleCodeSource) {
                hashMap.put(object5, nArray);
            } else {
                if (jarEntry != null) {
                    certificateArray = jarEntry.getCertificates();
                } else {
                    object3 = javaUtilJarAccess2;
                    object4 = object3.getCodeSource(jarFile, uRL, (String)object5);
                    Certificate[] certificateArray2 = certificateArray = object4 != null ? ((CodeSource)object4).getCertificates() : null;
                }
                if (certificateArray != null && certificateArray.length > 0) {
                    object3 = new int[certificateArray.length];
                    for (int i = 0; i < certificateArray.length; ++i) {
                        int n6 = javaUtilJarAccess.indexOf(certificateArray[i]);
                        if (n6 == -1) {
                            n6 = javaUtilJarAccess.size();
                            javaUtilJarAccess.add(certificateArray[i]);
                        }
                        object3[i] = (JavaUtilJarAccess)n6;
                    }
                    object4 = String.valueOf(((JavaUtilJarAccess)object3).length);
                    for (int i = 0; i < ((JavaUtilJarAccess)object3).length; ++i) {
                        object4 = (String)object4 + " " + (int)object3[i];
                    }
                    object = (int[])hashMap6.get(object4);
                    if (object == null) {
                        hashMap6.put(object4, object3);
                        object2 = new CodeSource(uRL, certificateArray);
                        hashMap4.put(object3, object2);
                    } else {
                        object3 = object;
                    }
                    hashMap.put(object5, object3);
                }
            }
            if (Config.isJavaVersionAtLeast15()) {
                if (this.hasSingleCodeSource) {
                    hashMap2.put(object5, nArray2);
                } else {
                    if (jarEntry != null) {
                        codeSignerArray = jarEntry.getCodeSigners();
                    } else {
                        object3 = javaUtilJarAccess2;
                        object4 = object3.getCodeSource(jarFile, uRL, (String)object5);
                        CodeSigner[] codeSignerArray2 = codeSignerArray = object4 != null ? ((CodeSource)object4).getCodeSigners() : null;
                    }
                    if (codeSignerArray != null && codeSignerArray.length > 0) {
                        object3 = new int[codeSignerArray.length];
                        for (int i = 0; i < codeSignerArray.length; ++i) {
                            int n7 = arrayList.indexOf(codeSignerArray[i]);
                            if (n7 == -1) {
                                n7 = arrayList.size();
                                arrayList.add(codeSignerArray[i]);
                            }
                            object3[i] = n7;
                        }
                        object4 = String.valueOf(((JavaUtilJarAccess)object3).length);
                        for (int i = 0; i < ((JavaUtilJarAccess)object3).length; ++i) {
                            object4 = (String)object4 + " " + (int)object3[i];
                        }
                        object = (int[])hashMap5.get(object4);
                        if (object == null) {
                            hashMap5.put(object4, (JavaUtilJarAccess)object3);
                            object2 = new CodeSource(uRL, codeSignerArray);
                            hashMap3.put(object3, object2);
                        } else {
                            object3 = object;
                        }
                        hashMap2.put(object5, object3);
                    }
                }
            }
            if (downloadDelegate == null || n3 % 10 != 0 && n3 < n2) continue;
            downloadDelegate.validating(uRL, n3, n2);
        }
        if (this.hasOnlySignedEntries && !JarUtil.allJarEntriesSigned(jarFile)) {
            throw new JARSigningException(uRL, this.version, 3);
        }
        if (cachedManifest != null) {
            this.section3Length = cachedManifest.writeFull(byteArrayOutputStream);
            this.reducedManifest2Length = cachedManifest.writeReduced(byteArrayOutputStream);
            this.section3Length += this.reducedManifest2Length;
        } else {
            this.section3Length = 0;
            this.reducedManifest2Length = 0;
        }
        object5 = new ObjectOutputStream(byteArrayOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object5));
        if (!javaUtilJarAccess.isEmpty()) {
            ((ObjectOutputStream)object5).writeInt(javaUtilJarAccess.size());
            Iterator iterator = javaUtilJarAccess.iterator();
            while (iterator.hasNext()) {
                ((ObjectOutputStream)object5).writeObject(iterator.next());
            }
            ((ObjectOutputStream)object5).flush();
            this.section4CertsLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
            serializableArray = hashMap.keySet().iterator();
            object3 = null;
            while (serializableArray.hasNext()) {
                object4 = (String)serializableArray.next();
                object = (int[])hashMap.get(object4);
                if (((String)object4).indexOf("/") != -1) {
                    object2 = ((String)object4).substring(0, ((String)object4).lastIndexOf("/"));
                    if (object3 != null && ((String)object2).equals(object3)) {
                        object4 = ((String)object4).substring(((String)object2).length());
                    }
                    object3 = object2;
                }
                bufferedWriter.write((String)object4);
                bufferedWriter.newLine();
                object2 = String.valueOf(((int[])object).length);
                for (int i = 0; i < ((int[])object).length; ++i) {
                    object2 = (String)object2 + " " + object[i];
                }
                bufferedWriter.write((String)object2, 0, ((String)object2).length());
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.flush();
            if (this.hasStrictSingleSigning()) {
                hashMap.clear();
                hashMap.put(null, nArray);
            }
        } else {
            ((ObjectOutputStream)object5).writeInt(0);
            ((ObjectOutputStream)object5).flush();
            this.section4CertsLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
        }
        this.section4Pre15Length = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - this.section3Length;
        if (!arrayList.isEmpty()) {
            Integer n8 = new Integer(arrayList.size());
            bufferedWriter.write(n8.toString());
            bufferedWriter.newLine();
            bufferedWriter.flush();
            serializableArray = arrayList.iterator();
            while (serializableArray.hasNext()) {
                ((ObjectOutputStream)object5).writeObject(serializableArray.next());
            }
            ((ObjectOutputStream)object5).flush();
            this.section4SignersLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - (this.section3Length + this.section4Pre15Length);
            object3 = hashMap2.keySet().iterator();
            object4 = null;
            while (object3.hasNext()) {
                String string;
                object = (String)object3.next();
                object2 = (int[])hashMap2.get(object);
                if (object.indexOf("/") != -1) {
                    string = object.substring(0, object.lastIndexOf("/"));
                    if (object4 != null && string.equals(object4)) {
                        object = object.substring(string.length());
                    }
                    object4 = string;
                }
                bufferedWriter.write((String)object);
                bufferedWriter.newLine();
                string = String.valueOf(((Object)object2).length);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    string = string + " " + (int)object2[i];
                }
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            if (this.hasStrictSingleSigning()) {
                hashMap2.clear();
                hashMap2.put(null, nArray2);
            }
        } else {
            bufferedWriter.write("0");
            bufferedWriter.newLine();
            ((ObjectOutputStream)object5).flush();
            this.section4SignersLength = !enhancedJarAccess ? 0 : byteArrayOutputStream.size() - (this.section3Length + this.section4Pre15Length);
        }
        bufferedWriter.flush();
        ((ObjectOutputStream)object5).flush();
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        this.section4Length = byteArrayOutputStream.size() - this.section3Length;
        JarSigningData jarSigningData = new JarSigningData(this.hasOnlySignedEntries, this.hasSingleCodeSource, this.hasMissingSignedEntries);
        this.signingDataRef = new SoftReference<JarSigningData>(jarSigningData);
        if (Config.isJavaVersionAtLeast15()) {
            if (arrayList.isEmpty()) return;
            serializableArray = arrayList.toArray(new CodeSigner[arrayList.size()]);
            jarSigningData.updateSignerInfo((CodeSigner[])serializableArray, hashMap2, hashMap3);
            return;
        }
        if (javaUtilJarAccess.isEmpty()) return;
        serializableArray = javaUtilJarAccess.toArray(new Certificate[javaUtilJarAccess.size()]);
        jarSigningData.updateCertInfo((Certificate[])serializableArray, hashMap, hashMap4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeadersOld(RandomAccessFile randomAccessFile) throws IOException {
        try {
            for (int i = randomAccessFile.readInt(); i > 0; --i) {
                String string = randomAccessFile.readUTF();
                if (string.equals("deploy_resource_codebase_ip")) {
                    this.setCodebaseIP(randomAccessFile.readUTF());
                    continue;
                }
                if (string.equals("<null>")) {
                    string = null;
                }
                this.headerFields.add(string, randomAccessFile.readUTF());
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeaders(DataInputStream dataInputStream) throws IOException {
        try {
            for (int i = dataInputStream.readInt(); i > 0; --i) {
                String string = dataInputStream.readUTF();
                if (string.equals("<null>")) {
                    string = null;
                }
                this.headerFields.add(string, dataInputStream.readUTF());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeaders(DataOutputStream dataOutputStream) throws IOException {
        try {
            if (this.headerFields == null) {
                dataOutputStream.writeInt(0);
                Object var6_2 = null;
                return;
            }
            Map map = this.headerFields.getHeaders();
            if (!map.isEmpty()) {
                dataOutputStream.writeInt(map.size());
                for (int i = 0; i < map.size(); ++i) {
                    String string = this.headerFields.getKey(i);
                    if (null == string) {
                        string = "<null>";
                    }
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeUTF(this.headerFields.getValue(i));
                }
            } else {
                dataOutputStream.writeInt(0);
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            throw throwable;
        }
        Object var6_3 = null;
    }

    private String printManifest() {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Attributes attributes = manifest.getMainAttributes();
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                stringBuffer.append("key: " + object);
                stringBuffer.append(" value: " + attributes.get(object) + "\n");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-----Cache Entry------\n");
        stringBuffer.append("busy: " + this.getBusy() + "\n");
        stringBuffer.append("incomplete: " + this.getIncomplete() + "\n");
        stringBuffer.append("cacheVersion: " + this.getCacheVersion() + "\n");
        stringBuffer.append("forceUpdate: " + this.getForceUpdate() + "\n");
        stringBuffer.append("noHref: " + this.getNoHref() + "\n");
        stringBuffer.append("contentLength: " + this.getContentLength() + "\n");
        long l = this.getLastModified();
        stringBuffer.append("lastModified: " + l + " [" + new Date(l).toString() + "]\n");
        stringBuffer.append("expirationDate: " + this.getExpirationDate() + "\n");
        stringBuffer.append("version: " + this.getVersion() + "\n");
        stringBuffer.append("URL: " + this.url + "\n");
        stringBuffer.append("NamespaceID: " + this.getNamespaceID() + "\n");
        stringBuffer.append("HTTP/HTTPS Header: " + this.getHeaders() + "\n");
        if (this.getManifest() != null) {
            stringBuffer.append("Jar-Manifest Main Attributes:\n");
            stringBuffer.append(this.printManifest());
            stringBuffer.append("----------------------\n");
        }
        return stringBuffer.toString();
    }

    public boolean matchesVersionString(String string, boolean bl) {
        if (this.getVersion() == null && string == null) {
            return true;
        }
        VersionString versionString = new VersionString(string);
        if (bl && !versionString.isSimpleVersion()) {
            return false;
        }
        return versionString.contains(this.getVersion());
    }

    public boolean isSameEntry(CacheEntry cacheEntry) {
        return cacheEntry != null && this.getIndexFile().equals(cacheEntry.getIndexFile());
    }

    private CodeSource createCodeSource(Certificate[] certificateArray) {
        if (this._url == null) {
            try {
                this._url = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new CodeSource(this._url, certificateArray);
    }

    private CodeSource createCodeSource(CodeSigner[] codeSignerArray) {
        if (this._url == null) {
            try {
                this._url = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new CodeSource(this._url, codeSignerArray);
    }

    static {
        try {
            JavaUtilJarAccess javaUtilJarAccess = SharedSecrets.javaUtilJarAccess();
            javaUtilJarAccess.setEagerValidation((JarFile)null, false);
            enhancedJarAccess = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (NullPointerException nullPointerException) {
            enhancedJarAccess = true;
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

