/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import com.sun.jmx.remote.util.EnvHelp;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.DescriptorRead;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMBeanAttributeInfoSupport
extends MBeanAttributeInfo
implements OpenMBeanAttributeInfo {
    static final long serialVersionUID = -4867215622149721849L;
    private OpenType<?> openType;
    private final Object defaultValue;
    private final Set<?> legalValues;
    private final Comparable minValue;
    private final Comparable maxValue;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanAttributeInfoSupport(String string, String string2, OpenType<?> openType, boolean bl, boolean bl2, boolean bl3) {
        this(string, string2, (OpenType)openType, bl, bl2, bl3, (Object)null);
    }

    public OpenMBeanAttributeInfoSupport(String string, String string2, OpenType<?> openType, boolean bl, boolean bl2, boolean bl3, Descriptor descriptor) {
        super(string, openType == null ? null : openType.getClassName(), string2, bl, bl2, bl3, ImmutableDescriptor.union(descriptor, openType.getDescriptor()));
        this.openType = openType;
        descriptor = this.getDescriptor();
        this.defaultValue = OpenMBeanAttributeInfoSupport.valueFrom(descriptor, "defaultValue", openType);
        this.legalValues = OpenMBeanAttributeInfoSupport.valuesFrom(descriptor, "legalValues", openType);
        this.minValue = OpenMBeanAttributeInfoSupport.comparableValueFrom(descriptor, "minValue", openType);
        this.maxValue = OpenMBeanAttributeInfoSupport.comparableValueFrom(descriptor, "maxValue", openType);
        try {
            OpenMBeanAttributeInfoSupport.check(this);
        }
        catch (OpenDataException openDataException) {
            throw new IllegalArgumentException(openDataException.getMessage(), openDataException);
        }
    }

    public <T> OpenMBeanAttributeInfoSupport(String string, String string2, OpenType<T> openType, boolean bl, boolean bl2, boolean bl3, T t) throws OpenDataException {
        this(string, string2, openType, bl, bl2, bl3, t, null);
    }

    public <T> OpenMBeanAttributeInfoSupport(String string, String string2, OpenType<T> openType, boolean bl, boolean bl2, boolean bl3, T t, T[] TArray) throws OpenDataException {
        this(string, string2, openType, bl, bl2, bl3, t, TArray, null, null);
    }

    public <T> OpenMBeanAttributeInfoSupport(String string, String string2, OpenType<T> openType, boolean bl, boolean bl2, boolean bl3, T t, Comparable<T> comparable, Comparable<T> comparable2) throws OpenDataException {
        this(string, string2, openType, bl, bl2, bl3, t, null, comparable, comparable2);
    }

    private <T> OpenMBeanAttributeInfoSupport(String string, String string2, OpenType<T> openType, boolean bl, boolean bl2, boolean bl3, T t, T[] TArray, Comparable<T> comparable, Comparable<T> comparable2) throws OpenDataException {
        super(string, openType == null ? null : openType.getClassName(), string2, bl, bl2, bl3, OpenMBeanAttributeInfoSupport.makeDescriptor(openType, t, TArray, comparable, comparable2));
        this.openType = openType;
        Descriptor descriptor = this.getDescriptor();
        this.defaultValue = t;
        this.minValue = comparable;
        this.maxValue = comparable2;
        this.legalValues = (Set)descriptor.getFieldValue("legalValues");
        OpenMBeanAttributeInfoSupport.check(this);
    }

    private Object readResolve() {
        if (this.getDescriptor().getFieldNames().length == 0) {
            return new OpenMBeanAttributeInfoSupport(this.name, this.description, this.openType, this.isReadable(), this.isWritable(), this.isIs(), OpenMBeanAttributeInfoSupport.makeDescriptor(this.openType, this.defaultValue, this.legalValues, this.minValue, this.maxValue));
        }
        return this;
    }

    static void check(OpenMBeanParameterInfo openMBeanParameterInfo) throws OpenDataException {
        OpenType<?> openType = openMBeanParameterInfo.getOpenType();
        if (openType == null) {
            throw new IllegalArgumentException("OpenType cannot be null");
        }
        if (openMBeanParameterInfo.getName() == null || openMBeanParameterInfo.getName().trim().equals("")) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (openMBeanParameterInfo.getDescription() == null || openMBeanParameterInfo.getDescription().trim().equals("")) {
            throw new IllegalArgumentException("Description cannot be null or empty");
        }
        if (openMBeanParameterInfo.hasDefaultValue()) {
            if (openType.isArray() || openType instanceof TabularType) {
                throw new OpenDataException("Default value not supported for ArrayType and TabularType");
            }
            if (!openType.isValue(openMBeanParameterInfo.getDefaultValue())) {
                String string = "Argument defaultValue's class [\"" + openMBeanParameterInfo.getDefaultValue().getClass().getName() + "\"] does not match the one defined in openType[\"" + openType.getClassName() + "\"]";
                throw new OpenDataException(string);
            }
        }
        if (openMBeanParameterInfo.hasLegalValues() && (openMBeanParameterInfo.hasMinValue() || openMBeanParameterInfo.hasMaxValue())) {
            throw new OpenDataException("cannot have both legalValue and minValue or maxValue");
        }
        if (openMBeanParameterInfo.hasMinValue() && !openType.isValue(openMBeanParameterInfo.getMinValue())) {
            String string = "Type of minValue [" + openMBeanParameterInfo.getMinValue().getClass().getName() + "] does not match OpenType [" + openType.getClassName() + "]";
            throw new OpenDataException(string);
        }
        if (openMBeanParameterInfo.hasMaxValue() && !openType.isValue(openMBeanParameterInfo.getMaxValue())) {
            String string = "Type of maxValue [" + openMBeanParameterInfo.getMaxValue().getClass().getName() + "] does not match OpenType [" + openType.getClassName() + "]";
            throw new OpenDataException(string);
        }
        if (openMBeanParameterInfo.hasDefaultValue()) {
            Iterator<?> iterator = openMBeanParameterInfo.getDefaultValue();
            if (openMBeanParameterInfo.hasLegalValues() && !openMBeanParameterInfo.getLegalValues().contains(iterator)) {
                throw new OpenDataException("defaultValue is not contained in legalValues");
            }
            if (openMBeanParameterInfo.hasMinValue() && openMBeanParameterInfo.getMinValue().compareTo(iterator) > 0) {
                throw new OpenDataException("minValue cannot be greater than defaultValue");
            }
            if (openMBeanParameterInfo.hasMaxValue() && openMBeanParameterInfo.getMaxValue().compareTo(iterator) < 0) {
                throw new OpenDataException("maxValue cannot be less than defaultValue");
            }
        }
        if (openMBeanParameterInfo.hasLegalValues()) {
            if (openType instanceof TabularType || openType.isArray()) {
                throw new OpenDataException("Legal values not supported for TabularType and arrays");
            }
            for (Object obj : openMBeanParameterInfo.getLegalValues()) {
                if (openType.isValue(obj)) continue;
                String string = "Element of legalValues [" + obj + "] is not a valid value for the specified openType [" + openType.toString() + "]";
                throw new OpenDataException(string);
            }
        }
        if (openMBeanParameterInfo.hasMinValue() && openMBeanParameterInfo.hasMaxValue() && openMBeanParameterInfo.getMinValue().compareTo(openMBeanParameterInfo.getMaxValue()) > 0) {
            throw new OpenDataException("minValue cannot be greater than maxValue");
        }
    }

    static <T> Descriptor makeDescriptor(OpenType<T> openType, T t, T[] TArray, Comparable<T> comparable, Comparable<T> comparable2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (t != null) {
            hashMap.put("defaultValue", t);
        }
        if (TArray != null) {
            Set<T> set = new HashSet();
            for (T t2 : TArray) {
                set.add(t2);
            }
            set = Collections.unmodifiableSet(set);
            hashMap.put("legalValues", set);
        }
        if (comparable != null) {
            hashMap.put("minValue", comparable);
        }
        if (comparable2 != null) {
            hashMap.put("maxValue", comparable2);
        }
        if (hashMap.isEmpty()) {
            return openType.getDescriptor();
        }
        hashMap.put("openType", openType);
        return new ImmutableDescriptor(hashMap);
    }

    static Descriptor makeDescriptor(OpenType openType, Object object, Set set, Comparable comparable, Comparable comparable2) {
        Object[] objectArray;
        if (set == null) {
            objectArray = null;
        } else {
            objectArray = new Object[set.size()];
            set.toArray(objectArray);
        }
        return OpenMBeanAttributeInfoSupport.makeDescriptor(openType, object, objectArray, comparable, comparable2);
    }

    static <T> T valueFrom(Descriptor descriptor, String string, OpenType<T> openType) {
        Object object = descriptor.getFieldValue(string);
        if (object == null) {
            return null;
        }
        try {
            return OpenMBeanAttributeInfoSupport.convertFrom(object, openType);
        }
        catch (Exception exception) {
            String string2 = "Cannot convert descriptor field " + string + "  to " + openType.getTypeName();
            throw EnvHelp.initCause(new IllegalArgumentException(string2), exception);
        }
    }

    static <T> Set<T> valuesFrom(Descriptor descriptor, String string, OpenType<T> openType) {
        Collection<Object> collection;
        HashSet<T> hashSet;
        Object object = descriptor.getFieldValue(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Set) {
            hashSet = (HashSet<T>)object;
            boolean bl = true;
            for (Object e : hashSet) {
                if (openType.isValue(e)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return hashSet;
            }
            collection = hashSet;
        } else if (object instanceof Object[]) {
            collection = Arrays.asList((Object[])object);
        } else {
            String string2 = "Descriptor value for " + string + " must be a Set or " + "an array: " + object.getClass().getName();
            throw new IllegalArgumentException(string2);
        }
        hashSet = new HashSet<T>();
        for (Object e : collection) {
            hashSet.add(OpenMBeanAttributeInfoSupport.convertFrom(e, openType));
        }
        return hashSet;
    }

    static <T> Comparable comparableValueFrom(Descriptor descriptor, String string, OpenType<T> openType) {
        T t = OpenMBeanAttributeInfoSupport.valueFrom(descriptor, string, openType);
        if (t == null || t instanceof Comparable) {
            return (Comparable)t;
        }
        String string2 = "Descriptor field " + string + " with value " + t + " is not Comparable";
        throw new IllegalArgumentException(string2);
    }

    private static <T> T convertFrom(Object object, OpenType<T> openType) {
        if (openType.isValue(object)) {
            return (T)object;
        }
        return OpenMBeanAttributeInfoSupport.convertFromStrings(object, openType);
    }

    private static <T> T convertFromStrings(Object object, OpenType<T> openType) {
        if (openType instanceof ArrayType) {
            return OpenMBeanAttributeInfoSupport.convertFromStringArray(object, openType);
        }
        if (object instanceof String) {
            return OpenMBeanAttributeInfoSupport.convertFromString((String)object, openType);
        }
        String string = "Cannot convert value " + object + " of type " + object.getClass().getName() + " to type " + openType.getTypeName();
        throw new IllegalArgumentException(string);
    }

    private static <T> T convertFromString(String string, OpenType<T> openType) {
        Constructor constructor;
        Class clazz;
        Object object;
        try {
            object = openType.safeGetClassName();
            ReflectUtil.checkPackageAccess((String)object);
            clazz = (Class)OpenMBeanAttributeInfoSupport.cast(Class.forName((String)object));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.toString());
        }
        try {
            object = clazz.getMethod("valueOf", String.class);
            if (!Modifier.isStatic(((Method)object).getModifiers()) || ((Method)object).getReturnType() != clazz) {
                object = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = null;
        }
        if (object != null) {
            try {
                return clazz.cast(MethodUtil.invoke((Method)object, null, new Object[]{string}));
            }
            catch (Exception exception) {
                String string2 = "Could not convert \"" + string + "\" using method: " + object;
                throw new IllegalArgumentException(string2, exception);
            }
        }
        try {
            constructor = clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            constructor = null;
        }
        if (constructor != null) {
            try {
                return constructor.newInstance(string);
            }
            catch (Exception exception) {
                String string3 = "Could not convert \"" + string + "\" using constructor: " + constructor;
                throw new IllegalArgumentException(string3, exception);
            }
        }
        throw new IllegalArgumentException("Don't know how to convert string to " + openType.getTypeName());
    }

    private static <T> T convertFromStringArray(Object object, OpenType<T> openType) {
        Class<?> clazz;
        Class<?> clazz2;
        Object object2;
        ArrayType arrayType = (ArrayType)openType;
        OpenType<?> openType2 = arrayType.getElementOpenType();
        int n = arrayType.getDimension();
        String string = "[";
        for (int i = 1; i < n; ++i) {
            string = string + "[";
        }
        try {
            object2 = openType2.safeGetClassName();
            ReflectUtil.checkPackageAccess((String)object2);
            clazz2 = Class.forName(string + "Ljava.lang.String;");
            clazz = Class.forName(string + "L" + (String)object2 + ";");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.toString());
        }
        if (!clazz2.isInstance(object)) {
            object2 = "Value for " + n + "-dimensional array of " + openType2.getTypeName() + " must be same type or a String " + "array with same dimensions";
            throw new IllegalArgumentException((String)object2);
        }
        if (n == 1) {
            object2 = openType2;
        } else {
            try {
                object2 = new ArrayType(n - 1, openType2);
            }
            catch (OpenDataException openDataException) {
                throw new IllegalArgumentException(openDataException.getMessage(), openDataException);
            }
        }
        int n2 = Array.getLength(object);
        Object object3 = Array.newInstance(clazz.getComponentType(), n2);
        for (int i = 0; i < n2; ++i) {
            Object object4 = Array.get(object, i);
            T t = OpenMBeanAttributeInfoSupport.convertFromStrings(object4, object2);
            Array.set(object3, i, t);
        }
        return (T)object3;
    }

    @Override
    public OpenType<?> getOpenType() {
        return this.openType;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Set<?> getLegalValues() {
        return this.legalValues;
    }

    @Override
    public Comparable<?> getMinValue() {
        return this.minValue;
    }

    @Override
    public Comparable<?> getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    @Override
    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    @Override
    public boolean hasMinValue() {
        return this.minValue != null;
    }

    @Override
    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    @Override
    public boolean isValue(Object object) {
        return OpenMBeanAttributeInfoSupport.isValue(this, object);
    }

    static boolean isValue(OpenMBeanParameterInfo openMBeanParameterInfo, Object object) {
        if (openMBeanParameterInfo.hasDefaultValue() && object == null) {
            return true;
        }
        return !(!openMBeanParameterInfo.getOpenType().isValue(object) || openMBeanParameterInfo.hasLegalValues() && !openMBeanParameterInfo.getLegalValues().contains(object) || openMBeanParameterInfo.hasMinValue() && openMBeanParameterInfo.getMinValue().compareTo(object) > 0 || openMBeanParameterInfo.hasMaxValue() && openMBeanParameterInfo.getMaxValue().compareTo(object) < 0);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OpenMBeanAttributeInfo)) {
            return false;
        }
        OpenMBeanAttributeInfo openMBeanAttributeInfo = (OpenMBeanAttributeInfo)object;
        return this.isReadable() == openMBeanAttributeInfo.isReadable() && this.isWritable() == openMBeanAttributeInfo.isWritable() && this.isIs() == openMBeanAttributeInfo.isIs() && OpenMBeanAttributeInfoSupport.equal(this, openMBeanAttributeInfo);
    }

    static boolean equal(OpenMBeanParameterInfo openMBeanParameterInfo, OpenMBeanParameterInfo openMBeanParameterInfo2) {
        if (openMBeanParameterInfo instanceof DescriptorRead) {
            Descriptor descriptor;
            if (!(openMBeanParameterInfo2 instanceof DescriptorRead)) {
                return false;
            }
            Descriptor descriptor2 = ((DescriptorRead)((Object)openMBeanParameterInfo)).getDescriptor();
            if (!((Object)descriptor2).equals(descriptor = ((DescriptorRead)((Object)openMBeanParameterInfo2)).getDescriptor())) {
                return false;
            }
        } else if (openMBeanParameterInfo2 instanceof DescriptorRead) {
            return false;
        }
        return openMBeanParameterInfo.getName().equals(openMBeanParameterInfo2.getName()) && openMBeanParameterInfo.getOpenType().equals(openMBeanParameterInfo2.getOpenType()) && (openMBeanParameterInfo.hasDefaultValue() ? openMBeanParameterInfo.getDefaultValue().equals(openMBeanParameterInfo2.getDefaultValue()) : !openMBeanParameterInfo2.hasDefaultValue()) && (openMBeanParameterInfo.hasMinValue() ? openMBeanParameterInfo.getMinValue().equals(openMBeanParameterInfo2.getMinValue()) : !openMBeanParameterInfo2.hasMinValue()) && (openMBeanParameterInfo.hasMaxValue() ? openMBeanParameterInfo.getMaxValue().equals(openMBeanParameterInfo2.getMaxValue()) : !openMBeanParameterInfo2.hasMaxValue()) && (openMBeanParameterInfo.hasLegalValues() ? ((Object)openMBeanParameterInfo.getLegalValues()).equals(openMBeanParameterInfo2.getLegalValues()) : !openMBeanParameterInfo2.hasLegalValues());
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            this.myHashCode = OpenMBeanAttributeInfoSupport.hashCode(this);
        }
        return this.myHashCode;
    }

    static int hashCode(OpenMBeanParameterInfo openMBeanParameterInfo) {
        int n = 0;
        n += openMBeanParameterInfo.getName().hashCode();
        n += openMBeanParameterInfo.getOpenType().hashCode();
        if (openMBeanParameterInfo.hasDefaultValue()) {
            n += openMBeanParameterInfo.getDefaultValue().hashCode();
        }
        if (openMBeanParameterInfo.hasMinValue()) {
            n += openMBeanParameterInfo.getMinValue().hashCode();
        }
        if (openMBeanParameterInfo.hasMaxValue()) {
            n += openMBeanParameterInfo.getMaxValue().hashCode();
        }
        if (openMBeanParameterInfo.hasLegalValues()) {
            n += ((Object)openMBeanParameterInfo.getLegalValues()).hashCode();
        }
        if (openMBeanParameterInfo instanceof DescriptorRead) {
            n += ((Object)((DescriptorRead)((Object)openMBeanParameterInfo)).getDescriptor()).hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            this.myToString = OpenMBeanAttributeInfoSupport.toString(this);
        }
        return this.myToString;
    }

    static String toString(OpenMBeanParameterInfo openMBeanParameterInfo) {
        Descriptor descriptor = openMBeanParameterInfo instanceof DescriptorRead ? ((DescriptorRead)((Object)openMBeanParameterInfo)).getDescriptor() : null;
        return openMBeanParameterInfo.getClass().getName() + "(name=" + openMBeanParameterInfo.getName() + ",openType=" + openMBeanParameterInfo.getOpenType() + ",default=" + openMBeanParameterInfo.getDefaultValue() + ",minValue=" + openMBeanParameterInfo.getMinValue() + ",maxValue=" + openMBeanParameterInfo.getMaxValue() + ",legalValues=" + openMBeanParameterInfo.getLegalValues() + (descriptor == null ? "" : ",descriptor=" + descriptor) + ")";
    }

    static <T> T cast(Object object) {
        return (T)object;
    }
}

