/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

class NetUtil {
    private static boolean revealLocalAddress;
    private static volatile boolean propRevealLocalAddr;

    NetUtil() {
    }

    static boolean doRevealLocalAddress() {
        return propRevealLocalAddr ? revealLocalAddress : NetUtil.readRevealLocalAddr();
    }

    static InetAddress getLoopbackAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError((Object)"This should never happen");
        }
        return inetAddress;
    }

    private static boolean readRevealLocalAddr() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                revealLocalAddress = Boolean.parseBoolean(AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("jdk.net.revealLocalAddress");
                    }
                }));
            }
            catch (Exception exception) {
                // empty catch block
            }
            propRevealLocalAddr = true;
        }
        return revealLocalAddress;
    }
}

