/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpCookie
implements Cloneable {
    private String name;
    private String value;
    private String comment;
    private String commentURL;
    private boolean toDiscard;
    private String domain;
    private long maxAge = -1L;
    private String path;
    private String portlist;
    private boolean secure;
    private boolean httpOnly;
    private int version = 1;
    private long whenCreated = 0L;
    private static final long MAX_AGE_UNSPECIFIED = -1L;
    private static final String[] COOKIE_DATE_FORMATS = new String[]{"EEE',' dd-MMM-yyyy HH:mm:ss 'GMT'", "EEE',' dd MMM yyyy HH:mm:ss 'GMT'", "EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "EEE',' dd-MMM-yy HH:mm:ss 'GMT'", "EEE',' dd MMM yy HH:mm:ss 'GMT'", "EEE MMM dd yy HH:mm:ss 'GMT'Z"};
    private static final String SET_COOKIE = "set-cookie:";
    private static final String SET_COOKIE2 = "set-cookie2:";
    private static final String tspecials = ",;";
    static Map<String, CookieAttributeAssignor> assignors = null;
    private static SimpleDateFormat[] cDateFormats;

    public HttpCookie(String string, String string2) {
        string = string.trim();
        if (string.length() == 0 || !HttpCookie.isToken(string) || HttpCookie.isReserved(string)) {
            throw new IllegalArgumentException("Illegal cookie name");
        }
        this.name = string;
        this.value = string2;
        this.toDiscard = false;
        this.secure = false;
        this.whenCreated = System.currentTimeMillis();
        this.portlist = null;
    }

    public static List<HttpCookie> parse(String string) {
        int n = HttpCookie.guessCookieVersion(string);
        if (HttpCookie.startsWithIgnoreCase(string, SET_COOKIE2)) {
            string = string.substring(SET_COOKIE2.length());
        } else if (HttpCookie.startsWithIgnoreCase(string, SET_COOKIE)) {
            string = string.substring(SET_COOKIE.length());
        }
        ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        if (n == 0) {
            HttpCookie httpCookie = HttpCookie.parseInternal(string);
            httpCookie.setVersion(0);
            arrayList.add(httpCookie);
        } else {
            List<String> list = HttpCookie.splitMultiCookies(string);
            for (String string2 : list) {
                HttpCookie httpCookie = HttpCookie.parseInternal(string2);
                httpCookie.setVersion(1);
                arrayList.add(httpCookie);
            }
        }
        return arrayList;
    }

    public boolean hasExpired() {
        if (this.maxAge == 0L) {
            return true;
        }
        if (this.maxAge == -1L) {
            return false;
        }
        long l = (System.currentTimeMillis() - this.whenCreated) / 1000L;
        return l > this.maxAge;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setCommentURL(String string) {
        this.commentURL = string;
    }

    public String getCommentURL() {
        return this.commentURL;
    }

    public void setDiscard(boolean bl) {
        this.toDiscard = bl;
    }

    public boolean getDiscard() {
        return this.toDiscard;
    }

    public void setPortlist(String string) {
        this.portlist = string;
    }

    public String getPortlist() {
        return this.portlist;
    }

    public void setDomain(String string) {
        this.domain = string != null ? string.toLowerCase() : string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMaxAge(long l) {
        this.maxAge = l;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("cookie version should be 0 or 1");
        }
        this.version = n;
    }

    boolean isHttpOnly() {
        return this.httpOnly;
    }

    void setHttpOnly(boolean bl) {
        this.httpOnly = bl;
    }

    public static boolean domainMatches(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        boolean bl = ".local".equalsIgnoreCase(string);
        int n = string.indexOf(46);
        if (n == 0) {
            n = string.indexOf(46, 1);
        }
        if (!(bl || n != -1 && n != string.length() - 1)) {
            return false;
        }
        int n2 = string2.indexOf(46);
        if (n2 == -1 && bl) {
            return true;
        }
        int n3 = string.length();
        int n4 = string2.length() - n3;
        if (n4 == 0) {
            return string2.equalsIgnoreCase(string);
        }
        if (n4 > 0) {
            String string3 = string2.substring(0, n4);
            String string4 = string2.substring(n4);
            return string3.indexOf(46) == -1 && string4.equalsIgnoreCase(string);
        }
        if (n4 == -1) {
            return string.charAt(0) == '.' && string2.equalsIgnoreCase(string.substring(1));
        }
        return false;
    }

    public String toString() {
        if (this.getVersion() > 0) {
            return this.toRFC2965HeaderString();
        }
        return this.toNetscapeHeaderString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpCookie)) {
            return false;
        }
        HttpCookie httpCookie = (HttpCookie)object;
        return HttpCookie.equalsIgnoreCase(this.getName(), httpCookie.getName()) && HttpCookie.equalsIgnoreCase(this.getDomain(), httpCookie.getDomain()) && HttpCookie.equals(this.getPath(), httpCookie.getPath());
    }

    public int hashCode() {
        int n = this.name.toLowerCase().hashCode();
        int n2 = this.domain != null ? this.domain.toLowerCase().hashCode() : 0;
        int n3 = this.path != null ? this.path.hashCode() : 0;
        return n + n2 + n3;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    private static boolean isToken(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    private static boolean isReserved(String string) {
        return string.equalsIgnoreCase("Comment") || string.equalsIgnoreCase("CommentURL") || string.equalsIgnoreCase("Discard") || string.equalsIgnoreCase("Domain") || string.equalsIgnoreCase("Expires") || string.equalsIgnoreCase("Max-Age") || string.equalsIgnoreCase("Path") || string.equalsIgnoreCase("Port") || string.equalsIgnoreCase("Secure") || string.equalsIgnoreCase("Version") || string.equalsIgnoreCase("HttpOnly") || string.charAt(0) == '$';
    }

    private static HttpCookie parseInternal(String string) {
        String string2;
        String string3;
        int n;
        HttpCookie httpCookie = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        try {
            string4 = stringTokenizer.nextToken();
            n = string4.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("Invalid cookie name-value pair");
            }
            string3 = string4.substring(0, n).trim();
            string2 = string4.substring(n + 1).trim();
            httpCookie = new HttpCookie(string3, HttpCookie.stripOffSurroundingQuote(string2));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Empty cookie header string");
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            n = string4.indexOf(61);
            if (n != -1) {
                string3 = string4.substring(0, n).trim();
                string2 = string4.substring(n + 1).trim();
            } else {
                string3 = string4.trim();
                string2 = null;
            }
            HttpCookie.assignAttribute(httpCookie, string3, string2);
        }
        return httpCookie;
    }

    private static void assignAttribute(HttpCookie httpCookie, String string, String string2) {
        string2 = HttpCookie.stripOffSurroundingQuote(string2);
        CookieAttributeAssignor cookieAttributeAssignor = assignors.get(string.toLowerCase());
        if (cookieAttributeAssignor != null) {
            cookieAttributeAssignor.assign(httpCookie, string, string2);
        }
    }

    private String toNetscapeHeaderString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName() + "=" + this.getValue());
        return stringBuilder.toString();
    }

    private String toRFC2965HeaderString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName()).append("=\"").append(this.getValue()).append('\"');
        if (this.getPath() != null) {
            stringBuilder.append(";$Path=\"").append(this.getPath()).append('\"');
        }
        if (this.getDomain() != null) {
            stringBuilder.append(";$Domain=\"").append(this.getDomain()).append('\"');
        }
        if (this.getPortlist() != null) {
            stringBuilder.append(";$Port=\"").append(this.getPortlist()).append('\"');
        }
        return stringBuilder.toString();
    }

    private long expiryDate2DeltaSeconds(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        for (int i = 0; i < COOKIE_DATE_FORMATS.length; ++i) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(COOKIE_DATE_FORMATS[i], Locale.US);
            gregorianCalendar.set(1970, 0, 1, 0, 0, 0);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            simpleDateFormat.setLenient(false);
            simpleDateFormat.set2DigitYearStart(gregorianCalendar.getTime());
            try {
                gregorianCalendar.setTime(simpleDateFormat.parse(string));
                if (!COOKIE_DATE_FORMATS[i].contains("yyyy")) {
                    int n = gregorianCalendar.get(1);
                    n = (n %= 100) < 70 ? (n += 2000) : (n += 1900);
                    gregorianCalendar.set(1, n);
                }
                return (gregorianCalendar.getTimeInMillis() - this.whenCreated) / 1000L;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return 0L;
    }

    private static int guessCookieVersion(String string) {
        int n = 0;
        if ((string = string.toLowerCase()).indexOf("expires=") != -1) {
            n = 0;
        } else if (string.indexOf("version=") != -1) {
            n = 1;
        } else if (string.indexOf("max-age") != -1) {
            n = 1;
        } else if (HttpCookie.startsWithIgnoreCase(string, SET_COOKIE2)) {
            n = 1;
        }
        return n;
    }

    private static String stripOffSurroundingQuote(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static boolean equalsIgnoreCase(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            return string.equalsIgnoreCase(string2);
        }
        return false;
    }

    private static boolean equals(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            return string.equals(string2);
        }
        return false;
    }

    private static boolean startsWithIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.length() >= string2.length() && string2.equalsIgnoreCase(string.substring(0, string2.length()));
    }

    private static List<String> splitMultiCookies(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                ++n;
            }
            if (c != ',' || n % 2 != 0) continue;
            arrayList.add(string.substring(n2, i));
            n2 = i + 1;
        }
        arrayList.add(string.substring(n2));
        return arrayList;
    }

    static {
        assignors = new HashMap<String, CookieAttributeAssignor>();
        assignors.put("comment", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                if (httpCookie.getComment() == null) {
                    httpCookie.setComment(string2);
                }
            }
        });
        assignors.put("commenturl", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                if (httpCookie.getCommentURL() == null) {
                    httpCookie.setCommentURL(string2);
                }
            }
        });
        assignors.put("discard", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                httpCookie.setDiscard(true);
            }
        });
        assignors.put("domain", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                if (httpCookie.getDomain() == null) {
                    httpCookie.setDomain(string2);
                }
            }
        });
        assignors.put("max-age", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                try {
                    long l = Long.parseLong(string2);
                    if (httpCookie.getMaxAge() == -1L) {
                        httpCookie.setMaxAge(l);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Illegal cookie max-age attribute");
                }
            }
        });
        assignors.put("path", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                if (httpCookie.getPath() == null) {
                    httpCookie.setPath(string2);
                }
            }
        });
        assignors.put("port", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                if (httpCookie.getPortlist() == null) {
                    httpCookie.setPortlist(string2 == null ? "" : string2);
                }
            }
        });
        assignors.put("secure", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                httpCookie.setSecure(true);
            }
        });
        assignors.put("httponly", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                httpCookie.setHttpOnly(true);
            }
        });
        assignors.put("version", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                try {
                    int n = Integer.parseInt(string2);
                    httpCookie.setVersion(n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Illegal cookie version attribute");
                }
            }
        });
        assignors.put("expires", new CookieAttributeAssignor(){

            public void assign(HttpCookie httpCookie, String string, String string2) {
                if (httpCookie.getMaxAge() == -1L) {
                    httpCookie.setMaxAge(httpCookie.expiryDate2DeltaSeconds(string2));
                }
            }
        });
        cDateFormats = null;
        cDateFormats = new SimpleDateFormat[COOKIE_DATE_FORMATS.length];
        for (int i = 0; i < COOKIE_DATE_FORMATS.length; ++i) {
            HttpCookie.cDateFormats[i] = new SimpleDateFormat(COOKIE_DATE_FORMATS[i], Locale.US);
            cDateFormats[i].setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    static interface CookieAttributeAssignor {
        public void assign(HttpCookie var1, String var2, String var3);
    }
}

