/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WeakCache<K, P, V> {
    private final ReferenceQueue<K> refQueue = new ReferenceQueue();
    private final ConcurrentMap<Object, ConcurrentMap<Object, Supplier<V>>> map = new ConcurrentHashMap<Object, ConcurrentMap<Object, Supplier<V>>>();
    private final ConcurrentMap<Supplier<V>, Boolean> reverseMap = new ConcurrentHashMap<Supplier<V>, Boolean>();
    private final BiFunction<K, P, ?> subKeyFactory;
    private final BiFunction<K, P, V> valueFactory;

    public WeakCache(BiFunction<K, P, ?> biFunction, BiFunction<K, P, V> biFunction2) {
        this.subKeyFactory = this.requireNonNull(biFunction);
        this.valueFactory = this.requireNonNull(biFunction2);
    }

    private <T> T requireNonNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public V get(K k, P p) {
        Object object;
        this.requireNonNull(p);
        this.expungeStaleEntries();
        Object object2 = CacheKey.valueOf(k, this.refQueue);
        ConcurrentMap<Object, Supplier<Factory>> concurrentMap = (ConcurrentHashMap)this.map.get(object2);
        if (concurrentMap == null && (object = (ConcurrentMap)this.map.putIfAbsent(object2, concurrentMap = new ConcurrentHashMap())) != null) {
            concurrentMap = object;
        }
        object = this.requireNonNull(this.subKeyFactory.apply(k, p));
        Supplier supplier = (Supplier)concurrentMap.get(object);
        Factory factory = null;
        Object t;
        while (supplier == null || (t = supplier.get()) == null) {
            if (factory == null) {
                factory = new Factory(k, p, object, concurrentMap);
            }
            if (supplier == null) {
                supplier = concurrentMap.putIfAbsent(object, factory);
                if (supplier != null) continue;
                supplier = factory;
                continue;
            }
            if (concurrentMap.replace(object, supplier, factory)) {
                supplier = factory;
                continue;
            }
            supplier = (Supplier)concurrentMap.get(object);
        }
        return (V)t;
    }

    public boolean containsValue(V v) {
        this.requireNonNull(v);
        this.expungeStaleEntries();
        return this.reverseMap.containsKey(new LookupValue<V>(v));
    }

    public int size() {
        this.expungeStaleEntries();
        return this.reverseMap.size();
    }

    private void expungeStaleEntries() {
        CacheKey cacheKey;
        while ((cacheKey = (CacheKey)this.refQueue.poll()) != null) {
            cacheKey.expungeFrom(this.map, this.reverseMap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface BiFunction<T, U, R> {
        public R apply(T var1, U var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CacheKey<K>
    extends WeakReference<K> {
        private static final Object NULL_KEY = new Object();
        private final int hash;

        static <K> Object valueOf(K k, ReferenceQueue<K> referenceQueue) {
            return k == null ? NULL_KEY : new CacheKey<K>(k, referenceQueue);
        }

        private CacheKey(K k, ReferenceQueue<K> referenceQueue) {
            super(k, referenceQueue);
            this.hash = System.identityHashCode(k);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Object t;
            return object == this || object != null && object.getClass() == this.getClass() && (t = this.get()) != null && t == ((CacheKey)object).get();
        }

        void expungeFrom(ConcurrentMap<?, ? extends ConcurrentMap<?, ?>> concurrentMap, ConcurrentMap<?, Boolean> concurrentMap2) {
            ConcurrentMap concurrentMap3 = (ConcurrentMap)concurrentMap.remove(this);
            if (concurrentMap3 != null) {
                for (Object v : concurrentMap3.values()) {
                    concurrentMap2.remove(v);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CacheValue<V>
    extends WeakReference<V>
    implements Value<V> {
        private final int hash;

        CacheValue(V v) {
            super(v);
            this.hash = System.identityHashCode(v);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Object t;
            return object == this || object instanceof Value && (t = this.get()) != null && t == ((Value)object).get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Factory
    implements Supplier<V> {
        private final K key;
        private final P parameter;
        private final Object subKey;
        private final ConcurrentMap<Object, Supplier<V>> valuesMap;

        Factory(K k, P p, Object object, ConcurrentMap<Object, Supplier<V>> concurrentMap) {
            this.key = k;
            this.parameter = p;
            this.subKey = object;
            this.valuesMap = concurrentMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized V get() {
            Object object;
            block6: {
                Supplier supplier = (Supplier)this.valuesMap.get(this.subKey);
                if (supplier != this) {
                    return null;
                }
                object = null;
                try {
                    object = WeakCache.this.requireNonNull(WeakCache.this.valueFactory.apply(this.key, this.parameter));
                    Object var4_3 = null;
                    if (object != null) break block6;
                    this.valuesMap.remove(this.subKey, this);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (object == null) {
                        this.valuesMap.remove(this.subKey, this);
                    }
                    throw throwable;
                }
                {
                }
            }
            assert (object != null);
            CacheValue<Object> cacheValue = new CacheValue<Object>(object);
            if (!this.valuesMap.replace(this.subKey, this, cacheValue)) {
                throw new AssertionError((Object)"Should not reach here");
            }
            WeakCache.this.reverseMap.put(cacheValue, Boolean.TRUE);
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LookupValue<V>
    implements Value<V> {
        private final V value;

        LookupValue(V v) {
            this.value = v;
        }

        @Override
        public V get() {
            return this.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.value);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Value && this.value == ((Value)object).get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Supplier<T> {
        public T get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Value<V>
    extends Supplier<V> {
    }
}

