/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessImpl
extends Process {
    private static final int VERIFICATION_CMD_BAT = 0;
    private static final int VERIFICATION_WIN32 = 1;
    private static final int VERIFICATION_LEGACY = 2;
    private static final char[][] ESCAPE_VERIFICATION = new char[][]{{' ', '\t', '<', '>', '&', '|', '^'}, {' ', '\t', '<', '>'}, {' ', '\t'}};
    private long handle = 0L;
    private FileDescriptor stdin_fd;
    private FileDescriptor stdout_fd;
    private FileDescriptor stderr_fd;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;

    static Process start(String[] stringArray, Map<String, String> map, String string, boolean bl) throws IOException {
        String string2 = ProcessEnvironment.toEnvironmentBlock(map);
        return new ProcessImpl(stringArray, string2, string, bl);
    }

    private static String[] getTokensFromCommand(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(8);
        Matcher matcher = LazyPattern.PATTERN.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String createCommandLine(int n, String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(string);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(' ');
            String string2 = stringArray[i];
            if (ProcessImpl.needsEscaping(n, string2)) {
                stringBuilder.append('\"').append(string2);
                if (n != 0 && string2.endsWith("\\")) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static boolean isQuoted(boolean bl, String string, String string2) {
        int n = string.length() - 1;
        if (n >= 1 && string.charAt(0) == '\"' && string.charAt(n) == '\"') {
            if (bl && string.indexOf(34, 1) != n) {
                throw new IllegalArgumentException(string2);
            }
            return true;
        }
        if (bl && string.indexOf(34) >= 0) {
            throw new IllegalArgumentException(string2);
        }
        return false;
    }

    private static boolean needsEscaping(int n, String string) {
        boolean bl = ProcessImpl.isQuoted(n == 0, string, "Argument has embedded quote, use the explicit CMD.EXE call.");
        if (!bl) {
            char[] cArray = ESCAPE_VERIFICATION[n];
            for (int i = 0; i < cArray.length; ++i) {
                if (string.indexOf(cArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getExecutablePath(String string) throws IOException {
        boolean bl = ProcessImpl.isQuoted(true, string, "Executable name has embedded quote, split the arguments");
        File file = new File(bl ? string.substring(1, string.length() - 1) : string);
        return file.getPath();
    }

    private boolean isShellFile(String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith(".CMD") || string2.endsWith(".BAT");
    }

    private String quoteString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        return stringBuilder.append('\"').append(string).append('\"').toString();
    }

    private ProcessImpl(String[] stringArray, String string, String string2, boolean bl) throws IOException {
        String string3;
        String string4;
        SecurityManager securityManager = System.getSecurityManager();
        boolean bl2 = false;
        if (securityManager == null) {
            bl2 = true;
            string4 = System.getProperty("jdk.lang.Process.allowAmbiguousCommands");
            if (string4 != null) {
                boolean bl3 = bl2 = !"false".equalsIgnoreCase(string4);
            }
        }
        if (bl2) {
            string4 = new File(stringArray[0]).getPath();
            if (ProcessImpl.needsEscaping(2, string4)) {
                string4 = this.quoteString(string4);
            }
            string3 = ProcessImpl.createCommandLine(2, string4, stringArray);
        } else {
            block8: {
                try {
                    string4 = ProcessImpl.getExecutablePath(stringArray[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string5 : stringArray) {
                        stringBuilder.append(string5).append(' ');
                    }
                    stringArray = ProcessImpl.getTokensFromCommand(stringBuilder.toString());
                    string4 = ProcessImpl.getExecutablePath(stringArray[0]);
                    if (securityManager == null) break block8;
                    securityManager.checkExec(string4);
                }
            }
            string3 = ProcessImpl.createCommandLine(this.isShellFile(string4) ? 0 : 1, this.quoteString(string4), stringArray);
        }
        this.stdin_fd = new FileDescriptor();
        this.stdout_fd = new FileDescriptor();
        this.stderr_fd = new FileDescriptor();
        this.handle = ProcessImpl.create(string3, string, string2, bl, this.stdin_fd, this.stdout_fd, this.stderr_fd);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ProcessImpl.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(ProcessImpl.this.stdin_fd));
                ProcessImpl.this.stdout_stream = new BufferedInputStream(new FileInputStream(ProcessImpl.this.stdout_fd));
                ProcessImpl.this.stderr_stream = new FileInputStream(ProcessImpl.this.stderr_fd);
                return null;
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    public void finalize() {
        this.close();
    }

    @Override
    public native int exitValue();

    @Override
    public native int waitFor();

    @Override
    public native void destroy();

    private static synchronized native long create(String var0, String var1, String var2, boolean var3, FileDescriptor var4, FileDescriptor var5, FileDescriptor var6) throws IOException;

    private native void close();

    private static class LazyPattern {
        private static final Pattern PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");

        private LazyPattern() {
        }
    }
}

